/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.DefaultJSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.ECMAL4Highlighter;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSemanticHighlightingUtil {
    @NonNls
    public static final String INSTANCE_FIELD = "instance field";
    @NonNls
    public static final String INSTANCE_METHOD = "instance method";
    @NonNls
    public static final String PARAMETER_MESSAGE = "parameter";
    private static boolean debug = ApplicationManager.getApplication().isUnitTestMode();

    private JSSemanticHighlightingUtil() {
    }

    private static boolean isClassContext(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement context = element.getContext();
        if (context instanceof JSClass) {
            return true;
        }
        return context instanceof JSFile && context.getContext() != null;
    }

    private static boolean isTypeScriptInterfaceReference(PsiElement element) {
        return element instanceof TypeScriptObjectType && JSSemanticHighlightingUtil.isClassContext(element);
    }

    private static JSTextAttributeKeysProvider getTextAttributeKeysProvider(PsiElement element) {
        Language lang;
        JSTextAttributeKeysProvider attributeKeysProvider;
        JSTextAttributeKeysProvider result = DefaultJSTextAttributeKeysProvider.getInstance();
        if (element != null && (attributeKeysProvider = (JSTextAttributeKeysProvider)JSTextAttributeKeysProvider.INSTANCE.forLanguage(lang = DialectDetector.languageOfElement(element))) != null) {
            result = attributeKeysProvider;
        }
        return result;
    }

    public static void highlight(JSPsiReferenceElement node, JSHighlighter highlighter, AnnotationHolder holder) {
        TextAttributeKeyInfo info;
        if (node instanceof JSReferenceExpression && ((JSReferenceExpression)node).getQualifier() == null && node.getNode().findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter) != null && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)node)) {
            return;
        }
        ResolveResult[] results = node.multiResolve(false);
        if (results.length == 0) {
            return;
        }
        if (results.length == 1 && highlighter.getDialectOptionsHolder() == DialectOptionHolder.ECMA_4 && results[0].getElement() instanceof JSClass && (info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(results[0].getElement(), (PsiElement)node, highlighter)) != null) {
            ASTNode genericSignature = node.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
            JSSemanticHighlightingUtil.justLineMarker((PsiElement)(genericSignature == null ? node : node.getReferenceNameElement()), info.getType(), info.getText(), holder);
            return;
        }
        TObjectIntHashMap countByTypes = new TObjectIntHashMap();
        boolean tsdOccurred = false;
        for (ResolveResult r : results) {
            TextAttributeKeyInfo info2;
            boolean isFromTsd;
            PsiElement resolve = r.getElement();
            if (resolve == null) continue;
            PsiFile file = resolve.getContainingFile();
            boolean bl = isFromTsd = file != null && DialectDetector.isTypeScriptDefinitionFile(resolve.getContainingFile());
            if (isFromTsd && !tsdOccurred) {
                tsdOccurred = true;
                countByTypes = new TObjectIntHashMap();
            }
            if (tsdOccurred && !isFromTsd || (info2 = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, (PsiElement)node, highlighter)) == null) continue;
            countByTypes.put((Object)info2, countByTypes.get((Object)info2) + 1);
        }
        Ref maxCount = Ref.create((Object)0);
        Ref info3 = Ref.create(null);
        countByTypes.forEachEntry((key, count) -> {
            if (count > (Integer)maxCount.get()) {
                maxCount.set((Object)count);
                info3.set(key);
            } else if (count == (Integer)maxCount.get() && ((TextAttributeKeyInfo)info3.get()).text.compareTo(((TextAttributeKeyInfo)key).text) > 0) {
                info3.set(key);
            }
            return true;
        });
        if (info3.get() != null) {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, ((TextAttributeKeyInfo)info3.get()).type, ((TextAttributeKeyInfo)info3.get()).text, holder);
        }
    }

    public static void highlight(@NotNull PsiElement place, @NotNull PsiElement resolve, JSHighlighter highlighter, AnnotationHolder holder) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "highlight"));
        }
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "highlight"));
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, place, highlighter);
        if (info != null) {
            JSSemanticHighlightingUtil.lineMarker(place, info.type, info.text, holder);
        }
    }

    @Nullable
    private static TextAttributeKeyInfo buildHighlightForResolveResult(@NotNull PsiElement resolve, @NotNull PsiElement place, JSHighlighter highlighter) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForResolveResult"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForResolveResult"));
        }
        PsiElement targetElement = JSSemanticHighlightingUtil.calculateMeaningfulElementForHighlighting(resolve);
        TextAttributeKeyInfo targetElementInfo = JSSemanticHighlightingUtil.buildHighlightForElement(targetElement, place, highlighter);
        return targetElementInfo != null ? targetElementInfo : JSSemanticHighlightingUtil.buildHighlightForElement(resolve, place, highlighter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TextAttributeKeyInfo buildHighlightForElement(@NotNull PsiElement resolve, @NotNull PsiElement place, JSHighlighter highlighter) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForElement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForElement"));
        }
        boolean isStatic = false;
        boolean isMethod = false;
        boolean isFunction = false;
        boolean isField = false;
        TextAttributeKeyInfo info = null;
        JSTextAttributeKeysProvider attributesKeyProvider = JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place);
        if (resolve instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolve;
            JSImplicitElement.Type type = implicitElement.getType();
            switch (type) {
                case Class: {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                }
                case Interface: {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, true, highlighter);
                }
                case Function: {
                    if (implicitElement.getNamespace() == null) {
                        isFunction = true;
                    } else {
                        isMethod = true;
                    }
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                    break;
                }
                case Namespace: {
                    info = TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
                    break;
                }
                case Variable: {
                    if (implicitElement.getNamespace() == null && implicitElement.isNamespaceExplicitlyDeclared()) {
                        info = TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
                        break;
                    }
                }
                case Property: 
                case Tag: {
                    isField = true;
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                }
            }
        } else {
            if (resolve instanceof JSProperty) {
                return JSSemanticHighlightingUtil.buildHighlightForProperty((JSProperty)resolve, place, highlighter);
            }
            if (resolve instanceof JSAttributeListOwner) {
                if (resolve instanceof JSVariable) {
                    return JSSemanticHighlightingUtil.buildHighlightForVariable((JSVariable)resolve, place, highlighter);
                }
                if (resolve instanceof JSClass) {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, ((JSClass)resolve).isInterface(), highlighter);
                }
                JSAttributeList attributeList = ((JSAttributeListOwner)resolve).getAttributeList();
                if (attributeList != null) {
                    isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                }
                DialectOptionHolder dialect = DialectDetector.dialectOfFile(resolve.getContainingFile());
                boolean bl = isMethod = resolve instanceof JSFunction && (!((JSFunction)resolve).isConstructor() || dialect != null && dialect.isJavaScript());
                if (isMethod && !JSSemanticHighlightingUtil.isClassContext(resolve) && !JSSemanticHighlightingUtil.isTypeScriptInterfaceReference(resolve.getContext())) {
                    isMethod = false;
                    isFunction = true;
                }
                if (JSResolveUtil.isConstructorFunction(resolve)) {
                    if (place != resolve) return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                    if (!"constructor".equals(((JSAttributeListOwner)resolve).getName())) return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                    info = TextAttributeKeyInfo.constructor(highlighter);
                }
            } else if (resolve instanceof JSDefinitionExpression) {
                if (JSPsiImplUtils.calculatePossibleFunction(resolve, place) != null) {
                    isMethod = true;
                } else {
                    isField = true;
                }
            }
        }
        if (isMethod) {
            info = isStatic ? TextAttributeKeyInfo.staticMethod(highlighter) : TextAttributeKeyInfo.instanceMethod(highlighter, place);
        } else if (isFunction) {
            info = TextAttributeKeyInfo.globalFunction(highlighter);
        } else if (isField) {
            info = TextAttributeKeyInfo.field(highlighter, attributesKeyProvider);
        }
        if (info != null) return info;
        return attributesKeyProvider.getTextAttributeKeyInfoForResolveResult(resolve, highlighter);
    }

    @NotNull
    private static TextAttributeKeyInfo buildHighlightForClass(@NotNull PsiElement place, boolean isInterface, JSHighlighter highlighter) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForClass"));
        }
        TextAttributesKey type = highlighter.getMappedKey(isInterface ? JSHighlighter.JS_INTERFACE : JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForClass());
        TextAttributeKeyInfo textAttributeKeyInfo = new TextAttributeKeyInfo(type, isInterface ? "interface" : "class");
        if (textAttributeKeyInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForClass"));
        }
        return textAttributeKeyInfo;
    }

    @Nullable
    private static TextAttributeKeyInfo buildHighlightForVariable(@NotNull JSVariable element, @NotNull PsiElement place, JSHighlighter highlighter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForVariable"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForVariable"));
        }
        JSTextAttributeKeysProvider attributesKeyProvider = JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place);
        if (element instanceof JSParameter) {
            return TextAttributeKeyInfo.parameter(highlighter, attributesKeyProvider);
        }
        if (element.tryGetFunctionExpressionInitializer() != null) {
            return TextAttributeKeyInfo.globalFunction(highlighter);
        }
        if (JSSemanticHighlightingUtil.isClassContext(element.getContext()) || element.getNamespace() != null) {
            boolean isStatic = element.getJSContext() == JSContext.STATIC;
            return isStatic ? TextAttributeKeyInfo.staticMemberVariable(highlighter) : TextAttributeKeyInfo.instanceMemberVariable(highlighter);
        }
        boolean localVariable = false;
        if (element instanceof ImplicitJSVariableImpl) {
            JSType type = element.getType();
            if (type != null && "Arguments".equals(type.getTypeText())) {
                localVariable = true;
            }
        } else {
            JSElement node = JSPsiImplUtils.getScopeNode((JSNamedElement)element);
            boolean bl = localVariable = node instanceof JSFunction || node instanceof JSFile && ((JSFile)node).isCommonJSModule();
        }
        if (localVariable) {
            return TextAttributeKeyInfo.localVariable(highlighter, attributesKeyProvider);
        }
        return TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
    }

    public static void highlight(JSAttribute attribute, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)attribute, ECMAL4Highlighter.ECMAL4_METADATA, "attribute", holder);
    }

    public static void highlight(JSLabeledStatement labeledStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    public static void highlight(JSStatementWithLabelReference labeledStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    private static void lineMarker(@NotNull PsiElement element, TextAttributesKey attrKey, String debugName, AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "lineMarker"));
        }
        if (attrKey == null) {
            return;
        }
        PsiElement markedNode = element.getLastChild();
        if (markedNode == null) {
            markedNode = element;
        }
        while (markedNode.getNode().getElementType() != JSTokenTypes.IDENTIFIER && markedNode.getPrevSibling() != null) {
            markedNode = markedNode.getPrevSibling();
        }
        if (element instanceof JSAttribute) {
            markedNode = element;
        } else if (element instanceof JSNamedElement) {
            PsiElement nameElement = ((JSNamedElement)element).getNameIdentifier();
            if (nameElement != null) {
                markedNode = nameElement;
            } else if (element instanceof ES6Property) {
                markedNode = null;
            }
        }
        if (markedNode == null) {
            return;
        }
        JSSemanticHighlightingUtil.justLineMarker(markedNode, attrKey, debugName, holder);
    }

    private static void justLineMarker(PsiElement markedNode, TextAttributesKey attrKey, String debugName, AnnotationHolder holder) {
        holder.createInfoAnnotation(markedNode, debug ? debugName : null).setTextAttributes(attrKey);
    }

    public static void highlight(JSProperty node, JSHighlighter highlighter, AnnotationHolder holder) {
        if (node instanceof ES6Property && ((ES6Property)node).isShorthanded()) {
            return;
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForProperty(node, (PsiElement)node, highlighter);
        JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
    }

    private static TextAttributeKeyInfo buildHighlightForProperty(JSProperty node, PsiElement place, JSHighlighter highlighter) {
        if (JSPsiImplUtils.calculatePossibleFunction((PsiElement)node, place) != null) {
            return TextAttributeKeyInfo.instanceMethod(highlighter, place);
        }
        return TextAttributeKeyInfo.field(highlighter, JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place));
    }

    public static void highlight(JSVariable node, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement nameIdentifier;
        if (!(node instanceof JSParameter) && ((nameIdentifier = node.getNameIdentifier()) == null || nameIdentifier instanceof JSReferenceExpression)) {
            return;
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForResolveResult((PsiElement)node, (PsiElement)node, highlighter);
        if (info != null) {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
        }
    }

    public static void highlight(TypeScriptPropertySignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript property signature", holder);
    }

    public static void highlight(TypeScriptFunctionSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "TypeScript function signature", holder);
    }

    public static void highlight(TypeScriptGenericOrMappedTypeParameter parameter, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)parameter, highlighter.getMappedKey(TypeScriptHighlighter.TS_TYPE_PARAMETER), "TypeScript type parameter", holder);
    }

    public static void highlight(TypeScriptIndexSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement element = signature.getParameterNameElement();
        if (element != null) {
            JSSemanticHighlightingUtil.lineMarker(element, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript function signature", holder);
        }
    }

    public static void highlight(@NotNull TypeScriptModule<?> module, JSHighlighter highlighter, AnnotationHolder holder) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "highlight"));
        }
        if (DialectDetector.isTypeScript(module)) {
            JSSemanticHighlightingUtil.lineMarker(module, highlighter.getMappedKey(TypeScriptHighlighter.TS_MODULE_NAME), "moduleName", holder);
        } else {
            JSSemanticHighlightingUtil.lineMarker(module, highlighter.getMappedKey(JSHighlighter.JS_MODULE_NAME), "moduleName", holder);
        }
    }

    @NotNull
    private static PsiElement calculateMeaningfulElementForHighlighting(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "calculateMeaningfulElementForHighlighting"));
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateTargetElementForHighlighting(element);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "calculateMeaningfulElementForHighlighting"));
        }
        return psiElement;
    }

    public static final class TextAttributeKeyInfo {
        private final TextAttributesKey type;
        private final String text;

        public TextAttributeKeyInfo(@NotNull TextAttributesKey type, @NotNull String text) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo", "<init>"));
            }
            this.type = type;
            this.text = text;
        }

        @NotNull
        public TextAttributesKey getType() {
            TextAttributesKey textAttributesKey = this.type;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo", "getType"));
            }
            return textAttributesKey;
        }

        @NotNull
        public String getText() {
            String string = this.text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo", "getText"));
            }
            return string;
        }

        public static TextAttributeKeyInfo localVariable(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForLocalVariable()), "local variable");
        }

        public static TextAttributeKeyInfo staticMemberVariable(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_STATIC_MEMBER_VARIABLE), "static field");
        }

        public static TextAttributeKeyInfo parameter(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForParameter()), JSSemanticHighlightingUtil.PARAMETER_MESSAGE);
        }

        public static TextAttributeKeyInfo field(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getTextAttributesKeyForInstanceField()), JSSemanticHighlightingUtil.INSTANCE_FIELD);
        }

        public static TextAttributeKeyInfo instanceMemberVariable(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "field");
        }

        public static TextAttributeKeyInfo globalFunction(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_GLOBAL_FUNCTION), "global function");
        }

        public static TextAttributeKeyInfo instanceMethod(JSHighlighter highlighter, PsiElement place) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForInstanceMethod()), JSSemanticHighlightingUtil.INSTANCE_METHOD);
        }

        public static TextAttributeKeyInfo staticMethod(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_STATIC_MEMBER_FUNCTION), "static method");
        }

        public static TextAttributeKeyInfo constructor(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_KEYWORD), "constructor");
        }

        public static TextAttributeKeyInfo globalVariable(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForGlobalVariable()), "global variable");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextAttributeKeyInfo info = (TextAttributeKeyInfo)o;
            if (!this.type.equals((Object)info.type)) {
                return false;
            }
            return this.text.equals(info.text);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.text.hashCode();
            return result;
        }
    }
}

