/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.navigation.JavaScriptGotoSuperHandler;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSGotoTargetRendererProvider;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.MergeQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptLineMarkerProvider
implements LineMarkerProvider {
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;
    public static final Function<PsiElement, String> ourClassInheritorsTooltipProvider = new ConstantFunction((Object)"Has subclasses");
    private static final Function<PsiElement, String> ourImplementedInterfacesTooltipProvider = new ConstantFunction((Object)"Has implementations");
    private static final Function<PsiElement, String> ourOverriddenFunctionsTooltipProvider = new ConstantFunction((Object)"Is overridden");
    private static final Function<PsiElement, String> ourOverriddenFunctionsTooltipProvider2 = new ConstantFunction((Object)"Has subtypes");
    private static final Function<PsiElement, String> ourImplementingFunctionsTooltipProvider = new ConstantFunction((Object)"Is implemented");
    public static final BasicGutterIconNavigationHandler<JSClass> ourClassInheritorsNavHandler = new BasicGutterIconNavigationHandler<JSClass>(){

        @Override
        protected String getTitle(JSClass elt, int size) {
            String name = JSFormatUtil.formatClass(elt, 1);
            return JSBundle.message((String)"choose.subclass", (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSClass> search(JSClass elt) {
            return JSClassSearch.searchClassInheritors(elt, true);
        }
    };
    public static final BasicGutterIconNavigationHandler<JSClass> ourInterfaceImplementationsNavHandler = new BasicGutterIconNavigationHandler<JSClass>(){

        @Override
        protected String getTitle(JSClass elt, int size) {
            String name = JSFormatUtil.formatClass(elt, 1);
            return JSBundle.message((String)"choose.implementing.class", (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSClass> search(JSClass elt) {
            return JavaScriptLineMarkerProvider.createSearchImplementationsQuery(elt, true);
        }
    };
    private static final BasicGutterIconNavigationHandler<JSPsiElementBase> ourOverriddenMembersNavHandler = new BasicGutterIconNavigationHandler<JSPsiElementBase>(){

        @Override
        protected String getTitle(JSPsiElementBase elt, int size) {
            if (elt instanceof JSFunction) {
                boolean ecma = DialectDetector.isActionScript((PsiElement)elt);
                String name = JSFormatUtil.formatMember(elt, 1);
                return JSBundle.message((String)(ecma ? "choose.overridden.method" : "choose.overridden.function"), (Object[])new Object[]{name, size});
            }
            return JSBundle.message((String)"choose.overridden.function", (Object[])new Object[]{elt.getName(), size});
        }

        @Override
        public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
            return JSResolveUtil.doFindOverridenFunctionStatic(elt);
        }
    };
    private static final BasicGutterIconNavigationHandler<JSPsiElementBase> ourImplementingMembersNavHandler = new BasicGutterIconNavigationHandler<JSPsiElementBase>(){

        @Override
        protected String getTitle(JSPsiElementBase elt, int size) {
            boolean ecma = DialectDetector.isActionScript((PsiElement)elt);
            String name = JSFormatUtil.formatMember(elt, 1);
            return JSBundle.message((String)(ecma ? "choose.implementing.method" : "choose.implementing.function"), (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)elt);
            return JavaScriptLineMarkerProvider.createSearchImplementedMemberQuery(containingClass != null && containingClass.isInterface(), elt);
        }
    };

    public JavaScriptLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    private static PsiElement findPrev(PsiElement element, Class ... classes) {
        PsiElement startFrom = element.getFirstChild();
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (prev instanceof PsiComment) {
            startFrom = prev;
        }
        if (startFrom != null) {
            PsiElement cur = element.getPrevSibling();
            while (cur != null) {
                cur = cur.getPrevSibling();
                for (Class cls : classes) {
                    if (!cls.isInstance(cur)) continue;
                    return cur;
                }
            }
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createBottomMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startFrom", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createBottomMethodSeparatorLineMarker"));
        }
        if (colorsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsManager", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createBottomMethodSeparatorLineMarker"));
        }
        LineMarkerInfo info = new LineMarkerInfo(startFrom, startFrom.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.BOTTOM;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createBottomMethodSeparatorLineMarker"));
        }
        return lineMarkerInfo;
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getLineMarkerInfo"));
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        if (file != null && file.getFileType().isBinary()) {
            return null;
        }
        LineMarkerInfo elementParent = this.createSeparatorMarker(element);
        if (elementParent != null) {
            return elementParent;
        }
        JSPsiElementBase namedElement = JavaScriptLineMarkerProvider.getElementFromLineMarker(element, false);
        if (JSClassUtils.isPossibleHierarchyMember((PsiElement)namedElement) && JavaScriptLineMarkerProvider.getPlaceForLineMarker(namedElement) == element) {
            if (namedElement.getName() == null) {
                return null;
            }
            Ref className = new Ref();
            Ref isInterface = Ref.create((Object)Boolean.FALSE);
            JSInheritanceUtil.iterateOverriddenMembersUp(namedElement, true, (possibleOverriddenMember, s) -> {
                isInterface.set((Object)(s != null && JSSymbolUtil.isInterface(s, (PsiElement)namedElement) ? 1 : 0));
                className.set(s);
                return false;
            }, namedElement instanceof JSFunction);
            if (!className.isNull()) {
                String tooltip = JSBundle.message((String)((Boolean)isInterface.get() != false ? "linemarker.implements.method.in" : "linemarker.overrides.method.in"), (Object[])new Object[]{className.get()});
                return this.createOverridingOrImplementingMarker(namedElement, (Ref<Boolean>)isInterface, tooltip);
            }
        }
        return null;
    }

    @Nullable
    private LineMarkerInfo createSeparatorMarker(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createSeparatorMarker"));
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS) {
            PsiElement parent;
            if (element instanceof JSFunction && !(element instanceof JSFunctionExpression)) {
                PsiElement prev;
                PsiElement parent2 = JSResolveUtil.findParent(element);
                if (!(!JavaScriptLineMarkerProvider.isContainer(parent2) || (prev = JavaScriptLineMarkerProvider.findPrev(element, JSNamedElement.class, JSVarStatement.class)) == null || prev instanceof TypeScriptFunction && ((TypeScriptFunction)prev).isOverloadDeclaration())) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(element), (EditorColorsManager)this.myColorsManager);
                }
            } else if (element instanceof JSProperty) {
                PsiElement prev = JavaScriptLineMarkerProvider.findPrev(element, JSProperty.class);
                if (((JSProperty)element).tryGetFunctionInitializer() != null || prev instanceof JSProperty && ((JSProperty)prev).tryGetFunctionInitializer() != null) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(element), (EditorColorsManager)this.myColorsManager);
                }
            } else if (element instanceof JSAssignmentExpression) {
                JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)element;
                PsiElement elementParent = element.getParent();
                PsiElement prev = JavaScriptLineMarkerProvider.findPrev(elementParent, JSExpressionStatement.class);
                if (prev instanceof JSExpressionStatement) {
                    JSExpression rOperand = assignmentExpression.getROperand();
                    JSExpression prevExpression = ((JSExpressionStatement)prev).getExpression();
                    if (JavaScriptLineMarkerProvider.isNonArrowFunctionExpression(rOperand) || prevExpression instanceof JSAssignmentExpression && JavaScriptLineMarkerProvider.isNonArrowFunctionExpression(((JSAssignmentExpression)prevExpression).getROperand())) {
                        return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(elementParent), (EditorColorsManager)this.myColorsManager);
                    }
                }
            } else if (element instanceof JSVariable) {
                PsiElement identifier;
                JSExpression initializer = ((JSVariable)element).getInitializer();
                if (JavaScriptLineMarkerProvider.isNonArrowFunctionExpression(initializer) && (identifier = ((JSVariable)element).getNameIdentifier()) != null) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(identifier), (EditorColorsManager)this.myColorsManager);
                }
            } else if (element instanceof JSFunctionExpression && (parent = element.getParent()) instanceof JSProperty && PsiTreeUtil.getNextSiblingOfType((PsiElement)parent, JSProperty.class) == null) {
                return JavaScriptLineMarkerProvider.createBottomMethodSeparatorLineMarker(element, this.myColorsManager);
            }
        }
        return null;
    }

    private static boolean isNonArrowFunctionExpression(@Nullable JSExpression expression) {
        return expression instanceof JSFunctionExpression && !JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunctionExpression)expression));
    }

    protected LineMarkerInfo<PsiElement> createOverridingOrImplementingMarker(final JSPsiElementBase member, Ref<Boolean> isInterface, String tooltip) {
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(member, (Boolean)isInterface.get() != false ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod, (Function<? super PsiElement, String>)new ParameterizedFunction<String>(tooltip){

            public String fun(PsiElement element) {
                return (String)this.myParam;
            }
        }, new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement place) {
                if (!member.isValid()) {
                    return;
                }
                JSPsiElementBase elt = JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true);
                THashSet results = new THashSet();
                JSInheritanceUtil.iterateOverriddenMembersUp(member, true, (arg_0, arg_1) -> 6.lambda$navigate$0((Set)results, arg_0, arg_1), elt instanceof JSFunction);
                String name = JSFormatUtil.formatMember(elt, 1);
                boolean ecma = DialectDetector.isActionScript((PsiElement)elt);
                JavaScriptLineMarkerProvider.doNavigate((Collection)results, JSBundle.message((String)(ecma ? "choose.super.method" : "choose.super.function"), (Object[])new Object[]{name, results.size()}), e);
            }

            private static /* synthetic */ Boolean lambda$navigate$0(Set results, List functions, String s) {
                results.addAll(functions);
                return true;
            }
        }, 11);
    }

    private static boolean isContainer(PsiElement parent) {
        return parent instanceof JSClass || parent instanceof JSBlockStatement && parent.getParent() instanceof JSFunction || parent instanceof JSFile || parent instanceof JSEmbeddedContent;
    }

    private static PsiElement findElementToStartMethodSeparator(@NotNull PsiElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "findElementToStartMethodSeparator"));
        }
        PsiElement deepestFirst = PsiTreeUtil.getDeepestFirst((PsiElement)parent);
        ASTNode commentNode = deepestFirst.getNode();
        if (commentNode != null && commentNode.getElementType() == JSDocTokenTypes.DOC_COMMENT_START) {
            return deepestFirst;
        }
        PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)deepestFirst);
        PsiElement comment = null;
        while (!(!(leaf instanceof PsiWhiteSpace) && !(leaf instanceof PsiComment) || leaf instanceof PsiComment && (commentNode = (comment = leaf).getNode()) != null && commentNode.getElementType() == JSDocTokenTypes.DOC_COMMENT_START)) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        if (comment != null) {
            return comment;
        }
        return deepestFirst;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "collectSlowLineMarkers"));
        }
        THashMap jsFunctionsToProcess = new THashMap();
        THashMap classMembersToProcess = new THashMap();
        this.fillElementsToCheckMarkers(elements, (Map<String, Set<JSPsiElementBase>>)jsFunctionsToProcess, (Map<JSClass, Set<JSQualifiedNamedElement>>)classMembersToProcess);
        this.addFunctionMarkers(elements, (Map<String, Set<JSPsiElementBase>>)jsFunctionsToProcess, result);
        this.addMemberMarkers((Map<JSClass, Set<JSQualifiedNamedElement>>)classMembersToProcess, result);
    }

    protected void addMemberMarkers(@NotNull Map<JSClass, Set<JSQualifiedNamedElement>> jsMembersToProcess, @NotNull Collection<LineMarkerInfo> result) {
        if (jsMembersToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsMembersToProcess", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "addMemberMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "addMemberMarkers"));
        }
        for (Map.Entry<JSClass, Set<JSQualifiedNamedElement>> entry : jsMembersToProcess.entrySet()) {
            ProgressManager.checkCanceled();
            JSClass clazz = entry.getKey();
            Set<JSQualifiedNamedElement> members = entry.getValue();
            this.addLineMarkersForClass(clazz, members, result);
        }
    }

    protected void addLineMarkersForClass(final @NotNull JSClass clazz, final @Nullable Set<JSQualifiedNamedElement> members, final @NotNull Collection<LineMarkerInfo> result) {
        Query<JSClass> inheritorsAndImplementationsClassQuery;
        boolean classCanBeImplemented;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "addLineMarkersForClass"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "addLineMarkersForClass"));
        }
        Query<JSClass> inheritorsClassQuery = JSClassSearch.searchClassInheritors(clazz, members != null);
        final boolean isInterface = clazz.isInterface();
        inheritorsClassQuery.forEach((Processor)new Processor<JSClass>(){
            private boolean addedClassMarker;
            private final Set<JSQualifiedNamedElement> membersClone;
            {
                this.membersClone = members == null || clazz.isInterface() ? null : new THashSet((Collection)members);
            }

            public boolean process(JSClass jsClassInheritor) {
                if (!(clazz instanceof XmlBackedJSClass || isInterface || this.addedClassMarker)) {
                    result.add(JavaScriptLineMarkerProvider.this.createClassHasInheritorsMarker(clazz));
                    this.addedClassMarker = true;
                }
                if (this.membersClone != null) {
                    Iterator<JSQualifiedNamedElement> membersIterator = this.membersClone.iterator();
                    while (membersIterator.hasNext()) {
                        JSQualifiedNamedElement member = membersIterator.next();
                        JSField possibleOverrideMember = null;
                        if (member instanceof JSFunction) {
                            JSFunction function = (JSFunction)member;
                            possibleOverrideMember = jsClassInheritor.findFunctionByNameAndKind(function.getName(), function.getKind());
                        } else if (member instanceof JSField) {
                            possibleOverrideMember = jsClassInheritor.findFieldByName(member.getName());
                        }
                        if (possibleOverrideMember == null || !JavaScriptLineMarkerProvider.this.isOverrideMember((JSAttributeListOwner)possibleOverrideMember, (JSAttributeListOwner)member)) continue;
                        result.add(JavaScriptLineMarkerProvider.this.createOverriddenMemberMarker(member));
                        membersIterator.remove();
                    }
                }
                return this.membersClone != null && !this.membersClone.isEmpty();
            }
        });
        boolean bl = classCanBeImplemented = isInterface || DialectDetector.isTypeScript((PsiElement)clazz);
        if (classCanBeImplemented && (inheritorsAndImplementationsClassQuery = JavaScriptLineMarkerProvider.createSearchImplementationsQuery(clazz, false)).findFirst() != null) {
            result.add(this.createClassHasImplementationsMarker(clazz));
        }
        if (members == null) {
            return;
        }
        ProgressManager.checkCanceled();
        for (JSQualifiedNamedElement member : members) {
            Collection<JSPsiElementBase> implementedMembers;
            Query<JSPsiElementBase> query;
            if (classCanBeImplemented && (query = JavaScriptLineMarkerProvider.createSearchImplementedMemberQuery(isInterface, (JSPsiElementBase)member)).findFirst() != null) {
                result.add(this.createImplementedMemberMarker(member));
            }
            if (isInterface) continue;
            ProgressManager.checkCanceled();
            if (member instanceof JSFunction && JavaScriptLineMarkerProvider.hasOverrideModifier((JSFunction)member) || (implementedMembers = JSInheritanceUtil.findImplementedMembers(member)).isEmpty()) continue;
            result.add(this.createImplementingMemberMarker((JSPsiElementBase)member, implementedMembers));
        }
    }

    @NotNull
    private static Query<JSPsiElementBase> createSearchImplementedMemberQuery(boolean isInterface, JSPsiElementBase member) {
        MergeQuery query = JSMembersSearch.searchImplementingMembers(member, false);
        if (isInterface) {
            query = new MergeQuery(query, JSMembersSearch.searchOverridingMembers(member, false));
        }
        MergeQuery mergeQuery = query;
        if (mergeQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createSearchImplementedMemberQuery"));
        }
        return mergeQuery;
    }

    protected boolean isOverrideMember(JSAttributeListOwner possibleOverrideMember, JSAttributeListOwner member) {
        return possibleOverrideMember != null && JSInheritanceUtil.canHaveSuperMember(possibleOverrideMember) && JSInheritanceUtil.isRealOverride(possibleOverrideMember, JSResolveUtil.getNamespaceValue(member.getAttributeList()), (PsiElement)member);
    }

    @NotNull
    private static Query<JSClass> createSearchImplementationsQuery(@NotNull JSClass clazz, boolean deep) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createSearchImplementationsQuery"));
        }
        if (!clazz.isInterface()) {
            Query<JSClass> query = JSClassSearch.searchInterfaceImplementations(clazz, deep);
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createSearchImplementationsQuery"));
            }
            return query;
        }
        MergeQuery mergeQuery = new MergeQuery(JSClassSearch.searchInterfaceImplementations(clazz, deep), JSClassSearch.searchClassInheritors(clazz, deep));
        if (mergeQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createSearchImplementationsQuery"));
        }
        return mergeQuery;
    }

    private static boolean hasOverrideModifier(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "hasOverrideModifier"));
        }
        JSAttributeList attributeList = function.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE);
    }

    protected LineMarkerInfo<PsiElement> createClassHasInheritorsMarker(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createClassHasInheritorsMarker"));
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)clazz, AllIcons.Gutter.OverridenMethod, ourClassInheritorsTooltipProvider, ourClassInheritorsNavHandler);
    }

    protected LineMarkerInfo<PsiElement> createClassHasImplementationsMarker(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createClassHasImplementationsMarker"));
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)clazz, AllIcons.Gutter.ImplementedMethod, ourImplementedInterfacesTooltipProvider, ourInterfaceImplementationsNavHandler);
    }

    protected LineMarkerInfo<PsiElement> createOverriddenMemberMarker(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createOverriddenMemberMarker"));
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)member, AllIcons.Gutter.OverridenMethod, ourOverriddenFunctionsTooltipProvider, ourOverriddenMembersNavHandler);
    }

    protected LineMarkerInfo<PsiElement> createImplementedMemberMarker(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createImplementedMemberMarker"));
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)member, AllIcons.Gutter.ImplementedMethod, ourImplementingFunctionsTooltipProvider, ourImplementingMembersNavHandler);
    }

    protected LineMarkerInfo<PsiElement> createImplementingMemberMarker(@NotNull JSPsiElementBase member, @NotNull Collection<? extends JSPsiElementBase> implementedMembers) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createImplementingMemberMarker"));
        }
        if (implementedMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementedMembers", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createImplementingMemberMarker"));
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(member, AllIcons.Gutter.ImplementingMethod, (Function<? super PsiElement, String>)new ParameterizedFunction<PsiElement>(implementedMembers.size() == 1 ? (PsiElement)ContainerUtil.getFirstItem(implementedMembers) : null){

            public String fun(PsiElement place) {
                PsiElement implementedMethodIfOnly = (PsiElement)this.myParam;
                if (implementedMethodIfOnly != null) {
                    String name;
                    PsiElement element;
                    String in = JSBundle.message((String)"linemarker.implements.invalid", (Object[])new Object[0]);
                    if (implementedMethodIfOnly.isValid() && (element = PsiTreeUtil.getParentOfType((PsiElement)implementedMethodIfOnly, JSClass.class)) != null && (name = ((NavigationItem)element).getName()) != null) {
                        in = name;
                    }
                    return JSBundle.message((String)"linemarker.implements.text", (Object[])new Object[]{JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true).getName(), in});
                }
                return JSBundle.message((String)"linemarker.implements.several", (Object[])new Object[0]);
            }
        }, new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement place) {
                JSQualifiedNamedElement elt = (JSQualifiedNamedElement)JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true);
                Collection<JSPsiElementBase> results = JSInheritanceUtil.findImplementedMembers(elt);
                String name = JSFormatUtil.formatMember((JSPsiElementBase)elt, 1);
                JavaScriptLineMarkerProvider.doNavigate(results, JSBundle.message((String)"choose.super.method", (Object[])new Object[]{name, results.size()}), e);
            }
        });
    }

    protected void addFunctionMarkers(@NotNull List<PsiElement> elements, @NotNull Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, final @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "addFunctionMarkers"));
        }
        if (jsFunctionsToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFunctionsToProcess", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "addFunctionMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "addFunctionMarkers"));
        }
        for (Map.Entry<String, Set<JSPsiElementBase>> entry : jsFunctionsToProcess.entrySet()) {
            ProgressManager.checkCanceled();
            final boolean isInterface = JSSymbolUtil.isInterface(entry.getKey(), (PsiElement)entry.getValue().iterator().next());
            final HashSet processed = new HashSet();
            JSResolveUtil.MyNamespaceProcessor processor = new JSResolveUtil.MyNamespaceProcessor(entry.getValue(), false){

                @Override
                protected boolean doProcess(PsiElement elt) {
                    Icon icon;
                    if (processed.contains(this.function)) {
                        return false;
                    }
                    boolean isClassOverride = JSSymbolUtil.isConstructorSymbol(this.function);
                    Icon icon2 = icon = isInterface ? AllIcons.Gutter.ImplementedMethod : AllIcons.Gutter.OverridenMethod;
                    Function tooltipProvider = isClassOverride && isInterface ? ourImplementedInterfacesTooltipProvider : (isClassOverride ? ourOverriddenFunctionsTooltipProvider2 : (isInterface ? ourImplementingFunctionsTooltipProvider : ourOverriddenFunctionsTooltipProvider));
                    result.add(JavaScriptLineMarkerProvider.createLineMarkerInfo(this.function, icon, (Function<? super PsiElement, String>)tooltipProvider, (GutterIconNavigationHandler<PsiElement>)ourOverriddenMembersNavHandler));
                    processed.add(this.function);
                    return false;
                }
            };
            processor.processDescendantsOf(entry.getKey(), elements.get(0));
        }
    }

    protected void fillElementsToCheckMarkers(@NotNull List<PsiElement> elements, @NotNull Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, @NotNull Map<JSClass, Set<JSQualifiedNamedElement>> classMembersToProcess) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "fillElementsToCheckMarkers"));
        }
        if (jsFunctionsToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFunctionsToProcess", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "fillElementsToCheckMarkers"));
        }
        if (classMembersToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classMembersToProcess", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "fillElementsToCheckMarkers"));
        }
        for (PsiElement place : elements) {
            ProgressManager.checkCanceled();
            JSPsiElementBase el = JavaScriptLineMarkerProvider.getElementFromLineMarker(place, false);
            if (el == null) continue;
            if (JSClassUtils.isPossibleHierarchyMember((PsiElement)el)) {
                JSQualifiedNamedElement member = (JSQualifiedNamedElement)el;
                if (member instanceof JSFunction && this.isNativeFunction((JSFunction)member)) continue;
                JSClass parentClass = JSUtils.getMemberContainingClass((PsiElement)member);
                if (!JSInheritanceUtil.canBeSuperMember((JSAttributeListOwner)member) && (member instanceof JSFunction && !((JSFunction)member).isConstructor() || parentClass != null)) continue;
                if (parentClass != null) {
                    THashSet members = classMembersToProcess.get(parentClass);
                    if (members == null) {
                        members = new THashSet();
                        classMembersToProcess.put(parentClass, (Set<JSQualifiedNamedElement>)members);
                    }
                    members.add((JSQualifiedNamedElement)member);
                    continue;
                }
                PsiElement parent = member.getParent();
                if (!(parent instanceof JSFile) && !(member instanceof JSFunctionExpression)) continue;
                JavaScriptLineMarkerProvider.addJSSymbolToSearch(jsFunctionsToProcess, (JSPsiElementBase)member);
                continue;
            }
            if (el instanceof JSClass) {
                JSClass clazz = (JSClass)el;
                if (classMembersToProcess.containsKey(clazz)) continue;
                classMembersToProcess.put(clazz, null);
                continue;
            }
            if (!(el instanceof JSDefinitionExpression) && !(el instanceof JSVariable) || !JavaScriptLineMarkerProvider.isExtension((JSElement)el)) continue;
            JavaScriptLineMarkerProvider.addJSSymbolToSearch(jsFunctionsToProcess, el);
        }
    }

    public boolean isNativeFunction(JSFunction function) {
        JSAttributeList attrList;
        return function.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 && (attrList = function.getAttributeList()) != null && attrList.hasModifier(JSAttributeList.ModifierType.NATIVE);
    }

    @NotNull
    private static PsiElement getPlaceForLineMarker(@NotNull JSPsiElementBase element) {
        PsiElement nameIdentifier;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getPlaceForLineMarker"));
        }
        if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)element)) != element) {
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getPlaceForLineMarker"));
            }
            return psiElement;
        }
        PsiElement child = element.getFirstChild();
        Object object = child != null ? child : element;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getPlaceForLineMarker"));
        }
        return object;
    }

    @Contract(value="_, true -> !null")
    @Nullable
    public static JSPsiElementBase getElementFromLineMarker(@NotNull PsiElement place, boolean withAssertion) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getElementFromLineMarker"));
        }
        if (place instanceof XmlBackedJSClass) {
            return (JSPsiElementBase)place;
        }
        JSNamedElement namedElement = JSPsiImplUtils.findElementFromNameIdentifier(place);
        JSPsiElementBase parent = namedElement instanceof JSPsiElementBase ? (JSPsiElementBase)namedElement : (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)place, JSPsiElementBase.class, (boolean)false);
        JSFunction function = JSPsiImplUtils.getPossibleFunction((PsiElement)parent);
        if (function != null) {
            parent = function;
        }
        if (withAssertion) {
            assert (parent != null && JavaScriptLineMarkerProvider.getPlaceForLineMarker(parent) == place) : "named element wasn't found for " + parent;
            return parent;
        }
        return parent != null && JavaScriptLineMarkerProvider.getPlaceForLineMarker(parent) == place ? parent : null;
    }

    private static boolean isExtension(JSElement def) {
        JSCallExpression callExpression;
        JSExpression methodExpression;
        JSExpression rOperand = null;
        if (def instanceof JSDefinitionExpression) {
            rOperand = ((JSDefinitionExpression)def).getInitializer();
        } else if (def instanceof JSVariable) {
            rOperand = ((JSVariable)def).getInitializer();
        }
        if (rOperand instanceof JSCallExpression && (methodExpression = (callExpression = (JSCallExpression)rOperand).getMethodExpression()) instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)methodExpression;
            return JSSymbolUtil.isExtendCall(refExpr.getQualifier(), refExpr.getReferenceName(), null);
        }
        return false;
    }

    private static void addJSSymbolToSearch(Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, JSPsiElementBase function) {
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(function);
        if (qName != null) {
            THashSet functions = jsFunctionsToProcess.get(qName);
            if (functions == null) {
                functions = new THashSet();
                jsFunctionsToProcess.put(qName, (Set<JSPsiElementBase>)functions);
            }
            functions.add((JSPsiElementBase)function);
        }
    }

    private static void doNavigate(Collection<? extends JSPsiNamedElementBase> items, String popupTitle, MouseEvent e) {
        JSGotoTargetRendererProvider.JSClassListCellRenderer renderer = new JSGotoTargetRendererProvider.JSClassListCellRenderer();
        items = JavaScriptGotoSuperHandler.sort(items, renderer);
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])items.toArray(new NavigatablePsiElement[items.size()]), (String)popupTitle, null, (ListCellRenderer)((Object)renderer));
    }

    private static LineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull JSPsiElementBase element, Icon icon, @Nullable Function<? super PsiElement, String> tooltipProvider, @NotNull GutterIconNavigationHandler<PsiElement> navHandler) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createLineMarkerInfo"));
        }
        if (navHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navHandler", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createLineMarkerInfo"));
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(element, icon, tooltipProvider, navHandler, 11);
    }

    private static LineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull JSPsiElementBase element, Icon icon, @Nullable Function<? super PsiElement, String> tooltipProvider, @NotNull GutterIconNavigationHandler<PsiElement> navHandler, int updatePass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createLineMarkerInfo"));
        }
        if (navHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navHandler", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createLineMarkerInfo"));
        }
        PsiElement place = JavaScriptLineMarkerProvider.getPlaceForLineMarker(element);
        return new LineMarkerInfo(place, place.getTextRange(), icon, updatePass, tooltipProvider, navHandler, GutterIconRenderer.Alignment.RIGHT);
    }

    private static abstract class ParameterizedFunction<P>
    implements Function<PsiElement, String> {
        @Nullable
        protected final P myParam;

        public ParameterizedFunction(@Nullable P param) {
            this.myParam = param;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParameterizedFunction)) {
                return false;
            }
            P otherParam = ((ParameterizedFunction)obj).myParam;
            return this.myParam != null ? this.myParam.equals(otherParam) : otherParam == null;
        }

        public int hashCode() {
            return this.myParam != null ? this.myParam.hashCode() : 0;
        }
    }

    public static abstract class BasicGutterIconNavigationHandler<T extends JSPsiNamedElementBase>
    implements GutterIconNavigationHandler<PsiElement> {
        public void navigate(MouseEvent e, PsiElement place) {
            JSPsiElementBase elt = JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true);
            Query<JSPsiElementBase> elementQuery = this.search(elt);
            if (elementQuery == null) {
                return;
            }
            Collection navElements = elementQuery.findAll();
            JavaScriptLineMarkerProvider.doNavigate(navElements, this.getTitle(elt, navElements.size()), e);
        }

        protected abstract String getTitle(T var1, int var2);

        @Nullable
        public abstract Query<T> search(T var1);
    }
}

