/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.inspections.ES6UnusedImportsInspection;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportOptimizer
extends JSModuleImportOptimizerBase {
    public final boolean supports(PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        JSFile jsFile = (JSFile)file;
        return this.checkDialect(DialectDetector.dialectOfFile((PsiFile)jsFile));
    }

    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS) && !holder.isFlow;
    }

    @Override
    @NotNull
    public Collection<JSModuleImportOptimizerBase.UnusedModuleInfo> getModulesInfo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getModulesInfo"));
        }
        Collection<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations((PsiElement)file);
        if (declarations.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getModulesInfo"));
            }
            return list;
        }
        final ArrayList infos = ContainerUtil.newArrayList();
        for (ES6ImportDeclaration declaration : declarations) {
            ES6UnusedImportsHelper.UnusedInfo info = ES6UnusedImportsHelper.getInfo(declaration);
            if (!info.isSideEffectImport() && ES6ImportPsiUtil.getFromClauseText((ES6ImportExportDeclaration)declaration) == null) continue;
            infos.add(info);
        }
        final List<String> importTexts = this.buildNewImportsText(file, infos);
        JSModuleImportOptimizerBase.UnusedModuleInfo info = new JSModuleImportOptimizerBase.UnusedModuleInfo(){

            @Override
            public List<String> getImportTexts() {
                return importTexts;
            }

            @Override
            public PsiElement getAnchor() {
                ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem((List)infos);
                assert (item != null);
                return item.getDeclaration();
            }

            @Override
            public List<PsiElement> getOldImports() {
                return infos.stream().map(el -> el.getDeclaration()).collect(Collectors.toList());
            }
        };
        List list = ContainerUtil.createMaybeSingletonList((Object)info);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getModulesInfo"));
        }
        return list;
    }

    @NotNull
    private List<String> buildNewImportsText(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> result = ES6ImportOptimizer.groupByFromClause(infos);
        boolean merge = JSCodeStyleSettings.isMergeImports((PsiElement)file);
        ArrayList importsResult = ContainerUtil.newArrayList();
        HashSet visitedImports = ContainerUtil.newHashSet();
        HashSet visitedSideEffectImports = ContainerUtil.newHashSet();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        ArrayList toProcessInfos = ContainerUtil.newArrayList(infos);
        ES6ImportOptimizer.sortByModuleName(file, toProcessInfos);
        for (ES6UnusedImportsHelper.UnusedInfo info : toProcessInfos) {
            Collection mergedImports;
            ES6ImportDeclaration declaration = info.getDeclaration();
            if (info.isSideEffectImport()) {
                if (!visitedSideEffectImports.add(declaration.getImportModuleText())) continue;
                ArrayList sideEffectImportWithComments = ContainerUtil.newArrayList();
                ES6ImportOptimizer.addSideEffectImport(file, document, sideEffectImportWithComments, info);
                JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)declaration, sideEffectImportWithComments);
                continue;
            }
            String fromText = ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)declaration);
            if (fromText == null || !visitedImports.add(fromText) || (mergedImports = result.get((Object)fromText)).isEmpty()) continue;
            ArrayList currentImports = ContainerUtil.newArrayList();
            if (merge) {
                this.processMergedImports(file, document, currentImports, fromText, mergedImports);
            } else {
                HashSet visitedBindingNames = ContainerUtil.newHashSet();
                HashSet visitedSpecifierNames = ContainerUtil.newHashSet();
                for (ES6UnusedImportsHelper.UnusedInfo mergedInfo : mergedImports) {
                    List<String> importBodyText = this.getImportBodyText(file, document, ContainerUtil.createMaybeSingletonList((Object)mergedInfo), fromText, visitedBindingNames, visitedSpecifierNames);
                    currentImports.addAll(importBodyText);
                }
            }
            JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)declaration, currentImports);
        }
        ArrayList arrayList = importsResult;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "buildNewImportsText"));
        }
        return arrayList;
    }

    private static void sortByModuleName(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "sortByModuleName"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "sortByModuleName"));
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)file);
        if (!settings.IMPORT_SORT_MODULE_NAME) {
            return;
        }
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportFromComparator((PsiElement)file);
        ContainerUtil.sort(infos, (o1, o2) -> {
            ES6ImportDeclaration declaration1 = o1.getDeclaration();
            ES6ImportDeclaration declaration2 = o2.getDeclaration();
            String fromClauseText1 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)declaration1);
            String fromClauseText2 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)declaration2);
            return comparator.compare(fromClauseText1, fromClauseText2);
        });
    }

    protected void processMergedImports(@NotNull PsiFile file, @Nullable Document document, List<String> importsResult, String fromText, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "processMergedImports"));
        }
        importsResult.addAll(this.getImportBodyText(file, document, mergedImports, fromText));
    }

    private static void addSideEffectImport(@NotNull PsiFile file, @Nullable Document document, @NotNull List<String> importsResult, @NotNull ES6UnusedImportsHelper.UnusedInfo info) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (importsResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResult", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addSideEffectImport"));
        }
        ES6ImportDeclaration declaration = info.getDeclaration();
        String name = declaration.getImportModuleText();
        if (!StringUtil.isEmpty((String)name)) {
            List<PsiElement> prevComments = JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration);
            importsResult.addAll(JSOptimizeImportUtil.getPsiElementsAsStrings(prevComments));
            StringBuilder builder = new StringBuilder();
            builder.append("import ");
            ES6ImportOptimizer.addFromPartWithoutKeyword(file, StringUtil.unquoteString((String)name), builder);
            JSOptimizeImportUtil.addSameLineComments(document, (PsiElement)declaration, builder);
            importsResult.add(builder.toString());
        }
    }

    @NotNull
    private static MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> groupByFromClause(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        LinkedMultiMap results = new LinkedMultiMap();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            ES6ImportDeclaration declaration = info.getDeclaration();
            String text = ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)declaration);
            if (text == null) continue;
            results.putValue((Object)text, (Object)info);
        }
        LinkedMultiMap linkedMultiMap = results;
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "groupByFromClause"));
        }
        return linkedMultiMap;
    }

    private static boolean isSuppressedUnused(ES6ImportExportDeclaration declaration) {
        return SuppressionUtil.isSuppressedInStatement((PsiElement)declaration, (String)ES6UnusedImportsInspection.SHORT_NAME, ES6ImportDeclaration.class);
    }

    protected List<String> getImportBodyText(@NotNull PsiFile file, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (mergedImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedImports", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        HashSet bindings = ContainerUtil.newHashSet();
        HashSet specifiers = ContainerUtil.newHashSet();
        return this.getImportBodyText(file, document, mergedImports, fromPart, bindings, specifiers);
    }

    protected List<String> getImportBodyText(@NotNull PsiFile file, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart, @NotNull Collection<String> visitedBindingNames, @NotNull Collection<String> visitedSpecifierNames) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (mergedImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedImports", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (visitedBindingNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedBindingNames", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        if (visitedSpecifierNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedSpecifierNames", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportBodyText"));
        }
        ArrayList listOfImports = ContainerUtil.newArrayList();
        ArrayList bindings = ContainerUtil.newArrayList();
        ArrayList specifiers = ContainerUtil.newArrayList();
        ArrayList prevCommentsToProcess = ContainerUtil.newArrayList();
        HashMap lineCommentsToProcess = ContainerUtil.newHashMap();
        for (ES6UnusedImportsHelper.UnusedInfo importInfo : mergedImports) {
            ES6ImportDeclaration declaration = importInfo.getDeclaration();
            ES6ImportOptimizer.fillUsedBindingsAndSpecifiers(bindings, specifiers, importInfo, declaration);
            PsiElement comment = JSOptimizeImportUtil.getLineComment(document, (PsiElement)declaration);
            if (comment != null) {
                lineCommentsToProcess.put(declaration, comment);
            }
            prevCommentsToProcess.addAll(JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration));
        }
        if (JSCodeStyleSettings.getSettings((PsiElement)file).IMPORT_SORT_MEMBERS) {
            Comparator<ES6ImportSpecifier> comparator = ES6ImportPsiUtil.getImportMemberComparator((PsiElement)file);
            ContainerUtil.sort((List)specifiers, comparator);
        }
        String importPrefix = this.getImportPrefix(mergedImports);
        boolean needCommaBeforeBinding = false;
        boolean lastIsAll = false;
        StringBuilder importBody = new StringBuilder();
        ArrayList lineCommentsForCurrentImport = ContainerUtil.newArrayList();
        for (ES6ImportedBinding binding : bindings) {
            PsiElement comment;
            if (!visitedBindingNames.add(binding.getName())) continue;
            if (needCommaBeforeBinding) {
                ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
                JSOptimizeImportUtil.addSameLineComments(importBody, JSOptimizeImportUtil.getPsiElementsAsStrings(lineCommentsForCurrentImport));
                String resultText = importPrefix + importBody.toString();
                listOfImports.add(resultText);
                importBody.setLength(0);
                lineCommentsForCurrentImport.clear();
            } else {
                needCommaBeforeBinding = true;
            }
            ES6ImportDeclaration declaration = binding.getDeclaration();
            if (declaration != null && (comment = (PsiElement)lineCommentsToProcess.remove(declaration)) != null) {
                lineCommentsForCurrentImport.add(comment);
            }
            importBody.append(binding.getText());
            lastIsAll = binding.isNamespaceImport();
        }
        if (lastIsAll) {
            ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
            JSOptimizeImportUtil.addSameLineComments(importBody, JSOptimizeImportUtil.getPsiElementsAsStrings(lineCommentsForCurrentImport));
            listOfImports.add(importPrefix + importBody.toString());
            needCommaBeforeBinding = false;
            importBody.setLength(0);
            lineCommentsForCurrentImport.clear();
        }
        boolean needOpenSpecifierList = true;
        boolean needCommaBeforeSpecifier = false;
        for (ES6ImportSpecifier specifier : specifiers) {
            String name;
            PsiElement comment;
            ES6ImportDeclaration declaration = specifier.getDeclaration();
            if (declaration != null && (comment = (PsiElement)lineCommentsToProcess.remove(declaration)) != null) {
                lineCommentsForCurrentImport.add(comment);
            }
            if (!visitedSpecifierNames.add(name = specifier.getDeclaredName())) continue;
            if (needOpenSpecifierList) {
                needOpenSpecifierList = false;
                if (needCommaBeforeBinding) {
                    importBody.append(", ");
                }
                importBody.append('{');
            }
            if (needCommaBeforeSpecifier) {
                importBody.append(", ");
            } else {
                needCommaBeforeSpecifier = true;
            }
            importBody.append(specifier.getText());
        }
        if (!needOpenSpecifierList) {
            importBody.append('}');
        }
        if (!StringUtil.isEmpty((CharSequence)importBody)) {
            ES6ImportOptimizer.addFromPart(file, fromPart, importBody);
            JSOptimizeImportUtil.addSameLineComments(importBody, JSOptimizeImportUtil.getPsiElementsAsStrings(lineCommentsForCurrentImport));
            listOfImports.add(importPrefix + importBody.toString());
        }
        List<String> comments = JSOptimizeImportUtil.getPsiElementsAsStrings(prevCommentsToProcess);
        return ContainerUtil.concat(comments, (List)listOfImports);
    }

    private static void fillUsedBindingsAndSpecifiers(List<ES6ImportedBinding> bindings, List<ES6ImportSpecifier> specifiers, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration) {
        boolean isSuppressedUnused = ES6ImportOptimizer.isSuppressedUnused((ES6ImportExportDeclaration)declaration);
        ES6ImportedBinding[] currentBindings = declaration.getImportedBindings();
        ES6ImportSpecifier[] currentSpecifiers = declaration.getImportSpecifiers();
        Collection<Object> unusedBindings = isSuppressedUnused ? ContainerUtil.newArrayList() : importInfo.getUnusedBindings();
        Collection<Object> unusedSpecifiers = isSuppressedUnused ? ContainerUtil.newArrayList() : importInfo.getUnusedSpecifiers();
        bindings.addAll(Arrays.stream(currentBindings).filter(el -> !unusedBindings.contains(el)).collect(Collectors.toList()));
        specifiers.addAll(Arrays.stream(currentSpecifiers).filter(el -> !unusedSpecifiers.contains(el)).collect(Collectors.toList()));
    }

    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        if ("import " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "getImportPrefix"));
        }
        return "import ";
    }

    private static void addFromPart(PsiFile file, String fromPart, StringBuilder importBody) {
        importBody.append(" from ");
        ES6ImportOptimizer.addFromPartWithoutKeyword(file, fromPart, importBody);
    }

    private static void addFromPartWithoutKeyword(@NotNull PsiFile file, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        if (fromPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPart", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/javascript/imports/ES6ImportOptimizer", "addFromPartWithoutKeyword"));
        }
        String quote = JSCodeStyleSettings.getQuote((PsiElement)file);
        importBody.append(quote);
        importBody.append(fromPart);
        importBody.append(quote);
        importBody.append(JSCodeStyleSettings.getSemicolon(file));
    }
}

