/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JSOptimizeImportUtil {
    public static void addSameLineComments(Document document, @NotNull PsiElement context, @NotNull StringBuilder importBody) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "addSameLineComments"));
        }
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "addSameLineComments"));
        }
        JSOptimizeImportUtil.addSameLineComments(importBody, JSOptimizeImportUtil.getPsiElementsAsStrings(ContainerUtil.createMaybeSingletonList((Object)JSOptimizeImportUtil.getLineComment(document, context))));
    }

    public static void addSameLineComments(@NotNull StringBuilder importBody, @NotNull Collection<String> sameLineComments) {
        if (importBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importBody", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "addSameLineComments"));
        }
        if (sameLineComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sameLineComments", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "addSameLineComments"));
        }
        if (!sameLineComments.isEmpty()) {
            importBody.append(" ");
            importBody.append(StringUtil.join(sameLineComments, (String)" "));
        }
    }

    public static void fillImportsWithNewLines(@NotNull List<String> importsResult, @NotNull PsiElement context, @NotNull List<String> elements) {
        if (importsResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResult", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "fillImportsWithNewLines"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "fillImportsWithNewLines"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "fillImportsWithNewLines"));
        }
        if (elements.isEmpty()) {
            return;
        }
        if (importsResult.size() > 0) {
            List<PsiElement> whitespaces = JSOptimizeImportUtil.getWhitespacesBeforePrevImport(context);
            if (whitespaces.size() > 0) {
                importsResult.addAll(JSOptimizeImportUtil.getPsiElementsAsStrings(whitespaces));
            } else {
                importsResult.add("\n");
            }
        }
        for (int i = 0; i < elements.size(); ++i) {
            String current = elements.get(i);
            if (i > 0) {
                importsResult.add("\n");
            }
            importsResult.add(current);
        }
    }

    public static boolean isAvailable(@NotNull PsiFile file) {
        DirectoryInfo directoryInfo;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "isAvailable"));
        }
        if (!file.isValid() || DumbService.getInstance((Project)file.getProject()).isDumb()) {
            return false;
        }
        DirectoryIndex directoryIndex = DirectoryIndex.getInstance((Project)file.getProject());
        JpsModuleSourceRootType sourceRootType = directoryIndex.getSourceRootType(directoryInfo = directoryIndex.getInfoForFile(file.getVirtualFile()));
        return !JavaResourceRootType.TEST_RESOURCE.equals(sourceRootType);
    }

    public static void deleteSiblingWhitespaceBetweenImports(PsiElement beforeElement, PsiElement after, boolean deleteBefore) {
        PsiElement sibling;
        if (deleteBefore) {
            sibling = beforeElement;
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                PsiElement prev = sibling.getPrevSibling();
                if (!JSOptimizeImportUtil.prevIsAcceptable(prev)) continue;
                sibling.delete();
            }
        }
        sibling = after;
        while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
            PsiElement nextSibling = sibling.getNextSibling();
            if (!JSOptimizeImportUtil.nextIsAcceptable(nextSibling)) continue;
            sibling.delete();
        }
    }

    public static boolean prevIsAcceptable(PsiElement prev) {
        return prev == null || JSOptimizeImportUtil.isImport(prev) || prev instanceof PsiWhiteSpace || prev instanceof PsiComment;
    }

    public static boolean isImport(PsiElement prev) {
        return prev instanceof ES6ImportDeclaration || prev instanceof TypeScriptImportStatement || prev instanceof JSImportStatement;
    }

    public static List<String> getPsiElementsAsStrings(@NotNull Collection<PsiElement> toProcess) {
        if (toProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toProcess", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "getPsiElementsAsStrings"));
        }
        return toProcess.stream().map(el -> el.getText()).collect(Collectors.toList());
    }

    public static List<PsiElement> getWhitespacesBeforePrevImport(@NotNull PsiElement importDeclaration) {
        if (importDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDeclaration", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "getWhitespacesBeforePrevImport"));
        }
        PsiElement sibling = importDeclaration;
        ArrayList siblings = ContainerUtil.newArrayList();
        while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
            siblings.add(0, sibling);
            PsiElement prev = sibling.getPrevSibling();
            if (!JSOptimizeImportUtil.isImport(prev)) continue;
            return siblings;
        }
        return ContainerUtil.emptyList();
    }

    public static boolean nextIsAcceptable(PsiElement next) {
        return next == null || JSOptimizeImportUtil.isImport(next) || next instanceof PsiWhiteSpace;
    }

    public static boolean isSameLineElement(@NotNull Document document, @NotNull PsiElement startElement, @NotNull PsiElement endElement, int offsetLine) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "isSameLineElement"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "isSameLineElement"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "isSameLineElement"));
        }
        int startElementEndOffset = document.getLineNumber(startElement.getTextRange().getEndOffset());
        int endElementStartOffset = document.getLineNumber(endElement.getTextRange().getStartOffset());
        return endElementStartOffset == offsetLine + startElementEndOffset;
    }

    public static PsiElement getLineComment(@Nullable Document document, @NotNull PsiElement declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "getLineComment"));
        }
        if (document == null) {
            return null;
        }
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)declaration, (Class[])new Class[]{PsiWhiteSpace.class});
        if (next instanceof PsiComment) {
            boolean isSameLineElements = JSOptimizeImportUtil.isSameLineElement(document, declaration, next, 0);
            return isSameLineElements ? next : null;
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> getPrevComments(@Nullable Document document, @NotNull PsiElement declaration) {
        PsiElement nextPrev;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "getPrevComments"));
        }
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)declaration, (Class[])new Class[]{PsiWhiteSpace.class});
        if (document == null || prev == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "getPrevComments"));
            }
            return list;
        }
        if (!JSOptimizeImportUtil.isSameLineElement(document, prev, declaration, 1) && !JSOptimizeImportUtil.isSameLineElement(document, prev, declaration, 0)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "getPrevComments"));
            }
            return list;
        }
        ArrayList comments = ContainerUtil.newArrayList();
        while (prev instanceof PsiComment && ((nextPrev = PsiTreeUtil.skipSiblingsBackward((PsiElement)prev, (Class[])new Class[]{PsiWhiteSpace.class})) == null || nextPrev instanceof PsiComment || !JSOptimizeImportUtil.isSameLineElement(document, prev, nextPrev, 0))) {
            comments.add(0, prev);
            prev = nextPrev;
        }
        ArrayList arrayList = comments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "getPrevComments"));
        }
        return arrayList;
    }

    public static void addNewImportTexts(@NotNull List<String> importTexts, @NotNull Project project, @Nullable Document document, @NotNull PsiElement context) {
        if (importTexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importTexts", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "addNewImportTexts"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "addNewImportTexts"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/imports/JSOptimizeImportUtil", "addNewImportTexts"));
        }
        String text = StringUtil.join(importTexts, (String)"");
        PsiFile newFile = JSChangeUtil.createJSFileFromText(project, text, DialectDetector.languageDialectOfElement(context));
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat((PsiElement)newFile);
        List<PsiElement> comments = JSOptimizeImportUtil.getPrevComments(document, context);
        PsiElement anchor = context;
        if (comments.size() > 0) {
            anchor = comments.get(0);
        }
        PsiElement siblingBeforeAnchor = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchor, (Class[])new Class[]{PsiWhiteSpace.class});
        PsiElement parent = anchor.getParent();
        PsiElement element = SharedImplUtil.addRange((PsiElement)parent, (PsiElement)newFile.getFirstChild(), (PsiElement)newFile.getLastChild(), (ASTNode)anchor.getNode(), (Boolean)Boolean.TRUE);
        if (element instanceof PsiComment && !(siblingBeforeAnchor instanceof PsiComment)) {
            JSChangeUtil.addWs(parent.getNode(), element.getNode(), "\n");
        }
    }

    public static class CommentHolder {
        public final List<PsiElement> prevComments;
        public final PsiElement lineComment;

        public CommentHolder(List<PsiElement> prevComments, PsiElement lineComment) {
            this.prevComments = prevComments;
            this.lineComment = lineComment;
        }
    }
}

