/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.ES6ImportIndex;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.typescript.modules.TypeScriptSimpleModuleReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportPathsResolver {
    public static final String INDEX_TS = "index.ts";
    private static final String[] INDEX_FILES = new String[]{"index.ts", "index.d.ts", "index.tsx"};
    private static final int USE_CACHED_VALUE = 1;
    private final ParameterizedCachedValueProvider<IncludingFilesCacheResult, VirtualFile> myCacheProvider;
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiFileFactory myPsiFileFactory;
    @NotNull
    private PsiManager myPsiManager;
    @NotNull
    private final PsiModificationTracker myTracker;
    private final ConcurrentMap<VirtualFile, ParameterizedCachedValue<IncludingFilesCacheResult, VirtualFile>> myLibraryIncludingCache;

    public IncludingFilesCacheResult createIndexValueCountTracker(@NotNull VirtualFile[] directIncludes, boolean isIndexFile, @NotNull String name, @Nullable String parentName, MultiMap<VirtualFile, ES6ImportIndex.ImportInfo> candidates, MultiMap<VirtualFile, ES6ImportIndex.ImportInfo> directoryCandidates) {
        if (directIncludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directIncludes", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "createIndexValueCountTracker"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "createIndexValueCountTracker"));
        }
        return this.createIndexValueCountTracker(directIncludes, name, parentName, isIndexFile, candidates.size(), isIndexFile ? directoryCandidates.size() : 0, candidates.hashCode(), isIndexFile ? directoryCandidates.hashCode() : 0);
    }

    @NotNull
    public IncludingFilesCacheResult createIndexValueCountTracker(final @NotNull VirtualFile[] directIncludes, final @NotNull String name, final @Nullable String directoryName, final boolean isIndex, final int candidateSize, final int directoryCandidateSize, final int candidatesHashCode, final int directoryCandidateHashCode) {
        if (directIncludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directIncludes", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "createIndexValueCountTracker"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "createIndexValueCountTracker"));
        }
        IncludingFilesCacheResult includingFilesCacheResult = new IncludingFilesCacheResult(){
            volatile boolean isTrackingStarted = false;
            volatile long lastModification = TypeScriptImportPathsResolver.access$100(TypeScriptImportPathsResolver.this).getModificationCount();

            @Override
            @NotNull
            public VirtualFile[] getValues() {
                if (directIncludes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver$1", "getValues"));
                }
                return directIncludes;
            }

            @Override
            public void startTracking() {
                if (this.isTrackingStarted) {
                    return;
                }
                this.isTrackingStarted = true;
            }

            public long getModificationCount() {
                MultiMap directoryCandidates;
                if (!this.isTrackingStarted) {
                    return 1L;
                }
                ApplicationManager.getApplication().assertReadAccessAllowed();
                long count = TypeScriptImportPathsResolver.this.myTracker.getModificationCount();
                if (count == this.lastModification) {
                    return 1L;
                }
                MultiMap candidates = TypeScriptImportPathsResolver.this.getCandidatesFromIndex(name);
                if (candidates.size() != candidateSize || candidates.hashCode() != candidatesHashCode) {
                    return -1L;
                }
                if (isIndex && directoryName != null && ((directoryCandidates = TypeScriptImportPathsResolver.this.getCandidatesFromIndex(directoryName)).size() != directoryCandidateSize || directoryCandidates.hashCode() != directoryCandidateHashCode)) {
                    return -1L;
                }
                this.lastModification = count;
                return 1L;
            }
        };
        if (includingFilesCacheResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "createIndexValueCountTracker"));
        }
        return includingFilesCacheResult;
    }

    public static TypeScriptImportPathsResolver getInstance(Project project) {
        return (TypeScriptImportPathsResolver)ServiceManager.getService((Project)project, TypeScriptImportPathsResolver.class);
    }

    public TypeScriptImportPathsResolver(@NotNull Project project, @NotNull PsiFileFactory psiFileFactory, @NotNull PsiManager psiManager, @NotNull PsiModificationTracker tracker) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "<init>"));
        }
        if (psiFileFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileFactory", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "<init>"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "<init>"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "<init>"));
        }
        this.myCacheProvider = new IncludingCacheProvider();
        this.myLibraryIncludingCache = ContainerUtil.newConcurrentMap();
        this.myProject = project;
        this.myPsiFileFactory = psiFileFactory;
        this.myPsiManager = psiManager;
        this.myTracker = tracker;
        project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver$2", "after"));
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFilePropertyChangeEvent) {
                        return;
                    }
                    TypeScriptImportPathsResolver.this.myLibraryIncludingCache.clear();
                }
            }
        });
    }

    @Nullable
    protected PsiFileSystemItem resolveIncludedFile(@NotNull ES6ImportIndex.ImportInfo info, final @NotNull PsiFile context) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "resolveIncludedFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "resolveIncludedFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final String path = info.getPath();
        final boolean hasExtension = JSFileReference.findExtension(path, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null;
        PsiFileImpl psiFile = (PsiFileImpl)this.myPsiFileFactory.createFileFromText("dummy.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)path);
        psiFile.setOriginalFile(context);
        return new FileReferenceSet((PsiElement)psiFile){

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                VirtualFile parent;
                VirtualFile nodeModules;
                Collection contexts = super.computeDefaultContexts();
                if (path.startsWith(".")) {
                    Collection collection = contexts;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver$3", "computeDefaultContexts"));
                    }
                    return collection;
                }
                VirtualFile config = TypeScriptImportPathsResolver.getConfig(context.getVirtualFile());
                if (config != null && (nodeModules = (parent = config.getParent()).findChild("node_modules")) != null) {
                    ArrayList items = ContainerUtil.newArrayList((Iterable)contexts);
                    TypeScriptImportPathsResolver.this.addFileIfNotNull(nodeModules, items);
                    VirtualFile types = nodeModules.findChild("@types");
                    if (types != null) {
                        TypeScriptImportPathsResolver.this.addFileIfNotNull(types, items);
                    }
                    ArrayList arrayList = items;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver$3", "computeDefaultContexts"));
                    }
                    return arrayList;
                }
                Collection collection = contexts;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver$3", "computeDefaultContexts"));
                }
                return collection;
            }

            public FileReference createFileReference(TextRange range, int index, String text) {
                return hasExtension ? super.createFileReference(range, index, text) : new TypeScriptSimpleModuleReference(text, index, range, this){

                    @Override
                    protected ResolveResult resolveDirectory(@NotNull PsiDirectory element) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver$3$1", "resolveDirectory"));
                        }
                        PsiFile indexFile = JSFileReferencesUtil.findIndexFile(TYPESCRIPT_EXTENSIONS_FIXED_ORDER, (PsiFileSystemItem)element);
                        if (indexFile != null) {
                            return new JSResolveResult((PsiElement)indexFile);
                        }
                        return super.resolveDirectory(element);
                    }
                };
            }

            protected boolean useIncludingFileAsContext() {
                return false;
            }
        }.resolve();
    }

    private void addFileIfNotNull(@NotNull VirtualFile virtualFile, @NotNull Collection<PsiFileSystemItem> items) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "addFileIfNotNull"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "addFileIfNotNull"));
        }
        PsiDirectory file = this.myPsiManager.findDirectory(virtualFile);
        if (file != null) {
            items.add((PsiFileSystemItem)file);
        }
    }

    @Nullable
    private static VirtualFile getConfig(@NotNull VirtualFile currentFile) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "getConfig"));
        }
        for (VirtualFile toCheck = currentFile.getParent(); toCheck != null; toCheck = toCheck.getParent()) {
            VirtualFile configFile = toCheck.findChild("tsconfig.json");
            if (configFile == null) continue;
            return configFile;
        }
        return null;
    }

    public VirtualFile[] getIncludingFiles(@NotNull VirtualFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "getIncludingFiles"));
        }
        ParameterizedCachedValue<IncludingFilesCacheResult, VirtualFile> value = this.getOrCreateCachedValue(context);
        IncludingFilesCacheResult result = (IncludingFilesCacheResult)value.getValue((Object)context);
        result.startTracking();
        return result.getValues();
    }

    private ParameterizedCachedValue<IncludingFilesCacheResult, VirtualFile> getOrCreateCachedValue(@NotNull VirtualFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "getOrCreateCachedValue"));
        }
        ParameterizedCachedValue value = (ParameterizedCachedValue)this.myLibraryIncludingCache.get(context);
        if (value != null) {
            return value;
        }
        ParameterizedCachedValue<IncludingFilesCacheResult, VirtualFile> defaultValue = CachedValuesManager.getManager((Project)this.myProject).createParameterizedCachedValue(this.myCacheProvider, true);
        ParameterizedCachedValue<IncludingFilesCacheResult, VirtualFile> prev = this.myLibraryIncludingCache.putIfAbsent(context, defaultValue);
        return prev == null ? defaultValue : prev;
    }

    private VirtualFile[] getIncludingFilesForCandidates(@NotNull VirtualFile context, @NotNull MultiMap<VirtualFile, ES6ImportIndex.ImportInfo> candidates) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "getIncludingFilesForCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "getIncludingFilesForCandidates"));
        }
        if (candidates.isEmpty()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile candidate : candidates.keySet()) {
            PsiFile candidatePsiFile;
            if (context.equals(candidate) || (candidatePsiFile = this.myPsiManager.findFile(candidate)) == null) continue;
            for (ES6ImportIndex.ImportInfo info : candidates.get((Object)candidate)) {
                PsiFileSystemItem item = this.resolveIncludedFile(info, candidatePsiFile);
                if (item == null || !context.equals(item.getVirtualFile())) continue;
                result.add(candidate);
            }
        }
        return (VirtualFile[])ArrayUtil.toObjectArray((Collection)result, VirtualFile.class);
    }

    private MultiMap<VirtualFile, ES6ImportIndex.ImportInfo> getCandidatesFromIndex(String name) {
        String nameWithoutExtension = TypeScriptUtil.getFileNameWithoutExtension(name);
        return ES6ImportIndex.getIncludingFileCandidates(nameWithoutExtension, GlobalSearchScope.allScope((Project)this.myProject));
    }

    private class IncludingCacheProvider
    implements ParameterizedCachedValueProvider<IncludingFilesCacheResult, VirtualFile> {
        private IncludingCacheProvider() {
        }

        public CachedValueProvider.Result<IncludingFilesCacheResult> compute(VirtualFile virtualFile) {
            VirtualFile parent;
            String name = virtualFile.getName();
            MultiMap candidates = TypeScriptImportPathsResolver.this.getCandidatesFromIndex(name);
            Object[] directIncludes = TypeScriptImportPathsResolver.this.getIncludingFilesForCandidates(virtualFile, (MultiMap<VirtualFile, ES6ImportIndex.ImportInfo>)candidates);
            boolean isIndex = ArrayUtil.contains((String)name, (String[])INDEX_FILES);
            ArrayList<Object> deps = new ArrayList<Object>(directIncludes.length);
            MultiMap directoryCandidates = MultiMap.empty();
            String parentName = null;
            if (isIndex && (parent = virtualFile.getParent()) != null) {
                parentName = parent.getName();
                directoryCandidates = TypeScriptImportPathsResolver.this.getCandidatesFromIndex(parentName);
                Object[] additionalIncludes = TypeScriptImportPathsResolver.this.getIncludingFilesForCandidates(virtualFile, (MultiMap<VirtualFile, ES6ImportIndex.ImportInfo>)directoryCandidates);
                directIncludes = (VirtualFile[])ArrayUtil.mergeArrays((Object[])directIncludes, (Object[])additionalIncludes);
                if (additionalIncludes.length > 0) {
                    deps.add(parent);
                }
            }
            ContainerUtil.addAll(deps, (Iterable)directoryCandidates.keySet());
            ContainerUtil.addAll(deps, (Iterable)candidates.keySet());
            deps.add(virtualFile);
            deps.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            IncludingFilesCacheResult result = TypeScriptImportPathsResolver.this.createIndexValueCountTracker((VirtualFile[])directIncludes, isIndex, name, parentName, (MultiMap<VirtualFile, ES6ImportIndex.ImportInfo>)candidates, (MultiMap<VirtualFile, ES6ImportIndex.ImportInfo>)directoryCandidates);
            return CachedValueProvider.Result.create((Object)result, deps);
        }
    }

    static interface IncludingFilesCacheResult
    extends ModificationTracker {
        @NotNull
        public VirtualFile[] getValues();

        public void startTracking();
    }
}

