/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inject;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.inject.JSUnicodeRegexpLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.EnumSet;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRegexpHost
implements RegExpLanguageHost {
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    public boolean characterNeedsEscaping(char c) {
        return c == '/';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    public boolean supportsPossessiveQuantifiers() {
        return false;
    }

    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        if (group.getType() != RegExpGroup.Type.PYTHON_NAMED_GROUP) {
            return false;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)group.getProject()).getInjectionHost((PsiElement)group);
        return host != null && DialectDetector.isActionScript((PsiElement)host);
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        if (!ref.isPythonNamedGroupRef()) {
            return false;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)ref.getProject()).getInjectionHost((PsiElement)ref);
        return host != null && DialectDetector.isActionScript((PsiElement)host);
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost((PsiElement)context);
        if (host == null || DialectDetector.isActionScript((PsiElement)host)) {
            EnumSet enumSet = EMPTY_NAMED_GROUP_TYPES;
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inject/JSRegexpHost", "getSupportedNamedGroupTypes"));
            }
            return enumSet;
        }
        EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.PYTHON_NAMED_GROUP);
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inject/JSRegexpHost", "getSupportedNamedGroupTypes"));
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return ((Object)((Object)JSUnicodeRegexpLanguage.INSTANCE)).equals(regExpChar.getContainingFile().getLanguage()) && regExpChar.getUnescapedText().charAt(1) == 'u';
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookbehindGroup", "com/intellij/lang/javascript/inject/JSRegexpHost", "supportsLookbehind"));
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)lookbehindGroup.getProject()).getInjectionHost((PsiElement)lookbehindGroup);
        if (host != null && DialectDetector.isActionScript((PsiElement)host)) {
            return RegExpLanguageHost.Lookbehind.VARIABLE_LENGTH_ALTERNATION;
        }
        return RegExpLanguageHost.Lookbehind.NOT_SUPPORTED;
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/lang/javascript/inject/JSRegexpHost", "isValidCategory"));
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = this.myPropertiesProvider.getAllKnownProperties();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inject/JSRegexpHost", "getAllKnownProperties"));
        }
        return stringArray;
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inject/JSRegexpHost", "getKnownCharacterClasses"));
        }
        return stringArray;
    }
}

