/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.JSConvertToForEachIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.control.ConstantIfStatementJSInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertForInToForOfQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private final SmartPsiElementPointer<JSForInStatement> myPointer;

    public ES6ConvertForInToForOfQuickFix(@NotNull JSForInStatement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "<init>"));
        }
        this.myPointer = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.for.in.to.for.of.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.for.in.to.for.of.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "isAvailable"));
        }
        JSForInStatement element = (JSForInStatement)this.myPointer.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        return new MyReferences(element).findReferences();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "invoke"));
        }
        this.applyImpl();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "applyFix"));
        }
        this.applyImpl();
    }

    private void applyImpl() {
        JSForInStatement forInStatement = (JSForInStatement)this.myPointer.getElement();
        if (forInStatement == null || !forInStatement.isValid()) {
            return;
        }
        MyReferences references = new MyReferences(forInStatement).keepReferences();
        if (!references.findReferences()) {
            return;
        }
        ASTNode inNode = forInStatement.getNode().findChildByType(JSTokenTypes.IN_KEYWORD);
        if (inNode == null) {
            return;
        }
        Project project = forInStatement.getProject();
        String newVarName = ES6ConvertForInToForOfQuickFix.getNewVarName(forInStatement, references);
        ES6ConvertForInToForOfQuickFix.replaceReferences(references, project, newVarName);
        ES6ConvertForInToForOfQuickFix.replaceHasOwnProperty(references, project);
        ES6ConvertForInToForOfQuickFix.replaceVariable(forInStatement, references, newVarName);
        ES6ConvertForInToForOfQuickFix.replaceInToOf(inNode, project);
    }

    private static void replaceHasOwnProperty(MyReferences references, Project project) {
        Collection<JSCallExpression> ownPropertyColl = references.getHasOwnPropertyCollection();
        if (!ownPropertyColl.isEmpty()) {
            JSIfStatement ifStatement = JSChangeUtil.createStatementSafe(project, "if(true){}", JSIfStatement.class);
            JSLiteralExpression trueLiteral = (JSLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)ifStatement, JSLiteralExpression.class);
            assert (trueLiteral != null);
            ArrayList<JSIfStatement> ifs = new ArrayList<JSIfStatement>();
            for (JSCallExpression expression : ownPropertyColl) {
                if (expression.getParent() instanceof JSIfStatement) {
                    ifs.add((JSIfStatement)expression.getParent());
                }
                expression.replace((JSExpression)trueLiteral);
            }
            if (!ifs.isEmpty()) {
                for (JSIfStatement anIf : ifs) {
                    ConstantIfStatementJSInspection.ConstantIfStatementFix.simplifyConstantIf(anIf);
                }
            }
        }
    }

    private static void replaceInToOf(ASTNode inNode, Project project) {
        JSForInStatement dummy = JSChangeUtil.createStatementSafe(project, "for (let a of arr){}", JSForInStatement.class);
        ASTNode ofNode = dummy.getNode().findChildByType(JSTokenTypes.OF_KEYWORD);
        assert (ofNode != null);
        PsiElement of = ofNode.getPsi();
        inNode.getPsi().replace(of);
    }

    private static void replaceVariable(JSForInStatement forInStatement, MyReferences references, String newVarName) {
        JSVarStatement varStatement = JSChangeUtil.createStatementSafe(forInStatement.getProject(), "const " + newVarName, JSVarStatement.class);
        PsiElement holder = references.getVariableHolder();
        if (holder instanceof JSVariable) {
            holder.getParent().replace((PsiElement)varStatement);
        } else {
            forInStatement.getVariableExpression().replace((PsiElement)varStatement);
        }
    }

    private static void replaceReferences(MyReferences references, Project project, String newVarName) {
        Collection<JSIndexedPropertyAccessExpression> accessExpressions = references.getReferences();
        if (!accessExpressions.isEmpty()) {
            ASTNode ast = JSChangeUtil.createExpressionFromText(project, newVarName);
            assert (ast != null);
            JSReferenceExpression newVarRef = (JSReferenceExpression)ast.getPsi(JSReferenceExpression.class);
            for (JSIndexedPropertyAccessExpression expression : accessExpressions) {
                expression.replace((JSExpression)newVarRef);
            }
        }
    }

    @NotNull
    private static String getNewVarName(JSForInStatement forInStatement, MyReferences references) {
        String collectionName = references.getCollectionExpressionName();
        String newVarName = collectionName == null ? null : StringUtil.unpluralize((String)collectionName);
        String string = newVarName = newVarName == null ? JSChangeUtil.generateNewVarName(collectionName + "Item", JSChangeUtil.getScopeElementInFile((PsiElement)forInStatement)) : newVarName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertForInToForOfQuickFix", "getNewVarName"));
        }
        return string;
    }

    private static class MyReferences {
        private final JSForInStatement myElement;
        private Collection<JSIndexedPropertyAccessExpression> myReferences;
        private Collection<JSCallExpression> myHasOwnPropertyCollection;
        private boolean myIsValid = false;
        private String myCollectionExpressionName;
        private PsiElement myVariableHolder;
        private JSElement myIterableExpression;

        public MyReferences(JSForInStatement element) {
            this.myElement = element;
        }

        public MyReferences keepReferences() {
            this.myReferences = new HashSet<JSIndexedPropertyAccessExpression>();
            this.myHasOwnPropertyCollection = new HashSet<JSCallExpression>();
            return this;
        }

        public boolean findReferences() {
            this.myIterableExpression = this.myElement.getCollectionExpression();
            JSElement jSElement = this.myIterableExpression = this.myIterableExpression instanceof JSReferenceExpression ? (JSElement)((JSReferenceExpression)this.myIterableExpression).resolve() : this.myIterableExpression;
            if (this.myIterableExpression == null || !this.myIterableExpression.isValid()) {
                return false;
            }
            this.myCollectionExpressionName = this.myIterableExpression instanceof JSNamedElement ? this.myIterableExpression.getName() : null;
            this.myVariableHolder = (PsiElement)JSConvertToForEachIntention.getForInVarName(this.myElement).getSecond();
            PsiElement searchTarget = this.myVariableHolder;
            if (searchTarget instanceof JSReferenceExpression) {
                searchTarget = ((JSReferenceExpression)searchTarget).resolve();
            }
            if (searchTarget == null || !searchTarget.isValid()) {
                return false;
            }
            Collection all = ReferencesSearch.search((PsiElement)searchTarget, (SearchScope)new LocalSearchScope((PsiElement)this.myElement)).findAll();
            for (PsiReference reference : all) {
                JSReferenceExpression method;
                PsiElement grand;
                if (!(reference instanceof PsiElement)) {
                    return false;
                }
                if (this.myVariableHolder.equals(reference)) continue;
                PsiElement parent = ((PsiElement)reference).getParent();
                if (parent instanceof JSIndexedPropertyAccessExpression) {
                    PsiElement resolve;
                    JSExpression qualifier = ((JSIndexedPropertyAccessExpression)parent).getQualifier();
                    if (qualifier instanceof JSReferenceExpression && this.myIterableExpression.equals(resolve = ((JSReferenceExpression)qualifier).resolve())) {
                        if (this.myReferences == null) continue;
                        this.myReferences.add((JSIndexedPropertyAccessExpression)parent);
                        continue;
                    }
                } else if (parent instanceof JSArgumentList && (grand = parent.getParent()) instanceof JSCallExpression && ((JSCallExpression)grand).getMethodExpression() instanceof JSReferenceExpression && (method = (JSReferenceExpression)((JSCallExpression)grand).getMethodExpression()).getQualifier() instanceof JSReferenceExpression && this.myIterableExpression.equals(((JSReferenceExpression)method.getQualifier()).resolve()) && "hasOwnProperty".equals(method.getReferenceName())) {
                    if (this.myHasOwnPropertyCollection == null) continue;
                    this.myHasOwnPropertyCollection.add((JSCallExpression)grand);
                    continue;
                }
                return false;
            }
            this.myIsValid = true;
            return true;
        }

        public PsiElement getVariableHolder() {
            return this.myVariableHolder;
        }

        public Collection<JSIndexedPropertyAccessExpression> getReferences() {
            return this.myReferences;
        }

        public Collection<JSCallExpression> getHasOwnPropertyCollection() {
            return this.myHasOwnPropertyCollection;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        public String getCollectionExpressionName() {
            return this.myCollectionExpressionName;
        }
    }
}

