/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportInspection;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.ES6ImportsWorker;
import com.intellij.lang.javascript.modules.LastImportRequireInScope;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertRequireIntoImportQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction,
BatchQuickFix<CommonProblemDescriptor> {
    @NotNull
    private final SmartPsiElementPointer<JSCallExpression> myPointer;

    public ES6ConvertRequireIntoImportQuickFix(@NotNull JSCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "<init>"));
        }
        this.myPointer = SmartPointerManager.getInstance((Project)call.getProject()).createSmartPsiElementPointer((PsiElement)call);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.require.into.es6.import.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.require.into.es6.import.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "invoke"));
        }
        JSCallExpression element = (JSCallExpression)this.myPointer.getElement();
        if (element != null && element.isValid()) {
            new Worker(element).execute();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "applyFix"));
        }
        JSCallExpression element = (JSCallExpression)this.myPointer.getElement();
        if (element != null && element.isValid()) {
            new Worker(element).execute();
        }
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "applyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "applyFix"));
        }
        if (psiElementsToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementsToIgnore", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "applyFix"));
        }
        new MyBatchRefactoringProcessor(project, descriptors, this.getFamilyName()).run();
    }

    private static class MyBatchRefactoringProcessor
    extends BaseRefactoringProcessor {
        private final CommonProblemDescriptor[] myDescriptors;
        private final String myName;
        private ImportInsertPlace myInsertPlace;
        private PsiElement topElement;
        private JSCallExpression topCall;

        public MyBatchRefactoringProcessor(Project project, CommonProblemDescriptor[] descriptors, String name) {
            super(project);
            this.myDescriptors = descriptors;
            this.myName = name;
        }

        @NotNull
        protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$MyBatchRefactoringProcessor", "createUsageViewDescriptor"));
            }
            BaseUsageViewDescriptor baseUsageViewDescriptor = new BaseUsageViewDescriptor(new PsiElement[0]);
            if (baseUsageViewDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$MyBatchRefactoringProcessor", "createUsageViewDescriptor"));
            }
            return baseUsageViewDescriptor;
        }

        @NotNull
        protected UsageInfo[] findUsages() {
            UsageInfo[] usageInfoArray;
            for (CommonProblemDescriptor descriptor : this.myDescriptors) {
                QuickFix[] fixes = descriptor.getFixes();
                if (fixes == null) continue;
                for (QuickFix fix : fixes) {
                    JSCallExpression call;
                    if (!(fix instanceof ES6ConvertRequireIntoImportQuickFix) || (call = (JSCallExpression)((ES6ConvertRequireIntoImportQuickFix)fix).myPointer.getElement()) == null || !call.isValid() || this.topCall != null && this.topCall.getTextRange().getStartOffset() <= call.getTextRange().getStartOffset()) continue;
                    this.topCall = call;
                    this.topElement = JSChangeUtil.getScopeElementInFile((PsiElement)call);
                }
            }
            if (this.topElement == null) {
                usageInfoArray = UsageInfo.EMPTY_ARRAY;
            } else {
                UsageInfo[] usageInfoArray2 = new UsageInfo[1];
                usageInfoArray = usageInfoArray2;
                usageInfoArray2[0] = new UsageInfo(this.topElement);
            }
            if (usageInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$MyBatchRefactoringProcessor", "findUsages"));
            }
            return usageInfoArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performRefactoring(@NotNull UsageInfo[] usages) {
            FileHeaderKeeper headerKeeper;
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$MyBatchRefactoringProcessor", "performRefactoring"));
            }
            FileHeaderKeeper fileHeaderKeeper = headerKeeper = this.topElement == null ? null : new FileHeaderKeeper(this.topElement);
            if (headerKeeper != null) {
                headerKeeper.saveStateAndCutHeader();
            }
            try {
                this.myInsertPlace = this.topElement == null ? null : new ImportInsertPlace(this.topElement, this.topCall);
                boolean firstInFile = this.myInsertPlace != null && !this.myInsertPlace.isAddAfterAnchor();
                List<CommonProblemDescriptor> list = Arrays.asList(this.myDescriptors);
                Collections.reverse(list);
                boolean changed = false;
                for (CommonProblemDescriptor descriptor : list) {
                    QuickFix[] fixes = descriptor.getFixes();
                    if (fixes == null) continue;
                    for (QuickFix fix : fixes) {
                        JSCallExpression element;
                        if (!(fix instanceof ES6ConvertRequireIntoImportQuickFix) || (element = (JSCallExpression)((ES6ConvertRequireIntoImportQuickFix)fix).myPointer.getElement()) == null || !element.isValid()) continue;
                        if (changed && firstInFile) {
                            this.myInsertPlace = new ImportInsertPlace(this.topElement, element);
                        }
                        new Worker(element).setImportInsertPlace(this.myInsertPlace).execute();
                        changed = true;
                    }
                }
            }
            finally {
                if (headerKeeper != null) {
                    headerKeeper.returnHeaderForSavedState();
                }
            }
        }

        @NotNull
        protected String getCommandName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$MyBatchRefactoringProcessor", "getCommandName"));
            }
            return string;
        }
    }

    private static class ImportInsertPlace {
        @NotNull
        private final PsiElement myTopElement;
        @Nullable
        private final PsiElement myAnchor;
        private final boolean myAddAfterAnchor;

        public ImportInsertPlace(@NotNull PsiElement topElement, @NotNull JSCallExpression callExpression) {
            if (topElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topElement", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$ImportInsertPlace", "<init>"));
            }
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$ImportInsertPlace", "<init>"));
            }
            this.myTopElement = topElement;
            PsiElement lastImportAnchor = new LastImportRequireInScope(true).withNoticeRequire(false).findAndSelect(topElement);
            if (lastImportAnchor != null && lastImportAnchor.getTextOffset() < callExpression.getTextOffset()) {
                this.myAnchor = lastImportAnchor;
                this.myAddAfterAnchor = true;
            } else {
                Pair<Boolean, PsiElement> placeInfo = ES6ImportPsiUtil.findPlaceForImport(this.myTopElement);
                this.myAnchor = (PsiElement)placeInfo.second;
                this.myAddAfterAnchor = (Boolean)placeInfo.first;
            }
        }

        public boolean isAddAfterAnchor() {
            return this.myAddAfterAnchor;
        }

        public ES6ImportDeclaration insert(ES6ImportDeclaration importStatement) {
            if (this.myAnchor != null) {
                ES6ImportDeclaration added = this.myAddAfterAnchor ? (ES6ImportDeclaration)this.myAnchor.getParent().addAfter((PsiElement)importStatement, this.myAnchor) : (ES6ImportDeclaration)this.myAnchor.getParent().addBefore((PsiElement)importStatement, this.myAnchor);
                this.myAnchor.getParent().addBefore(CommentsMover.createNewLine(this.myAnchor), (PsiElement)added);
                if (!(added.getNextSibling() == null && this.myTopElement instanceof JSFile || added.getNextSibling() instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)added.getNextSibling().getText()) > 0)) {
                    if (added.getNextSibling() instanceof PsiWhiteSpace) {
                        added.getNextSibling().delete();
                    }
                    this.myAnchor.getParent().addAfter(CommentsMover.createNewLine(this.myAnchor), (PsiElement)added);
                }
                return added;
            }
            return (ES6ImportDeclaration)this.myTopElement.add((PsiElement)importStatement);
        }
    }

    private static class Worker {
        private final JSCallExpression myCallExpression;
        private JSVariable myOwnerVariable;
        private PsiElement myFirstReference;
        private String myFirstReferenceText;
        private PsiElement myTopElement;
        private CommentsMover myCommentsMover;
        private final Set<PsiElement> myTouchedElements;
        private boolean myShouldMoveComments;
        private boolean myHasReferenceTail;
        private JSDestructuringElement myDestructuringElement;
        private ImportInsertPlace myImportInsertPlace;

        public Worker(@NotNull JSCallExpression callExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "<init>"));
            }
            this.myCallExpression = callExpression;
            this.myTouchedElements = new HashSet<PsiElement>();
        }

        public Worker setImportInsertPlace(ImportInsertPlace importInsertPlace) {
            this.myImportInsertPlace = importInsertPlace;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            this.init();
            if (this.myTopElement == null) {
                return;
            }
            FileHeaderKeeper headerKeeper = null;
            if (this.myImportInsertPlace == null) {
                headerKeeper = new FileHeaderKeeper(this.myTopElement);
                headerKeeper.saveStateAndCutHeader();
            }
            try {
                JSExpression[] arguments = this.myCallExpression.getArguments();
                if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                    PsiElement createdReferenceTarget;
                    JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)this.myCallExpression, JSSourceElement.class);
                    boolean bl = this.myShouldMoveComments = sourceElement != null && this.shouldMoveComments(sourceElement);
                    if (sourceElement != null) {
                        this.myCommentsMover = new CommentsMover(sourceElement);
                    }
                    String requireText = StringUtil.unquoteString((String)arguments[0].getText());
                    if (this.myDestructuringElement != null && this.tryProcessAsDestructuring(requireText)) {
                        this.moveComments();
                        return;
                    }
                    Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> existing = ES6ImportsWorker.getExistingImport(this.myTopElement, requireText, this.myFirstReferenceText);
                    if (existing != null && this.useExistingImport(requireText, existing)) {
                        return;
                    }
                    ES6ImportDeclaration importDeclaration = this.createImport(requireText);
                    if (importDeclaration != null) {
                        this.myTouchedElements.add((PsiElement)importDeclaration);
                    }
                    if ((createdReferenceTarget = Worker.getReferencedElement(importDeclaration)) == null) {
                        return;
                    }
                    this.moveComments();
                    this.replaceWithReferenceToImport(this.myHasReferenceTail, createdReferenceTarget, createdReferenceTarget.getText(), this.myFirstReference);
                }
            }
            finally {
                if (headerKeeper != null) {
                    headerKeeper.returnHeaderForSavedState();
                }
            }
        }

        private void moveComments() {
            if (this.myCommentsMover != null && this.myShouldMoveComments) {
                this.myCommentsMover.move(this.myTouchedElements, this.myTouchedElements);
            }
        }

        private boolean tryProcessAsDestructuring(@NotNull String requireText) {
            JSDestructuringProperty[] properties;
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "tryProcessAsDestructuring"));
            }
            if (this.myDestructuringElement == null) {
                return false;
            }
            PsiElement grand = this.myDestructuringElement.getParent();
            if (!(grand instanceof JSVarStatement)) {
                return false;
            }
            JSDestructuringContainer container = this.myDestructuringElement.getTarget();
            if (!(container instanceof JSDestructuringObject)) {
                return false;
            }
            JSDestructuringObject object = (JSDestructuringObject)container;
            for (JSDestructuringProperty property : properties = object.getProperties()) {
                if (property.getDestructuringElement() == null || property.getDestructuringElement().getName() == null || StringUtil.isEmptyOrSpaces((String)property.getName())) {
                    return false;
                }
                if (!"default".equals(property.getName()) || !"default".equals(property.getDestructuringElement().getName())) continue;
                return false;
            }
            ES6ImportPsiUtil.ES6ExistingImports existingImports = ES6ImportPsiUtil.getExistingImports(this.myTopElement, requireText);
            for (JSDestructuringProperty property : properties) {
                ES6ImportDeclaration declaration;
                ES6ImportSpecifier existingExactSpecifier;
                String reference = property.getName();
                assert (reference != null);
                JSInitializerOwner variable = property.getDestructuringElement();
                boolean isDefault = "default".equals(reference);
                ES6ImportPsiUtil.CreateImportExportInfo importData = new ES6ImportPsiUtil.CreateImportExportInfo(reference, variable.getName(), isDefault ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                ES6ImportSpecifier eS6ImportSpecifier = existingExactSpecifier = isDefault ? null : existingImports.getSpecifiers().get(reference);
                if (existingExactSpecifier != null) {
                    if (variable.getName().equals(existingExactSpecifier.getDeclaredName())) continue;
                    ES6ImportSpecifier replaceTarget = existingExactSpecifier.getAlias() != null ? existingExactSpecifier.getAlias() : existingExactSpecifier;
                    JSChangeUtil.rebindVariableUsages((PsiElement)variable, (PsiElement)replaceTarget, this.myTopElement);
                    continue;
                }
                if (!isDefault && !existingImports.getSpecifiers().isEmpty()) {
                    Map.Entry<String, ES6ImportSpecifier> entry = existingImports.getSpecifiers().entrySet().iterator().next();
                    assert (entry.getValue().getDeclaration() != null);
                    declaration = entry.getValue().getDeclaration();
                    if (this.insertImportIntoExistingRebind(declaration, importData, existingImports, variable)) continue;
                }
                boolean existingUsed = false;
                for (ES6ImportedBinding binding : existingImports.getBindings()) {
                    if (binding.isNamespaceImport() || !(binding.getParent() instanceof ES6ImportDeclaration)) continue;
                    if (isDefault) {
                        JSChangeUtil.rebindVariableUsages((PsiElement)property.getDestructuringElement(), (PsiElement)binding, this.myTopElement);
                        existingUsed = true;
                        break;
                    }
                    if (!this.insertImportIntoExistingRebind((ES6ImportDeclaration)binding.getParent(), importData, existingImports, variable)) continue;
                    existingUsed = true;
                    break;
                }
                if (existingUsed) continue;
                declaration = this.createImport(importData, requireText);
                assert (declaration != null);
                existingImports.addDeclaration(declaration);
                this.myTouchedElements.add((PsiElement)declaration);
                PsiElement toRebind = Worker.getReferencedElement(declaration);
                assert (toRebind != null);
                JSChangeUtil.rebindVariableUsages((PsiElement)variable, toRebind, this.myTopElement);
            }
            JSDestructuringElement parent = this.myDestructuringElement;
            PsiElement current = parent.getNextSibling();
            while (current instanceof PsiWhiteSpace) {
                current = parent.getNextSibling();
            }
            if (current != null && current.getNode().getElementType() == JSTokenTypes.COMMA) {
                parent.getParent().deleteChildRange((PsiElement)parent, current);
            } else {
                parent.delete();
            }
            if (((JSVarStatement)grand).getVariables().length == 0) {
                grand.delete();
            }
            return true;
        }

        @Nullable
        private static PsiElement getReferencedElement(ES6ImportDeclaration declaration) {
            Object[] bindings = declaration.getImportedBindings();
            if (bindings.length > 0) {
                return (PsiElement)ArrayUtil.getFirstElement((Object[])bindings);
            }
            ES6ImportSpecifier importSpecifier = (ES6ImportSpecifier)ArrayUtil.getFirstElement((Object[])declaration.getImportSpecifiers());
            if (importSpecifier == null) {
                return null;
            }
            ES6ImportSpecifierAlias alias = importSpecifier.getAlias();
            if (alias != null && alias.getNameIdentifier() != null) {
                return alias.getNameIdentifier();
            }
            return importSpecifier;
        }

        private boolean insertImportIntoExistingRebind(@NotNull ES6ImportDeclaration declaration, @NotNull ES6ImportPsiUtil.CreateImportExportInfo importData, @NotNull ES6ImportPsiUtil.ES6ExistingImports existingImports, @NotNull JSInitializerOwner variable) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "insertImportIntoExistingRebind"));
            }
            if (importData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importData", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "insertImportIntoExistingRebind"));
            }
            if (existingImports == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingImports", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "insertImportIntoExistingRebind"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "insertImportIntoExistingRebind"));
            }
            this.myTouchedElements.add((PsiElement)declaration);
            ES6ImportSpecifier importSpecifier = ES6ImportPsiUtil.insertImportSpecifier(declaration, importData);
            if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                existingImports.addSpecifier(importSpecifier);
                ES6ImportSpecifier nameElement = importSpecifier.getAlias() != null ? importSpecifier.getAlias() : importSpecifier;
                JSChangeUtil.rebindVariableUsages((PsiElement)variable, (PsiElement)nameElement, this.myTopElement);
                return true;
            }
            return false;
        }

        private boolean useExistingImport(String requireText, Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> existing) {
            String elementName;
            ES6ImportExportDeclarationPart importElement = (ES6ImportExportDeclarationPart)existing.getSecond();
            ES6ImportDeclaration declaration = (ES6ImportDeclaration)existing.getFirst();
            String string = elementName = importElement == null ? null : importElement.getDeclaredName();
            if (elementName != null) {
                if (importElement instanceof ES6ImportedBinding && !"default".equals(this.myFirstReferenceText)) {
                    this.replaceWithReferenceToImport(this.myFirstReference != null, (PsiElement)importElement, elementName, (PsiElement)this.myCallExpression);
                } else {
                    ES6ImportSpecifierAlias alias;
                    ES6ImportExportDeclarationPart toRebind = importElement;
                    if (importElement instanceof ES6ImportSpecifier && (alias = ((ES6ImportSpecifier)importElement).getAlias()) != null) {
                        toRebind = alias;
                    }
                    this.replaceWithReferenceToImport(this.myHasReferenceTail, (PsiElement)toRebind, elementName, this.myFirstReference);
                }
                return true;
            }
            if (declaration != null) {
                ES6ImportPsiUtil.CreateImportExportInfo info = this.getPrefixInfo(requireText, this.myCallExpression.getParent());
                if (info == null) {
                    return true;
                }
                ES6ImportSpecifier importSpecifier = ES6ImportPsiUtil.insertImportSpecifier(declaration, info);
                if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                    this.replaceWithReferenceToImport(this.myHasReferenceTail, (PsiElement)importSpecifier, importSpecifier.getDeclaredName(), this.myFirstReference);
                    return true;
                }
            }
            return false;
        }

        private void replaceWithReferenceToImport(boolean hasReferenceTail, @NotNull PsiElement createdReferenceTarget, @NotNull String createdName, @Nullable PsiElement replacementTarget) {
            if (createdReferenceTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdReferenceTarget", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "replaceWithReferenceToImport"));
            }
            if (createdName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdName", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "replaceWithReferenceToImport"));
            }
            JSExpressionStatement statement = (JSExpressionStatement)JSChangeUtil.createStatementFromText(this.myCallExpression.getProject(), createdName).getPsi(JSExpressionStatement.class);
            if (!hasReferenceTail) {
                if (this.myOwnerVariable != null) {
                    if (!createdName.equals(this.myOwnerVariable.getName())) {
                        JSChangeUtil.rebindVariableUsages((PsiElement)this.myOwnerVariable, createdReferenceTarget, this.myTopElement);
                    }
                    NewLineEraser eraser = new NewLineEraser(this.myOwnerVariable.getParent());
                    this.myOwnerVariable.delete();
                    eraser.process();
                } else if (this.myCallExpression.getParent() instanceof JSExpressionStatement && ((JSExpressionStatement)this.myCallExpression.getParent()).getExpression() == this.myCallExpression) {
                    NewLineEraser eraser = new NewLineEraser(this.myCallExpression.getParent());
                    this.myCallExpression.getParent().delete();
                    eraser.process();
                } else if (this.myCallExpression.getParent() instanceof JSCommaExpression) {
                    JSCommaExpression comma = (JSCommaExpression)this.myCallExpression.getParent();
                    JSExpression other = comma.getLOperand() == this.myCallExpression ? comma.getROperand() : comma.getLOperand();
                    comma.replace((PsiElement)other);
                } else {
                    this.myCallExpression.replace(statement.getExpression());
                }
            } else if (replacementTarget != null) {
                replacementTarget.replace((PsiElement)statement.getExpression());
            }
        }

        private boolean shouldMoveComments(@NotNull JSSourceElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "shouldMoveComments"));
            }
            if (this.myDestructuringElement != null && element instanceof JSVarStatement) {
                JSVariable[] variables;
                for (JSVariable variable : variables = ((JSVarStatement)element).getVariables()) {
                    if (PsiTreeUtil.isAncestor((PsiElement)this.myDestructuringElement, (PsiElement)variable, (boolean)true)) continue;
                    return false;
                }
                return true;
            }
            if (element instanceof JSVarStatement && ((JSVarStatement)element).getVariables().length == 1 && ((JSVarStatement)element).getVariables()[0] == this.myOwnerVariable) {
                return true;
            }
            return element instanceof JSExpressionStatement && ((JSExpressionStatement)element).getExpression() == this.myCallExpression;
        }

        @Nullable
        private ES6ImportDeclaration createImport(@NotNull String requireText) {
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "createImport"));
            }
            PsiElement parent = this.myCallExpression.getParent();
            ES6ImportPsiUtil.CreateImportExportInfo info = this.getPrefixInfo(requireText, parent);
            if (info == null) {
                return null;
            }
            return this.createImport(info, requireText);
        }

        @Nullable
        private ES6ImportDeclaration createImport(ES6ImportPsiUtil.CreateImportExportInfo importData, @NotNull String requireText) {
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "createImport"));
            }
            String quotedModuleName = ES6ImportPsiUtil.wrapWithQuotesFromSettings(requireText, (PsiElement)this.myCallExpression);
            ES6ImportDeclaration createdImport = (ES6ImportDeclaration)ES6ImportPsiUtil.createImportExport((PsiElement)this.myCallExpression, importData, quotedModuleName);
            return this.createImportInProperPlace(createdImport);
        }

        private ES6ImportDeclaration createImportInProperPlace(ES6ImportDeclaration importStatement) {
            if (this.myImportInsertPlace == null) {
                this.myImportInsertPlace = new ImportInsertPlace(this.myTopElement, this.myCallExpression);
            }
            return this.myImportInsertPlace.insert(importStatement);
        }

        @Nullable
        private ES6ImportPsiUtil.CreateImportExportInfo getPrefixInfo(@NotNull String requireText, @Nullable PsiElement parent) {
            String prefixText;
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "getPrefixInfo"));
            }
            String string = prefixText = this.myOwnerVariable != null ? this.myOwnerVariable.getName() : this.calculateVariableName(requireText);
            if (parent instanceof JSReferenceExpression) {
                if (this.myFirstReferenceText == null) {
                    return null;
                }
                if ("default".equals(this.myFirstReferenceText)) {
                    return new ES6ImportPsiUtil.CreateImportExportInfo(prefixText);
                }
                if (this.myHasReferenceTail || this.myFirstReferenceText.equals(prefixText)) {
                    return new ES6ImportPsiUtil.CreateImportExportInfo(this.myFirstReferenceText, null, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                }
                return new ES6ImportPsiUtil.CreateImportExportInfo(this.myFirstReferenceText, prefixText, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
            }
            return prefixText == null ? null : new ES6ImportPsiUtil.CreateImportExportInfo(prefixText);
        }

        private void init() {
            this.findTopElement();
            this.initFirstReference();
            this.lookupOwnerVariable();
        }

        private void initFirstReference() {
            PsiElement parent = this.myCallExpression.getParent();
            if (parent instanceof JSReferenceExpression) {
                String fullReferenceText = parent.getText();
                this.myFirstReference = parent;
                String callText = this.myCallExpression.getText();
                if (!fullReferenceText.startsWith(callText) || fullReferenceText.length() == callText.length()) {
                    return;
                }
                this.myFirstReferenceText = fullReferenceText.substring(callText.length() + 1);
            }
        }

        private void lookupOwnerVariable() {
            PsiElement current = this.myCallExpression.getParent();
            while (current instanceof JSReferenceExpression) {
                current = current.getParent();
            }
            if (current instanceof JSDestructuringElement && current.getParent() instanceof JSVarStatement && ((JSDestructuringElement)current).getInitializer() != null && PsiTreeUtil.isAncestor((PsiElement)((JSDestructuringElement)current).getInitializer(), (PsiElement)this.myCallExpression, (boolean)false)) {
                this.myDestructuringElement = (JSDestructuringElement)current;
            }
            PsiElement previous = null;
            current = this.myCallExpression.getParent();
            int refCnt = 0;
            while (current instanceof JSReferenceExpression || previous != null && current instanceof JSCallExpression && !Worker.isInCallArgumentsList(previous)) {
                if (current instanceof JSReferenceExpression) {
                    ++refCnt;
                }
                previous = current;
                current = current.getParent();
            }
            boolean bl = this.myHasReferenceTail = refCnt > 1 || refCnt == 1 && previous instanceof JSCallExpression;
            if (current instanceof JSVariable) {
                this.myOwnerVariable = (JSVariable)current;
            }
        }

        private static boolean isInCallArgumentsList(PsiElement current) {
            return PsiTreeUtil.isAncestor((PsiElement)((JSCallExpression)current.getParent()).getArgumentList(), (PsiElement)current, (boolean)true);
        }

        private String calculateVariableName(@NotNull String requireText) {
            String varNameCandidate;
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "calculateVariableName"));
            }
            if (this.myTopElement == null) {
                return null;
            }
            if (this.myFirstReferenceText != null && !"default".equals(this.myFirstReferenceText)) {
                varNameCandidate = this.myFirstReferenceText;
            } else {
                String[] split = ES6ConvertRequireIntoImportInspection.cutRelativePathStartAndForwardSlash(requireText).split("/");
                varNameCandidate = split[0];
            }
            return JSChangeUtil.generateNewVarName(varNameCandidate, this.myTopElement);
        }

        private void findTopElement() {
            this.myTopElement = JSChangeUtil.getScopeElementInFile((PsiElement)this.myCallExpression);
        }
    }
}

