/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6PossiblyAsyncFunctionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)node);
                if (optionHolder == null || !optionHolder.hasFeature(JSLanguageFeature.ASYNC_AWAIT)) {
                    return;
                }
                JSFunction parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
                if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "await") && parentFunction != null && (this.isUnterminatedStatement((PsiElement)node) || node.resolve() == null)) {
                    holder.registerProblem((PsiElement)node, ES6PossiblyAsyncFunctionInspection.getQuickFixText(parentFunction), new LocalQuickFix[]{new MyQuickFix()});
                }
                super.visitJSReferenceExpression(node);
            }

            private boolean isUnterminatedStatement(PsiElement element) {
                PsiElement sibling = PsiTreeUtil.nextLeaf((PsiElement)element);
                PsiErrorElement errorElement = sibling instanceof PsiErrorElement ? (PsiErrorElement)sibling : null;
                return errorElement != null && JSBundle.message((String)"javascript.parser.message.expected.newline.or.semicolon", (Object[])new Object[0]).equals(errorElement.getErrorDescription());
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @NotNull
    private static String getQuickFixText(JSFunction function) {
        String name = function.getName();
        String string = name != null ? JSBundle.message((String)"js.possibly.async.function.quick.fix", (Object[])new Object[]{name}) : JSBundle.message((String)"js.possibly.async.function.quick.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection", "getQuickFixText"));
        }
        return string;
    }

    private static PsiElement psiFromText(@NotNull JSFunction context, @NotNull String text) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection", "psiFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection", "psiFromText"));
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)context);
        Project project = context.getProject();
        boolean isClassMember = context instanceof JSFunctionProperty || context.getParent() instanceof JSClass;
        ASTNode astNode = isClassMember ? JSChangeUtil.createClassMemberFromText(project, text, dialect) : JSChangeUtil.createStatementFromText(project, text, dialect, true);
        return astNode.getPsi();
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.possibly.async.function.quick.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection$MyQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection$MyQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection$MyQuickFix", "applyFix"));
            }
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), JSFunction.class);
            if (function == null) {
                return;
            }
            JSAttributeList attributeList = function.getAttributeList();
            JSAttributeListWrapper wrapper = new JSAttributeListWrapper(attributeList);
            wrapper.overrideModifier(JSAttributeList.ModifierType.ASYNC, true);
            wrapper.applyTo((JSAttributeListOwner)function);
            function.replace(ES6PossiblyAsyncFunctionInspection.psiFromText(function, function.getText()));
        }
    }
}

