/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6ShorthandObjectPropertyInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    private static final LocalQuickFix expandShorthandQuickFix = new ExpandShorthandQuickFix();
    private static final LocalQuickFix replaceWithShorthandFix = new ReplaceWithShorthandQuickFix();
    private static final LocalQuickFix replaceWithFunctionPropertyFix = new ReplaceWithFunctionPropertyQuickFix();
    private static final LocalQuickFix expandFunctionPropertyFix = new ExpandFunctionPropertyQuickFix();

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDestructuringProperty(JSDestructuringProperty property) {
                boolean canBeShorthanded;
                if (!this.isES6((PsiElement)property)) {
                    return;
                }
                boolean isShorthand = property instanceof JSDestructuringShorthandedProperty;
                if (isShorthand) {
                    this.registerExpandFix((JSElement)property, expandShorthandQuickFix);
                    return;
                }
                boolean bl = canBeShorthanded = property.getDestructuringElement() instanceof JSVariable && StringUtil.equals((CharSequence)property.getDestructuringElement().getText(), (CharSequence)property.getName());
                if (canBeShorthanded) {
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JSBundle.message((String)"js.property.can.be.replaced.with.shorthand", (Object[])new Object[0]), replaceWithShorthandFix);
                }
            }

            public void visitJSProperty(JSProperty property) {
                boolean canBeShorthanded;
                boolean isShorthand;
                if (!this.isES6((PsiElement)property)) {
                    return;
                }
                boolean bl = isShorthand = property instanceof ES6Property && ((ES6Property)property).isShorthanded();
                if (isShorthand || property instanceof JSFunctionProperty) {
                    LocalQuickFix fix = property instanceof JSFunctionProperty ? expandFunctionPropertyFix : expandShorthandQuickFix;
                    this.registerExpandFix((JSElement)property, fix);
                    return;
                }
                PsiElement identifier = property.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                boolean bl2 = canBeShorthanded = property.getValue() instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)property.getValue(), property.getName());
                if (canBeShorthanded) {
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JSBundle.message((String)"js.property.can.be.replaced.with.shorthand", (Object[])new Object[0]), replaceWithShorthandFix);
                    return;
                }
                if (property.getValue() instanceof JSFunctionExpression && !property.isGetProperty() && !property.isSetProperty() && !JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunctionExpression)property.getValue()))) {
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JSBundle.message((String)"js.property.can.be.replaced.with.function.property", (Object[])new Object[0]), replaceWithFunctionPropertyFix);
                }
            }

            private void registerShorthandFix(PsiNameIdentifierOwner element, String description, LocalQuickFix fix) {
                PsiElement identifier = element.getNameIdentifier();
                if (identifier != null) {
                    holder.registerProblem(identifier, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
                }
            }

            private void registerExpandFix(JSElement element, LocalQuickFix fix) {
                if (holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)element, fix.getFamilyName(), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{fix});
                }
            }

            private boolean isES6(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$1", "isES6"));
                }
                DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
                return dialect != null && (dialect.isECMA6 || dialect.isTypeScript);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static JSProperty replacePropertyWithText(@NotNull JSProperty property, @NotNull String propertyText) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection", "replacePropertyWithText"));
        }
        if (propertyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyText", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection", "replacePropertyWithText"));
        }
        JSObjectLiteralExpression dummyObjectLiteral = JSChangeUtil.createExpressionPsiWithContext("{" + propertyText + "}", (PsiElement)property, JSObjectLiteralExpression.class);
        if (dummyObjectLiteral == null || dummyObjectLiteral.getFirstProperty() == null) {
            return null;
        }
        return (JSProperty)property.replace((PsiElement)dummyObjectLiteral.getFirstProperty());
    }

    private static class ExpandFunctionPropertyQuickFix
    implements LocalQuickFix {
        private ExpandFunctionPropertyQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.expand.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandFunctionPropertyQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandFunctionPropertyQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandFunctionPropertyQuickFix", "applyFix"));
            }
            JSFunctionProperty property = (JSFunctionProperty)ObjectUtils.tryCast((Object)descriptor.getStartElement(), JSFunctionProperty.class);
            if (property == null) {
                return;
            }
            if (property.getName() == null) {
                return;
            }
            JSFunction result = JSFunctionsHelper.createAnonymousFunction((JSFunction)property);
            if (result == null) {
                return;
            }
            JSProperty resultProp = ES6ShorthandObjectPropertyInspection.replacePropertyWithText((JSProperty)property, property.getName() + ": " + result.getText());
            FormatFixer.create((PsiElement)resultProp, FormatFixer.Mode.Reformat).fixFormat();
        }
    }

    private static class ReplaceWithFunctionPropertyQuickFix
    implements LocalQuickFix {
        private ReplaceWithFunctionPropertyQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.replace.with.function.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithFunctionPropertyQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            JSFunction function;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithFunctionPropertyQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithFunctionPropertyQuickFix", "applyFix"));
            }
            JSProperty property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), JSProperty.class);
            JSFunction jSFunction = function = property != null && property.getValue() instanceof JSFunction ? (JSFunction)property.getValue() : null;
            if (property == null || function == null || property.getName() == null) {
                return;
            }
            ES6FunctionProperty result = JSFunctionsHelper.createFunctionProperty(function, property.getName());
            if (result == null) {
                return;
            }
            property = (JSProperty)property.replace((PsiElement)result);
            FormatFixer.create((PsiElement)property, FormatFixer.Mode.Reformat).fixFormat();
        }
    }

    private static class ExpandShorthandQuickFix
    implements LocalQuickFix {
        private ExpandShorthandQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.expand.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandShorthandQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String name;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandShorthandQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandShorthandQuickFix", "applyFix"));
            }
            ES6Property es6Property = (ES6Property)ObjectUtils.tryCast((Object)descriptor.getStartElement(), ES6Property.class);
            if (es6Property != null && es6Property.getName() != null && es6Property.getValue() != null) {
                ES6ChangeUtil.expandShorthandPropertyWithValue(es6Property, es6Property.getName());
                return;
            }
            JSDestructuringShorthandedProperty destructuringProperty = (JSDestructuringShorthandedProperty)ObjectUtils.tryCast((Object)descriptor.getStartElement(), JSDestructuringShorthandedProperty.class);
            if (destructuringProperty != null && (name = destructuringProperty.getName()) != null) {
                ES6ChangeUtil.expandDestructuringProperty(destructuringProperty, name, name);
            }
        }
    }

    private static class ReplaceWithShorthandQuickFix
    implements LocalQuickFix {
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.replace.with.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithShorthandQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithShorthandQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithShorthandQuickFix", "applyFix"));
            }
            JSProperty property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), JSProperty.class);
            if (property != null) {
                ES6ChangeUtil.replaceWithShorthand(property);
                return;
            }
            JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), JSDestructuringProperty.class);
            if (destructuringProperty != null) {
                ES6ChangeUtil.replaceWithShorthand(destructuringProperty);
            }
        }
    }
}

