/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSCommentMatchesSignatureInspection
extends JSInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.comment.matches.signature.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDocComment(JSDocComment docComment) {
                JSFunction function = JSDocumentationUtils.findFunctionAppliedTo(docComment);
                if (function != null) {
                    UpdateFunctionCommentQuickFix fix = null;
                    JSDocumentationUtils.JSDocParametersMappingToFunctionInfo info = JSDocumentationUtils.checkDocCommentMatchesFunctionSignature(docComment, function);
                    if (info != null && info.hasParamTag()) {
                        JSParameter[] parameters;
                        List<Pair<Integer, String>> paramsToAdd = info.getParamsToAdd();
                        Map<Integer, String> paramsToRemove = info.getParamsToRemove();
                        THashSet paramsIndicesToRemove = new THashSet(paramsToRemove.size());
                        fix = new UpdateFunctionCommentQuickFix((Set<Integer>)paramsIndicesToRemove, paramsToAdd);
                        JSDocTag[] tags = paramsToRemove.isEmpty() ? JSDocTag.EMPTY_ARRAY : docComment.getTags();
                        for (Map.Entry entry : paramsToRemove.entrySet()) {
                            JSDocTag elementToHighlight;
                            int a = (Integer)entry.getKey();
                            String b = (String)entry.getValue();
                            paramsIndicesToRemove.add(a);
                            JSDocTag tag = tags[a];
                            ASTNode type = tag.getNode().findChildByType(JSDocTokenTypes.DOC_COMMENT_DATA);
                            Object object = elementToHighlight = type != null ? type.getPsi() : tag;
                            if (b != null) continue;
                            String message = JSBundle.message((String)"js.comment.matches.signature.inspection.problem2", (Object[])new Object[]{"without name"});
                            holder.registerProblem((PsiElement)elementToHighlight, message, new LocalQuickFix[]{fix});
                        }
                        JSParameter[] jSParameterArray = parameters = paramsToAdd.isEmpty() ? null : function.getParameterVariables();
                        if (parameters != null) {
                            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(parameters.length);
                            for (int i = 0; i < parameters.length; ++i) {
                                hashMap.put(parameters[i].getName(), i);
                            }
                            for (Pair<Integer, String> entry : paramsToAdd) {
                                holder.registerProblem((PsiElement)parameters[(Integer)hashMap.get(entry.getSecond())], JSBundle.message((String)"js.comment.matches.signature.inspection.problem1", (Object[])new Object[]{entry.getSecond()}), new LocalQuickFix[]{fix});
                            }
                        }
                    }
                    for (JSDocTag tag : docComment.getTags()) {
                        for (PsiReference ref : tag.getReferences()) {
                            if (!(ref instanceof JSDocParamReference) || !XmlHighlightVisitor.hasBadResolve((PsiReference)ref, (boolean)false)) continue;
                            holder.registerProblem(ref.getElement(), ref.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)ref), new LocalQuickFix[]{fix});
                        }
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static class UpdateFunctionCommentQuickFix
    implements LocalQuickFix {
        private final Set<Integer> myParamsToRemove;
        private final List<Pair<Integer, String>> myParamsToAdd;

        UpdateFunctionCommentQuickFix(Set<Integer> paramsToRemove, List<Pair<Integer, String>> paramsToAdd) {
            this.myParamsToRemove = paramsToRemove;
            this.myParamsToAdd = paramsToAdd;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.comment.matches.signature.inspection.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            JSFunction function;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof JSParameter) {
                function = ((JSParameter)element).getDeclaringFunction();
            } else {
                JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, JSDocComment.class);
                JSFunction jSFunction = function = docComment != null ? JSDocumentationUtils.findFunctionAppliedTo(docComment) : null;
            }
            if (function == null) {
                return;
            }
            ArrayList<Pair<Integer, String>> tagsToAdd = new ArrayList<Pair<Integer, String>>(this.myParamsToAdd.size());
            for (Pair<Integer, String> pair : this.myParamsToAdd) {
                tagsToAdd.add((Pair<Integer, String>)Pair.create((Object)pair.first, (Object)("param " + (String)pair.second)));
            }
            JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes((PsiElement)function, tagsToAdd, null, this.myParamsToRemove);
        }
    }
}

