/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSMethodCanBeStaticInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.method.can.be.static.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){
            Condition<PsiElement>[] addins;

            public void visitJSFunctionDeclaration(final @NotNull JSFunction function) {
                TypeScriptFunction tsFunction;
                JSAttributeList classAttributeList;
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection$1", "visitJSFunctionDeclaration"));
                }
                JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)function);
                if (clazz == null) {
                    return;
                }
                if (clazz.isInterface()) {
                    return;
                }
                if (clazz.getName() == null) {
                    return;
                }
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                JSAttributeList attributeList = function.getAttributeList();
                if (attributeList == null || attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                    return;
                }
                if (function.isConstructor() || "toString".equals(function.getName())) {
                    return;
                }
                if (!attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE && (classAttributeList = clazz.getAttributeList()) != null && classAttributeList.findAttributeByName("Abstract") != null) {
                    return;
                }
                if (this.addins == null) {
                    this.addins = (Condition[])InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions();
                }
                for (JSAttributeList addin : this.addins) {
                    if (!addin.value((Object)function)) continue;
                    return;
                }
                boolean isEmpty = false;
                JSSourceElement[] body = function.getBody();
                if (body.length == 0) {
                    isEmpty = true;
                } else if (body[0] instanceof JSBlockStatement) {
                    boolean bl = isEmpty = body[0].getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS) == null;
                }
                if (isEmpty) {
                    return;
                }
                if (function instanceof TypeScriptFunction && (tsFunction = (TypeScriptFunction)function).hasOverloadDeclarations()) {
                    return;
                }
                final Ref dependsOnInstance = new Ref();
                function.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor(){

                    public void visitJSThisExpression(JSThisExpression node) {
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    public void visitJSSuperExpression(JSSuperExpression superExpression) {
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    public void visitJSReferenceExpression(JSReferenceExpression node) {
                        if (node.getQualifier() == null && !JSResolveUtil.isSelfReference((PsiElement)node)) {
                            ResolveResult[] resolveResults = node.multiResolve(false);
                            if (resolveResults.length == 0) {
                                dependsOnInstance.set((Object)Boolean.TRUE);
                            }
                            for (ResolveResult resolveResult : resolveResults) {
                                PsiElement resolve;
                                if (!resolveResult.isValidResult()) {
                                    dependsOnInstance.set((Object)Boolean.TRUE);
                                }
                                if ((resolve = resolveResult.getElement()) instanceof ImplicitJSVariableImpl && ("hostComponent".equals(((ImplicitJSVariableImpl)resolve).getName()) || "outerDocument".equals(((ImplicitJSVariableImpl)resolve).getName()))) {
                                    dependsOnInstance.set((Object)Boolean.TRUE);
                                    continue;
                                }
                                if (resolve instanceof JSAttributeListOwner && !(resolve instanceof JSClass)) {
                                    PsiElement resolvedMemberParent;
                                    JSAttributeList resolvedMemberAttrList = ((JSAttributeListOwner)resolve).getAttributeList();
                                    if (resolvedMemberAttrList == null || resolvedMemberAttrList.hasModifier(JSAttributeList.ModifierType.STATIC) || JSResolveUtil.isConstructorFunction(resolve) || resolve == function || !((resolvedMemberParent = JSResolveUtil.findParent(resolve)) instanceof JSClass)) continue;
                                    dependsOnInstance.set((Object)Boolean.TRUE);
                                    continue;
                                }
                                if (!(resolve instanceof JSImplicitElement) || ((JSImplicitElement)resolve).getType() != JSImplicitElement.Type.Tag) continue;
                                dependsOnInstance.set((Object)Boolean.TRUE);
                            }
                        }
                        super.visitJSReferenceExpression(node);
                    }

                    public void visitJSFunctionExpression(JSFunctionExpression node) {
                        this.checkFunForExternals((JSFunctionBaseImpl)node);
                    }

                    private void checkFunForExternals(JSFunctionBaseImpl node) {
                        THashSet usedExternalVars = new THashSet();
                        node.addReferencedExternalNames((Set<String>)usedExternalVars);
                        if (usedExternalVars.size() > 0 || JSPsiImplUtils.isArrowFunction(node) && node.isReferencesThis()) {
                            dependsOnInstance.set((Object)Boolean.TRUE);
                        }
                    }

                    public void visitJSFunctionDeclaration(JSFunction node) {
                        this.checkFunForExternals((JSFunctionBaseImpl)node);
                    }

                    public void visitElement(PsiElement element) {
                        if (dependsOnInstance.get() != null) {
                            return;
                        }
                        super.visitElement(element);
                    }
                });
                if (dependsOnInstance.get() == null && !JSInheritanceUtil.participatesInMemberHierarchy((JSQualifiedNamedElement)function)) {
                    LocalQuickFix[] localQuickFixArray;
                    if (holder.isOnTheFly()) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = JSFixFactory.getInstance().makeMethodStaticFix();
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem(nameIdentifier, JSBundle.message((String)"js.method.can.be.static", (Object[])new Object[0]), fixes);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

