/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.inspections.JSSharedUsageInformation;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalDeclarationsCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationsReferencesCacheCleaner {
    @NotNull
    private final JSUnusedGlobalDeclarationsCache myCache;

    public static UnusedDeclarationsReferencesCacheCleaner getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner", "getInstance"));
        }
        return (UnusedDeclarationsReferencesCacheCleaner)ServiceManager.getService((Project)project, UnusedDeclarationsReferencesCacheCleaner.class);
    }

    public UnusedDeclarationsReferencesCacheCleaner(@NotNull Project project, @NotNull JSUnusedGlobalDeclarationsCache cache) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner", "<init>"));
        }
        this.myCache = cache;
    }

    public void startListening(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner", "startListening"));
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new VirtualFileContentsChangedAdapter(){

            protected void onBeforeFileChange(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner$1", "onBeforeFileChange"));
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner$1", "fileCreated"));
                }
            }

            protected void onFileChange(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner$1", "onFileChange"));
                }
                if (!Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
                    return;
                }
                UnusedDeclarationsReferencesCacheCleaner.this.reset(file.isValid() ? psiManager.findFile(file) : null);
            }
        }));
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile file) {
                UnusedDeclarationsReferencesCacheCleaner.this.reset(file);
            }
        }, (Disposable)project);
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner$3", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner$3", "fileClosed"));
                }
                if (!Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
                    return;
                }
                FileEditor[] editors = source.getAllEditors(file);
                if (editors.length == 0) {
                    UnusedDeclarationsReferencesCacheCleaner.this.myCache.fileIsNotInterestingAnyMore(file);
                }
            }

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner$3", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/UnusedDeclarationsReferencesCacheCleaner$3", "fileOpened"));
                }
                if (!Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
                    return;
                }
                UnusedDeclarationsReferencesCacheCleaner.this.myCache.restartFile(file);
            }
        });
    }

    public void reset(@Nullable PsiFile psiFile) {
        if (!Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            this.myCache.restart();
        }
        if (psiFile != null) {
            JSSharedUsageInformation.clear(psiFile);
        }
    }
}

