/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportsWorker {
    @Nullable
    public static Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> getExistingImport(@NotNull PsiElement scope, @NotNull String fromText, @Nullable String nameToImport) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getExistingImport"));
        }
        if (fromText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromText", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getExistingImport"));
        }
        Collection<ES6ImportDeclaration> importDeclarations = ES6ImportPsiUtil.getImportDeclarations(scope);
        for (ES6ImportDeclaration element : importDeclarations) {
            String quotedFromClauseText = ES6ImportPsiUtil.getFromClauseText((ES6ImportExportDeclaration)element);
            if (quotedFromClauseText == null || !fromText.equals(StringUtil.unquoteString((String)quotedFromClauseText))) continue;
            boolean isDefault = "default".equals(nameToImport);
            if (nameToImport != null && !isDefault) {
                ES6ImportSpecifier[] specifiers;
                for (ES6ImportSpecifier importSpecifier : specifiers = element.getImportSpecifiers()) {
                    if (!nameToImport.equals(importSpecifier.getReferenceName())) continue;
                    return Pair.create((Object)element, (Object)importSpecifier);
                }
                Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> binding = ES6ImportsWorker.getImportedBinding(element, false);
                if (binding != null) {
                    return binding;
                }
                if (specifiers.length > 0) {
                    return Pair.create((Object)element, null);
                }
            }
            return ES6ImportsWorker.getImportedBinding(element, isDefault);
        }
        return null;
    }

    @Nullable
    private static Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> getImportedBinding(ES6ImportDeclaration element, boolean isDefault) {
        ES6ImportedBinding[] bindings;
        for (ES6ImportedBinding binding : bindings = element.getImportedBindings()) {
            if (isDefault && binding.isNamespaceImport()) continue;
            return Pair.create((Object)element, (Object)binding);
        }
        return null;
    }
}

