/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.JavaScriptGenerateAccessorHandler;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCreateAccessorIntentionBase
extends PsiElementBaseIntentionAction {
    public JSCreateAccessorIntentionBase() {
        this.setText(this.getDescription());
    }

    protected abstract String getDescription();

    protected abstract String getMessageKey();

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        String varName;
        PsiLanguageInjectionHost context;
        PsiElement parentParent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase", "isAvailable"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof JSFile)) {
            return false;
        }
        DialectOptionHolder dialectOfElement = DialectDetector.dialectOfFile(containingFile);
        if (dialectOfElement == null || dialectOfElement.isECMA4 && !this.isAvailableForECMA4()) {
            return false;
        }
        if (DialectOptionHolder.ECMA_6.equals((Object)dialectOfElement) && this.tryConstructorPropertyVariant(element) != null) {
            return true;
        }
        JSVariable variable = JSCreateAccessorIntentionBase.getVariable(element);
        if (variable != null && variable.isConst()) {
            return false;
        }
        PsiElement parent = variable == null ? null : variable.getParent();
        PsiElement psiElement = parentParent = parent instanceof JSVarStatement ? parent.getParent() : null;
        if (parentParent instanceof ES6Class && parent instanceof JSVarStatementBase) {
            return false;
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = context = parentParent == null ? null : InjectedLanguageManager.getInstance((Project)parentParent.getProject()).getInjectionHost(parentParent);
        JSClass jsClass = parentParent instanceof JSClass ? (JSClass)parentParent : (parentParent instanceof JSFile && context instanceof XmlText ? XmlBackedJSClassImpl.getContainingComponent((XmlElement)((XmlText)context)) : null);
        String string = varName = variable == null ? null : variable.getName();
        if (jsClass != null && StringUtil.isNotEmpty((String)varName)) {
            this.setText(JSBundle.message((String)this.getMessageKey(), (Object[])new Object[]{varName}));
            String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(varName, project);
            return this.isAvailableFor(jsClass, accessorName);
        }
        return false;
    }

    private JSDefinitionExpression tryConstructorPropertyVariant(@NotNull PsiElement element) {
        JSFunction constructor;
        JSReferenceExpression reference;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase", "tryConstructorPropertyVariant"));
        }
        if (element.getParent() instanceof JSReferenceExpression && (reference = (JSReferenceExpression)element.getParent()).getQualifier() != null && "this".equals(reference.getQualifier().getText()) && (constructor = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)reference, JSFunction.class)) != null && "constructor".equals(constructor.getName()) && reference.getParent() instanceof JSDefinitionExpression && constructor.getParent() instanceof ES6Class) {
            String varName = reference.getReferenceName();
            this.setText(JSBundle.message((String)this.getMessageKey(), (Object[])new Object[]{varName}));
            String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(varName, element.getProject());
            return this.isAvailableFor((JSClass)((ES6Class)constructor.getParent()), accessorName) ? (JSDefinitionExpression)reference.getParent() : null;
        }
        return null;
    }

    @Nullable
    private static JSVariable getVariable(PsiElement element) {
        PsiElement var = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSVariable.class, JSVarStatement.class});
        if (var instanceof JSVariable) {
            return (JSVariable)var;
        }
        if (var instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)var).getVariables();
            return variables.length == 1 ? variables[0] : null;
        }
        return null;
    }

    protected abstract boolean isAvailableFor(JSClass var1, String var2);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase", "invoke"));
        }
        PsiFile file = element.getContainingFile();
        JSClass jsClass = BaseJSGenerateHandler.findClass(file, editor);
        if (jsClass == null) {
            return;
        }
        final Ref node = new Ref();
        JavaScriptGenerateAccessorHandler handler = new JavaScriptGenerateAccessorHandler(this.getGenerationMode(), true){

            @Override
            protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
                ContainerUtil.addIfNotNull(candidates, (Object)node.get());
            }
        };
        JSVariable variable = JSCreateAccessorIntentionBase.getVariable(element);
        if (variable == null) {
            JSDefinitionExpression expression;
            if (DialectOptionHolder.ECMA_6.equals((Object)DialectDetector.dialectOfFile(element.getContainingFile())) && (expression = this.tryConstructorPropertyVariant(element)) != null) {
                node.set((Object)new JSNamedElementNode((JSPsiNamedElementBase)expression));
            }
        } else {
            node.set((Object)new JSNamedElementNode((JSPsiNamedElementBase)variable));
        }
        handler.invoke(project, editor, file);
    }

    protected boolean isAvailableForECMA4() {
        return false;
    }

    protected abstract JSGetterSetterGenerationMode getGenerationMode();

    public boolean startInWriteAction() {
        return false;
    }
}

