/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json.adapters;

import com.intellij.lang.javascript.json.adapters.JSJsonPropertyAdapter;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJsonArrayAdapter
implements JsonArrayValueAdapter {
    @NotNull
    private final JSArrayLiteralExpression myArray;

    public JSJsonArrayAdapter(@NotNull JSArrayLiteralExpression array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/lang/javascript/json/adapters/JSJsonArrayAdapter", "<init>"));
        }
        this.myArray = array;
    }

    @NotNull
    public List<JsonValueAdapter> getElements() {
        List<JsonValueAdapter> list = Arrays.stream(this.myArray.getExpressions()).filter(e -> e != null).map(e -> JSJsonPropertyAdapter.createValueAdapterByType(e)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/adapters/JSJsonArrayAdapter", "getElements"));
        }
        return list;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return true;
    }

    public boolean isStringLiteral() {
        return false;
    }

    public boolean isNumberLiteral() {
        return false;
    }

    public boolean isBooleanLiteral() {
        return false;
    }

    @NotNull
    public PsiElement getDelegate() {
        JSArrayLiteralExpression jSArrayLiteralExpression = this.myArray;
        if (jSArrayLiteralExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/adapters/JSJsonArrayAdapter", "getDelegate"));
        }
        return jSArrayLiteralExpression;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return this;
    }

    public boolean shouldCheckIntegralRequirements() {
        return false;
    }
}

