/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryRootsComponentDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.ScriptingLibraryProperties;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryType
extends LibraryType<ScriptingLibraryProperties> {
    private static final OrderRootType[] EXTERNAL_ROOT_TYPES = new OrderRootType[]{OrderRootType.CLASSES, OrderRootType.SOURCES};

    protected JSLibraryType() {
        super(JSLibraryKind.INSTANCE);
    }

    public static JSLibraryType getInstance() {
        return JSLibraryTypeHolder.ourInstance;
    }

    @NotNull
    public String getCreateActionName() {
        if ("JavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryType", "getCreateActionName"));
        }
        return "JavaScript";
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/lang/javascript/library/JSLibraryType", "createNewLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSLibraryType", "createNewLibrary"));
        }
        return LibraryTypeService.getInstance().createLibraryFromFiles(this.createLibraryRootsComponentDescriptor(), parentComponent, contextDirectory, (LibraryType)this, project);
    }

    public boolean isSuitableModule(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/library/JSLibraryType", "isSuitableModule"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/lang/javascript/library/JSLibraryType", "isSuitableModule"));
        }
        return WebModuleTypeBase.isWebModule((Module)module);
    }

    @NotNull
    public LibraryRootsComponentDescriptor createLibraryRootsComponentDescriptor() {
        JSLibraryRootsComponentDescriptor jSLibraryRootsComponentDescriptor = new JSLibraryRootsComponentDescriptor();
        if (jSLibraryRootsComponentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryType", "createLibraryRootsComponentDescriptor"));
        }
        return jSLibraryRootsComponentDescriptor;
    }

    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<ScriptingLibraryProperties> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/lang/javascript/library/JSLibraryType", "createPropertiesEditor"));
        }
        return null;
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Library.JsLibrary;
    }

    public OrderRootType[] getExternalRootTypes() {
        return EXTERNAL_ROOT_TYPES;
    }

    private static class JSLibraryTypeHolder {
        private static final JSLibraryType ourInstance = (JSLibraryType)((Object)LibraryType.EP_NAME.findExtension(JSLibraryType.class));

        private JSLibraryTypeHolder() {
        }
    }
}

