/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingLibraryIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryListGroup
extends ActionGroup {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Project project = e != null ? e.getProject() : null;
        AnAction[] anActionArray = project != null ? JSLibraryListGroup.getLibraryActions(project) : AnAction.EMPTY_ARRAY;
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getChildren"));
        }
        return anActionArray;
    }

    @NotNull
    private static AnAction[] getLibraryActions(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getLibraryActions"));
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        List<ScriptingLibraryModel> libraries = JSLibraryListGroup.sort(libraryManager.getAllLibraries());
        boolean predefinedSeparator = false;
        for (ScriptingLibraryModel library : libraries) {
            if (library.isPredefined() && !predefinedSeparator) {
                actions.add(new Separator("Predefined"));
                predefinedSeparator = true;
            }
            actions.add((Object)new MySetJsLibraryAction(library, mappings));
        }
        AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getLibraryActions"));
        }
        return anActionArray;
    }

    @NotNull
    private static List<ScriptingLibraryModel> sort(@NotNull ScriptingLibraryModel[] libraries) {
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "sort"));
        }
        ArrayList result = ContainerUtil.newArrayList((Object[])libraries);
        Collections.sort(result, (lib1, lib2) -> {
            if (lib1.isPredefined() != lib2.isPredefined()) {
                return lib1.isPredefined() ? 1 : -1;
            }
            return lib1.getName().compareToIgnoreCase(lib2.getName());
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "sort"));
        }
        return arrayList;
    }

    private static class MySetJsLibraryAction
    extends AnAction {
        private final ScriptingLibraryModel myLibrary;
        private final JSLibraryMappings myMappings;

        private MySetJsLibraryAction(@NotNull ScriptingLibraryModel library, @NotNull JSLibraryMappings mappings) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup$MySetJsLibraryAction", "<init>"));
            }
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup$MySetJsLibraryAction", "<init>"));
            }
            super(StringUtil.escapeMnemonics((String)library.getName()), null, null);
            this.myLibrary = library;
            this.myMappings = mappings;
        }

        public void update(AnActionEvent e) {
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            Presentation presentation = e.getPresentation();
            if (file == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setEnabledAndVisible(true);
            if (this.myMappings.isLibraryInScopeFor(file, this.myLibrary.getName())) {
                presentation.setIcon(ScriptingLibraryIcons.CHECKED_ICON);
                if (this.myMappings.isAssociatedWith(file, this.myLibrary.getName())) {
                    presentation.setDescription("Don't use library");
                } else {
                    presentation.setEnabled(false);
                    presentation.setDescription("Already set for containing folder or project.");
                }
            } else {
                presentation.setIcon(ScriptingLibraryIcons.UNCHECKED_ICON);
                presentation.setDescription("Use library");
            }
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile file;
            Project project = e != null ? e.getProject() : null;
            VirtualFile virtualFile = file = e != null ? (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE) : null;
            if (project == null || file == null) {
                return;
            }
            WriteAction.run(() -> {
                JSLibraryManager manager = JSLibraryManager.getInstance(project);
                ScriptingLibraryMappings mappings = manager.getLibraryMappings();
                if (this.myMappings.isLibraryInScopeFor(file, this.myLibrary.getName())) {
                    if (this.myMappings.isAssociatedWith(file, this.myLibrary.getName())) {
                        mappings.disassociate(file, this.myLibrary.getName());
                    }
                } else {
                    mappings.associate(file, this.myLibrary.getName(), this.myLibrary.isPredefined());
                }
                manager.commitChanges();
            });
        }
    }
}

