/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterEditorNotificationPanel;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.Function;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterAnnotationsBuilder<T extends JSLinterState> {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final JSLinterAnnotationResult<T> myResult;
    @NotNull
    private final AnnotationHolder myHolder;
    @NotNull
    private final HighlightDisplayKey myKey;
    @NotNull
    private final UntypedJSLinterConfigurable myConfigurable;
    @NotNull
    private final String myPrefix;
    private int myTabSize;
    @NotNull
    private JSLinterWithInspectionExternalAnnotator.HighlightingGranularity myHighlightingGranularity;
    @NotNull
    private final Class<? extends JSLinterInspection> myInspectionClass;
    @NotNull
    private final JSLinterStandardFixes myStandardFixes;

    public JSLinterAnnotationsBuilder(@NotNull PsiFile file, @NotNull JSLinterAnnotationResult<T> annotationResult, @NotNull AnnotationHolder holder, @NotNull HighlightDisplayKey inspectionKey, @NotNull UntypedJSLinterConfigurable configurable, @NotNull String errorPrefix, @NotNull Class<? extends JSLinterInspection> inspectionClass, @NotNull JSLinterStandardFixes fixes) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (annotationResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResult", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (inspectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionKey", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (errorPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPrefix", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (inspectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionClass", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        this.myTabSize = 1;
        this.myFile = file;
        this.myResult = annotationResult;
        this.myHolder = holder;
        this.myKey = inspectionKey;
        this.myConfigurable = configurable;
        this.myPrefix = errorPrefix;
        this.myInspectionClass = inspectionClass;
        this.myStandardFixes = fixes;
        this.myHighlightingGranularity = JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.none;
    }

    @NotNull
    public JSLinterAnnotationsBuilder<T> setTabSize(int tabSize) {
        this.myTabSize = tabSize;
        JSLinterAnnotationsBuilder jSLinterAnnotationsBuilder = this;
        if (jSLinterAnnotationsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "setTabSize"));
        }
        return jSLinterAnnotationsBuilder;
    }

    public void apply() {
        this.apply(PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile));
    }

    public void apply(@Nullable Document document) {
        Annotation annotation;
        if (document == null) {
            return;
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)this.myFile.getProject());
        SeverityRegistrar severityRegistrar = inspectionProjectProfileManager.getSeverityRegistrar();
        HighlightSeverity defaultSeverity = JSLinterUtil.getSeverity(inspectionProjectProfileManager, this.myKey, this.myFile);
        EditorColorsScheme colorsScheme = this.myResult.getInput().getColorsScheme();
        Function severityTextAttributesProvider = severity -> JSLinterUtil.getTextAttributes(colorsScheme, severityRegistrar, severity);
        TextAttributes defaultSeverityTextAttributes = (TextAttributes)severityTextAttributesProvider.fun((Object)defaultSeverity);
        List<JSLinterError> limitedErrors = JSLinterUtil.limitErrorsAtTheSamePosition(this.myResult.getErrors(), 10);
        if (this.myHolder.isBatchMode()) {
            JSLinterFileLevelAnnotation fileLevelError;
            JSLinterError globalLinterError;
            if (this.myResult.hasFileLevelInfo() && (annotation = this.createAnnotation(document, globalLinterError = new JSLinterError(1, 1, (fileLevelError = this.myResult.getFileLevelError()).getMessage(), null, fileLevelError.getSeverity()), defaultSeverity, defaultSeverityTextAttributes, (Function<HighlightSeverity, TextAttributes>)severityTextAttributesProvider)) != null) {
                fileLevelError.getFixes().createListForError(this.myResult.getConfigFile(), this.myConfigurable, globalLinterError).forEach(error -> annotation.registerFix(error));
            }
        } else {
            this.createFileLevelAnnotations();
        }
        for (JSLinterError linterError : limitedErrors) {
            annotation = this.createAnnotation(document, linterError, defaultSeverity, defaultSeverityTextAttributes, (Function<HighlightSeverity, TextAttributes>)severityTextAttributesProvider);
            if (annotation == null) continue;
            List<IntentionAction> list = this.myStandardFixes.createListForError(this.myResult.getConfigFile(), this.myConfigurable, linterError);
            list.forEach(action -> annotation.registerFix(action, null, this.myKey));
        }
    }

    private void createFileLevelAnnotations() {
        JSLinterFileLevelAnnotation error = this.myResult.getFileLevelError();
        if (error != null) {
            error.prefix(this.myPrefix);
            JSLinterStandardFixes fixes = new JSLinterStandardFixes().setShowEditSettings(false).setOtherFixes(error.getFixes().createList(this.myResult.getConfigFile(), this.myConfigurable)).setEditConfig(false);
            JSLinterFileLevelAnnotation copy = new JSLinterFileLevelAnnotation(error.getIcon(), error.getMessage(), error.getSeverity(), fixes);
            if (error.getShortMessage() != null) {
                copy.setShortMessage(error.getShortMessage());
            }
            JSLinterEditorNotificationPanel.setNotification(this.myFile.getProject(), this.myInspectionClass, this.myFile.getVirtualFile(), copy);
        } else {
            JSLinterEditorNotificationPanel.clearNotification(this.myFile.getProject(), this.myInspectionClass, this.myFile.getVirtualFile());
        }
    }

    @Nullable
    protected Annotation createAnnotation(@NotNull Document document, @NotNull JSLinterError linterError, @NotNull HighlightSeverity defaultSeverity, @Nullable TextAttributes defaultSeverityTextAttributes, @Nullable Function<HighlightSeverity, TextAttributes> severityTextAttributesProvider) {
        TextAttributes severityTextAttributes;
        HighlightSeverity severity;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "createAnnotation"));
        }
        if (linterError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterError", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "createAnnotation"));
        }
        if (defaultSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSeverity", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "createAnnotation"));
        }
        int errorLine = linterError.getLine();
        int errorColumn = linterError.getColumn();
        if (errorLine < 0 || errorLine >= document.getLineCount()) {
            return null;
        }
        TextRange range = this.calculateAnnotationRange(document, errorLine, errorColumn);
        if (range == null) {
            return null;
        }
        String message = this.myPrefix + linterError.getDescription();
        String code = linterError.getCode();
        if (code != null) {
            message = message + " (" + code + ")";
        }
        if ((severity = linterError.getSeverity()) != null) {
            if (severityTextAttributesProvider == null) {
                throw new AssertionError();
            }
            severityTextAttributes = (TextAttributes)severityTextAttributesProvider.fun((Object)severity);
        } else {
            severity = defaultSeverity;
            severityTextAttributes = defaultSeverityTextAttributes;
        }
        Annotation annotation = JSLinterUtil.createAnnotation(this.myHolder, severity, severityTextAttributes, range, message);
        annotation.setAfterEndOfLine(range.getStartOffset() == document.getLineEndOffset(errorLine));
        return annotation;
    }

    private TextRange calculateAnnotationRange(@NotNull Document document, int errorLine, int errorColumn) {
        int errorLineStartOffset;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "calculateAnnotationRange"));
        }
        int lineEndOffset = document.getLineEndOffset(errorLine);
        int lineStartOffset = document.getLineStartOffset(errorLine);
        if (errorColumn == -1) {
            errorLineStartOffset = JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.line == this.myHighlightingGranularity ? lineStartOffset : lineEndOffset;
        } else {
            errorLineStartOffset = JSLinterAnnotationsBuilder.calcErrorStartOffsetInDocument(document, lineStartOffset, lineEndOffset, errorColumn, this.myTabSize);
            errorLineStartOffset = Math.min(errorLineStartOffset, document.getTextLength() - 1);
        }
        if (errorLineStartOffset == -1) {
            return null;
        }
        PsiElement element = this.myFile.findElementAt(errorLineStartOffset);
        if (element != null && element.isValid()) {
            Set suppressors = InspectionProfileEntry.getSuppressors((PsiElement)element);
            for (InspectionSuppressor suppressor : suppressors) {
                if (!suppressor.isSuppressedFor(element, this.myKey.getID())) continue;
                return null;
            }
        }
        if (JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.line.equals((Object)this.myHighlightingGranularity)) {
            return new TextRange(lineStartOffset, lineEndOffset);
        }
        if (JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element.equals((Object)this.myHighlightingGranularity) && element != null && element.isValid()) {
            if (element instanceof PsiWhiteSpace) {
                TextRange range = element.getTextRange();
                return new TextRange(Math.max(lineStartOffset, range.getStartOffset()), range.getEndOffset());
            }
            return element.getTextRange();
        }
        return new TextRange(errorLineStartOffset, errorLineStartOffset + 1);
    }

    private static int calcErrorStartOffsetInDocument(@NotNull Document document, int lineStartOffset, int lineEndOffset, int errorColumn, int tabSize) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "calcErrorStartOffsetInDocument"));
        }
        if (tabSize <= 1) {
            if (errorColumn < 0) {
                return lineStartOffset;
            }
            if (lineStartOffset + errorColumn <= lineEndOffset) {
                return lineStartOffset + errorColumn;
            }
            return lineEndOffset;
        }
        CharSequence docText = document.getCharsSequence();
        int offset = lineStartOffset;
        for (int col = 0; offset < lineEndOffset && col < errorColumn; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
        }
        return offset;
    }

    public JSLinterAnnotationsBuilder<T> setHighlightingGranularity(@NotNull JSLinterWithInspectionExternalAnnotator.HighlightingGranularity highlightingGranularity) {
        if (highlightingGranularity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingGranularity", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "setHighlightingGranularity"));
        }
        this.myHighlightingGranularity = highlightingGranularity;
        return this;
    }
}

