/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterDescriptor {
    public static final ExtensionPointName<JSLinterDescriptor> EP_NAME = ExtensionPointName.create((String)"com.intellij.JavaScript.linter.descriptor");

    @NotNull
    public abstract String getDisplayName();

    @Nullable
    public String packageName() {
        return null;
    }

    @Nullable
    public String packageJsonSectionName() {
        return null;
    }

    public boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterDescriptor", "hasConfigFiles"));
        }
        return false;
    }

    public void enable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterDescriptor", "enable"));
        }
        JSLinterConfiguration.getInstance(project, this.getConfigurationClass()).setEnabled(true);
    }

    public void disable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterDescriptor", "disable"));
        }
        JSLinterConfiguration.getInstance(project, this.getConfigurationClass()).setEnabled(false);
    }

    @NotNull
    public Priority getPriority() {
        Priority priority = Priority.Default;
        if (priority == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterDescriptor", "getPriority"));
        }
        return priority;
    }

    @NotNull
    public abstract Class<? extends JSLinterConfiguration> getConfigurationClass();

    protected static enum Priority {
        High(2),
        Default(1);

        public final int value;

        private Priority(int value) {
            this.value = value;
        }
    }
}

