/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.history.LocalHistory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterFixAction
extends AnAction {
    @NotNull
    private final String myLinterName;

    public JSLinterFixAction(@NotNull @NonNls String linterName, @Nullable String description, @Nullable Icon icon) {
        if (linterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterName", "com/intellij/lang/javascript/linter/JSLinterFixAction", "<init>"));
        }
        super(JSBundle.message((String)"javascript.linter.action.fix.problems.name", (Object[])new Object[]{linterName}), description, icon);
        this.myLinterName = linterName;
    }

    @NotNull
    protected abstract JSLinterConfiguration getConfiguration(Project var1);

    protected Collection<FileType> getFileTypes() {
        return ContainerUtil.createMaybeSingletonList((Object)JavaScriptSupportLoader.JAVASCRIPT);
    }

    public void update(AnActionEvent e) {
        boolean enabled = new Helper(e.getDataContext()).enabled();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Helper helper = new Helper(e.getDataContext());
        this.actionPerformedImpl(helper);
    }

    private void actionPerformedImpl(@NotNull Helper helper) {
        int result;
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/lang/javascript/linter/JSLinterFixAction", "actionPerformedImpl"));
        }
        if (!helper.enabled()) {
            return;
        }
        VirtualFile[] selected = helper.getFiles();
        if ((selected.length > 1 || selected.length == 1 && selected[0].isDirectory()) && (result = Messages.showOkCancelDialog((Project)helper.getProject(), (String)JSBundle.message((String)"javascript.linter.action.fix.prompt", (Object[])new Object[]{this.myLinterName}), (String)this.getTemplatePresentation().getText(), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        Collection<VirtualFile> fromScope = helper.getFilesFromScope();
        Runnable completeCallback = this.getCompleteCallback(helper.getProject(), fromScope);
        if (!this.preProcess(helper, fromScope)) {
            return;
        }
        ProgressManager.getInstance().run(this.createTask(helper.getProject(), fromScope, completeCallback));
    }

    private boolean preProcess(@NotNull Helper helper, Collection<VirtualFile> fromScope) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/lang/javascript/linter/JSLinterFixAction", "preProcess"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)helper.getProject()).ensureFilesWritable(fromScope);
        if (operationStatus.hasReadonlyFiles()) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)helper.getProject()).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        return true;
    }

    protected Runnable getCompleteCallback(@NotNull Project project, @NotNull Collection<VirtualFile> filesToProcess) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterFixAction", "getCompleteCallback"));
        }
        if (filesToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToProcess", "com/intellij/lang/javascript/linter/JSLinterFixAction", "getCompleteCallback"));
        }
        String message = JSBundle.message((String)"javascript.linter.action.fix.problems.name.finish", (Object[])new Object[]{this.myLinterName});
        List changedFiles = filesToProcess.stream().filter(arg_0 -> ((FileDocumentManager)FileDocumentManager.getInstance()).isFileModified(arg_0)).collect(Collectors.toList());
        return () -> {
            if (filesToProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToProcess", "com/intellij/lang/javascript/linter/JSLinterFixAction", "lambda$getCompleteCallback$0"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterFixAction", "lambda$getCompleteCallback$0"));
            }
            ArrayList toProcess = ContainerUtil.newArrayList((Iterable)filesToProcess);
            toProcess.removeAll(changedFiles);
            RefreshSession session = RefreshQueue.getInstance().createSession(false, false, null, ModalityState.NON_MODAL);
            session.addAllFiles((Collection)toProcess);
            session.launch();
            for (VirtualFile file : changedFiles) {
                VfsImplUtil.forceSyncRefresh((VirtualFile)file);
            }
            LocalHistory.getInstance().putSystemLabel(project, message);
        };
    }

    public IntentionAction asIntentionAction() {
        return new JSLinterFixIntentionAction();
    }

    protected abstract Task createTask(@NotNull Project var1, @NotNull Collection<VirtualFile> var2, @NotNull Runnable var3);

    private class JSLinterFixIntentionAction
    extends BaseIntentionAction
    implements HighPriorityAction {
        private JSLinterFixIntentionAction() {
        }

        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"javascript.linter.action.fix.problems.file.text", (Object[])new Object[]{JSLinterFixAction.this.myLinterName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterFixAction$JSLinterFixIntentionAction", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = StringUtil.notNullize((String)JSLinterFixAction.this.getTemplatePresentation().getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterFixAction$JSLinterFixIntentionAction", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterFixAction$JSLinterFixIntentionAction", "isAvailable"));
            }
            return file != null && new Helper(project, new VirtualFile[]{file.getVirtualFile()}).enabled();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterFixAction$JSLinterFixIntentionAction", "invoke"));
            }
            if (file == null) {
                return;
            }
            JSLinterFixAction.this.actionPerformedImpl(new Helper(project, new VirtualFile[]{file.getVirtualFile()}));
        }
    }

    private class Helper {
        private final Project myProject;
        private final VirtualFile[] myFiles;
        private GlobalSearchScope myScope;

        public Helper(DataContext dataContext) {
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            this.myFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        }

        public Helper(@NotNull Project project, VirtualFile[] files) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterFixAction$Helper", "<init>"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/linter/JSLinterFixAction$Helper", "<init>"));
            }
            this.myProject = project;
            this.myFiles = files;
        }

        public boolean enabled() {
            if (this.myProject == null) {
                return false;
            }
            if (!JSLinterFixAction.this.getConfiguration(this.myProject).isEnabled()) {
                return false;
            }
            if (this.myFiles == null) {
                return false;
            }
            this.myScope = this.createScope();
            return ContainerUtil.or(JSLinterFixAction.this.getFileTypes(), type -> FileTypeIndex.containsFileOfType((FileType)type, (GlobalSearchScope)this.myScope));
        }

        @NotNull
        private GlobalSearchScope createScope() {
            if (this.myFiles.length == 0) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterFixAction$Helper", "createScope"));
                }
                return globalSearchScope;
            }
            GlobalSearchScope scope = null;
            for (VirtualFile file : this.myFiles) {
                GlobalSearchScope current = file.isDirectory() ? GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)file, (boolean)true) : GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file);
                scope = scope == null ? current : scope.union((SearchScope)current);
            }
            assert (scope != null);
            GlobalSearchScope globalSearchScope = scope = scope.intersectWith(GlobalSearchScope.projectScope((Project)this.myProject));
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterFixAction$Helper", "createScope"));
            }
            return globalSearchScope;
        }

        public Project getProject() {
            return this.myProject;
        }

        public VirtualFile[] getFiles() {
            return this.myFiles;
        }

        public Collection<VirtualFile> getFilesFromScope() {
            ArrayList result = ContainerUtil.newArrayList();
            Collection<FileType> types = JSLinterFixAction.this.getFileTypes();
            for (FileType type : types) {
                result.addAll(FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)this.myScope));
            }
            return result;
        }
    }
}

