/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class LinterUnsavedConfigFileManager {
    private static final Logger LOG = Logger.getInstance(LinterUnsavedConfigFileManager.class);
    private static final int SAVE_POSTPONE_TIMEOUT_MILLIS = 300;
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;
    private final Map<VirtualFile, WatchedDocument> myWatchedDocumentsByFile;
    @NotNull
    private final Alarm myAlarm;
    private Runnable myUpdateRunnable;

    public LinterUnsavedConfigFileManager(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "<init>"));
        }
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "<init>"));
        }
        this.myWatchedDocumentsByFile = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myDocumentManager = documentManager;
        this.myAlarm = new Alarm((Disposable)this.myProject);
        this.myUpdateRunnable = () -> {
            if (this.canSaveNow()) {
                this.doSaveFiles();
            } else {
                LOG.trace("Could not save now, rescheduling");
                this.myAlarm.addRequest(this.myUpdateRunnable, 300);
            }
        };
    }

    public boolean requestSaveIfNeeded(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "requestSaveIfNeeded"));
        }
        Application application = ApplicationManager.getApplication();
        application.assertReadAccessAllowed();
        boolean hasModifiedConfigs = configs.stream().anyMatch(this::isFileModified);
        if (!hasModifiedConfigs) {
            return true;
        }
        application.invokeLater(() -> {
            if (configs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "lambda$requestSaveIfNeeded$1"));
            }
            this.registerDocumentsToSave(configs);
            this.rescheduleSave();
        }, ModalityState.any(), this.myProject.getDisposed());
        return false;
    }

    private void registerDocumentsToSave(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "registerDocumentsToSave"));
        }
        configs.forEach(config -> {
            if (!this.isFileModified((VirtualFile)config) || this.myWatchedDocumentsByFile.containsKey(config)) {
                return;
            }
            Document document = this.myDocumentManager.getDocument(config);
            if (document != null) {
                this.myWatchedDocumentsByFile.put((VirtualFile)config, new WatchedDocument((VirtualFile)config, document));
            } else {
                LOG.info("Could not find document for save for file: " + config.getPath());
            }
        });
    }

    private void rescheduleSave() {
        if (this.myAlarm.isEmpty()) {
            LOG.trace("Scheduling save in 300");
            this.myAlarm.addRequest(this.myUpdateRunnable, 300);
        }
    }

    private void doSaveFiles() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myWatchedDocumentsByFile.values().stream().filter(item -> ((WatchedDocument)item).myFile.isValid()).forEach(item -> {
            LOG.debug("Saving " + ((WatchedDocument)item).myFile.getPath());
            this.myDocumentManager.saveDocument(((WatchedDocument)item).myDocument);
            item.stop();
        });
        this.myWatchedDocumentsByFile.clear();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private boolean canSaveNow() {
        long currentTimeMillis = System.currentTimeMillis();
        return this.myWatchedDocumentsByFile.values().stream().allMatch(d -> currentTimeMillis - ((WatchedDocument)d).myLastModifiedMillis >= 300L);
    }

    private boolean isFileModified(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "isFileModified"));
        }
        return file.isValid() && !file.isDirectory() && this.myDocumentManager.isFileModified(file);
    }

    private static class WatchedDocument
    implements DocumentListener {
        private final VirtualFile myFile;
        private final Document myDocument;
        private long myLastModifiedMillis;

        public WatchedDocument(@NotNull VirtualFile file, @NotNull Document document) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager$WatchedDocument", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager$WatchedDocument", "<init>"));
            }
            this.myFile = file;
            this.myDocument = document;
            this.myDocument.addDocumentListener((DocumentListener)this);
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void documentChanged(DocumentEvent e) {
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void stop() {
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }
}

