/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jscs.JscsExternalAnnotator;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsInspection
extends JSLinterInspection {
    @Override
    @NotNull
    protected JscsExternalAnnotator getExternalAnnotatorForBatchInspection() {
        JscsExternalAnnotator jscsExternalAnnotator = JscsExternalAnnotator.getInstanceForBatchInspection();
        if (jscsExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsInspection", "getExternalAnnotatorForBatchInspection"));
        }
        return jscsExternalAnnotator;
    }

    public static HighlightDisplayKey getHighlightDisplayKey() {
        return JscsInspection.getHighlightDisplayKeyByClass(JscsInspection.class);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"settings.javascript.linters.jscs.configurable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new JscsSuppressForFileByCommentFix(HighlightDisplayKey.find((String)this.getShortName()), JSInspectionSuppressor.getHolderClass(element)), new JscsSuppressForLineByCommentFix(HighlightDisplayKey.find((String)this.getShortName()), JSInspectionSuppressor.getHolderClass(element))};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsInspection", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    private static class JscsSuppressForFileByCommentFix
    extends SuppressByCommentFix {
        public JscsSuppressForFileByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends PsiElement> suppressionHolderClass) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix", "<init>"));
            }
            if (suppressionHolderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressionHolderClass", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix", "<init>"));
            }
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress all JSCS rules for file" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix", "getText"));
            }
            return "Suppress all JSCS rules for file";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix", "createSuppression"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix", "createSuppression"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix", "createSuppression"));
            }
            Document document = JSLinterUtil.getDocumentForElement(element);
            if (document == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (container == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForFileByCommentFix", "lambda$createSuppression$0"));
                }
                document.insertString(0, (CharSequence)String.format("//%sjscs:disable\n", JSCodeStyleSettings.getLineCommentPrefix(container)));
            }, null, null);
        }
    }

    public static class JscsSuppressForLineByCommentFix
    extends SuppressByCommentFix {
        public JscsSuppressForLineByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends PsiElement> suppressionHolderClass) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix", "<init>"));
            }
            if (suppressionHolderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressionHolderClass", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix", "<init>"));
            }
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress all JSCS rules for current line" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix", "getText"));
            }
            return "Suppress all JSCS rules for current line";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix", "createSuppression"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix", "createSuppression"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix", "createSuppression"));
            }
            Document document = JSLinterUtil.getDocumentForElement(element);
            if (document == null) {
                return;
            }
            int lineNo = document.getLineNumber(element.getTextOffset());
            JscsSuppressForLineByCommentFix.suppressRuleForLine(project, document, element.getContainingFile(), lineNo, element.getTextOffset(), "");
        }

        public static void suppressRuleForLine(Project project, Document document, PsiFile file, int line, int elementOffset, String rule) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                String commentPrefix;
                int lineEndOffset = document.getLineEndOffset(line);
                PsiElement contextElement = file.findElementAt(elementOffset);
                String string = commentPrefix = contextElement instanceof JSElement ? JSCodeStyleSettings.getLineCommentPrefix((PsiElement)file) : " ";
                if (!JscsSuppressForLineByCommentFix.lineHasComments(document, file, line, elementOffset)) {
                    document.insertString(lineEndOffset, (CharSequence)String.format("//%sjscs:ignore %s", commentPrefix, rule));
                } else {
                    int lineStartOffset = document.getLineStartOffset(line);
                    document.insertString(lineEndOffset, (CharSequence)String.format("\n//%sjscs:enable %s", commentPrefix, rule));
                    document.insertString(lineStartOffset, (CharSequence)String.format("//%sjscs:disable %s\n", commentPrefix, rule));
                }
            }, null, null);
        }

        private static boolean lineHasComments(Document document, PsiFile file, int line, final int elementOffset) {
            final boolean[] result = new boolean[1];
            final int endOffset = document.getLineEndOffset(line);
            PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jscs/JscsInspection$JscsSuppressForLineByCommentFix$1", "execute"));
                    }
                    TextRange range = element.getTextRange();
                    if (element instanceof PsiComment && range.getStartOffset() > elementOffset && range.getStartOffset() < endOffset) {
                        result[0] = true;
                        return false;
                    }
                    return true;
                }
            });
            return result[0];
        }
    }
}

