/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileType;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.config.JscsOptionDescriptor;
import com.intellij.lang.javascript.linter.jscs.config.ValueType;
import com.intellij.lang.javascript.linter.jshint.config.JSHintOptionCompletionObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsConfigFileCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        block9: {
            JscsOptionDescriptor.ValueDescription description;
            boolean topLevel;
            JscsOptionDescriptor descriptor;
            Convertor valueConvertor;
            block10: {
                block11: {
                    if (parameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileCompletionContributor", "fillCompletionVariants"));
                    }
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileCompletionContributor", "fillCompletionVariants"));
                    }
                    PsiElement position = parameters.getPosition();
                    PsiFile containingFile = position.getContainingFile();
                    if (containingFile == null) {
                        return;
                    }
                    PsiFile originalFile = containingFile.getOriginalFile();
                    VirtualFile vFile = originalFile.getViewProvider().getVirtualFile();
                    if (!((Object)((Object)JscsConfigFileType.INSTANCE)).equals(vFile.getFileType())) break block9;
                    PsiElement positionParent = position.getParent();
                    boolean insideStringLiteral = JSLinterConfigFileUtil.isStringLiteral(positionParent);
                    valueConvertor = o -> {
                        if (insideStringLiteral) {
                            return o;
                        }
                        return StringUtil.wrapWithDoubleQuote((String)o);
                    };
                    JsonPosition jsonPosition = JscsConfigFileCompletionContributor.findPosition(position);
                    List<String> propChain = jsonPosition.getPropChain();
                    if (propChain.isEmpty()) {
                        return;
                    }
                    descriptor = JscsConfigFileCompletionContributor.findOptionDescriptor(jsonPosition, !jsonPosition.isValue());
                    boolean bl = topLevel = jsonPosition.getPropChain().size() == 1;
                    if (!jsonPosition.isValue()) break block10;
                    if (!topLevel) break block11;
                    JscsOption jscsOption = JscsOption.safeValueOf(propChain.get(0));
                    if (jscsOption == null) {
                        return;
                    }
                    JscsConfigFileCompletionContributor.fillVariantsInsideValue(parameters, result, (Convertor<String, String>)valueConvertor, jscsOption.getDescriptor());
                    break block9;
                }
                if (descriptor == null) break block9;
                JscsConfigFileCompletionContributor.fillVariantsInsideValue(parameters, result, (Convertor<String, String>)valueConvertor, descriptor);
                break block9;
            }
            if (topLevel) {
                JscsConfigFileCompletionContributor.completePropertyNames(result, (Convertor<String, String>)valueConvertor);
            } else if (descriptor != null && (description = descriptor.getTypes().get((Object)ValueType.obj)) instanceof JscsOptionDescriptor.ValuesObject) {
                Set<Map.Entry<String, JscsOptionDescriptor>> entries = ((JscsOptionDescriptor.ValuesObject)description).getFields().entrySet();
                for (Map.Entry<String, JscsOptionDescriptor> entry : entries) {
                    JscsConfigFileCompletionContributor.addPropertyNameCompletionVariant(result, (Convertor<String, String>)valueConvertor, entry.getKey(), entry.getValue().getDescription());
                }
            }
        }
    }

    private static void fillVariantsInsideValue(CompletionParameters parameters, CompletionResultSet result, Convertor<String, String> valueConvertor, JscsOptionDescriptor descriptor) {
        ArrayList variants = ContainerUtil.newArrayList();
        PsiElement position = parameters.getPosition();
        PsiElement positionParent = position.getParent();
        boolean insideStringLiteral = JSLinterConfigFileUtil.isStringLiteral(positionParent);
        boolean isInArray = JSLinterConfigFileUtil.isArray(positionParent.getParent()) || insideStringLiteral && JSLinterConfigFileUtil.isArray(positionParent.getParent().getParent());
        JscsOptionDescriptor.ValueDescription strDescr = descriptor.getTypes().get((Object)ValueType.str);
        JscsOptionDescriptor.ValueDescription arrDescr = descriptor.getTypes().get((Object)ValueType.array);
        if (strDescr instanceof JscsOptionDescriptor.ValuesCollection) {
            JscsConfigFileCompletionContributor.addCollectionsVariants(valueConvertor, variants, (JscsOptionDescriptor.ValuesCollection)strDescr);
        }
        if (arrDescr instanceof JscsOptionDescriptor.ValuesCollection) {
            JscsConfigFileCompletionContributor.addCollectionsVariants(valueConvertor, variants, (JscsOptionDescriptor.ValuesCollection)arrDescr);
        }
        if (!insideStringLiteral && !isInArray && descriptor.getTypes().containsKey((Object)ValueType.bool)) {
            variants.add(Boolean.TRUE.toString());
        }
        if (!insideStringLiteral && !isInArray && descriptor.getTypes().containsKey((Object)ValueType.true_or_false)) {
            variants.add(Boolean.TRUE.toString());
            variants.add(Boolean.FALSE.toString());
        }
        for (String variant : variants) {
            LookupElementBuilder builder = LookupElementBuilder.create((String)variant);
            result.addElement((LookupElement)builder);
        }
        JSLinterConfigFileUtil.skipOtherCompletionContributors(parameters, result);
    }

    private static void addCollectionsVariants(Convertor<String, String> valueConvertor, List<String> variants, JscsOptionDescriptor.ValuesCollection strDescr) {
        JscsOptionDescriptor.ValuesCollection coll = strDescr;
        String[] values = coll.getArrValues();
        if (values != null) {
            for (String value : values) {
                value = "\t".equals(value) ? "\\t" : value;
                variants.add((String)valueConvertor.convert((Object)value));
            }
        }
    }

    private static void completePropertyNames(CompletionResultSet result, Convertor<String, String> valueConvertor) {
        for (JscsOption option : JscsOption.values()) {
            JscsConfigFileCompletionContributor.addPropertyNameCompletionVariant(result, valueConvertor, option.name(), option.getDescription());
        }
    }

    private static void addPropertyNameCompletionVariant(@NotNull CompletionResultSet result, Convertor<String, String> valueConvertor, String variant, final @Nullable String description) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileCompletionContributor", "addPropertyNameCompletionVariant"));
        }
        String lookupString = (String)valueConvertor.convert((Object)variant);
        LookupElementBuilder builder = LookupElementBuilder.create((Object)new JSHintOptionCompletionObject(lookupString), (String)lookupString);
        if (description != null) {
            builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

                public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                    presentation.setItemText(element.getLookupString());
                    presentation.setTypeGrayed(true);
                    presentation.setTypeText(description);
                }
            });
        }
        result.addElement((LookupElement)builder);
    }

    private static JscsOptionDescriptor findOptionDescriptor(JsonPosition position, boolean forParent) {
        int bound;
        List<String> chain = position.getPropChain();
        if (chain.isEmpty()) {
            return null;
        }
        if (chain.size() == 1) {
            return null;
        }
        JscsOption option = JscsOption.safeValueOf(chain.get(0));
        if (option == null) {
            return null;
        }
        JscsOptionDescriptor descriptor = option.getDescriptor();
        JscsOptionDescriptor.ValueDescription description = option.getDescriptor().getTypes().get((Object)ValueType.obj);
        int n = bound = forParent ? chain.size() - 1 : chain.size();
        for (int idx = 1; idx < bound; ++idx) {
            if (!(description instanceof JscsOptionDescriptor.ValuesObject)) {
                return null;
            }
            descriptor = ((JscsOptionDescriptor.ValuesObject)description).getFields().get(chain.get(idx));
            if (descriptor == null) {
                return null;
            }
            description = descriptor.getTypes().get((Object)ValueType.obj);
        }
        return descriptor;
    }

    private static JsonPosition findPosition(PsiElement element) {
        JsonProperty property;
        PsiElement position = element;
        JsonStringLiteral value = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, JsonStringLiteral.class, (boolean)false);
        JsonProperty firstProp = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        boolean isValue = firstProp != null && (value == null && firstProp.getNameElement() != element.getParent() || value != null && value != firstProp.getNameElement());
        ArrayList<String> names = new ArrayList<String>();
        while (position != null && (property = JSLinterConfigFileUtil.getProperty(position.getParent())) != null) {
            names.add(property.getName());
            position = property;
        }
        Collections.reverse(names);
        return new JsonPosition(names, isValue);
    }

    private static class JsonPosition {
        private final List<String> myPropChain;
        private final boolean myIsValue;

        public JsonPosition(List<String> propChain, boolean isValue) {
            this.myPropChain = propChain;
            this.myIsValue = isValue;
        }

        public List<String> getPropChain() {
            return this.myPropChain;
        }

        public boolean isValue() {
            return this.myIsValue;
        }
    }
}

