/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.version;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionDescriptor;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintVersionUtil {
    private static final Logger LOG = Logger.getInstance(JSHintVersionUtil.class);
    private static final String VERSIONS_JSON_FILENAME = "versions.json";
    private static final String BASE_URL = "http://download.jetbrains.com/idea/jshint";
    public static final String BUNDLED_VERSION = "2.9.4";
    private static final int DOWNLOAD_ATTEMPT_COUNT = 3;
    private static volatile ImmutableList<JSHintVersionDescriptor> OUR_CACHED_VERSION_DESCRIPTORS;

    private JSHintVersionUtil() {
    }

    @NotNull
    public static String guessUrl(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "guessUrl"));
        }
        String string = JSHintVersionUtil.createUrl(JSHintVersionUtil.getJSHintSourceFileBaseName(version));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "guessUrl"));
        }
        return string;
    }

    public static void downloadVersions(@Nullable ProgressIndicator indicator) throws IOException {
        String url = JSHintVersionUtil.createUrl(VERSIONS_JSON_FILENAME);
        JSHintVersionUtil.downloadFile(indicator, VERSIONS_JSON_FILENAME, url, 3, (Predicate<String>)((Predicate)input -> {
            if (input != null) {
                try {
                    List<JSHintVersionDescriptor> versions = JSHintVersionUtil.parseVersion(input);
                    return versions.size() > 0;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }));
        OUR_CACHED_VERSION_DESCRIPTORS = null;
    }

    @NotNull
    public static File downloadSourceVersionOnce(@Nullable ProgressIndicator indicator, @NotNull JSHintVersionDescriptor versionDescriptor) throws IOException {
        if (versionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionDescriptor", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadSourceVersionOnce"));
        }
        File file = JSHintVersionUtil.downloadSourceVersion(indicator, versionDescriptor, 1);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadSourceVersionOnce"));
        }
        return file;
    }

    @NotNull
    public static File downloadSourceVersion(@Nullable ProgressIndicator indicator, @NotNull JSHintVersionDescriptor versionDescriptor, int attempts) throws IOException {
        if (versionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionDescriptor", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadSourceVersion"));
        }
        String fileBaseName = JSHintVersionUtil.getJSHintSourceFileBaseName(versionDescriptor.getVersion());
        File file = JSHintVersionUtil.downloadFile(indicator, fileBaseName, versionDescriptor.getUrl(), attempts, (Predicate<String>)((Predicate)input -> input != null && input.contains("JSHINT")));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadSourceVersion"));
        }
        return file;
    }

    @NotNull
    public static ImmutableList<JSHintVersionDescriptor> getVersions() {
        ImmutableList<JSHintVersionDescriptor> descriptors = OUR_CACHED_VERSION_DESCRIPTORS;
        if (descriptors != null) {
            ImmutableList<JSHintVersionDescriptor> immutableList = descriptors;
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "getVersions"));
            }
            return immutableList;
        }
        OUR_CACHED_VERSION_DESCRIPTORS = descriptors = JSHintVersionUtil.doGetVersions();
        ImmutableList<JSHintVersionDescriptor> immutableList = descriptors;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "getVersions"));
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<JSHintVersionDescriptor> doGetVersions() {
        String content;
        File versionJsonFile = JSHintVersionUtil.getVersionsJsonFile();
        Object descriptors = null;
        if (versionJsonFile.isFile()) {
            try {
                content = Files.toString((File)versionJsonFile, (Charset)StandardCharsets.UTF_8);
                descriptors = JSHintVersionUtil.parseVersion(content);
            }
            catch (Exception e) {
                FileUtil.delete((File)versionJsonFile);
                LOG.warn("Can not parse '" + versionJsonFile.getAbsolutePath() + "'!", (Throwable)e);
            }
        }
        if (descriptors == null) {
            try {
                content = JSHintVersionUtil.readFromClassPath(VERSIONS_JSON_FILENAME);
                descriptors = JSHintVersionUtil.parseVersion(content);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not parse bundled versions.json!", e);
            }
        }
        descriptors = JSHintVersionUtil.addGuessableVersionDescriptorFirstIfMissing(descriptors, BUNDLED_VERSION);
        ImmutableList immutableList = ImmutableList.copyOf(descriptors);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "doGetVersions"));
        }
        return immutableList;
    }

    @NotNull
    public static ImmutableList<JSHintVersionDescriptor> addGuessableVersionDescriptorFirstIfMissing(@NotNull List<JSHintVersionDescriptor> descriptors, @NotNull String version) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "addGuessableVersionDescriptorFirstIfMissing"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "addGuessableVersionDescriptorFirstIfMissing"));
        }
        JSHintVersionDescriptor descriptor = JSHintVersionUtil.find(descriptors, version);
        if (descriptor != null) {
            ImmutableList immutableList = ImmutableList.copyOf(descriptors);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "addGuessableVersionDescriptorFirstIfMissing"));
            }
            return immutableList;
        }
        ArrayList list = ContainerUtil.newArrayList();
        list.add(new JSHintVersionDescriptor(version, JSHintVersionUtil.guessUrl(version)));
        list.addAll(descriptors);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)list);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "addGuessableVersionDescriptorFirstIfMissing"));
        }
        return immutableList;
    }

    @Nullable
    public static JSHintVersionDescriptor find(@NotNull List<JSHintVersionDescriptor> descriptors, @NotNull String version) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "find"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "find"));
        }
        for (JSHintVersionDescriptor versionDescriptor : descriptors) {
            if (!versionDescriptor.getVersion().equals(version)) continue;
            return versionDescriptor;
        }
        return null;
    }

    @NotNull
    private static List<JSHintVersionDescriptor> parseVersion(@NotNull String versionsFileContent) {
        List<JSHintVersionDescriptor> list;
        JsonElement jsonElement;
        if (versionsFileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionsFileContent", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "parseVersion"));
        }
        if (versionsFileContent.trim().isEmpty()) {
            throw new RuntimeException("Can not parse version list from empty content!");
        }
        try {
            JsonParser jsonParser = new JsonParser();
            jsonElement = jsonParser.parse(versionsFileContent);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not parse JSON from version list. Malformed JSON was received, content: '" + versionsFileContent, e);
        }
        try {
            list = JSHintVersionUtil.toVersionList(jsonElement);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Wrong JSON was received, content: '" + versionsFileContent, e);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "parseVersion"));
        }
        return list;
    }

    @NotNull
    private static List<JSHintVersionDescriptor> toVersionList(@NotNull JsonElement jsonElement) {
        if (jsonElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonElement", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "toVersionList"));
        }
        if (!jsonElement.isJsonArray()) {
            throw new RuntimeException("jsonElement is expected be an instance of " + JsonArray.class.getName());
        }
        JsonArray array = jsonElement.getAsJsonArray();
        ArrayList versions = ContainerUtil.newArrayList();
        for (JsonElement element : array) {
            if (!element.isJsonObject()) {
                throw new RuntimeException("Unexpected child element " + element.getClass().getName());
            }
            JsonObject obj = element.getAsJsonObject();
            JsonElement nameElement = obj.get("version");
            String name = null;
            if (nameElement != null) {
                name = nameElement.getAsString();
            }
            String url = null;
            JsonElement urlElement = obj.get("url");
            if (urlElement != null) {
                url = urlElement.getAsString();
            }
            if (name == null || url == null) continue;
            versions.add(new JSHintVersionDescriptor(name, url));
        }
        ArrayList arrayList = versions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "toVersionList"));
        }
        return arrayList;
    }

    @NotNull
    private static String createUrl(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "createUrl"));
        }
        String string = StringUtil.trimEnd((String)BASE_URL, (String)"/") + "/" + fileBaseName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "createUrl"));
        }
        return string;
    }

    @NotNull
    public static String getJSHintSourceFileBaseName(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "getJSHintSourceFileBaseName"));
        }
        String string = "jshint-" + version + ".js";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "getJSHintSourceFileBaseName"));
        }
        return string;
    }

    @NotNull
    private static File downloadFile(@Nullable ProgressIndicator indicator, @NotNull String fileBaseName, @NotNull String url, int attempts, @Nullable Predicate<String> contentChecker) throws IOException {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadFile"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadFile"));
        }
        File dir = JSHintVersionUtil.getJSHintDirOrCreateIfNeeded();
        File outputFile = new File(dir, fileBaseName);
        File tempFile = FileUtil.createTempFile((File)dir, (String)fileBaseName, (String)".tmp");
        for (int i = 1; i <= attempts; ++i) {
            File file;
            String message = (attempts > 1 ? "[Attempt#" + i + "] " : "") + "Downloading " + url;
            long startTimeNano = System.nanoTime();
            try {
                boolean success = DownloadUtil.downloadAtomically((ProgressIndicator)indicator, (String)url, (File)outputFile, (File)tempFile, contentChecker);
                if (!success) {
                    throw new IOException("Content check failed.");
                }
                LOG.info(message + " succeed in " + JSHintVersionUtil.formatTakenTime(startTimeNano) + " and saved to " + outputFile);
                file = outputFile;
            }
            catch (IOException e) {
                LOG.warn(message + " failed in " + JSHintVersionUtil.formatTakenTime(startTimeNano));
                if (i != attempts) continue;
                throw e;
            }
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadFile"));
            }
            return file;
        }
        File file = outputFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadFile"));
        }
        return file;
    }

    private static String formatTakenTime(long startTimeNano) {
        return String.format("%.1f ms", (double)(System.nanoTime() - startTimeNano) / 1000000.0);
    }

    @NotNull
    private static File getJSHintDir() {
        File file;
        File javascriptDir = new File(PathManager.getSystemPath(), "javascript");
        File jshintDir = new File(javascriptDir, "jshint");
        try {
            file = jshintDir.getCanonicalFile();
        }
        catch (IOException e) {
            File file2 = jshintDir;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "getJSHintDir"));
            }
            return file2;
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "getJSHintDir"));
        }
        return file;
    }

    @NotNull
    private static File getJSHintDirOrCreateIfNeeded() throws IOException {
        File dir = JSHintVersionUtil.getJSHintDir();
        if (!FileUtil.createDirectory((File)dir)) {
            throw new IOException("Can't create " + dir.getAbsolutePath());
        }
        File file = dir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "getJSHintDirOrCreateIfNeeded"));
        }
        return file;
    }

    private static File getVersionsJsonFile() {
        File jshintDir = JSHintVersionUtil.getJSHintDir();
        return new File(jshintDir, VERSIONS_JSON_FILENAME);
    }

    static boolean isBundledVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "isBundledVersion"));
        }
        return version.equals(BUNDLED_VERSION);
    }

    public static boolean isSourceLocallyAvailable(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "isSourceLocallyAvailable"));
        }
        if (JSHintVersionUtil.isBundledVersion(version)) {
            return true;
        }
        String fileBaseName = JSHintVersionUtil.getJSHintSourceFileBaseName(version);
        File dir = JSHintVersionUtil.getJSHintDir();
        File outputFile = new File(dir, fileBaseName);
        return outputFile.isFile();
    }

    @NotNull
    private static String readFromClassPath(@NotNull String fileBaseName) throws IOException {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "readFromClassPath"));
        }
        InputStream inputStream = JSHintVersionUtil.class.getResourceAsStream(fileBaseName);
        if (inputStream == null) {
            throw new RuntimeException("Resource " + fileBaseName + " is not found!");
        }
        InputStreamReader reader = new InputStreamReader(inputStream, CharsetToolkit.UTF8_CHARSET);
        String string = FileUtil.loadTextAndClose((Reader)reader);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "readFromClassPath"));
        }
        return string;
    }

    public static void downloadSourceContent(@NotNull String version) throws IOException {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadSourceContent"));
        }
        ImmutableList<JSHintVersionDescriptor> descriptors = JSHintVersionUtil.getVersions();
        JSHintVersionDescriptor descriptor = JSHintVersionUtil.find(descriptors, version);
        if (descriptor == null) {
            JSHintVersionUtil.downloadVersions(null);
            descriptors = JSHintVersionUtil.getVersions();
            descriptor = JSHintVersionUtil.find(descriptors, version);
        }
        if (descriptor != null) {
            JSHintVersionUtil.downloadSourceVersion(null, descriptor, 3);
        }
    }

    public static void downloadSourceContentUnderProgress(@NotNull Project project, final @NotNull String version, final @NotNull Runnable callback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadSourceContentUnderProgress"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadSourceContentUnderProgress"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "downloadSourceContentUnderProgress"));
        }
        Task.Backgroundable task = new Task.Backgroundable(project, "Updating JSHint to " + version, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil$1", "run"));
                }
                try {
                    JSHintVersionUtil.downloadSourceContent(version);
                }
                catch (Exception e) {
                    LOG.warn("Can't fetch JSHint " + version, (Throwable)e);
                }
                finally {
                    callback.run();
                }
            }
        };
        task.queue();
    }

    @Nullable
    public static String loadSourceContentFromLocalDrive(@NotNull String version) throws IOException {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionUtil", "loadSourceContentFromLocalDrive"));
        }
        String fileBaseName = JSHintVersionUtil.getJSHintSourceFileBaseName(version);
        if (JSHintVersionUtil.isBundledVersion(version)) {
            LOG.info("JSHint " + version + " is loaded from classpath");
            return JSHintVersionUtil.readFromClassPath(fileBaseName);
        }
        File dir = JSHintVersionUtil.getJSHintDir();
        File outputFile = new File(dir, fileBaseName);
        if (outputFile.isFile()) {
            LOG.info("JSHint " + version + " is loaded from " + outputFile.getAbsolutePath());
            return FileUtil.loadFile((File)outputFile, (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        return null;
    }
}

