/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.LastImportRequireInScope;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddInnerRequireAmdModuleToModulesListFix
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    private final String myRequireName;
    @NotNull
    private final JSAmdUtil.AmdLoaderCallOnPointers myAmdLoaderCallOnPointers;
    private final String myPath;
    private final String myReferenceName;
    private final boolean myIsSingleQuotes;

    public AddInnerRequireAmdModuleToModulesListFix(@NotNull String requireName, @NotNull JSAmdUtil.AmdLoaderCallOnPointers pointers, String path, String referenceName, boolean isSingleQuotes) {
        if (requireName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireName", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "<init>"));
        }
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "<init>"));
        }
        this.myRequireName = requireName;
        this.myAmdLoaderCallOnPointers = pointers;
        this.myPath = path;
        this.myReferenceName = referenceName;
        this.myIsSingleQuotes = isSingleQuotes;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "showHint"));
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myIsSingleQuotes) {
            String string = "Insert " + this.myRequireName + "('" + this.myPath + "')";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "getText"));
            }
            return string;
        }
        String string = "Insert " + this.myRequireName + "(\"" + this.myPath + "\")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "invoke"));
        }
        this.invokeImpl();
    }

    @Override
    public String getVarName() {
        return this.myReferenceName;
    }

    private void invokeImpl() {
        JSAmdUtil.AmdLoaderCall amdLoaderCall = this.myAmdLoaderCallOnPointers.toCall();
        if (!amdLoaderCall.isValid()) {
            return;
        }
        JSParameter parameter = amdLoaderCall.getRequireSugaredParameter();
        Project project = parameter.getProject();
        StringBuilder text = new StringBuilder();
        if (this.myIsSingleQuotes) {
            text.append("var ").append(this.myReferenceName).append(" = ").append(this.myRequireName).append("('").append(this.myPath).append("');");
        } else {
            text.append("var ").append(this.myReferenceName).append(" = ").append(this.myRequireName).append("(\"").append(this.myPath).append("\");");
        }
        PsiElement requireElement = ImportCommonJSModuleFix.createDummyFile(project, text.toString()).getFirstChild();
        JSFunctionExpression callBackExpression = amdLoaderCall.getCallBackExpression();
        JSSourceElement[] body = callBackExpression.getBody();
        if (body.length == 0) {
            return;
        }
        JSSourceElement element = body[0];
        PsiElement last = new LastImportRequireInScope(false).withRequireName(this.myRequireName).findAndSelect((PsiElement)element);
        if (last == null) {
            PsiElement child = PsiTreeUtil.getChildOfType((PsiElement)element, JSStatement.class);
            if (child == null) {
                element.add(requireElement);
            } else {
                element.addBefore(requireElement, child);
            }
        } else {
            element.addAfter(requireElement, last);
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart(callBackExpression.getContainingFile());
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = AddInnerRequireAmdModuleToModulesListFix.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Node.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "getFamilyName"));
        }
        return "Node.js";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix", "applyFix"));
        }
        this.invokeImpl();
    }
}

