/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.AmdJsModulesSuggester;
import com.intellij.lang.javascript.modules.JSBaseModulesDependenciesElementVisitor;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmdModulesDependenciesInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        MyJSElementVisitor myJSElementVisitor = new MyJSElementVisitor(session, holder, this.myOnTheFly);
        if (myJSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AmdModulesDependenciesInspection", "createVisitor"));
        }
        return myJSElementVisitor;
    }

    private static class MyJSElementVisitor
    extends JSBaseModulesDependenciesElementVisitor {
        public MyJSElementVisitor(LocalInspectionToolSession session, ProblemsHolder holder, boolean onTheFly) {
            super(session, holder, onTheFly);
        }

        @Override
        protected String getInspectionText() {
            return "Missing AMD module dependency";
        }

        @Override
        @Nullable
        protected JsModulesSuggester createSuggester(@NotNull PsiElement node, @NotNull ModuleReferenceInfo info) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/AmdModulesDependenciesInspection$MyJSElementVisitor", "createSuggester"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/modules/AmdModulesDependenciesInspection$MyJSElementVisitor", "createSuggester"));
            }
            if (!MyJSElementVisitor.isForBrowser(node.getProject(), this.mySession.getFile().getVirtualFile())) {
                return null;
            }
            JSAmdUtil.AmdLoaderCallOnPointers definition = JSAmdUtil.getCachedWrappingAmdDefinition(node);
            Set<VirtualFile> files = MyJSElementVisitor.cacheAndGetPredefinedLibraries(node.getProject(), this.mySession);
            return definition == null ? null : new AmdJsModulesSuggester(files, info, node, definition.toCall());
        }
    }
}

