/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportAction
implements QuestionAction {
    public static final Key<Boolean> NO_HINT_KEY = Key.create((String)"ES6.auto.import.no.hint");
    public static final ImportElementFilter DEFAULT_FILTER = new DefaultElementFilter();
    @Nullable
    protected final Editor myEditor;
    @Nullable
    protected final String myName;
    @Nullable
    protected final PsiElement myContext;
    protected final ImportElementFilter myFilter;

    public ES6ImportAction(@Nullable Editor editor, @Nullable PsiElement context, @Nullable String name, @NotNull ImportElementFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/modules/ES6ImportAction", "<init>"));
        }
        this.myContext = context;
        this.myEditor = editor;
        this.myName = name;
        this.myFilter = filter;
    }

    public boolean execute() {
        this.executeForAllVariants();
        return true;
    }

    @Nullable
    public PsiElement executeForAllVariants() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContext == null || this.myName == null || !this.myContext.isValid()) {
            return null;
        }
        if (!this.myFilter.isValidContext(this.myContext)) {
            return null;
        }
        List<JSElement> candidates = this.getCandidates();
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1 || this.myEditor == null) {
            return this.addImport(candidates);
        }
        HashMap preRenderedQNames = ContainerUtil.newHashMap();
        Project project = this.myContext.getProject();
        Collection<JSElement> elementsFromLibraries = ES6ImportAction.getElementsFromLibraries(project, candidates);
        PsiFile file = this.myContext.getContainingFile();
        if (elementsFromLibraries.isEmpty()) {
            List<JSElement> finalElements = ES6ImportAction.getFinalElements(project, file, candidates, elementsFromLibraries, preRenderedQNames);
            if (finalElements.size() == 1) {
                return this.addImport(candidates);
            }
            this.showPopup(finalElements, preRenderedQNames);
            return null;
        }
        Runnable calcModuleNamesAndShowPopupIfNecessary = () -> {
            List newCandidates = (List)ReadAction.compute(() -> ES6ImportAction.getFinalElements(project, file, candidates, elementsFromLibraries, preRenderedQNames));
            TransactionGuard.submitTransaction((Disposable)project, () -> {
                this.setNoHintFlag(false);
                if (newCandidates.isEmpty() || !this.myContext.isValid()) {
                    return;
                }
                if (newCandidates.size() == 1) {
                    JSElement item = (JSElement)ContainerUtil.getFirstItem((List)newCandidates);
                    assert (item != null);
                    if (!item.isValid()) {
                        return;
                    }
                    Runnable runnable = () -> this.executeFor(item);
                    CommandProcessor.getInstance().executeCommand(item.getProject(), runnable, this.getClass().getName(), (Object)this);
                    return;
                }
                this.showPopup(newCandidates, preRenderedQNames);
            });
        };
        this.setNoHintFlag(true);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            calcModuleNamesAndShowPopupIfNecessary.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(calcModuleNamesAndShowPopupIfNecessary);
        }
        return null;
    }

    private void setNoHintFlag(boolean value) {
        if (this.myContext == null) {
            return;
        }
        PsiElement toSet = this.myContext;
        if (this.myContext.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
            toSet = this.myContext.getParent();
        }
        toSet.putUserData(NO_HINT_KEY, (Object)value);
    }

    @NotNull
    private JSElement addImport(List<JSElement> candidates) {
        JSElement candidate = candidates.iterator().next();
        JSElement jSElement = this.executeFor(candidate);
        if (jSElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "addImport"));
        }
        return jSElement;
    }

    public JSElement executeWithoutPrepare(@NotNull JSElement candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/modules/ES6ImportAction", "executeWithoutPrepare"));
        }
        assert (this.myContext != null && this.myName != null);
        this.runAction(this.myEditor, this.myName, candidate, this.myContext);
        return candidate;
    }

    @NotNull
    public JSElement executeFor(@NotNull JSElement candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/modules/ES6ImportAction", "executeFor"));
        }
        assert (this.myContext != null && this.myName != null);
        FileHeaderKeeper keeper = new FileHeaderKeeper(ES6CreateImportUtil.getExternalModuleScope(this.myContext));
        JSElement element = this.executeWithoutPrepare(candidate);
        if (keeper.canMove()) {
            CommandProcessor.getInstance().executeCommand(this.myContext.getProject(), () -> WriteAction.run(() -> keeper.moveHeader()), "Move header", (Object)this);
        }
        JSElement jSElement = element;
        if (jSElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "executeFor"));
        }
        return jSElement;
    }

    @NotNull
    public List<JSElement> getCandidates() {
        if (!this.isContextValid(this.myContext) || this.myName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "getCandidates"));
            }
            return list;
        }
        GlobalSearchScope scope = ES6CreateImportUtil.createSymbolToImportSearchScope(this.myContext.getProject(), this.myContext);
        JSImportPlaceInfo info = new JSImportPlaceInfo(this.myContext);
        ArrayList candidates = ContainerUtil.newArrayList();
        Processor processor = toProcess -> {
            if (ES6CreateImportUtil.isAvailableForImport((PsiElement)toProcess, info)) {
                candidates.add(toProcess);
            }
            return true;
        };
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)this.myName, this.myContext.getProject(), scope, JSElement.class, processor);
        Processor assignmentProcessor = toProcess -> {
            JSExpression expression = toProcess.getExpression();
            if (expression instanceof JSQualifiedNamedElement) {
                candidates.add(expression);
            } else {
                candidates.add(toProcess);
            }
            return true;
        };
        StubIndex.getInstance().processElements(ES6DefaultAssignmentModuleIndex.KEY, (Object)this.myName, this.myContext.getProject(), scope, JSExportAssignment.class, assignmentProcessor);
        List<JSElement> result = this.additionalProcessCandidates(info, candidates);
        List<JSElement> list = this.myFilter.filterByContext(this.myContext, result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "getCandidates"));
        }
        return list;
    }

    @Contract(value="null -> false")
    protected boolean isContextValid(@Nullable PsiElement context) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (context == null || !context.isValid()) {
            return false;
        }
        Project project = context.getProject();
        return !DumbService.isDumb((Project)project) && !project.isDisposed();
    }

    @NotNull
    protected List<JSElement> additionalProcessCandidates(@NotNull JSImportPlaceInfo info, @NotNull List<JSElement> candidates) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/modules/ES6ImportAction", "additionalProcessCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/javascript/modules/ES6ImportAction", "additionalProcessCandidates"));
        }
        List<JSElement> list = candidates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "additionalProcessCandidates"));
        }
        return list;
    }

    protected void runAction(@Nullable Editor editor, @NotNull String name, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/ES6ImportAction", "runAction"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/javascript/modules/ES6ImportAction", "runAction"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/modules/ES6ImportAction", "runAction"));
        }
        boolean isDefault = ES6ImportHandler.isExportedWithDefault((PsiElement)elementToImport);
        assert (this.myContext != null);
        WriteAction.run(() -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/ES6ImportAction", "lambda$runAction$8"));
            }
            if (elementToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/javascript/modules/ES6ImportAction", "lambda$runAction$8"));
            }
            ES6ImportPsiUtil.insertJSImport(this.myContext, name, isDefault ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER, elementToImport.getContainingFile(), editor);
        });
    }

    @NotNull
    private static List<JSElement> getFinalElements(@NotNull Project project, @NotNull PsiFile file, @NotNull List<JSElement> candidates, @NotNull Collection<JSElement> elementsFromLibraries, @NotNull Map<PsiElement, String> renderedTexts) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ES6ImportAction", "getFinalElements"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/ES6ImportAction", "getFinalElements"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/javascript/modules/ES6ImportAction", "getFinalElements"));
        }
        if (elementsFromLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/javascript/modules/ES6ImportAction", "getFinalElements"));
        }
        if (renderedTexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedTexts", "com/intellij/lang/javascript/modules/ES6ImportAction", "getFinalElements"));
        }
        if (!file.isValid() || project.isDisposed() || !project.isOpen()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "getFinalElements"));
            }
            return list;
        }
        candidates = ES6ImportAction.removeMergedElements(candidates, elementsFromLibraries);
        if (elementsFromLibraries.isEmpty()) {
            List<JSElement> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "getFinalElements"));
            }
            return list;
        }
        HashMap modulesInfos = ContainerUtil.newHashMap();
        ES6ImportAction.fillExternalModuleNames(project, modulesInfos, elementsFromLibraries, file);
        modulesInfos.forEach((el, info) -> {
            if (renderedTexts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedTexts", "com/intellij/lang/javascript/modules/ES6ImportAction", "lambda$getFinalElements$9"));
            }
            renderedTexts.put((PsiElement)el, info.getPath());
        });
        List<JSElement> list = ES6ImportAction.removeSimilarLibraryModules(candidates, modulesInfos);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "getFinalElements"));
        }
        return list;
    }

    private void showPopup(@NotNull List<JSElement> candidates, @NotNull Map<PsiElement, String> preRenderedQNames) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/javascript/modules/ES6ImportAction", "showPopup"));
        }
        if (preRenderedQNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preRenderedQNames", "com/intellij/lang/javascript/modules/ES6ImportAction", "showPopup"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        assert (this.myEditor != null);
        NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])candidates.toArray(new JSElement[candidates.size()])), this.createRenderer(preRenderedQNames), (String)JSBundle.message((String)"choose.class.to.import.title", (Object[])new Object[0]), this.createModuleProcessor()).showInBestPositionFor(this.myEditor);
    }

    @NotNull
    private PsiElementProcessor<JSElement> createModuleProcessor() {
        PsiElementProcessor<JSElement> psiElementProcessor = new PsiElementProcessor<JSElement>(){

            public boolean execute(@NotNull JSElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/ES6ImportAction$1", "execute"));
                }
                CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/ES6ImportAction$1", "lambda$execute$0"));
                    }
                    if (ES6ImportAction.this.myContext == null || !ES6ImportAction.this.myContext.isValid() || !element.isValid()) {
                        return;
                    }
                    assert (ES6ImportAction.this.myName != null);
                    ES6ImportAction.this.executeFor(element);
                }, this.getClass().getName(), (Object)this);
                return false;
            }
        };
        if (psiElementProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "createModuleProcessor"));
        }
        return psiElementProcessor;
    }

    @NotNull
    protected PsiElementListCellRenderer<JSElement> createRenderer(final @NotNull Map<PsiElement, String> preRenderedQNames) {
        if (preRenderedQNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preRenderedQNames", "com/intellij/lang/javascript/modules/ES6ImportAction", "createRenderer"));
        }
        ES6QualifiedNamedElementRenderer<JSElement> eS6QualifiedNamedElementRenderer = new ES6QualifiedNamedElementRenderer<JSElement>(){

            @Override
            protected String getContainerText(JSElement element, String name) {
                String preRenderedQName = (String)preRenderedQNames.get(element);
                if (!StringUtil.isEmpty((String)preRenderedQName)) {
                    return "(" + preRenderedQName + ")";
                }
                return super.getContainerText(element, name);
            }
        };
        if (eS6QualifiedNamedElementRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "createRenderer"));
        }
        return eS6QualifiedNamedElementRenderer;
    }

    private static void fillExternalModuleNames(@NotNull Project project, @NotNull Map<PsiElement, JSModuleNameInfo> renderedText, @NotNull Collection<JSElement> elementsFromLibraries, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ES6ImportAction", "fillExternalModuleNames"));
        }
        if (renderedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedText", "com/intellij/lang/javascript/modules/ES6ImportAction", "fillExternalModuleNames"));
        }
        if (elementsFromLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/javascript/modules/ES6ImportAction", "fillExternalModuleNames"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/ES6ImportAction", "fillExternalModuleNames"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (JSElement element : elementsFromLibraries) {
            JSModuleNameInfo nameToModule = TypeScriptAutoImportUtil.getExternalFileModuleName(project, element, (PsiElement)file);
            if (nameToModule == null) continue;
            renderedText.put((PsiElement)element, nameToModule);
        }
    }

    private static boolean checkReferenceExpressionAcceptable(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/modules/ES6ImportAction", "checkReferenceExpressionAcceptable"));
        }
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        boolean hasValidResult = false;
        for (ResolveResult result : results) {
            if (!result.isValidResult()) continue;
            hasValidResult = true;
            break;
        }
        return !hasValidResult;
    }

    @NotNull
    private static Collection<JSElement> getElementsFromLibraries(@NotNull Project project, @NotNull Collection<JSElement> candidates) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ES6ImportAction", "getElementsFromLibraries"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/javascript/modules/ES6ImportAction", "getElementsFromLibraries"));
        }
        Collection collection = candidates.stream().filter(element -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ES6ImportAction", "lambda$getElementsFromLibraries$10"));
            }
            PsiFile file = element.getContainingFile();
            if (!(file instanceof JSFile) || !((JSFile)file).isCommonJSModule()) {
                return false;
            }
            VirtualFile fileToSearch = file.getVirtualFile();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
            if (virtualFile == null) {
                return false;
            }
            Pair<VirtualFile, VirtualFile> parentLibraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(project, fileToSearch, JSLibraryUtil.LIBRARY_DIR_NAMES);
            return parentLibraryDirectory != null;
        }).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "getElementsFromLibraries"));
        }
        return collection;
    }

    @NotNull
    private static List<JSElement> removeMergedElements(@NotNull List<JSElement> candidates, @NotNull Collection<JSElement> elementsFromLibraries) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/javascript/modules/ES6ImportAction", "removeMergedElements"));
        }
        if (elementsFromLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/javascript/modules/ES6ImportAction", "removeMergedElements"));
        }
        HashSet qNames = ContainerUtil.newHashSet();
        HashSet toRemove = ContainerUtil.newHashSet();
        for (JSElement candidate : candidates) {
            PsiElement module;
            String qName;
            if (elementsFromLibraries.contains(candidate) || StringUtil.isEmpty((String)(qName = JSQualifiedNamedElementRenderer.getQualifiedName(candidate))) || (module = ES6PsiUtil.findExternalModule((PsiElement)candidate)) != null || qNames.add(qName)) continue;
            toRemove.add(candidate);
        }
        if (toRemove.isEmpty()) {
            List<JSElement> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "removeMergedElements"));
            }
            return list;
        }
        List<JSElement> list = candidates.stream().filter(el -> !toRemove.contains(el)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "removeMergedElements"));
        }
        return list;
    }

    @NotNull
    private static List<JSElement> removeSimilarLibraryModules(@NotNull List<JSElement> candidates, @NotNull Map<PsiElement, JSModuleNameInfo> calculatedModules) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/javascript/modules/ES6ImportAction", "removeSimilarLibraryModules"));
        }
        if (calculatedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculatedModules", "com/intellij/lang/javascript/modules/ES6ImportAction", "removeSimilarLibraryModules"));
        }
        if (calculatedModules.isEmpty() || calculatedModules.size() == 1) {
            List<JSElement> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "removeSimilarLibraryModules"));
            }
            return list;
        }
        HashSet toRemove = ContainerUtil.newHashSet();
        Set<Map.Entry<PsiElement, JSModuleNameInfo>> entries = calculatedModules.entrySet();
        ArrayList toIterate = ContainerUtil.newArrayList(calculatedModules.entrySet());
        HashSet uniqueModuleNamesForSymbols = ContainerUtil.newHashSet();
        HashSet uniqueModuleNamesForModules = ContainerUtil.newHashSet();
        entries.forEach(entry -> {
            JSModuleNameInfo moduleInfo = (JSModuleNameInfo)entry.getValue();
            VirtualFile pathFile = moduleInfo.getPathFile();
            PsiElement elementToImport = (PsiElement)entry.getKey();
            String pathText = pathFile.getPath();
            if (!StringUtil.isEmpty((String)pathText)) {
                if (elementToImport instanceof TypeScriptModule) {
                    if (!uniqueModuleNamesForModules.add(pathText)) {
                        toRemove.add(elementToImport);
                    }
                } else if (!uniqueModuleNamesForSymbols.add(pathText)) {
                    toRemove.add(elementToImport);
                }
            }
            if (!pathFile.isDirectory()) {
                return;
            }
            toIterate.forEach(second -> {
                JSModuleNameInfo secondModuleInfo = (JSModuleNameInfo)second.getValue();
                VirtualFile secondModuleInfoPathFile = secondModuleInfo.getPathFile();
                if (secondModuleInfoPathFile.isDirectory() && VfsUtilCore.isAncestor((VirtualFile)secondModuleInfoPathFile, (VirtualFile)pathFile, (boolean)true) && secondModuleInfoPathFile.findChild("package.json") != null) {
                    toRemove.add(elementToImport);
                }
            });
        });
        List<JSElement> list = candidates.stream().filter(el -> !toRemove.contains(el)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction", "removeSimilarLibraryModules"));
        }
        return list;
    }

    public static interface ImportElementFilter {
        @NotNull
        public List<JSElement> filterByContext(@NotNull PsiElement var1, @NotNull List<JSElement> var2);

        public boolean isValidContext(@NotNull PsiElement var1);
    }

    public static class DefaultElementFilter
    implements ImportElementFilter {
        @Override
        @NotNull
        public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter", "filterByContext"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter", "filterByContext"));
            }
            if (result.isEmpty()) {
                List<JSElement> list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter", "filterByContext"));
                }
                return list;
            }
            if (context.getNode().getElementType() == JSTokenTypes.XML_TAG_NAME) {
                List<JSElement> list = result.stream().filter(el -> ReactXmlExtension.isPossibleReactComponent((PsiElement)el)).collect(Collectors.toList());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter", "filterByContext"));
                }
                return list;
            }
            List<JSElement> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter", "filterByContext"));
            }
            return list;
        }

        @Override
        public boolean isValidContext(@NotNull PsiElement context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/ES6ImportAction$DefaultElementFilter", "isValidContext"));
            }
            return !(context instanceof JSReferenceExpression) || ES6ImportAction.checkReferenceExpressionAcceptable((JSReferenceExpression)context);
        }
    }
}

