/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.ES6ImportsWorker;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportES6ModuleFix
extends ImportCommonJSModuleFix {
    private final NotNullLazyValue<String> myInsertedText;

    public ImportES6ModuleFix(@NotNull PsiElement node, @NotNull ModuleFixCreator.FixDescriptor descriptor, String quoteString, boolean needHint) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "<init>"));
        }
        super(node, descriptor, quoteString, needHint);
        this.myInsertedText = new NotNullLazyValue<String>(){

            @NotNull
            protected String compute() {
                String importedElementText = ImportES6ModuleFix.this.getImportData().getRawText();
                String string = "import " + importedElementText + " from " + ImportES6ModuleFix.this.myQuotes + ImportES6ModuleFix.this.getPath() + ImportES6ModuleFix.this.myQuotes;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix$1", "compute"));
                }
                return string;
            }
        };
    }

    @Override
    protected boolean modifyExistingImports(@NotNull PsiElement scope, Editor editor, @NotNull PsiElement reference) {
        boolean haveReplacement;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "modifyExistingImports"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "modifyExistingImports"));
        }
        ImportData importData = this.getImportData();
        PsiElement parent = reference.getParent();
        if (parent instanceof ES6ImportSpecifier) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)grandParent).getFromClause() == null) {
                return ES6CreateImportUtil.insertFromClause((ES6ImportDeclaration)grandParent, this.myQuotes + this.getPath() + this.myQuotes);
            }
            return false;
        }
        if (!JSCodeStyleSettings.isMergeImports(scope)) {
            return false;
        }
        PsiElement replaceTarget = ImportES6ModuleFix.correctReplaceTarget(reference, importData);
        Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> existing = ES6ImportsWorker.getExistingImport(scope, this.getPath(), importData.getImportedName());
        if (existing == null) {
            return false;
        }
        ES6ImportExportDeclarationPart importElement = (ES6ImportExportDeclarationPart)existing.getSecond();
        ES6ImportDeclaration declaration = (ES6ImportDeclaration)existing.getFirst();
        String importedName = importElement == null ? null : importElement.getDeclaredName();
        boolean canBeDefault = importData.getImportType() == ES6ImportPsiUtil.ImportExportType.DEFAULT || importData.getImportType() == ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        boolean importAllSuggestedForExactImport = importElement instanceof ES6ImportedBinding && this.isNeedMemberImport();
        boolean importSpecifierSuggestedForDefault = importElement instanceof ES6ImportedBinding && !canBeDefault;
        boolean bl = haveReplacement = importedName != null && !importAllSuggestedForExactImport && !importSpecifierSuggestedForDefault;
        if (haveReplacement) {
            this.replaceWithNewReference(replaceTarget, editor, importedName);
            return true;
        }
        if (declaration != null && !ES6ImportPsiUtil.hasNamespaceImport(declaration)) {
            if (importData.getImportType() != ES6ImportPsiUtil.ImportExportType.SPECIFIER) {
                return false;
            }
            ES6ImportSpecifier importSpecifier = ES6ImportPsiUtil.insertImportSpecifier(declaration, importData);
            if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                this.replaceWithNewReference(replaceTarget, editor, importSpecifier.getDeclaredName());
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static PsiElement correctReplaceTarget(@NotNull PsiElement reference, ImportData prefix) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "correctReplaceTarget"));
        }
        if (reference instanceof JSReferenceExpression) {
            JSReferenceExpression replaceTarget = (JSReferenceExpression)reference;
            if (prefix.myReplaceTarget == null) {
                while (replaceTarget.getQualifier() instanceof JSReferenceExpression) {
                    replaceTarget = (JSReferenceExpression)replaceTarget.getQualifier();
                }
            }
            JSReferenceExpression jSReferenceExpression = replaceTarget;
            if (jSReferenceExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "correctReplaceTarget"));
            }
            return jSReferenceExpression;
        }
        PsiElement psiElement = reference;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "correctReplaceTarget"));
        }
        return psiElement;
    }

    @Override
    protected void replaceReferences(PsiElement element, Editor editor) {
        String name;
        PsiElement replaceTarget = ImportES6ModuleFix.correctReplaceTarget(element, this.getImportData());
        if (replaceTarget instanceof JSReferenceExpression && (name = ((JSReferenceExpression)replaceTarget).getReferenceName()) != null) {
            this.replaceWithNewReference(replaceTarget, editor, name);
        }
    }

    private boolean isNeedMemberImport() {
        PsiElement replaceReference = this.myFixDescriptor.getTailToReplaceReference();
        String tailName = replaceReference != null ? this.myFixDescriptor.getTail()[0] : null;
        return !"default".equals(tailName) && replaceReference != null;
    }

    @Override
    protected PsiElement createRequire(@NotNull PsiFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "createRequire"));
        }
        PsiFile file = ImportES6ModuleFix.createDummyFile(context.getProject(), this.getInsertedText() + JSCodeStyleSettings.getSemicolon(context));
        return file.getFirstChild();
    }

    private String getInsertedText() {
        return (String)this.myInsertedText.getValue();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.inspection.es6.modules.dependencies.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    private ImportData getImportData() {
        String varName = this.myFixDescriptor.getFirstWordInFile();
        ES6ImportPsiUtil.ImportExportType type = this.myFixDescriptor.getImportType();
        if (type != null) {
            ImportData importData = new ImportData(varName, type);
            if (importData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getImportData"));
            }
            return importData;
        }
        if (this.myFixDescriptor.getFirstWordInExportsName() != null) {
            if (this.myFixDescriptor.getFirstWordInExportsName().equals(varName)) {
                ImportData importData = new ImportData(varName, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                if (importData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getImportData"));
                }
                return importData;
            }
            ImportData importData = new ImportData(this.myFixDescriptor.getFirstWordInExportsName(), varName, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
            if (importData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getImportData"));
            }
            return importData;
        }
        if (this.myFixDescriptor.getTail() != null) {
            String tail = this.myFixDescriptor.getTail()[0];
            PsiElement target = this.myFixDescriptor.getTailToReplaceReference();
            ImportData importData = new ImportData(tail == null ? varName : tail, ES6ImportPsiUtil.ImportExportType.SPECIFIER, target);
            if (importData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getImportData"));
            }
            return importData;
        }
        ImportData importData = new ImportData(varName, ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL);
        if (importData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getImportData"));
        }
        return importData;
    }

    @Override
    protected void insertCreatedElement(@NotNull PsiElement scope, @Nullable Editor editor, @NotNull PsiElement created) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "insertCreatedElement"));
        }
        if (created == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "created", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "insertCreatedElement"));
        }
        ES6CreateImportUtil.findPlaceAndInsertImport(scope, created, editor);
    }

    @Nls
    @NotNull
    public String getText() {
        String wholeImportWrapQuote = "'".equals(this.myQuotes) ? "\"" : "'";
        String string = "Insert " + wholeImportWrapQuote + this.getInsertedText() + wholeImportWrapQuote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getText"));
        }
        return string;
    }

    private static class ImportData
    extends ES6ImportPsiUtil.CreateImportExportInfo {
        @Nullable
        private final PsiElement myReplaceTarget;

        public ImportData(@NotNull String importedName, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
            if (importedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedName", "com/intellij/lang/javascript/modules/ImportES6ModuleFix$ImportData", "<init>"));
            }
            if (importType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/javascript/modules/ImportES6ModuleFix$ImportData", "<init>"));
            }
            this(importedName, importType, null);
        }

        public ImportData(@Nullable String exportedName, @Nullable String importedName, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
            if (importType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/javascript/modules/ImportES6ModuleFix$ImportData", "<init>"));
            }
            super(exportedName, importedName, importType);
            this.myReplaceTarget = null;
        }

        public ImportData(@NotNull String importedName, @NotNull ES6ImportPsiUtil.ImportExportType importType, @Nullable PsiElement replaceTarget) {
            if (importedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedName", "com/intellij/lang/javascript/modules/ImportES6ModuleFix$ImportData", "<init>"));
            }
            if (importType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/javascript/modules/ImportES6ModuleFix$ImportData", "<init>"));
            }
            super(importedName, importType);
            this.myReplaceTarget = replaceTarget;
        }
    }
}

