/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        if (sourceElement == null) {
            return null;
        }
        PsiElement[] elements = JSGotoDeclarationHandler.getGotoDeclarationTargetsImpl(sourceElement);
        if (elements != null && elements.length > 0) {
            return (PsiElement[])Arrays.stream(elements).map(el -> JSTargetElementEvaluator.adjustTargetElement(el)).toArray(PsiElement[]::new);
        }
        return elements;
    }

    @Nullable
    private static PsiElement[] getGotoDeclarationTargetsImpl(@NotNull PsiElement sourceElement) {
        PsiElement resolved;
        JSReferenceExpression element;
        ResolveResult[] resolveResults;
        Collection<PsiElement> elements;
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/javascript/navigation/JSGotoDeclarationHandler", "getGotoDeclarationTargetsImpl"));
        }
        ASTNode node = sourceElement.getNode();
        if (node == null || !JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType())) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof ES6ImportedBinding) {
            ES6ImportedBinding importedBinding = (ES6ImportedBinding)parent;
            if (importedBinding.isNamespaceImport()) {
                return null;
            }
            Collection elements2 = importedBinding.findReferencedElements();
            if (elements2.size() > 0) {
                return elements2.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        if (parent instanceof JSReferenceExpression && parent.getParent() instanceof JSNewExpression && !(elements = JSResolveResult.toElements(resolveResults = (element = (JSReferenceExpression)parent).multiResolve(false))).isEmpty()) {
            List result = ContainerUtil.newSmartList();
            for (PsiElement psiElement : elements) {
                ResolveResult[] results;
                Collection<PsiElement> resolvedElements;
                if (!(psiElement instanceof JSClass) || (resolvedElements = JSResolveResult.toElements(results = JSClassUtils.resolveES6Constructor((JSClass)psiElement, (JSExpression)parent))).isEmpty()) continue;
                result.addAll(resolvedElements);
            }
            if (result.size() > 0) {
                return result.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        JSReferenceExpression referenceExpression = parent instanceof JSReferenceExpression ? (JSReferenceExpression)parent : null;
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property && ((ES6Property)grandParent).isShorthanded() && (resolved = referenceExpression.resolve()) != null) {
            return new PsiElement[]{resolved};
        }
        return null;
    }

    @Nullable
    public String getActionText(DataContext context) {
        return null;
    }
}

