/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringTemplateExpressionImpl
extends JSLiteralExpressionImpl
implements JSStringTemplateExpression {
    private static TokenSet STRING_TEMPLATE_PART_SET = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART});

    public JSStringTemplateExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSStringTemplateExpressionImpl(@NotNull JSLiteralExpressionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/ecma6/impl/JSStringTemplateExpressionImpl", "<init>"));
        }
        super(stub, (IStubElementType)JSStubElementTypes.STRING_TEMPLATE_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/JSStringTemplateExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSStringTemplateExpression((JSStringTemplateExpression)this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public boolean isQuotedLiteral() {
        return true;
    }

    @Override
    @Nullable
    public Object getValue() {
        ASTNode child3;
        ASTNode child1 = this.getNode().getFirstChildNode();
        ASTNode child2 = child1 != null ? child1.getTreeNext() : null;
        ASTNode aSTNode = child3 = child2 != null ? child2.getTreeNext() : null;
        if (child1 != null && child1.getElementType() == JSTokenTypes.BACKQUOTE && child2 != null && child2.getElementType() == JSTokenTypes.STRING_TEMPLATE_PART && child3 != null && child3.getElementType() == JSTokenTypes.BACKQUOTE && child3.getTreeNext() == null) {
            return child2.getText();
        }
        return null;
    }

    @NotNull
    public TextRange[] getStringRanges() {
        ASTNode[] strings = this.getNode().getChildren(STRING_TEMPLATE_PART_SET);
        TextRange[] result = new TextRange[strings.length];
        int startOffset = this.getTextRange().getStartOffset();
        for (int i = 0; i < strings.length; ++i) {
            result[i] = strings[i].getTextRange().shiftRight(-startOffset);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/JSStringTemplateExpressionImpl", "getStringRanges"));
        }
        return result;
    }

    @NotNull
    public JSExpression[] getArguments() {
        JSExpression[] jSExpressionArray = (JSExpression[])this.getStubOrPsiChildren(JSElementTypes.EXPRESSIONS, JSExpression.ARRAY_FACTORY);
        if (jSExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/JSStringTemplateExpressionImpl", "getArguments"));
        }
        return jSExpressionArray;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/ecma6/impl/JSStringTemplateExpressionImpl", "updateText"));
        }
        ASTNode expr = JSChangeUtil.createExpressionFromText(this.getProject(), text, DialectDetector.getLanguageDialect((PsiElement)this));
        if (expr.getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION) {
            this.getNode().replaceAllChildrenToChildrenOf(expr);
        }
        return this;
    }
}

