/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeListImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptAttributeListImpl
extends JSAttributeListImpl {
    private volatile JSAttribute[] myAttributes;
    private volatile Map<String, Object> myNameToAttributesMap;
    private static final Key<CachedValue<String>> ourCachedResolvedNsKey = Key.create((String)"ourCachedResolvedNs");
    private static final UserDataCache<CachedValue<String>, JSElement, Object> ourCachedOpenedNsesCache = new UserDataCache<CachedValue<String>, JSElement, Object>(){

        protected CachedValue<String> compute(JSElement jsElement, Object p) {
            return CachedValuesManager.getManager((Project)jsElement.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)JSPsiImplUtils.calcNamespaceReference((PsiElement)jsElement), new Object[]{jsElement.getContainingFile()}), false);
        }
    };

    public ActionScriptAttributeListImpl(ASTNode node) {
        super(node);
    }

    public ActionScriptAttributeListImpl(@NotNull JSAttributeListStub stub, @NotNull JSStubElementType<JSAttributeListStub, JSAttributeList> elementType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "<init>"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "<init>"));
        }
        super(stub, elementType);
    }

    @Override
    public JSConditionalCompileVariableReference getConditionalCompileVariableReference() {
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null && !stub.hasConditionalCompilerVariable()) {
            return null;
        }
        ASTNode conditionalCompileVarRef = this.getNode().findChildByType(JSElementTypes.CONDITIONAL_COMPILE_VARIABLE_REFERENCE);
        return conditionalCompileVarRef != null ? (JSConditionalCompileVariableReference)conditionalCompileVarRef.getPsi() : null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "add"));
        }
        if (element.getNode().getElementType() == JSTokenTypes.OVERRIDE_KEYWORD) {
            return JSChangeUtil.doDoAddBefore((PsiElement)this, element, this.getFirstChild());
        }
        return super.add(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public JSAttribute[] getAttributes() {
        if (this.myAttributes == null) {
            ActionScriptAttributeListImpl actionScriptAttributeListImpl = this;
            synchronized (actionScriptAttributeListImpl) {
                if (this.myAttributes == null) {
                    this.myAttributes = (JSAttribute[])this.getStubOrPsiChildren((IStubElementType)JSStubElementTypes.ATTRIBUTE, JSAttribute.ARRAY_FACTORY);
                }
            }
        }
        if (this.myAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "getAttributes"));
        }
        return this.myAttributes;
    }

    @Override
    @NotNull
    public JSAttribute[] getAttributesByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "getAttributesByName"));
        }
        this.initAttributes();
        Object o = this.myNameToAttributesMap.get(name);
        if (o == null) {
            if (JSAttribute.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "getAttributesByName"));
            }
            return JSAttribute.EMPTY_ARRAY;
        }
        if (o instanceof JSAttribute) {
            JSAttribute[] jSAttributeArray = new JSAttribute[]{(JSAttribute)o};
            if (jSAttributeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "getAttributesByName"));
            }
            return jSAttributeArray;
        }
        JSAttribute[] jSAttributeArray = (JSAttribute[])o;
        if (jSAttributeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "getAttributesByName"));
        }
        return jSAttributeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes() {
        if (this.myNameToAttributesMap == null) {
            ActionScriptAttributeListImpl actionScriptAttributeListImpl = this;
            synchronized (actionScriptAttributeListImpl) {
                if (this.myNameToAttributesMap == null) {
                    THashMap map = null;
                    for (JSAttribute attr : this.getAttributes()) {
                        String name = attr.getName();
                        if (name == null) continue;
                        if (map != null) {
                            Object o = map.get(name);
                            if (o == null) {
                                map.put(name, attr);
                                continue;
                            }
                            if (o instanceof JSAttribute) {
                                map.put(name, new JSAttribute[]{(JSAttribute)o, attr});
                                continue;
                            }
                            map.put(name, ArrayUtil.append((Object[])((JSAttribute[])o), (Object)attr, JSAttribute.class));
                            continue;
                        }
                        map = new THashMap();
                        map.put(name, attr);
                    }
                    if (map == null) {
                        map = Collections.emptyMap();
                    }
                    this.myNameToAttributesMap = map;
                }
            }
        }
    }

    @Override
    public JSAttribute findAttributeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptAttributeListImpl", "findAttributeByName"));
        }
        this.initAttributes();
        Object o = this.myNameToAttributesMap.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof JSAttribute) {
            return (JSAttribute)o;
        }
        return ((JSAttribute[])o)[0];
    }

    @Override
    @Nullable
    public String getNamespace() {
        JSAttributeListStub attributeListStub = (JSAttributeListStub)this.getGreenStub();
        if (attributeListStub != null) {
            return attributeListStub.getNamespace();
        }
        JSReferenceExpression namespaceElement = this.getNamespaceElement();
        return namespaceElement != null ? namespaceElement.getText() : null;
    }

    @Override
    public JSReferenceExpression getNamespaceElement() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
        return node != null ? (JSReferenceExpression)node.getPsi() : null;
    }

    @Override
    public boolean hasModifier(JSAttributeList.ModifierType modifier) {
        PsiElement parent;
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasModifier(modifier);
        }
        if (this.hasExplicitModifier(modifier)) {
            return true;
        }
        if (modifier == JSAttributeList.ModifierType.STATIC && (parent = this.getParent()) instanceof JSNamespaceDeclaration) {
            PsiElement grandParent = JSResolveUtil.findParent(parent);
            return grandParent instanceof JSClass;
        }
        return false;
    }

    @Override
    public String resolveNamespaceValue() {
        String ns = this.tryResolveNamespaceValueFromStub();
        if (ns != null) {
            return ns;
        }
        try {
            return (String)((CachedValue)ourCachedOpenedNsesCache.get(ourCachedResolvedNsKey, (UserDataHolder)this, null)).getValue();
        }
        catch (IndexNotReadyException ex) {
            return this.getNamespace();
        }
    }

    @Nullable
    public String tryResolveNamespaceValueFromStub() {
        String resolvedNamespace;
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null && !"-\"-".equals(resolvedNamespace = stub.getResolvedNamespace())) {
            return resolvedNamespace;
        }
        return null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myNameToAttributesMap = null;
        this.myAttributes = null;
    }

    protected Object clone() {
        ActionScriptAttributeListImpl attrList = (ActionScriptAttributeListImpl)((Object)super.clone());
        attrList.myNameToAttributesMap = null;
        attrList.myAttributes = null;
        return attrList;
    }
}

