/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ES6ChangeUtil {
    private ES6ChangeUtil() {
    }

    public static void replaceWithShorthand(@NotNull JSProperty source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "replaceWithShorthand"));
        }
        String text = String.format("{%s}", source.getName());
        ES6ChangeUtil.replacePropertyWithText(source, text);
    }

    public static void expandShorthandPropertyWithValue(@NotNull ES6Property source, @NotNull String value) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "expandShorthandPropertyWithValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "expandShorthandPropertyWithValue"));
        }
        String text = String.format("{%s:%s}", source.getName(), value);
        ES6ChangeUtil.replacePropertyWithText((JSProperty)source, text);
    }

    public static void expandShorthandPropertyWithName(@NotNull ES6Property source, @NotNull String name) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "expandShorthandPropertyWithName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "expandShorthandPropertyWithName"));
        }
        String text = String.format("{%s:%s}", name, source.getName());
        ES6ChangeUtil.replacePropertyWithText((JSProperty)source, text);
    }

    public static void replacePropertyWithText(@NotNull JSProperty source, @NotNull String text) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "replacePropertyWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "replacePropertyWithText"));
        }
        JSObjectLiteralExpression jsObjectLiteralExpression = JSChangeUtil.createExpressionPsiWithContext(text, (PsiElement)source, JSObjectLiteralExpression.class);
        if (jsObjectLiteralExpression == null) {
            return;
        }
        source.replace((PsiElement)ObjectUtils.assertNotNull((Object)jsObjectLiteralExpression.getFirstProperty()));
    }

    public static void replaceWithShorthand(@NotNull JSDestructuringProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "replaceWithShorthand"));
        }
        JSDestructuringProperty replacement = ES6ChangeUtil.destructuringPropertyFromText(property.getName(), (PsiElement)property);
        property.replace((PsiElement)replacement);
    }

    @NotNull
    public static JSDestructuringProperty expandDestructuringProperty(@NotNull JSDestructuringShorthandedProperty property, @NotNull String propertyName, @NotNull String variableName) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "expandDestructuringProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "expandDestructuringProperty"));
        }
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "expandDestructuringProperty"));
        }
        JSDestructuringProperty expanded = ES6ChangeUtil.destructuringPropertyFromText(String.format("%s : %s", propertyName, variableName), (PsiElement)property);
        JSDestructuringProperty jSDestructuringProperty = (JSDestructuringProperty)property.replace((PsiElement)expanded);
        if (jSDestructuringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "expandDestructuringProperty"));
        }
        return jSDestructuringProperty;
    }

    private static JSDestructuringProperty destructuringPropertyFromText(String text, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil", "destructuringPropertyFromText"));
        }
        String template = null;
        if (PsiTreeUtil.getParentOfType((PsiElement)context, JSVarStatement.class) != null) {
            template = String.format("var {%s}", text);
        } else if (PsiTreeUtil.getParentOfType((PsiElement)context, JSParameterList.class) != null) {
            template = String.format("function({%s}){}", text);
        }
        if (template == null) {
            throw new UnsupportedOperationException(String.format("Could not find context of type JSVarStatement or JSParameterList for element %s [%s]", context, context.getText()));
        }
        JSElement sourceElement = JSChangeUtil.createStatementPsiFromTextWithContext(template, context, JSElement.class);
        Ref propertyRef = new Ref();
        PsiTreeUtil.processElements((PsiElement)sourceElement, element -> {
            JSDestructuringProperty destructuringProperty;
            JSDestructuringProperty jSDestructuringProperty = destructuringProperty = element instanceof JSDestructuringProperty ? (JSDestructuringProperty)element : null;
            if (element instanceof JSDestructuringProperty) {
                propertyRef.set((Object)destructuringProperty);
                return false;
            }
            return true;
        });
        return (JSDestructuringProperty)propertyRef.get();
    }
}

