/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSIndexingDataHolder;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefinitionExpressionImpl
extends JSQualifiedNamedElementBaseImpl<JSDefinitionExpressionStub>
implements JSDefinitionExpression,
StubBasedPsiElement<JSDefinitionExpressionStub>,
JSIndexingDataHolder {
    private static final String NULL_NAME = "^null";
    private String myName;
    private static final Key<ParameterizedCachedValue<JSSymbolNamespace, JSDefinitionExpressionImpl>> SYMBOL_NAMESPACE_PROVIDER_KEY = Key.create((String)"js.definition.expression.symbol.namespace");
    private static final ParameterizedCachedValueProvider<JSSymbolNamespace, JSDefinitionExpressionImpl> SYMBOL_NAMESPACE_PROVIDER = new ParameterizedCachedValueProvider<JSSymbolNamespace, JSDefinitionExpressionImpl>(){

        public CachedValueProvider.Result<JSSymbolNamespace> compute(JSDefinitionExpressionImpl param) {
            JSSymbolNamespace data = param.calculateSymbolNamespace(null);
            return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{param.getContainingFile()});
        }
    };

    public JSDefinitionExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSDefinitionExpressionImpl(@NotNull JSDefinitionExpressionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "<init>"));
        }
        super(stub, (IStubElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
    }

    @Nullable
    public JSExpression getExpression() {
        ASTNode expressionNode = JSDefinitionExpressionImpl.getExpressionNode(this.getNode());
        return expressionNode != null ? (JSExpression)expressionNode.getPsi() : null;
    }

    @Nullable
    public static ASTNode getExpressionNode(@NotNull ASTNode definitionNode) {
        if (definitionNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionNode", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "getExpressionNode"));
        }
        return definitionNode.findChildByType(JSElementTypes.EXPRESSIONS);
    }

    @Nullable
    public JSExpression getInitializer() {
        return JSPsiImplUtils.getRightmostOperand(this);
    }

    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Nullable
    public JSFunctionExpression tryGetFunctionExpressionInitializer() {
        JSExpression initializer = this.getInitializerOrStub();
        return initializer instanceof JSFunctionExpression ? (JSFunctionExpression)initializer : null;
    }

    public JSExpression getInitializerOrStub() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getStub();
        if (stub != null) {
            if (!stub.keepsInitializerStub()) {
                return null;
            }
            StubElement nextSibling = StubTreeUtil.getNextSibling(stub, JSElementTypes.EXPRESSIONS);
            while (nextSibling != null) {
                if (nextSibling.getStubType() == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
                    nextSibling = StubTreeUtil.getNextSibling((StubElement)nextSibling.getChildrenStubs().get(0), JSElementTypes.EXPRESSIONS);
                    continue;
                }
                return (JSExpression)nextSibling.getPsi();
            }
            return null;
        }
        return this.getInitializer();
    }

    @Nullable
    public String getInitializerReference() {
        JSExpression rOperand;
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getInitializerReference();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)parent).getROperand()) instanceof JSReferenceExpression && ((JSReferenceExpression)rOperand).getQualifier() == null) {
            return ((JSReferenceExpression)rOperand).getReferencedName();
        }
        return null;
    }

    @Nullable
    public JSType getType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this, () -> {
            JSType type;
            JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
            if (stub != null) {
                String typeString = stub.getTypeString();
                type = JSTypeUtils.parseSerializedType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)this, stub.isTypeExplicitlyDeclared()));
            } else {
                type = this.doGetType();
            }
            return CachedValueProvider.Result.create((Object)type, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        });
    }

    private JSType doGetType() {
        if (this.tryGetFunctionExpressionInitializer() != null) {
            return null;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)this);
        JSType type = null;
        if (docComment instanceof JSDocComment) {
            String typeString = ((JSDocComment)docComment).getType();
            if (typeString != null) {
                type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
        } else {
            PsiComment scopeComment = JSDocumentationUtils.findScopeComment(this);
            if (scopeComment instanceof JSDocComment) {
                String propertyType;
                Map properties = ((JSDocComment)scopeComment).getProperties();
                String name = this.getName();
                if (properties != null && name != null && (propertyType = (String)properties.get(JSQualifiedNameImpl.create(name, null))) != null) {
                    type = JSTypeUtils.createType(propertyType, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
                }
            }
        }
        PsiElement parent = this.getParent();
        if (type == null && parent instanceof JSAssignmentExpression) {
            JSExpression initializer;
            JSExpression operand = ((JSAssignmentExpression)parent).getROperand();
            type = JSSymbolUtil.evaluateTypeLocally(operand, true);
            if (type == null && CommonJSUtil.isExportNamespace(this.getNamespace()) && (initializer = this.getInitializer()) != null && (type = JSFileCachedDataEvaluator.getTypeForExportedElement(initializer)) != null) {
                type = JSTypeUtils.copyWithNewSourceRecursive(type, JSTypeSourceFactory.createTypeSource((PsiElement)initializer, false));
            }
            if (type != null) {
                type = JSTypeUtils.copyWithExplicitlyDeclared(type, false);
            }
        }
        return type;
    }

    @Override
    public void clearCaches() {
        this.myName = null;
    }

    public String getName() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this.myName == null) {
            String name;
            this.myName = NULL_NAME;
            JSExpression expression = this.getExpression();
            if (expression instanceof JSReferenceExpression) {
                this.myName = ((JSReferenceExpression)expression).getReferencedName();
            } else if (expression instanceof JSIndexedPropertyAccessExpression && (name = JSSymbolUtil.getIndexedPropertyName((JSIndexedPropertyAccessExpression)expression)) != null) {
                this.myName = name;
            }
        }
        return this.myName != NULL_NAME ? this.myName : null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "setName"));
        }
        JSExpression expression = this.getExpression();
        if (expression instanceof JSReferenceExpressionImpl) {
            return ((JSReferenceExpressionImpl)expression).handleElementRenameInternal(name);
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDefinitionExpression((JSDefinitionExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public Icon getIcon(int flags) {
        JSExpression value = this.getInitializerOrStub();
        if (value instanceof JSCallExpression) {
            Collection baseTypes;
            JSElementIndexingData indexingData = ((JSCallExpression)value).getIndexingData();
            Collection collection = baseTypes = indexingData != null ? indexingData.getBaseTypes() : null;
            if (baseTypes != null) {
                return JSIconProvider.getForLanguage((PsiElement)this).getClassIcon();
            }
        }
        Icon baseIcon = value instanceof JSFunction ? JSFunctionImpl.getFunctionBaseIcon((JSFunctionItem)((JSFunction)value)) : PlatformIcons.FIELD_ICON;
        return JSDefinitionExpressionImpl.getIcon((JSPsiElementBase)this, baseIcon, flags);
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof JSAssignmentExpression) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSStatement) {
                if (grandParent instanceof JSExpressionStatement) {
                    grandParent.delete();
                } else {
                    parent.delete();
                }
                return;
            }
            if (grandParent instanceof JSBinaryExpression) {
                ((JSBinaryExpression)grandParent).getROperand().replace(((JSAssignmentExpression)parent).getROperand());
                return;
            }
            if (grandParent instanceof JSVariable) {
                JSExpression initializerExpression = ((JSVariable)grandParent).getInitializer();
                initializerExpression.replace(((JSAssignmentExpression)parent).getROperand());
                return;
            }
        }
        super.delete();
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getNode() : null;
    }

    public PsiElement getNameIdentifier() {
        JSExpression expression = this.getExpression();
        return expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceNameElement() : null;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        JSSymbolNamespace symbolNamespace = this.getSymbolNamespace();
        return symbolNamespace.isLocal() ? null : symbolNamespace.getQualifiedName();
    }

    @NotNull
    private JSSymbolNamespace getSymbolNamespace() {
        JSSymbolNamespace jSSymbolNamespace = (JSSymbolNamespace)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, SYMBOL_NAMESPACE_PROVIDER_KEY, SYMBOL_NAMESPACE_PROVIDER, false, (Object)this);
        if (jSSymbolNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "getSymbolNamespace"));
        }
        return jSSymbolNamespace;
    }

    @NotNull
    public JSSymbolNamespace calculateSymbolNamespace(@Nullable Set<PsiElement> visited) {
        JSContext jsContext;
        boolean namespaceExplicitlyDeclared;
        JSQualifiedName namespace;
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        boolean isDeclaration = true;
        boolean isLocal = false;
        if (stub != null) {
            namespace = stub.getNamespace();
            namespaceExplicitlyDeclared = stub.isNamespaceExplicitlyDeclared();
            jsContext = stub.getJSContext();
            isDeclaration = stub.isDeclaration();
        } else {
            JSExpression qualifier;
            JSExpression expression;
            namespace = null;
            namespaceExplicitlyDeclared = false;
            jsContext = JSContext.UNKNOWN;
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)this);
            if (docComment instanceof JSDocComment && (namespaceExplicitlyDeclared = ((JSDocComment)docComment).isNamespaceExplicitlyDeclared())) {
                namespace = ((JSDocComment)docComment).getNamespace();
            }
            Object object = (expression = this.getExpression()) instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getQualifier() : (qualifier = expression instanceof JSIndexedPropertyAccessExpression ? ((JSIndexedPropertyAccessExpression)expression).getQualifier() : null);
            if (!namespaceExplicitlyDeclared && qualifier != null) {
                JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(qualifier, visited);
                if (ns != null) {
                    namespace = ns.getQualifiedName();
                    namespaceExplicitlyDeclared = ns.isExplicitlyDeclared();
                    jsContext = ns.getJSContext();
                    isDeclaration = ns.isDeclaration();
                    isLocal = ns.isLocal();
                } else {
                    namespace = JSSymbolUtil.getReferencedNamespace(qualifier);
                    namespaceExplicitlyDeclared = false;
                    if (namespace != null && namespace.getParent() == null) {
                        isLocal = true;
                    }
                }
            } else if (!namespaceExplicitlyDeclared) {
                namespaceExplicitlyDeclared = !JSTreeUtil.withinWithStatement(this.getNode());
                String name = this.getName();
                if (name != null) {
                    isLocal = JSTreeUtil.definedInScopeAndUp(name, this.getNode());
                }
            }
            if (jsContext == JSContext.UNKNOWN) {
                jsContext = JSSymbolUtil.getContext(this);
            }
        }
        JSSymbolNamespaceImpl jSSymbolNamespaceImpl = new JSSymbolNamespaceImpl(namespace, jsContext, namespaceExplicitlyDeclared, isDeclaration, isLocal);
        if (jSSymbolNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "calculateSymbolNamespace"));
        }
        return jSSymbolNamespaceImpl;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getSymbolNamespace().isExplicitlyDeclared();
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            JSNamespace jSNamespace = stub.getJSNamespace();
            if (jSNamespace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "getJSNamespace"));
            }
            return jSNamespace;
        }
        JSSymbolNamespace jSSymbolNamespace = this.getSymbolNamespace();
        if (jSSymbolNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "getJSNamespace"));
        }
        return jSSymbolNamespace;
    }

    @NotNull
    public JSContext getJSContext() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "getJSContext"));
            }
            return jSContext;
        }
        JSContext jSContext = this.getSymbolNamespace().getJSContext();
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "getJSContext"));
        }
        return jSContext;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "getAccessType"));
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = JSPsiImplUtils.getAccessType(this);
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl", "getAccessType"));
        }
        return accessType;
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        PsiComment comment;
        JSExpression rOperand;
        JSNamespaceEvaluationResult rOpNamespace;
        PsiElement parent;
        JSElementIndexingDataImpl result = null;
        String name = this.getName();
        if ("prototype".equals(name) && (parent = this.getParent()) instanceof JSAssignmentExpression && (rOpNamespace = JSSymbolUtil.evaluateNamespaceLocally(rOperand = ((JSAssignmentExpression)parent).getROperand())) != null) {
            result = this.createBaseTypeIndexingData(rOpNamespace.toType((PsiElement)this));
        }
        if ((comment = JSDocumentationUtils.findDocComment((PsiElement)this)) instanceof JSDocComment && (((JSDocComment)comment).isClassExplicitly() || ((JSDocComment)comment).hasInterfaceTag())) {
            if (result == null) {
                result = new JSElementIndexingDataImpl();
            }
            if (((JSDocComment)comment).isClassExplicitly()) {
                result.setIsClassExplicitly();
            }
            if (((JSDocComment)comment).hasInterfaceTag()) {
                result.setIsInterfaceExplicitly();
            }
        }
        return result;
    }

    @Nullable
    public JSElementIndexingData getIndexingData() {
        return JSImplicitElementProviderImpl.getIndexingData(this);
    }

    @Nullable
    private JSElementIndexingData createBaseTypeIndexingData(@Nullable JSType superType) {
        JSQualifiedName namespace = this.getNamespace();
        if (this.getJSContext() != JSContext.INSTANCE && namespace != null && superType != null) {
            JSElementIndexingDataImpl data = new JSElementIndexingDataImpl();
            data.addBaseType(namespace.getQualifiedName(), superType.getTypeText(JSType.TypeTextFormat.SERIALIZED));
            return data;
        }
        return null;
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public boolean isExportedWithDefault() {
        return false;
    }

    public boolean isDeclaration() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDeclaration();
        }
        return this.getSymbolNamespace().isDeclaration();
    }
}

