/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class JSDocTagReferencesHolderImpl
extends JSElementImpl {
    private static final Pattern REPLACE_ASTERISKS_PATTERN = Pattern.compile("\\n\\s*\\*?");
    private static final Key<ParameterizedCachedValue<PsiReference[], JSDocTagReferencesHolderImpl>> REFERENCES_KEY = new Key("js.doc.tag.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSDocTagReferencesHolderImpl> REFERENCES_PROVIDER = new ParameterizedCachedValueProvider<PsiReference[], JSDocTagReferencesHolderImpl>(){

        @Nullable
        public CachedValueProvider.Result<PsiReference[]> compute(JSDocTagReferencesHolderImpl param) {
            return CachedValueProvider.Result.create((Object)param.createRefs(), (Object[])new Object[]{param});
        }
    };

    public JSDocTagReferencesHolderImpl(IElementType elementType) {
        super(elementType);
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    protected abstract PsiReference[] createRefs();

    @NotNull
    protected PsiReference[] createReferencesFromText(@NotNull String text, boolean soft, boolean event, boolean module, boolean isNamepath, boolean isDeclaration) {
        boolean parsedSuccessfully;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl", "createReferencesFromText"));
        }
        int offset = 0;
        boolean wrappedInBraces = false;
        if (text.startsWith("{")) {
            text = text.substring(1);
            ++offset;
            soft = false;
            wrappedInBraces = true;
        }
        if (text.endsWith("}")) {
            text = text.substring(0, text.length() - 1);
        } else {
            wrappedInBraces = false;
        }
        ArrayList result = new ArrayList();
        Matcher matcher = REPLACE_ASTERISKS_PATTERN.matcher(text);
        StringBuilder builder = new StringBuilder(text);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            builder.replace(start, end, StringUtil.repeatSymbol((char)' ', (int)(end - start)));
        }
        text = builder.toString();
        SmartList myReferences = new SmartList();
        JSTypeParser typeParser = new JSTypeParser(text, new JSTypeVisitor((List)myReferences){
            final /* synthetic */ List val$myReferences;
            {
                this.val$myReferences = list;
            }

            @Override
            public void visitSingleType(int startOffset, String name) {
                if (!"void".equals(name)) {
                    this.val$myReferences.add(Pair.create((Object)startOffset, (Object)name));
                }
            }

            @Override
            public void visitRecordProperty(int startOffset, String name, @Nullable String recordPropertyType) {
            }
        });
        boolean bl = parsedSuccessfully = (isNamepath ? typeParser.parseNamepath() : typeParser.parseParameterType()) != null;
        if (parsedSuccessfully) {
            for (Pair reference : myReferences) {
                String qName = (String)reference.second;
                JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this, qName, offset + (Integer)reference.first, soft, event, module);
                Collections.addAll(result, set.getReferences());
            }
        } else if (wrappedInBraces || JSDocumentationUtils.isExtendedTypeName(text) || DialectDetector.isActionScript((PsiElement)this)) {
            JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this, text, offset, soft);
            Collections.addAll(result, set.getReferences());
        }
        PsiReference[] psiReferenceArray = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl", "createReferencesFromText"));
        }
        return psiReferenceArray;
    }
}

