/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.literal;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementCustomProvider;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLiteralImplicitElementProvidersRegistry {
    private static final Map<String, Collection<JSLiteralImplicitElementProvider>> ourCallArgumentsProvidersRegistry = new THashMap();
    private static final Collection<JSLiteralImplicitElementCustomProvider> ourCustomProvidersRegistry = new SmartList();

    @NotNull
    private static JSLiteralImplicitElementProvider createClassImplicitElementProvider(final boolean isNamespace) {
        JSLiteralImplicitElementProvider jSLiteralImplicitElementProvider = new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSQualifiedName qualifiedName;
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$6", "fillIndexingData"));
                }
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$6", "fillIndexingData"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$6", "fillIndexingData"));
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (qualifiedName = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
                    if ((!"YAHOO".equals(qualifiedName.getName()) || qualifiedName.getParent() == null) && "YAHOO".equals(qualifier.getText())) {
                        qualifiedName = ((JSQualifiedNameImpl)qualifiedName).withQualifier(JSQualifiedNameImpl.create("YAHOO", null));
                    }
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(qualifiedName.getName(), (PsiElement)argument).setNamespace(qualifiedName.getParent()).setType(isNamespace ? JSImplicitElement.Type.Namespace : JSImplicitElement.Type.Class);
                    outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(builder));
                    JSStubIndexingUtils.addImplicitNamespaces(qualifiedName, outIndexingData.getImplicitElements(), (PsiElement)argument);
                }
            }
        };
        if (jSLiteralImplicitElementProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry", "createClassImplicitElementProvider"));
        }
        return jSLiteralImplicitElementProvider;
    }

    private static void addImplicitElementProvider(String methodName, JSLiteralImplicitElementProvider type) {
        SmartList list = ourCallArgumentsProvidersRegistry.get(methodName);
        if (list == null) {
            list = new SmartList();
            ourCallArgumentsProvidersRegistry.put(methodName, (Collection<JSLiteralImplicitElementProvider>)list);
        }
        list.add((JSLiteralImplicitElementProvider)type);
    }

    @Nullable
    public static JSElementIndexingData calculateIndexingData(@NotNull JSLiteralExpression literalExpression) {
        String name;
        JSExpression methodExpression;
        PsiElement grandParent;
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry", "calculateIndexingData"));
        }
        PsiElement parent = literalExpression.getParent();
        if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && (name = ((JSReferenceExpression)methodExpression).getReferencedName()) != null && ourCallArgumentsProvidersRegistry.containsKey(name)) {
            Collection<JSLiteralImplicitElementProvider> elementProviderTypes = ourCallArgumentsProvidersRegistry.get(name);
            JSElementIndexingDataImpl data = new JSElementIndexingDataImpl();
            for (JSLiteralImplicitElementProvider type : elementProviderTypes) {
                type.fillIndexingData(literalExpression, (JSCallExpression)grandParent, data);
            }
            return data;
        }
        JSElementIndexingDataImpl result = null;
        ASTNode node = literalExpression.getNode();
        for (JSLiteralImplicitElementCustomProvider provider : ourCustomProvidersRegistry) {
            if (!provider.checkIfCandidate(node)) continue;
            if (result == null) {
                result = new JSElementIndexingDataImpl();
            }
            provider.fillIndexingDataForCandidate(literalExpression, result);
        }
        return result;
    }

    public static boolean shouldCreateStub(ASTNode node) {
        String name;
        ASTNode methodExpression;
        ASTNode grandParent;
        ASTNode parent = node.getTreeParent();
        if (parent.getElementType() == JSElementTypes.ARGUMENT_LIST && (grandParent = parent.getTreeParent()).getElementType() == JSStubElementTypes.CALL_EXPRESSION && (methodExpression = grandParent.getFirstChildNode()).getElementType() == JSElementTypes.REFERENCE_EXPRESSION && ourCallArgumentsProvidersRegistry.containsKey(name = methodExpression.getLastChildNode().getText())) {
            return true;
        }
        for (JSLiteralImplicitElementCustomProvider customProvider : ourCustomProvidersRegistry) {
            if (!customProvider.checkIfCandidate(node)) continue;
            return true;
        }
        return false;
    }

    static {
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("defineProperty", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                String name;
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$1", "fillIndexingData"));
                }
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$1", "fillIndexingData"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$1", "fillIndexingData"));
                }
                JSExpression[] arguments = callExpression.getArguments();
                if (arguments.length >= 3 && argument == arguments[1] && (name = argument.getValueAsPropertyName()) != null) {
                    JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(arguments[0]);
                    JSQualifiedName qualifiedName = ns != null ? ns.getQualifiedName() : null;
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)argument).setNamespace(qualifiedName).setTypeString(JSDocumentationUtils.findType((PsiElement)callExpression));
                    outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(builder));
                }
            }
        });
        JSLiteralImplicitElementProvider type = new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                String name;
                JSExpression[] arguments;
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$2", "fillIndexingData"));
                }
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$2", "fillIndexingData"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$2", "fillIndexingData"));
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (arguments = callExpression.getArguments()).length == 2 && arguments[0] == argument && (name = argument.getValueAsPropertyName()) != null) {
                    JSQualifiedName namespace = JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(name, namespace, (PsiElement)argument));
                }
            }
        };
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("__defineGetter__", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("__defineSetter__", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("method", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("provide", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSQualifiedName qualifiedName;
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$3", "fillIndexingData"));
                }
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$3", "fillIndexingData"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$3", "fillIndexingData"));
                }
                JSExpression[] jsExpressions = callExpression.getArguments();
                if (jsExpressions.length == 1 && jsExpressions[0] == argument && (qualifiedName = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(qualifiedName.getName(), (PsiElement)argument).setNamespace(qualifiedName.getParent()).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Class);
                    JSImplicitElementImpl element = builder.toImplicitElement();
                    outIndexingData.addImplicitElement((JSImplicitElement)element);
                    JSStubIndexingUtils.addImplicitNamespaces(qualifiedName, outIndexingData.getImplicitElements(), (PsiElement)argument);
                }
            }
        });
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("addProperty", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSExpression[] jsExpressions;
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$4", "fillIndexingData"));
                }
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$4", "fillIndexingData"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$4", "fillIndexingData"));
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (jsExpressions = callExpression.getArguments()).length == 2 && jsExpressions[0] == argument) {
                    JSQualifiedName namespace = JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    String propertyName = argument.getValueAsPropertyName();
                    String type = jsExpressions[1].getText().toLowerCase();
                    if (propertyName != null) {
                        JSImplicitElementImpl.Builder builder;
                        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)callExpression);
                        String typeString = null;
                        if (comment instanceof JSDocComment) {
                            typeString = ((JSDocComment)comment).getType();
                        }
                        if (type.contains("read")) {
                            builder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestGetterName(propertyName), (PsiElement)argument).setType(JSImplicitElement.Type.Function).setTypeString(typeString).setNamespace(namespace);
                            outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                        }
                        if (type.contains("write")) {
                            builder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestSetterName(propertyName), (PsiElement)argument).setType(JSImplicitElement.Type.Function).setParameters(Collections.singletonList(new JSImplicitParameterStructure(propertyName, typeString, false, false, true))).setNamespace(namespace);
                            outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                        }
                        builder = new JSImplicitElementImpl.Builder("_" + propertyName, (PsiElement)argument).setNamespace(namespace).setTypeString(typeString);
                        outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                    }
                }
            }
        });
        type = JSLiteralImplicitElementProvidersRegistry.createClassImplicitElementProvider(true);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("namespace", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("ns", type);
        type = JSLiteralImplicitElementProvidersRegistry.createClassImplicitElementProvider(false);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("defineClass", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("define", type);
        type = new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSExpression[] jsExpressions;
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$5", "fillIndexingData"));
                }
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$5", "fillIndexingData"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$5", "fillIndexingData"));
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier instanceof JSReferenceExpression && (jsExpressions = callExpression.getArguments()).length == 2 && jsExpressions[0] == argument) {
                    JSReferenceExpression refExpr = (JSReferenceExpression)qualifier;
                    Object namespace = "Window".equals(refExpr.getReferencedName()) && refExpr.getQualifier() == null ? null : JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    String propertyName = argument.getValueAsPropertyName();
                    if (propertyName != null) {
                        outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(propertyName, (JSQualifiedName)namespace, (PsiElement)argument));
                    }
                }
            }
        };
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("extend", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("implement", type);
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
            for (String methodName : handler.interestedMethodNames()) {
                JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider(methodName, handler.createLiteralImplicitElementProvider(methodName));
            }
            JSLiteralImplicitElementCustomProvider customProvider = handler.createLiteralImplicitElementCustomProvider();
            if (customProvider == null) continue;
            ourCustomProvidersRegistry.add(customProvider);
        }
    }
}

