/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionHelper;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionResultSink
extends ResultSink {
    private JSType mySmartCompletionExpectedType;
    @NotNull
    private JSCompletionPlaceFilter myPlaceFilter = JSCompletionPlaceFilter.ANY;
    private TIntArrayList myNestingLevels = new TIntArrayList();
    private int myCurrentNestingLevel = 0;
    private int myThisClassVariantsStart = -1;
    private int myThisClassVariantsEnd = -1;
    protected ProcessingContext mySmartCompletionInheritanceProcessingContext;
    private String myReferencedParameterName;
    private String myQualifiedNameToSkip;
    private final PrefixMatcher myPrefixMatcher;
    private int myGlobalDeclarationsStart = Integer.MAX_VALUE;

    public CompletionResultSink(PsiElement place) {
        super(place);
        Condition<JSClass> filter;
        ResolveProcessor.ProcessingOptions processingOptions;
        if (place != null && (processingOptions = (ResolveProcessor.ProcessingOptions)place.getContainingFile().getOriginalFile().getUserData(ResolveProcessor.PROCESSING_OPTIONS)) != null && (filter = processingOptions.getFilter()) != null) {
            this.acceptOnlyClasses(filter);
        }
        if (place instanceof JSReferenceExpression) {
            PsiElement originalParent;
            JSParameterItem param;
            PsiElement parent;
            JSType expectedType;
            if (this.myPlaceFilter == JSCompletionPlaceFilter.ANY) {
                this.myPlaceFilter = CompletionResultSink.buildSimpleCompletionFilter(place);
            }
            if (this.isActionScript() && JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction() && (expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)place)) != null) {
                this.mySmartCompletionExpectedType = expectedType;
                this.mySmartCompletionInheritanceProcessingContext = JSSmartCompletionVariantsHandler.initProcessingContext(place);
            }
            if ((parent = place.getParent()) instanceof JSArgumentList && (param = JSResolveUtil.findParameterForUsedArgument((JSExpression)((JSReferenceExpression)place), (JSArgumentList)parent)) != null) {
                this.myReferencedParameterName = param.getName();
            }
            if (JSResolveUtil.isSelfReference(parent, place) && (originalParent = PsiUtilBase.getOriginalElement((PsiElement)parent, JSQualifiedNamedElement.class)) instanceof JSQualifiedNamedElement) {
                this.myQualifiedNameToSkip = ((JSQualifiedNamedElement)originalParent).getQualifiedName();
            }
        }
        this.myPrefixMatcher = JSCompletionContributor.getInstance().getPrefixMatcher();
    }

    @Override
    public String getName() {
        return null;
    }

    public void setSmartCompletionInheritanceProcessingContext(ProcessingContext smartCompletionInheritanceProcessingContext) {
        this.mySmartCompletionInheritanceProcessingContext = smartCompletionInheritanceProcessingContext;
    }

    public ProcessingContext getSmartCompletionInheritanceProcessingContext() {
        return this.mySmartCompletionInheritanceProcessingContext;
    }

    @Override
    public boolean accepts(PsiElement element) {
        if (element instanceof JSPsiElementBase && !this.myPlaceFilter.isAcceptable((JSPsiElementBase)element)) {
            return false;
        }
        return super.accepts(element);
    }

    @Override
    public boolean addResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        if (this.mySmartCompletionExpectedType != null && !JSSmartCompletionVariantsHandler.isAcceptableVariant(element, this.mySmartCompletionExpectedType, this.mySmartCompletionInheritanceProcessingContext)) {
            return true;
        }
        this.myNestingLevels.add(this.myCurrentNestingLevel);
        return super.addResult(element, state, resolveProcessor);
    }

    public void acceptOnlyClasses(final @NotNull Condition<JSClass> classFilter) {
        if (classFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFilter", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink", "acceptOnlyClasses"));
        }
        this.myPlaceFilter = new JSCompletionPlaceFilter(){

            @Override
            boolean isAcceptable(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink$1", "isAcceptable"));
                }
                return element instanceof JSPackageWrapper || element instanceof JSClass && classFilter.value((Object)((JSClass)element));
            }
        };
    }

    private void flushMyThisClassVariantsEnd() {
        if (this.myThisClassVariantsEnd == -1) {
            List<PsiElement> results = this.getResults();
            if (results == null) {
                this.myThisClassVariantsEnd = 0;
            } else {
                int classVariantsEnd = results.size();
                if (results.get(classVariantsEnd - 1) instanceof JSClass) {
                    --classVariantsEnd;
                }
                this.myThisClassVariantsEnd = classVariantsEnd;
            }
        }
    }

    @NotNull
    private static JSCompletionPlaceFilter buildSimpleCompletionFilter(PsiElement place) {
        if (DialectDetector.isActionScript(place) && place instanceof JSReferenceExpression && !ResolveProcessor.completeConstructorName(place) && !(place.getParent() instanceof JSReferenceListMember)) {
            JSCompletionPlaceFilter jSCompletionPlaceFilter = JSCompletionPlaceFilter.ANY;
            if (jSCompletionPlaceFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink", "buildSimpleCompletionFilter"));
            }
            return jSCompletionPlaceFilter;
        }
        JSCompletionPlaceFilter jSCompletionPlaceFilter = JSCompletionPlaceFilter.forPlace(place);
        if (jSCompletionPlaceFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink", "buildSimpleCompletionFilter"));
        }
        return jSCompletionPlaceFilter;
    }

    public List<LookupElement> getResultsAsObjects() {
        List<PsiElement> processorResults = this.getResults();
        return processorResults == null ? Collections.emptyList() : this.resultsToLookupElements(processorResults);
    }

    public List<LookupElement> resultsToLookupElements(List<PsiElement> processorResults) {
        int numberOfVariants = processorResults.size();
        ArrayList<LookupElement> objects = new ArrayList<LookupElement>(numberOfVariants);
        Set<String> variantsFromSmartCompletion = JSCompletionContributor.getInstance().getAlreadyUsedClassesSet();
        THashSet processedCandidateNames = new THashSet(numberOfVariants);
        THashMap typeScriptCompleteMatches = ContainerUtil.newTroveMap();
        if (variantsFromSmartCompletion != null) {
            processedCandidateNames.addAll(variantsFromSmartCompletion);
        }
        for (int i = 0; i < numberOfVariants; ++i) {
            PsiElement resolve;
            PsiElement namedElement = processorResults.get(i);
            String name = ResolveProcessor.getName(namedElement);
            if (namedElement instanceof ES6ImportExportSpecifier && (resolve = ((PsiReference)namedElement).resolve()) != null) {
                namedElement = resolve;
            }
            if (name == null || !BasicJavascriptNamesValidator.isUnqualifiedType(name) || namedElement instanceof ImplicitJSVariableImpl && "use strict".equals(name)) continue;
            String qName = this.getQualifiedNameForResultElement(namedElement, name);
            if (this.myQualifiedNameToSkip != null && this.myQualifiedNameToSkip.equals(qName)) continue;
            int nestingLevel = this.getNestedLevelForResultElement(namedElement, i, name);
            boolean typeScript = DialectDetector.isTypeScript(namedElement);
            boolean sameClass = typeScript ? nestingLevel == 0 : this.checkInThisClassVariants(i) || namedElement instanceof JSProperty;
            boolean matchesReferencedParameterName = this.myReferencedParameterName != null && this.myReferencedParameterName.equals(name);
            JSLookupPriority priority = this.getPriorityForResultElement(namedElement, i, nestingLevel, typeScript, matchesReferencedParameterName);
            if (typeScript && VariantsProcessor.wasCompleteMatch(priority.getPriorityValue())) {
                Pair levelToContext;
                boolean hasSameNameObject;
                boolean isClassContext;
                PsiElement currentContext = namedElement.getContext();
                String nameForMerge = qName;
                boolean bl = isClassContext = currentContext instanceof JSClass || currentContext instanceof TypeScriptObjectType;
                if (isClassContext) {
                    nameForMerge = name;
                }
                boolean bl2 = hasSameNameObject = (levelToContext = (Pair)typeScriptCompleteMatches.get(nameForMerge)) != null;
                if (!processedCandidateNames.add(qName) && !hasSameNameObject) continue;
                if (levelToContext == null) {
                    typeScriptCompleteMatches.put(nameForMerge, Pair.create((Object)nestingLevel, (Object)currentContext));
                }
                if (hasSameNameObject) {
                    boolean overloadDeclaration;
                    PsiElement storedContext = (PsiElement)levelToContext.second;
                    Integer storedLevel = (Integer)levelToContext.first;
                    boolean bl3 = overloadDeclaration = storedContext == currentContext || isClassContext && storedLevel.equals(nestingLevel);
                    if (!overloadDeclaration) {
                        continue;
                    }
                }
            } else if (!processedCandidateNames.add(qName)) continue;
            objects.add(this.createLookupItem(namedElement, name, sameClass, priority));
        }
        return objects;
    }

    private boolean checkInThisClassVariants(int i) {
        return i >= this.myThisClassVariantsStart && (i < this.myThisClassVariantsEnd || this.myThisClassVariantsEnd == -1);
    }

    private JSLookupPriority getPriorityForResultElement(PsiElement namedElement, int currentIndex, int nestingLevel, boolean typeScript, boolean matchesReferencedParameterName) {
        JSLookupPriority priority = null;
        if (this.place != null) {
            priority = JSDialectSpecificHandlersFactory.forElement(this.place).getSpecificCompletionVariantPriority(namedElement);
        }
        if (priority == null) {
            if (typeScript) {
                boolean fromTheSameFile;
                boolean bl = fromTheSameFile = currentIndex < this.myGlobalDeclarationsStart;
                priority = this.place instanceof JSReferenceExpression && ((JSReferenceExpression)this.place).getQualifier() == null && !fromTheSameFile && nestingLevel == 0 ? JSLookupPriority.TOP_LEVEL_SYMBOLS_FROM_OTHER_FILES : (fromTheSameFile ? JSLookupPriority.getSameFileValue(matchesReferencedParameterName, nestingLevel) : JSLookupPriority.getSameTypeValue(false, BaseJSSymbolProcessor.MatchType.COMPLETE, nestingLevel));
            } else {
                priority = JSLookupPriority.getSameFileValue(matchesReferencedParameterName, nestingLevel);
            }
            if (typeScript && namedElement instanceof JSImplicitElement && nestingLevel == 0 && ((JSImplicitElement)namedElement).hasMinorImportance()) {
                priority = JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false);
            }
        }
        return priority;
    }

    @Nullable
    private String getQualifiedNameForResultElement(PsiElement namedElement, String name) {
        String qName = this.place != null && this.place.getParent() instanceof JSNewExpression && namedElement instanceof JSFunction && ((JSFunction)namedElement).isConstructor() ? ((JSClass)namedElement.getParent()).getQualifiedName() + "." + ((JSFunction)namedElement).getName() : (namedElement instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)namedElement).getQualifiedName() : name);
        return qName;
    }

    private int getNestedLevelForResultElement(PsiElement namedElement, int indexInResults, String name) {
        int nestingLevel = this.myNestingLevels.get(indexInResults);
        if ("arguments".equals(name) && namedElement instanceof ImplicitJSVariableImpl) {
            nestingLevel = -1;
        }
        if (namedElement instanceof JSProperty) {
            int max = 0;
            for (int j = 0; j < this.myNestingLevels.size(); ++j) {
                max = Math.max(max, this.myNestingLevels.getQuick(indexInResults));
            }
            nestingLevel = max;
        }
        return nestingLevel;
    }

    protected LookupElement createLookupItem(PsiElement namedElement, String name, boolean sameClass, @NotNull JSLookupPriority priority) {
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink", "createLookupItem"));
        }
        for (JSCompletionHelper helper : (JSCompletionHelper[])Extensions.getExtensions(JSCompletionHelper.EP_NAME)) {
            LookupElement lookupElement = helper.createLookupElement(namedElement, name, sameClass, priority);
            if (lookupElement == null) continue;
            return lookupElement;
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(namedElement, name, priority, sameClass, this.isActionScript());
    }

    @Override
    public void startingParent(PsiElement parent, ResolveProcessor resolveProcessor) {
        if (parent instanceof JSClass) {
            int scopeBound;
            List<PsiElement> results = super.getResults();
            int n = results == null ? 0 : (scopeBound = !results.isEmpty() && results.get(results.size() - 1) == parent ? results.size() - 1 : results.size());
            if (scopeBound > 0 && !DialectDetector.isTypeScript(parent)) {
                ++this.myCurrentNestingLevel;
            }
            if (this.myThisClassVariantsStart == -1) {
                int n2 = this.myThisClassVariantsStart = results != null ? results.size() : 0;
                if (!resolveProcessor.isToProcessMembers()) {
                    this.flushMyThisClassVariantsEnd();
                }
            } else {
                this.flushMyThisClassVariantsEnd();
            }
        } else if (parent instanceof JSFunction) {
            ++this.myCurrentNestingLevel;
        }
    }

    @Override
    public boolean skipTopLevelItems() {
        return this.place instanceof JSReferenceExpression && !JSResolveUtil.isExprInTypeContext((JSReferenceExpression)this.place) && this.myPrefixMatcher != null && this.myPrefixMatcher.getPrefix().length() == 0 && !(this.place.getContainingFile() instanceof PsiCodeFragment);
    }

    @Override
    public boolean needTopLevelClassName(String name) {
        return this.myPrefixMatcher == null || this.myPrefixMatcher.prefixMatches(name);
    }

    @Override
    public int getNestingLevel() {
        return this.myCurrentNestingLevel;
    }

    @Override
    public void setNestingLevel(int nestingLevel) {
        this.myCurrentNestingLevel = nestingLevel;
    }

    @Override
    public void startGlobalDeclarations() {
        List<PsiElement> results = this.getResults();
        this.myGlobalDeclarationsStart = results != null ? results.size() : 0;
    }
}

