/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluateContext
implements JSEvaluationResultContext {
    @Nullable
    public final PsiFile targetFile;
    private PsiElement source;
    private JSReferenceExpression myProcessedExpression;
    private final Deque<JSApplyContextElement> myJSElementsToApply;
    private boolean myTypeIsGuessed;
    @Nullable
    private PsiFile myJSModule;
    private final Set<String> visitedTypes = new THashSet();

    public JSEvaluateContext(@Nullable PsiFile targetFile) {
        this.targetFile = targetFile;
        this.myJSElementsToApply = new ArrayDeque<JSApplyContextElement>(5);
    }

    @NotNull
    public static JSEvaluateContext fromEvaluationResultContext(@NotNull JSEvaluationResultContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
        }
        if (context instanceof JSEvaluateContext) {
            JSEvaluateContext jSEvaluateContext = (JSEvaluateContext)context;
            if (jSEvaluateContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
            }
            return jSEvaluateContext;
        }
        JSEvaluateContext result = new JSEvaluateContext(null);
        for (JSApplyContextElement element : context.getJSElementsToApply()) {
            result.pushJSElementToApply(element);
        }
        result.setTypeIsGuessed(context.isTypeGuessed());
        result.myJSModule = context.getJSModule();
        JSEvaluateContext jSEvaluateContext = result;
        if (jSEvaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
        }
        return jSEvaluateContext;
    }

    @Nullable
    public JSReferenceExpression getProcessedExpression() {
        return this.myProcessedExpression;
    }

    public void setProcessedExpression(@Nullable JSReferenceExpression processedExpression) {
        this.myProcessedExpression = processedExpression;
    }

    public PsiElement getSource() {
        return this.source;
    }

    public void setSource(PsiElement source) {
        this.source = source;
    }

    @NotNull
    public JSApplyContextElement popJSElementToApply() {
        JSApplyContextElement jSApplyContextElement = this.myJSElementsToApply.pop();
        if (jSApplyContextElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "popJSElementToApply"));
        }
        return jSApplyContextElement;
    }

    @Override
    @Nullable
    public JSApplyContextElement peekJSElementToApply() {
        return this.myJSElementsToApply.peek();
    }

    public void pushJSElementToApply(@NotNull JSApplyContextElement elementToApply) {
        if (elementToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToApply", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "pushJSElementToApply"));
        }
        this.myJSElementsToApply.push(elementToApply);
    }

    public void processWithJSElementToApply(@NotNull JSApplyContextElement elementToApply, @NotNull Runnable runnable) {
        if (elementToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToApply", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithJSElementToApply"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithJSElementToApply"));
        }
        this.myJSElementsToApply.push(elementToApply);
        runnable.run();
        this.myJSElementsToApply.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processWithJSElementToApply(@NotNull JSApplyContextElement elementToApply, @NotNull JSEvaluationResultContext evaluateContext, @NotNull Consumer<JSEvaluationResultContext> consumer) {
        if (elementToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToApply", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithJSElementToApply"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithJSElementToApply"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithJSElementToApply"));
        }
        JSEvaluateContext context = JSEvaluateContext.fromEvaluationResultContext(evaluateContext);
        try {
            context.pushJSElementToApply(elementToApply);
            consumer.consume((Object)context);
        }
        finally {
            context.popJSElementToApply();
        }
    }

    public void processWithoutTopJSElementToApply(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithoutTopJSElementToApply"));
        }
        JSApplyContextElement pop = this.myJSElementsToApply.pop();
        try {
            runnable.run();
        }
        finally {
            this.myJSElementsToApply.push(pop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processWithoutTopJSElementToApply(@NotNull Processor<JSApplyContextElement> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithoutTopJSElementToApply"));
        }
        JSApplyContextElement pop = this.myJSElementsToApply.pop();
        try {
            boolean bl = processor.process((Object)pop);
            return bl;
        }
        finally {
            this.myJSElementsToApply.push(pop);
        }
    }

    @Override
    public boolean isJSElementsToApplyEmpty() {
        return this.myJSElementsToApply.isEmpty();
    }

    @Override
    public boolean isTypeGuessed() {
        return this.myTypeIsGuessed;
    }

    public void setTypeIsGuessed(boolean typeIsGuessed) {
        this.myTypeIsGuessed = typeIsGuessed;
    }

    @NotNull
    public Deque<JSApplyContextElement> getJSElementsToApply() {
        Deque<JSApplyContextElement> deque = this.myJSElementsToApply;
        if (deque == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "getJSElementsToApply"));
        }
        return deque;
    }

    @Override
    @Nullable
    public PsiFile getJSModule() {
        return this.myJSModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withJSModule(@Nullable PsiFile jsModule, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withJSModule"));
        }
        PsiFile jsModuleBefore = this.getJSModule();
        try {
            this.myJSModule = jsModule;
            runnable.run();
        }
        finally {
            this.myJSModule = jsModuleBefore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withCombinedContext(@NotNull JSEvaluationResultContext context, @NotNull Runnable runnable) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withCombinedContext"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withCombinedContext"));
        }
        int sizeBefore = this.myJSElementsToApply.size();
        PsiFile jsModuleBefore = this.myJSModule;
        boolean typeIsGuessedBefore = this.myTypeIsGuessed;
        try {
            for (JSApplyContextElement element : context.getJSElementsToApply()) {
                this.pushJSElementToApply(element);
            }
            this.myJSModule = context.getJSModule();
            this.myTypeIsGuessed |= context.isTypeGuessed();
            runnable.run();
        }
        finally {
            while (this.myJSElementsToApply.size() > sizeBefore) {
                this.popJSElementToApply();
            }
            this.myJSModule = jsModuleBefore;
            this.myTypeIsGuessed = typeIsGuessedBefore;
        }
    }

    @Override
    public boolean isEquivalentTo(JSEvaluationResultContext other) {
        return JSEvaluationResultContext.JSEvaluationResultContextImpl.areEvaluationContextsEquivalent(this, other);
    }

    public boolean ensureProcessed(@NotNull JSType type, @NotNull JSEvaluationResultContext evaluationContext) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "ensureProcessed"));
        }
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "ensureProcessed"));
        }
        String text = type.getTypeText(JSType.TypeTextFormat.SERIALIZED);
        PsiFile module = evaluationContext.getJSModule();
        if (module != null) {
            text = text + module.hashCode();
        }
        return !this.visitedTypes.add(text);
    }

    public static enum JSEvaluationPlace {
        PARAMETER_TYPE,
        TYPEOF_TYPE,
        CLASS_REFERENCE_LIST,
        TS_TYPEOF_TYPE,
        EXTERNAL_MODULE,
        EXPORTED_ELEMENT,
        DEFAULT,
        FORCE_EVALUATE_TYPE,
        REFERENCE_EXPRESSION;

    }
}

