/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSOverrideHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSSuperClassIndex;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.lang.javascript.validation.JSFunctionCollector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInheritanceUtil {
    private static final ThreadLocal<GlobalSearchScope> ourEnforcedScope = new ThreadLocal();

    public static <T extends JSPsiElementBase> boolean iterateOverriddenMembersUp(@NotNull JSPsiElementBase method, boolean recursive, @NotNull PairFunction<List<T>, String, Boolean> methodsProcessor, boolean onlyFunctions) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMembersUp"));
        }
        if (methodsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodsProcessor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMembersUp"));
        }
        return JSInheritanceUtil.iterateOverriddenMembersUp(method, recursive, methodsProcessor, (Set<String>)new THashSet(), onlyFunctions);
    }

    private static <T extends JSPsiElementBase> boolean iterateOverriddenMembersUp(@NotNull JSPsiElementBase member, final boolean recursive, final @NotNull PairFunction<List<T>, String, Boolean> membersProcessor, final @NotNull Set<String> visitedTypes, final boolean onlyFunctions) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMembersUp"));
        }
        if (membersProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersProcessor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMembersUp"));
        }
        if (visitedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedTypes", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMembersUp"));
        }
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(member);
        String methodName = member.getName();
        if (qName != null && methodName != null) {
            boolean nodeIsMember;
            PsiElement parent = JSResolveUtil.findParent((PsiElement)member);
            boolean bl = nodeIsMember = !qName.endsWith(methodName);
            if (!nodeIsMember) {
                return true;
            }
            return JSResolveUtil.iterateType(member, (PsiElement)(parent instanceof JSClass ? parent : member.getContainingFile()), qName, new JSOverrideHandler(){

                @Override
                public boolean process(@NotNull List<JSPsiElementBase> elements, PsiElement scope, String className) {
                    if (elements == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$1", "process"));
                    }
                    if (!visitedTypes.add(className)) {
                        return true;
                    }
                    ArrayList<JSPsiElementBase> results = new ArrayList<JSPsiElementBase>(elements.size());
                    for (PsiElement psiElement : elements) {
                        results.add((JSPsiElementBase)psiElement);
                    }
                    if (!((Boolean)membersProcessor.fun(results, (Object)className)).booleanValue()) {
                        return false;
                    }
                    if (recursive) {
                        for (PsiElement psiElement : elements) {
                            if (onlyFunctions && !(psiElement instanceof JSFunctionItem) || JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)psiElement, true, membersProcessor, visitedTypes, onlyFunctions)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }, onlyFunctions);
        }
        return true;
    }

    public static boolean iterateOverriddenMethodsUp(@NotNull JSFunction method, @NotNull Processor<JSFunction> methodsProcessor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMethodsUp"));
        }
        if (methodsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodsProcessor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMethodsUp"));
        }
        return JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)method, (Processor<JSPsiElementBase>)((Processor)el -> {
            if (methodsProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodsProcessor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$iterateOverriddenMethodsUp$0"));
            }
            return methodsProcessor.process((Object)((JSFunction)el));
        }));
    }

    public static boolean iterateOverriddenMemberUp(@NotNull JSPsiElementBase el, @NotNull Processor<JSPsiElementBase> methodsProcessor) {
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMemberUp"));
        }
        if (methodsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodsProcessor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateOverriddenMemberUp"));
        }
        boolean onlyFunctions = el instanceof JSFunction;
        return JSInheritanceUtil.iterateOverriddenMembersUp(el, true, (jsNamedElements, s) -> {
            if (methodsProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodsProcessor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$iterateOverriddenMemberUp$1"));
            }
            if (jsNamedElements.isEmpty()) {
                return false;
            }
            JSPsiElementBase toProcess = (JSPsiElementBase)ContainerUtil.getFirstItem((List)jsNamedElements);
            if (onlyFunctions && !(toProcess instanceof JSFunction)) {
                return false;
            }
            if (!methodsProcessor.process((Object)toProcess)) {
                return false;
            }
            return true;
        }, onlyFunctions);
    }

    public static Collection<JSFunction> findImplementedMethods(@NotNull JSFunction implementingFunction) {
        if (implementingFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementingFunction", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findImplementedMethods"));
        }
        return JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)implementingFunction).stream().filter(el -> el instanceof JSFunction).map(el -> (JSFunction)el).collect(Collectors.toList());
    }

    @NotNull
    public static Collection<JSPsiElementBase> findImplementedMembers(@NotNull JSQualifiedNamedElement implementingMember) {
        if (implementingMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementingMember", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findImplementedMembers"));
        }
        if (!(implementingMember instanceof JSAttributeListOwner) || !(implementingMember instanceof TypeScriptTypeMember) && !JSInheritanceUtil.canHaveSuperMember(((JSAttributeListOwner)implementingMember).getAttributeList())) {
            List<JSPsiElementBase> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findImplementedMembers"));
            }
            return list;
        }
        final JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)implementingMember);
        if (containingClass == null) {
            List<JSPsiElementBase> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findImplementedMembers"));
            }
            return list;
        }
        final HashSet collectedObjects = ContainerUtil.newHashSet();
        final String name = implementingMember.getName();
        if (name == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findImplementedMembers"));
            }
            return list;
        }
        JSCollectMembersToImplementProcessor processor = new JSCollectMembersToImplementProcessor((PsiElement)implementingMember, true){

            @Override
            protected void processMembers(@NotNull List<PsiElement> processorResults) {
                if (processorResults == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processorResults", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$2", "processMembers"));
                }
                collectedObjects.addAll(processorResults);
            }

            @Override
            @NotNull
            protected ResultSink createResultSink() {
                ResolveResultSink resolveResultSink = new ResolveResultSink(this.place, name);
                if (resolveResultSink == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$2", "createResultSink"));
                }
                return resolveResultSink;
            }

            @Override
            protected boolean shouldProcessClass(@NotNull JSClass jsClass) {
                if (jsClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$2", "shouldProcessClass"));
                }
                return !DialectDetector.isTypeScript((PsiElement)jsClass) || containingClass.isEquivalentTo((PsiElement)jsClass) || jsClass.findFunctionByName(name) == null && jsClass.findFieldByName(name) == null;
            }
        };
        JSResolveUtil.processInterfaceMembers(containingClass, processor);
        Collection collection = collectedObjects.stream().map(el -> (JSPsiElementBase)el).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findImplementedMembers"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JSPsiElementBase> findNearestOverriddenMembers(@NotNull JSPsiElementBase method, boolean onlyFunctions) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findNearestOverriddenMembers"));
        }
        THashSet result = new THashSet();
        JSInheritanceUtil.iterateOverriddenMembersUp(method, false, (arg_0, arg_1) -> JSInheritanceUtil.lambda$findNearestOverriddenMembers$5((Collection)result, arg_0, arg_1), onlyFunctions);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findNearestOverriddenMembers"));
        }
        return tHashSet;
    }

    public static boolean processNearestOverriddenMethods(@NotNull JSFunctionItem method, @NotNull Processor<JSFunction> processor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processNearestOverriddenMethods"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processNearestOverriddenMethods"));
        }
        Ref result = Ref.create((Object)Boolean.TRUE);
        JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)method, false, (functions, s) -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$processNearestOverriddenMethods$6"));
            }
            for (JSPsiElementBase function : functions) {
                JSFunction overridden = JSPsiImplUtils.getPossibleFunction((PsiElement)function);
                if (processor.process((Object)overridden)) continue;
                result.set((Object)Boolean.FALSE);
                return false;
            }
            return true;
        }, true);
        return (Boolean)result.get();
    }

    @Nullable
    public static JSClass findSomeDeclaringClass(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findSomeDeclaringClass"));
        }
        return (JSClass)ContainerUtil.getFirstItem(JSInheritanceUtil.findDeclaringClasses(method), null);
    }

    public static Map<JSClass, JSFunction> findDeclaringClassesMap(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findDeclaringClassesMap"));
        }
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        Collection<JSFunction> topMethods = JSInheritanceUtil.findTopMethods(method);
        for (JSFunction topMethod : topMethods) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)topMethod);
            if (containingClass == null) continue;
            result.put(containingClass, topMethod);
        }
        return result;
    }

    public static Collection<JSClass> findDeclaringClasses(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findDeclaringClasses"));
        }
        return JSInheritanceUtil.findDeclaringClassesMap(method).keySet();
    }

    @NotNull
    public static Collection<JSPsiElementBase> findTopMembers(@NotNull JSQualifiedNamedElement member) {
        Collection<JSPsiElementBase> implementedMembers;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findTopMembers"));
        }
        JSQualifiedNamedElement currentMember = member;
        JSPsiElementBase topParent = JSInheritanceUtil.findTopOverriddenMember((JSPsiElementBase)member);
        if (topParent != null) {
            currentMember = topParent;
        }
        if (!(implementedMembers = JSInheritanceUtil.findImplementedMembers(currentMember)).isEmpty()) {
            ArrayList result = ContainerUtil.newArrayListWithCapacity((int)implementedMembers.size());
            for (JSPsiElementBase implementedMember : implementedMembers) {
                JSPsiElementBase toOverriddenForInterface = JSInheritanceUtil.findTopOverriddenMember(implementedMember);
                result.add(toOverriddenForInterface != null ? toOverriddenForInterface : implementedMember);
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findTopMembers"));
            }
            return arrayList;
        }
        List<JSQualifiedNamedElement> list = Collections.singletonList(currentMember);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findTopMembers"));
        }
        return list;
    }

    public static Collection<JSFunction> findTopMethods(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findTopMethods"));
        }
        return JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)method).stream().filter(el -> el instanceof JSFunction).map(el -> (JSFunction)el).collect(Collectors.toList());
    }

    @Nullable
    public static JSPsiElementBase findTopOverriddenMember(@NotNull JSPsiElementBase member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findTopOverriddenMember"));
        }
        Ref result = new Ref();
        JSInheritanceUtil.iterateOverriddenMemberUp(member, (Processor<JSPsiElementBase>)((Processor)currentMember -> {
            result.set(currentMember);
            return true;
        }));
        return (JSPsiElementBase)result.get();
    }

    @Nullable
    public static JSFunction findTopOverriddenMethod(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findTopOverriddenMethod"));
        }
        Ref result = new Ref();
        JSInheritanceUtil.iterateOverriddenMethodsUp(method, (Processor<JSFunction>)((Processor)function -> {
            result.set(function);
            return true;
        }));
        return (JSFunction)result.get();
    }

    public static Collection<JSClass> findAllParentsForClass(@NotNull JSClass clazz, boolean includeNotProject) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findAllParentsForClass"));
        }
        HashSet<JSClass> supers = new HashSet<JSClass>();
        JSInheritanceUtil.findAllParentsForClass(clazz, supers, includeNotProject);
        return supers;
    }

    public static void findAllParentsForClass(@NotNull JSClass clazz, @NotNull Collection<JSClass> result, boolean includeNotProject) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findAllParentsForClass"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findAllParentsForClass"));
        }
        for (JSClass superClass : clazz.getSupers()) {
            if (!includeNotProject && !clazz.getManager().isInProject((PsiElement)superClass) || superClass.isEquivalentTo((PsiElement)clazz) || JSPsiImplUtils.containsEquivalent(result, (PsiElement)superClass)) continue;
            if (!JSResolveUtil.isObjectClass(superClass)) {
                result.add(superClass);
                JSInheritanceUtil.findAllParentsForClass(superClass, result, includeNotProject);
                continue;
            }
            if (clazz.isInterface()) continue;
            result.add(superClass);
        }
    }

    public static boolean canBeSuperMethod(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "canBeSuperMethod"));
        }
        return JSInheritanceUtil.canBeSuperMember((JSAttributeListOwner)method);
    }

    public static boolean canBeSuperMember(@NotNull JSAttributeListOwner member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "canBeSuperMember"));
        }
        if (member instanceof TypeScriptTypeMember) {
            return true;
        }
        return (!(member instanceof JSFunction) || !((JSFunction)member).isConstructor()) && JSInheritanceUtil.canBeSuperMember(member.getAttributeList());
    }

    private static boolean canBeSuperMember(@Nullable JSAttributeList methodAttributeList) {
        return methodAttributeList == null || !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && !methodAttributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && methodAttributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE;
    }

    public static boolean canHaveSuperMember(@NotNull JSAttributeListOwner member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "canHaveSuperMember"));
        }
        if (member instanceof JSFunction && ((JSFunction)member).isConstructor()) {
            return false;
        }
        return member instanceof TypeScriptTypeMember || JSInheritanceUtil.canHaveSuperMember(member.getAttributeList());
    }

    public static boolean canHaveSuperMethod(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "canHaveSuperMethod"));
        }
        return JSInheritanceUtil.canHaveSuperMember((JSAttributeListOwner)method);
    }

    @Contract(value="null -> false")
    public static boolean canHaveSuperMember(@Nullable JSAttributeList methodAttributeList) {
        if (methodAttributeList != null) {
            return !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
        }
        return false;
    }

    @Nullable
    public static JSClass findNearestBaseClass(@NotNull JSClass aClass, boolean includeNonProject) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findNearestBaseClass"));
        }
        JSClass[] supers = aClass.getSupers();
        if (supers.length > 0) {
            JSClass superClass = supers[0];
            if (JSResolveUtil.isObjectClass(superClass) && supers.length > 1) {
                superClass = supers[1];
            }
            if (includeNonProject || superClass.getManager().isInProject((PsiElement)superClass)) {
                return superClass;
            }
        }
        return null;
    }

    public static boolean isMemberOfSubclass(@NotNull JSClass superClass, @NotNull JSElement classMember, boolean allowSuperClass) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isMemberOfSubclass"));
        }
        if (classMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classMember", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isMemberOfSubclass"));
        }
        JSClass memberClass = JSUtils.getMemberContainingClass((PsiElement)classMember);
        if (memberClass == null) {
            return false;
        }
        if (superClass.isEquivalentTo((PsiElement)memberClass)) {
            return allowSuperClass;
        }
        return JSInheritanceUtil.isParentClass(memberClass, superClass);
    }

    public static Collection<JSClass> findDirectSubClasses(@NotNull JSClass jsClass, boolean skipSubInterfaces) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findDirectSubClasses"));
        }
        ArrayList<JSClass> result = new ArrayList<JSClass>();
        if (!jsClass.isInterface() || !skipSubInterfaces) {
            JSClassSearch.searchClassInheritors(jsClass, false).forEach(jsClass1 -> {
                if (!JSPsiImplUtils.containsEquivalent(result, (PsiElement)jsClass1)) {
                    result.add((JSClass)jsClass1);
                }
                return true;
            });
        }
        if (jsClass.isInterface()) {
            JSClassSearch.searchInterfaceImplementations(jsClass, false).forEach(candidate -> {
                if (jsClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$findDirectSubClasses$12"));
                }
                if ((skipSubInterfaces || JSPsiImplUtils.containsEquivalent((PsiElement[])candidate.getSupers(), (PsiElement)jsClass)) && !JSPsiImplUtils.containsEquivalent(result, (PsiElement)candidate)) {
                    result.add((JSClass)candidate);
                }
                return true;
            });
        }
        return result;
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, strict, JSResolveUtil.getResolveScope((PsiElement)clazz));
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict, @Nullable PsiElement context) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, strict, JSResolveUtil.getResolveScope((PsiElement)(context != null ? context : clazz)));
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict, @NotNull GlobalSearchScope resolveScope) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (!strict && clazz.isEquivalentTo((PsiElement)parentClass)) {
            return true;
        }
        return (Boolean)JSInheritanceUtil.withEnforcedScope(() -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$isParentClass$13"));
            }
            if (parentClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$isParentClass$13"));
            }
            return JSInheritanceUtil.isParentClass(clazz, parentClass, (Set<JSClass>)new THashSet());
        }, resolveScope);
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, true);
    }

    @Nullable
    public static JSFunction findMethodInClass(@Nullable JSFunction pattern, @NotNull JSClass aClass, boolean lookInSupers) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMethodInClass"));
        }
        if (pattern == null) {
            return null;
        }
        JSFunction method = aClass.findFunctionByNameAndKind(pattern.getName(), pattern.getKind());
        if (method != null) {
            return method;
        }
        if (lookInSupers && JSInheritanceUtil.canHaveSuperMethod(pattern)) {
            final Ref result = new Ref();
            JSResolveUtil.iterateType((JSPsiElementBase)pattern, (PsiElement)aClass, aClass.getQualifiedName(), new JSOverrideHandler(){

                @Override
                public boolean process(@NotNull List<JSPsiElementBase> elements, PsiElement scope, String className) {
                    if (elements == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$3", "process"));
                    }
                    result.set((Object)((JSFunction)elements.iterator().next()));
                    return false;
                }
            }, true);
            return (JSFunction)result.get();
        }
        return null;
    }

    public static boolean participatesInHierarchy(JSFunction fun) {
        return !JSInheritanceUtil.processHierarchy(fun, (Processor<JSFunction>)((Processor)jsFunction -> false));
    }

    public static boolean participatesInMemberHierarchy(JSQualifiedNamedElement el) {
        return !JSInheritanceUtil.processMemberHierarchy(el, (Processor<JSPsiElementBase>)((Processor)possibleElement -> false));
    }

    public static boolean processHierarchy(@NotNull JSFunction fun, @NotNull Processor<JSFunction> processor) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processHierarchy"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processHierarchy"));
        }
        if (JSUtils.getMemberContainingClass((PsiElement)fun) == null) {
            return true;
        }
        if (!ContainerUtil.process(JSInheritanceUtil.findImplementedMethods(fun), processor)) {
            return false;
        }
        if (!JSInheritanceUtil.iterateOverriddenMethodsUp(fun, processor)) {
            return false;
        }
        return JSInheritanceUtil.iterateMethodsDown(fun, processor);
    }

    public static boolean processMemberHierarchy(@NotNull JSQualifiedNamedElement member, @NotNull Processor<JSPsiElementBase> processor) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processMemberHierarchy"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processMemberHierarchy"));
        }
        if (JSUtils.getMemberContainingClass((PsiElement)member) == null) {
            return true;
        }
        if (!ContainerUtil.process(JSInheritanceUtil.findImplementedMembers(member), processor)) {
            return false;
        }
        if (!JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)member, processor)) {
            return false;
        }
        Processor functionProcessor = el -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$processMemberHierarchy$16"));
            }
            return processor.process(el);
        };
        return !(member instanceof JSFunction) || JSInheritanceUtil.iterateMethodsDown((JSFunction)member, (Processor<JSFunction>)functionProcessor);
    }

    public static boolean iterateMethodsDown(@NotNull JSFunction fun, @NotNull Processor<JSFunction> processor) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateMethodsDown"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateMethodsDown"));
        }
        return JSInheritanceUtil.iterateMethodsDown(fun, processor, false);
    }

    public static boolean iterateMethodsDown(@NotNull JSFunction fun, @NotNull Processor<JSFunction> processor, boolean checkOverrideModifier) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateMethodsDown"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateMethodsDown"));
        }
        Processor p = checkOverrideModifier ? jsFunction -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$iterateMethodsDown$17"));
            }
            JSAttributeList attributeList = jsFunction.getAttributeList();
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                return true;
            }
            return processor.process(jsFunction);
        } : processor;
        if (!JSFunctionsSearch.searchOverridingFunctions(fun, true).forEach(p)) {
            return false;
        }
        return JSFunctionsSearch.searchImplementingFunctions(fun, true).forEach(processor);
    }

    public static boolean hasSuperMethods(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "hasSuperMethods"));
        }
        return !JSInheritanceUtil.iterateOverriddenMethodsUp(method, (Processor<JSFunction>)((Processor)jsFunction -> false));
    }

    public static Collection<JSFunction> collectFunctionsToOverride(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "collectFunctionsToOverride"));
        }
        if (clazz.isInterface()) {
            return Collections.emptyList();
        }
        JSFunctionCollector _functionsToOverride = null;
        Predicate<JSFunction> functionFilter = function -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$collectFunctionsToOverride$19"));
            }
            JSAttributeList attributeList = function.getAttributeList();
            if (attributeList != null && (attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE)) {
                return false;
            }
            return JSResolveUtil.isAccessibleFromCurrentPackage((PsiElement)function, (PsiElement)clazz);
        };
        for (JSClass superClazz : clazz.getSuperClasses()) {
            _functionsToOverride = JSFunctionCollector.collectAllVisibleClassFunctions(superClazz, _functionsToOverride, functionFilter);
        }
        final JSFunctionCollector functionsToOverride = _functionsToOverride;
        ResolveProcessor collectOwnFunctions = new ResolveProcessor(null, (PsiElement)clazz){
            {
                super(name, _place);
                this.setToProcessMembers(true);
                this.setToProcessHierarchy(false);
                this.setLocalResolve(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$4", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$4", "execute"));
                }
                if (element instanceof JSFunction) {
                    JSFunction function = (JSFunction)element;
                    if (function.isConstructor() || functionsToOverride == null) {
                        return true;
                    }
                    functionsToOverride.removeFunctionByNameAndKind(function.getName(), function.getKind());
                }
                return true;
            }
        };
        clazz.processDeclarations((PsiScopeProcessor)collectOwnFunctions, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
        return functionsToOverride != null ? functionsToOverride.getFunctions() : Collections.emptyList();
    }

    public static Collection<JSCallExpression> findSuperConstructorCalls(@NotNull JSFunction constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findSuperConstructorCalls"));
        }
        JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)constructor);
        return clazz != null ? JSInheritanceUtil.findSuperConstructorCalls(clazz) : Collections.emptyList();
    }

    public static Collection<JSCallExpression> findSuperConstructorCalls(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findSuperConstructorCalls"));
        }
        ArrayList<JSCallExpression> result = new ArrayList<JSCallExpression>();
        Processor p = jsCallExpression -> {
            result.add((JSCallExpression)jsCallExpression);
            return true;
        };
        Collection<JSClass> subClasses = JSInheritanceUtil.findDirectSubClasses(clazz, true);
        for (JSClass subClass : subClasses) {
            JSInheritanceUtil.processSuperCallsIn(subClass, (Processor<JSCallExpression>)p);
        }
        return result;
    }

    public static boolean processSuperCallsIn(@NotNull JSClass subClass, @NotNull Processor<JSCallExpression> processor) {
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processSuperCallsIn"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processSuperCallsIn"));
        }
        JSFunction subClassConstructor = subClass.getConstructor();
        if (subClassConstructor != null) {
            SuperCallSearcher superCallSearcher = new SuperCallSearcher();
            subClassConstructor.accept((PsiElementVisitor)superCallSearcher);
            if (superCallSearcher.myResult != null && !processor.process((Object)superCallSearcher.myResult)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static SinkResolveProcessor<?> createFindSuperMemberByNameProcessor(@NotNull String name, final @Nullable String namespace, final @Nullable PsiElement context, final boolean onlyFunctions) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "createFindSuperMemberByNameProcessor"));
        }
        SinkResolveProcessor<ResolveResultSink> resolveProcessor = new SinkResolveProcessor<ResolveResultSink>(name, context, new ResolveResultSink(context, name)){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$5", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$5", "execute"));
                }
                if (!onlyFunctions && element instanceof JSField || element instanceof JSFunction) {
                    if (!JSInheritanceUtil.isRealOverride((JSAttributeListOwner)element, namespace, context)) {
                        return true;
                    }
                    return super.execute(element, state);
                }
                return true;
            }
        };
        resolveProcessor.setToProcessHierarchy(true);
        resolveProcessor.setLocalResolve(true);
        resolveProcessor.setSkipImplicitDeclarations(true);
        SinkResolveProcessor<ResolveResultSink> sinkResolveProcessor = resolveProcessor;
        if (sinkResolveProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "createFindSuperMemberByNameProcessor"));
        }
        return sinkResolveProcessor;
    }

    public static boolean isRealOverride(@NotNull JSAttributeListOwner member, @Nullable String namespace, @Nullable PsiElement context) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isRealOverride"));
        }
        JSAttributeList attributeList = member.getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            if (type == JSAttributeList.AccessType.PRIVATE) {
                return false;
            }
            if (type == JSAttributeList.AccessType.PACKAGE_LOCAL && attributeList.getNamespace() == null && !(member.getParent() instanceof JSFile)) {
                return JSResolveUtil.isAccessibleFromCurrentPackage((PsiElement)member, context);
            }
        }
        String elementNs = JSResolveUtil.getNamespaceValue(attributeList);
        return (namespace != null || elementNs == null) && (namespace == null || namespace.equals(elementNs));
    }

    public static boolean processOverrides(JSClass clazz, JSOverrideHandler handler, @NotNull String name, String namespace, PsiElement context, boolean onlyFunctions) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "processOverrides"));
        }
        SinkResolveProcessor<?> resolveProcessor = JSInheritanceUtil.createFindSuperMemberByNameProcessor(name, namespace, context, onlyFunctions);
        for (JSClass superClazz : clazz.getSuperClasses()) {
            List<PsiElement> unfilteredResults;
            List results;
            JSClass resultMemberContainingClass;
            PsiElement element;
            if (superClazz == clazz) break;
            boolean b = superClazz.processDeclarations(resolveProcessor, ResolveState.initial(), (PsiElement)superClazz, context);
            if (b || (element = resolveProcessor.getResult()) == null || (resultMemberContainingClass = JSUtils.getMemberContainingClass(element)) == null || handler.process(results = ContainerUtil.mapNotNull((Collection)ContainerUtil.notNullize(unfilteredResults = resolveProcessor.getResults()), el -> (JSPsiElementBase)ObjectUtils.tryCast((Object)el, JSPsiElementBase.class)), (PsiElement)superClazz, resultMemberContainingClass.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    private static boolean searchClassInHierarchy(@NotNull JSClass classToSearch, @NotNull Ref<JSPsiElementBase> overriddenMember) {
        if (classToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToSearch", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "searchClassInHierarchy"));
        }
        if (overriddenMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenMember", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "searchClassInHierarchy"));
        }
        Ref success = Ref.create();
        JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)overriddenMember.get(), (Processor<JSPsiElementBase>)((Processor)el -> {
            if (classToSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToSearch", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$searchClassInHierarchy$22"));
            }
            if (overriddenMember == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenMember", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$searchClassInHierarchy$22"));
            }
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)el);
            if (classToSearch.isEquivalentTo((PsiElement)containingClass)) {
                success.set((Object)true);
                return false;
            }
            overriddenMember.set(el);
            JSAttributeList attributeList = el instanceof JSAttributeListOwner ? ((JSAttributeListOwner)el).getAttributeList() : null;
            return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE);
        }));
        return !success.isNull();
    }

    public static boolean checkMemberHierarchyIncludeClass(@NotNull JSPsiElementBase resolvedElement, @NotNull JSClass elementParent) {
        if (resolvedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedElement", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "checkMemberHierarchyIncludeClass"));
        }
        if (elementParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementParent", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "checkMemberHierarchyIncludeClass"));
        }
        Ref topOverriddenMember = new Ref((Object)resolvedElement);
        if (JSInheritanceUtil.searchClassInHierarchy(elementParent, (Ref<JSPsiElementBase>)topOverriddenMember)) {
            return true;
        }
        Collection<JSPsiElementBase> implementedMembers = JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)topOverriddenMember.get());
        for (JSPsiElementBase member : implementedMembers) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)member);
            if (elementParent.isEquivalentTo((PsiElement)containingClass)) {
                return true;
            }
            if (!JSInheritanceUtil.searchClassInHierarchy(elementParent, (Ref<JSPsiElementBase>)Ref.create((Object)member))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static JSQualifiedNamedElement findMember(@NotNull String name, @NotNull JSClass jsClass, @NotNull SearchedMemberType searchedMemberType, @Nullable JSFunction.FunctionKind limitByFunctionKind, boolean lookInSupers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMember"));
        }
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMember"));
        }
        if (searchedMemberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchedMemberType", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMember"));
        }
        return JSInheritanceUtil.findMember(name, jsClass, searchedMemberType, limitByFunctionKind, lookInSupers, (Set<JSClass>)(lookInSupers ? new THashSet() : Collections.emptySet()));
    }

    @Nullable
    private static JSQualifiedNamedElement findMember(@NotNull String name, @NotNull JSClass jsClass, @NotNull SearchedMemberType memberType, @Nullable JSFunction.FunctionKind limitByFunctionKind, boolean lookInSuperClasses, @NotNull Set<JSClass> visited) {
        JSField field;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMember"));
        }
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMember"));
        }
        if (memberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberType", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMember"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMember"));
        }
        if (visited.contains(jsClass)) {
            return null;
        }
        if ((memberType == SearchedMemberType.Fields || memberType == SearchedMemberType.FieldsAndMethods) && (field = jsClass.findFieldByName(name)) != null) {
            return field;
        }
        if (memberType == SearchedMemberType.Methods || memberType == SearchedMemberType.FieldsAndMethods) {
            JSFunction function;
            JSFunction jSFunction = function = limitByFunctionKind == null ? jsClass.findFunctionByName(name) : jsClass.findFunctionByNameAndKind(name, limitByFunctionKind);
            if (function != null) {
                return function;
            }
        }
        if (lookInSuperClasses) {
            visited.add(jsClass);
            for (JSClass superClass : jsClass.getSuperClasses()) {
                JSQualifiedNamedElement inSuper = JSInheritanceUtil.findMember(name, superClass, memberType, limitByFunctionKind, true, visited);
                if (inSuper == null) continue;
                return inSuper;
            }
        }
        return null;
    }

    private static boolean isParentClass(@NotNull JSClass aClass, @Nullable JSClass parent, @NotNull Set<JSClass> visited) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (visited.contains(aClass)) {
            return false;
        }
        for (JSClass superClazz : aClass.getSupers()) {
            if (superClazz.isEquivalentTo((PsiElement)parent)) {
                return true;
            }
            visited.add(aClass);
            if (!JSInheritanceUtil.isParentClass(superClazz, parent, visited)) continue;
            return true;
        }
        return false;
    }

    public static <T> T withEnforcedScope(Computable<T> r, GlobalSearchScope scope) {
        assert (JSInheritanceUtil.getEnforcedScope() == null);
        ourEnforcedScope.set(scope);
        try {
            Object object = r.compute();
            return (T)object;
        }
        finally {
            ourEnforcedScope.set(null);
        }
    }

    public static GlobalSearchScope getEnforcedScope() {
        return ourEnforcedScope.get();
    }

    @Nullable
    public static JSParameter findMatchedSuperParameter(@NotNull JSParameter parameter, @NotNull JSFunction function) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMatchedSuperParameter"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "findMatchedSuperParameter"));
        }
        int _parameterIndex = Integer.MAX_VALUE;
        JSParameter[] parameters = function.getParameterVariables();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != parameter) continue;
            _parameterIndex = i;
            break;
        }
        int parameterIndex = _parameterIndex;
        Ref matchedSuperParameter = Ref.create(null);
        JSInheritanceUtil.processNearestOverriddenMethods((JSFunctionItem)function, (Processor<JSFunction>)((Processor)overridden -> {
            if (overridden == null) {
                return true;
            }
            JSParameter[] overriddenParameters = overridden.getParameterVariables();
            if (parameterIndex < overriddenParameters.length) {
                matchedSuperParameter.set((Object)overriddenParameters[parameterIndex]);
                return false;
            }
            return true;
        }));
        return (JSParameter)matchedSuperParameter.get();
    }

    public static boolean iterateAllMethodsInHierarchy(@NotNull JSFunction function, @NotNull Processor<JSFunction> processor) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateAllMethodsInHierarchy"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "iterateAllMethodsInHierarchy"));
        }
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        Collection<JSFunction> topMethods = JSInheritanceUtil.findTopMethods(function);
        for (JSFunction topMethod : topMethods) {
            if (uniqueProcessor.process((Object)topMethod) && JSInheritanceUtil.iterateMethodsDown(topMethod, (Processor<JSFunction>)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public static boolean isParentClass(@NotNull String className, @NotNull String parentClassName, @NotNull PsiElement context) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (parentClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClassName", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "isParentClass"));
        }
        THashSet visited = new THashSet();
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(className);
        while (!queue.isEmpty()) {
            String currentName = (String)queue.poll();
            boolean result = StubIndex.getInstance().processElements(JSSuperClassIndex.KEY, (Object)currentName, context.getProject(), JSResolveUtil.getResolveScope(context), JSClass.class, arg_0 -> JSInheritanceUtil.lambda$isParentClass$24((Set)visited, parentClassName, queue, arg_0));
            if (result) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$isParentClass$24(Set visited, @NotNull String parentClassName, Queue queue, JSClass element) {
        if (parentClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClassName", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil", "lambda$isParentClass$24"));
        }
        String qName = element.getQualifiedName();
        if (qName != null && visited.add(qName)) {
            if (parentClassName.equals(qName)) {
                return false;
            }
            queue.offer(qName);
        }
        return true;
    }

    private static /* synthetic */ Boolean lambda$findNearestOverriddenMembers$5(Collection result, List functions, String s) {
        result.addAll(functions);
        return true;
    }

    public static abstract class CacheByEnforcedResolveScope<T> {
        private static final GlobalSearchScope NO_ENFORCED_SCOPE_MARKER = new NoEnforcedScopeMarker();
        private final Map<GlobalSearchScope, T> myCache = ContainerUtil.newConcurrentMap();

        public T compute() {
            GlobalSearchScope enforcedScope = JSInheritanceUtil.getEnforcedScope();
            GlobalSearchScope key = enforcedScope != null ? enforcedScope : NO_ENFORCED_SCOPE_MARKER;
            T value = this.myCache.get(key);
            if (value == null) {
                value = this.computeForScope(enforcedScope);
                this.myCache.put(key, value);
            }
            return value;
        }

        protected abstract T computeForScope(@Nullable GlobalSearchScope var1);

        private static class NoEnforcedScopeMarker
        extends GlobalSearchScope {
            private NoEnforcedScopeMarker() {
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker", "contains"));
                }
                return false;
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker", "isSearchInModuleContent"));
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return false;
            }
        }
    }

    private static class SuperCallSearcher
    extends JSRecursiveElementVisitor {
        private JSCallExpression myResult;

        private SuperCallSearcher() {
        }

        public void visitJSCallExpression(JSCallExpression node) {
            if (node.getMethodExpression() instanceof JSSuperExpression) {
                this.myResult = node;
            }
        }
    }

    public static enum SearchedMemberType {
        Fields,
        Methods,
        FieldsAndMethods;

    }
}

