/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSResolveResult
implements ResolveResult {
    @NonNls
    public static final String QUALIFIED_NAME_IS_NOT_IMPORTED = "javascript.qualified.name.is.not.imported.message";
    @NonNls
    public static final String ELEMENT_IS_NOT_ACCESSIBLE = "javascript.element.is.not.accessible.message";
    @NonNls
    public static final String PROTECTED_MEMBER_IS_NOT_ACCESSIBLE = "javascript.protected.member.is.not.accessible.message";
    @NonNls
    public static final String MEMBER_FROM_UNOPENED_NAMESPACE = "javascript.member.from.unopened.namespace.message";
    @NonNls
    public static final String PROPERTY_IS_READ_ONLY = "javascript.property.is.read.only.message";
    @NonNls
    public static final String PROPERTY_IS_WRITE_ONLY = "javascript.property.is.write.only.message";
    @NonNls
    public static final String PRIVATE_MEMBER_IS_NOT_ACCESSIBLE = "javascript.private.member.is.not.accessible.message";
    @NonNls
    public static final String JS_PRIVATE_MEMBER_IS_NOT_ACCESSIBLE = "javascript.jsdoc.private.member.is.not.accessible.message";
    @NonNls
    public static final String JS_PROTECTED_MEMBER_IS_NOT_ACCESSIBLE = "javascript.jsdoc.protected.member.is.not.accessible.message";
    @NonNls
    public static final String JS_NEED_TO_BE_EXPORTED = "javascript.element.need.to.be.exported";
    @NonNls
    public static final String JS_NEED_TO_BE_IMPORTED = "javascript.element.need.to.be.imported";
    @NonNls
    public static final String TS_NEED_TO_BE_INCLUDED_TO_CONFIG = "javascript.element.need.to.be.included.to.config";
    public static final String[] INSUFFICIENT_VISIBILITY_PROBLEM_KEYS = new String[]{"javascript.element.is.not.accessible.message", "javascript.private.member.is.not.accessible.message", "javascript.protected.member.is.not.accessible.message", "javascript.jsdoc.private.member.is.not.accessible.message", "javascript.jsdoc.protected.member.is.not.accessible.message"};
    @NonNls
    public static final String STATIC_MEMBER_INACCESSIBLE = "javascript.static.member.is.not.accessible.message";
    @NonNls
    public static final String INSTANCE_MEMBER_INACCESSIBLE = "javascript.instance.member.is.not.accessible.message";
    @NonNls
    public static final String ARGUMENT_TYPES_MISMATCH = "javascript.argument.types.mismatch";
    public static final ResolveResult[] TOO_MANY_CANDIDATES = new ResolveResult[]{new JSResolveResult(null)};
    @Nullable
    private final PsiElement myElement;
    private final JSElement myImportUsed;
    private final String myResolveProblemKey;

    public JSResolveResult(@Nullable PsiElement element) {
        this(element, null, null);
    }

    public JSResolveResult(@Nullable PsiElement element, @Nullable JSElement importUsed, @Nullable @PropertyKey(resourceBundle="messages.JavaScriptBundle") String resolveProblemKey) {
        this.myElement = element;
        this.myResolveProblemKey = resolveProblemKey;
        this.myImportUsed = importUsed;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    public boolean isValidResult() {
        return this.myResolveProblemKey == null;
    }

    @Nullable
    public JSImportStatement getActionScriptImport() {
        return this.myImportUsed instanceof JSImportStatement ? (JSImportStatement)this.myImportUsed : null;
    }

    @Nullable
    public ES6ImportExportDeclarationPart getES6Import() {
        if (this.myImportUsed == null) {
            return null;
        }
        return this.myImportUsed instanceof ES6ImportExportDeclarationPart ? (ES6ImportExportDeclarationPart)this.myImportUsed : null;
    }

    @Nullable
    public String getResolveProblemKey() {
        return this.myResolveProblemKey;
    }

    @Nullable
    public static PsiElement resolveAny(@NotNull ResolveResult[] results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/psi/resolve/JSResolveResult", "resolveAny"));
        }
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!result.isValidResult() || element == null) continue;
            return element;
        }
        return results.length > 0 ? results[0].getElement() : null;
    }

    @Nullable
    public static PsiElement resolve(@NotNull ResolveResult[] results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/psi/resolve/JSResolveResult", "resolve"));
        }
        return results.length == 1 && results[0].isValidResult() ? results[0].getElement() : null;
    }

    public static Collection<PsiElement> toElements(@Nullable ResolveResult[] results, boolean ignoreInvalid) {
        if (results == null || results.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList psiElements = ContainerUtil.newArrayListWithCapacity((int)results.length);
        for (ResolveResult result : results) {
            PsiElement element;
            if (ignoreInvalid && !result.isValidResult() || (element = result.getElement()) == null) continue;
            psiElements.add(element);
        }
        return psiElements;
    }

    @NotNull
    public static Collection<PsiElement> toElements(@Nullable ResolveResult[] results) {
        Collection<PsiElement> collection = JSResolveResult.toElements(results, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveResult", "toElements"));
        }
        return collection;
    }
}

