/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyStaticContextElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluator {
    protected static final PsiElement EXPLICIT_TYPE_MARKER_ELEMENT = PsiUtilCore.NULL_PSI_ELEMENT;
    private static final ThreadLocal<JSRecursionGuard> recursionGuardHolder = new ThreadLocal();
    public static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE = 20;
    private static final Key<ParameterizedCachedValue<JSTypeEvaluationResult, JSExpression>> CACHE_KEY_EXPRESSION_TYPE = Key.create((String)"js.evaluator.expression.type");
    private static final ParameterizedCachedValueProvider<JSTypeEvaluationResult, JSExpression> CACHE_PROVIDER_EXPRESSION_TYPE = new ParameterizedCachedValueProvider<JSTypeEvaluationResult, JSExpression>(){

        public CachedValueProvider.Result<JSTypeEvaluationResult> compute(JSExpression param) {
            JSSimpleTypeProcessor typeProcessor = new JSSimpleTypeProcessor();
            PsiFile targetFile = param.getContainingFile();
            JSTypeEvaluator typeEvaluator = JSDialectSpecificHandlersFactory.forElement((PsiElement)targetFile).newTypeEvaluator(new JSEvaluateContext(targetFile), typeProcessor);
            typeEvaluator.doEvaluateTypes(param, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
            JSTypeEvaluationResult type = typeProcessor.getResult();
            return CachedValueProvider.Result.create((Object)type, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };
    protected final JSEvaluateContext myContext;
    protected final JSTypeProcessor myTypeProcessor;

    protected JSTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        this.myContext = context;
        this.myTypeProcessor = processor;
    }

    @Nullable
    public static JSType forceEvaluateType(PsiElement target, JSExpression expr, PsiFile targetFile) {
        JSSimpleTypeProcessor typeProcessor = new JSSimpleTypeProcessor(target);
        JSTypeEvaluator.evaluateTypes(expr, targetFile, typeProcessor, JSEvaluateContext.JSEvaluationPlace.FORCE_EVALUATE_TYPE);
        return typeProcessor.getType();
    }

    public static void evaluateTypes(@NotNull JSExpression expr, JSTypeProcessor typeProcessor) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateTypes"));
        }
        JSTypeEvaluator.evaluateTypes(expr, expr.getContainingFile(), typeProcessor, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public static void evaluateTypes(JSExpression expr, PsiFile targetFile, JSTypeProcessor typeProcessor) {
        JSTypeEvaluator.evaluateTypes(expr, targetFile, typeProcessor, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public static void evaluateTypes(JSExpression expr, @NotNull PsiFile targetFile, JSTypeProcessor typeProcessor, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateTypes"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateTypes"));
        }
        JSTypeEvaluator.evaluateExpressionOrElementTypes(targetFile, typeProcessor, (PsiElement)expr, place);
    }

    public static void evaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateExpressionOrElementTypes"));
        }
        if (typeProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProcessor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateExpressionOrElementTypes"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateExpressionOrElementTypes"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateExpressionOrElementTypes"));
        }
        JSTypeEvaluator typeEvaluator = JSDialectSpecificHandlersFactory.forElement((PsiElement)targetFile).newTypeEvaluator(new JSEvaluateContext(targetFile), typeProcessor);
        if (element instanceof JSExpression) {
            typeEvaluator.evaluateTypes((JSExpression)element, place);
        } else if (element instanceof JSDestructuringContainer) {
            typeEvaluator.evaluateDestructuringContainer((JSDestructuringContainer)element);
        } else {
            typeEvaluator.addTypeFromResolveResult(element, false);
        }
    }

    @Nullable
    public static JSTypeEvaluationResult getExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getExpressionType"));
        }
        JSRecursionGuard context = recursionGuardHolder.get();
        if (context != null && context.isAlreadyProcessingItem((PsiElement)expression)) {
            return null;
        }
        return (JSTypeEvaluationResult)CachedValuesManager.getManager((Project)expression.getProject()).getParameterizedCachedValue((UserDataHolder)expression, CACHE_KEY_EXPRESSION_TYPE, CACHE_PROVIDER_EXPRESSION_TYPE, false, (Object)expression);
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getElementType"));
        }
        PsiFile targetFile = element.getContainingFile();
        JSSimpleTypeProcessor typeProcessor = new JSSimpleTypeProcessor();
        JSTypeEvaluator.evaluateExpressionOrElementTypes(targetFile, typeProcessor, element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        return typeProcessor.getResult();
    }

    private void addTypeEvaluationResultElement(@NotNull JSTypeEvaluationResult.JSTypeEvaluationResultElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeEvaluationResultElement"));
        }
        JSType type = element.getType();
        JSSymbolNamespace namespace = element.getNamespace();
        PsiElement source = element.getSource();
        this.myContext.withCombinedContext(element.getEvaluationContext(), () -> {
            if (type != null) {
                JSTypeEvaluator.applyContextAndProcess(type, this.myContext, source, this.myTypeProcessor);
            } else if (namespace != null) {
                JSTypeEvaluator.applyContextAndProcessNamespace((JSNamespace)namespace, this.myContext, source, this.myTypeProcessor);
            } else {
                assert (source != null);
                this.applyContextAndProcessResolvedElement(source);
            }
        });
    }

    public void addType(@Nullable JSType _type, @Nullable PsiElement source) {
        if (_type == null) {
            return;
        }
        if (_type instanceof JSRequireCallExpressionType) {
            Collection<PsiElement> elements;
            String referencedModule = ((JSRequireCallExpressionType)_type).getReferencedModule();
            PsiFile scope = ((JSRequireCallExpressionType)_type).getScope();
            if (scope != null && !(elements = JSFileReferencesUtil.resolveModuleReference(scope, referencedModule)).isEmpty()) {
                for (PsiElement element : elements) {
                    JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.EXTERNAL_MODULE, module -> this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)module));
                }
                return;
            }
        }
        JSTypeEvaluator.applyContextAndProcess(_type, this.myContext, source, this.myTypeProcessor);
    }

    private static void applyContextAndProcess(@NotNull JSType _type, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcess"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcess"));
        }
        if (_type instanceof JSEvaluableType) {
            _type = _type.substitute();
        }
        if (!context.isJSElementsToApplyEmpty()) {
            JSApplyContextElement pop = context.popJSElementToApply();
            if (pop instanceof JSApplyCallElement) {
                JSType returnType = JSTypeUtils.tryGetReturnType(_type, (JSApplyCallElement)pop);
                if (returnType == null) {
                    returnType = JSAnyType.get((PsiElement)((JSApplyCallElement)pop).getCallExpression(), false);
                }
                JSTypeEvaluator.applyContextAndProcess(returnType, context, null, processor);
            } else if (pop instanceof JSApplyPropertyElement) {
                JSTypeEvaluator.applyContextAndProcessDestructuringProperty((JSApplyPropertyElement)pop, _type, context, null, processor);
            } else if (pop instanceof JSApplyIndexedAccessElement) {
                JSApplyContextUtil.applyContextAndProcessDestructuringArray((JSApplyIndexedAccessElement)pop, _type, type -> {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$applyContextAndProcess$2"));
                    }
                    if (processor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$applyContextAndProcess$2"));
                    }
                    JSTypeEvaluator.applyContextAndProcess(type, context, null, processor);
                });
            } else if (pop instanceof JSApplyInstanceContextElement) {
                JSType returnType;
                TypeScriptTypeArgumentList typeArgumentsList;
                JSNewExpression newExpression = ((JSApplyInstanceContextElement)pop).getNewExpression();
                if (newExpression instanceof TypeScriptNewExpression && (typeArgumentsList = ((TypeScriptNewExpression)newExpression).getTypeArguments()) != null) {
                    Object[] typeArguments = typeArgumentsList.getTypeArguments();
                    List types = ContainerUtil.map((Object[])typeArguments, TypeScriptTypeParser.MAP_DECLARATION_TO_TYPE);
                    _type = new JSGenericTypeImpl(_type.getSource(), _type, types);
                }
                boolean processed = false;
                if (newExpression != null && (returnType = JSTypeUtils.tryGetReturnType(_type, (JSApplyInstanceContextElement)pop)) != null) {
                    processed = true;
                    JSTypeEvaluator.applyContextAndProcess(returnType, context, source, processor);
                }
                if (!processed && _type instanceof JSNamedType && ((JSNamedType)_type).isStaticOrInstance() != JSContext.INSTANCE) {
                    _type = ((JSNamedType)_type).copyWithJSContext(JSContext.INSTANCE);
                    JSTypeEvaluator.applyContextAndProcess(_type, context, source, processor);
                }
            } else if (pop instanceof JSApplyStaticContextElement && _type instanceof JSNamedType && ((JSNamedType)_type).isStaticOrInstance() != JSContext.STATIC) {
                _type = ((JSNamedType)_type).copyWithJSContext(JSContext.STATIC);
                JSTypeEvaluator.applyContextAndProcess(_type, context, source, processor);
            }
            context.pushJSElementToApply(pop);
            return;
        }
        _type = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(_type, (JSExpression)context.getProcessedExpression(), null);
        if (CommonJSUtil.isModuleType(_type)) {
            JSContext jsContext = _type instanceof JSNamedType ? ((JSNamedType)_type).isStaticOrInstance() : JSContext.UNKNOWN;
            PsiFile scope = _type.getSource().getScope();
            if (scope != null) {
                JSTypeEvaluator.addDefaultExportNamespaces((PsiElement)scope, jsContext, context, processor);
            }
        }
        JSType type2 = context.isTypeGuessed() && _type.getSource().isExplicitlyDeclared() ? JSTypeUtils.copyWithExplicitlyDeclaredRecursive(_type, false) : _type;
        processor.process(type2, context, source);
    }

    private static void applyContextAndProcessDestructuringProperty(@NotNull JSApplyPropertyElement pop, @NotNull JSType _type, @NotNull JSEvaluateContext context, PsiElement source, @NotNull JSTypeProcessor processor) {
        if (pop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pop", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessDestructuringProperty"));
        }
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessDestructuringProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessDestructuringProperty"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessDestructuringProperty"));
        }
        _type = JSTypeUtils.getValuableType(_type);
        String propertyName = pop.getName();
        JSDestructuringProperty property = pop.getProperty();
        if (!(_type instanceof JSRecordType) && DialectDetector.isTypeScript((PsiElement)property)) {
            _type = _type.asRecordType();
        }
        if (_type instanceof JSRecordType) {
            JSType propertyType;
            JSRecordType.PropertySignature signature = ((JSRecordType)_type).findPropertySignature(propertyName);
            JSType jSType = propertyType = signature != null ? signature.getType() : null;
            if (propertyType != null) {
                PsiElement signatureSource = signature.getSource();
                PsiElement newSource = signatureSource == null ? source : signatureSource;
                JSTypeEvaluator.applyContextAndProcess(propertyType, context, newSource, processor);
            }
        } else if (_type instanceof JSNamedType) {
            String newTypeName = _type.getTypeText(JSType.TypeTextFormat.RESOLVED) + "." + propertyName;
            JSTypeSource newTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)property, ((JSNamedType)_type).isExplicitlyDeclared());
            JSType newType = JSNamedType.createType(newTypeName, newTypeSource, JSContext.STATIC);
            JSTypeEvaluator.applyContextAndProcess(newType, context, (PsiElement)property, processor);
        }
    }

    protected void addType(@NotNull String type, PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addType"));
        }
        PsiElement scope = source;
        if (scope == null) {
            scope = this.myTypeProcessor.getTarget();
        }
        if (scope == null) {
            scope = this.myContext.targetFile;
        }
        this.addType(JSNamedType.createType(type, JSTypeSourceFactory.createTypeSource(scope, false), JSContext.UNKNOWN), source);
    }

    protected void addNamespace(@NotNull JSNamespace namespace, @Nullable PsiElement source) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addNamespace"));
        }
        JSTypeEvaluator.applyContextAndProcessNamespace(namespace, this.myContext, source, this.myTypeProcessor);
    }

    static void applyContextAndProcessNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        List elementsToApply;
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessNamespace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessNamespace"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessNamespace"));
        }
        List list = elementsToApply = context.isJSElementsToApplyEmpty() ? ContainerUtil.emptyList() : new SmartList();
        while (!context.isJSElementsToApplyEmpty()) {
            JSApplyContextElement peek = context.peekJSElementToApply();
            if (peek instanceof JSApplyInstanceContextElement) {
                namespace = JSNamespaceImpl.withContext(namespace, JSContext.INSTANCE);
            } else if (peek instanceof JSApplyStaticContextElement) {
                namespace = JSNamespaceImpl.withContext(namespace, JSContext.STATIC);
            } else {
                if (!(peek instanceof JSApplyPropertyElement)) break;
                String name = ((JSApplyPropertyElement)peek).getName();
                source = null;
                namespace = new JSNamespaceImpl(JSQualifiedNameImpl.create(name, namespace.getQualifiedName()), JSContext.STATIC, namespace.isExplicitlyDeclared());
            }
            elementsToApply.add(context.popJSElementToApply());
        }
        if (context.isJSElementsToApplyEmpty()) {
            JSSymbolNamespaceImpl symbolNamespace = new JSSymbolNamespaceImpl(namespace.getQualifiedName(), namespace.getJSContext(), namespace.isExplicitlyDeclared(), false, namespace.isLocal());
            processor.processNamespace(symbolNamespace, context, source);
        }
        for (int i = elementsToApply.size() - 1; i >= 0; --i) {
            context.pushJSElementToApply((JSApplyContextElement)elementsToApply.get(i));
        }
    }

    protected void evaluateTypes(JSExpression rawqualifier) {
        this.evaluateTypes(rawqualifier, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    protected void evaluateTypes(JSExpression rawqualifier, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateTypes"));
        }
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            this.doEvaluateTypes(rawqualifier, place);
        } else {
            this.evaluateCachedTypes(rawqualifier);
        }
    }

    protected void doEvaluateTypes(JSExpression rawqualifier, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        JSPrefixExpression prefixExpression;
        JSType typecast;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "doEvaluateTypes"));
        }
        if (rawqualifier != null && (typecast = JSDocumentationUtils.findTypeFromInlineComment((PsiElement)rawqualifier)) != null) {
            this.addType(typecast, null);
            return;
        }
        if (rawqualifier instanceof JSDefinitionExpression) {
            rawqualifier = ((JSDefinitionExpression)rawqualifier).getExpression();
        }
        if (rawqualifier instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)rawqualifier).getQualifier() == null && rawqualifier.getNode().findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true)), (PsiElement)rawqualifier);
                return;
            }
            this.processItem((JSReferenceExpression)rawqualifier, place, expression -> {
                JSReferenceExpression oldQualifier = this.myContext.getProcessedExpression();
                try {
                    this.myContext.setProcessedExpression((JSReferenceExpression)expression);
                    this.processRefExpr((JSReferenceExpression)expression);
                }
                finally {
                    this.myContext.setProcessedExpression(oldQualifier);
                }
            });
        } else if (rawqualifier instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)rawqualifier, place);
        } else if (rawqualifier instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)rawqualifier, place);
        } else if (rawqualifier instanceof JSPrefixExpression) {
            JSType promiseComponentType;
            JSType type;
            prefixExpression = (JSPrefixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            String evaluatedType = null;
            if (JSTokenTypes.EXCL == sign || JSTokenTypes.DELETE_KEYWORD == sign) {
                evaluatedType = "boolean";
            } else if (JSTokenTypes.PLUS == sign || JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.TILDE == sign || JSTokenTypes.MINUSMINUS == sign || JSTokenTypes.MINUS == sign) {
                if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    type = JSResolveUtil.getExpressionJSType(prefixExpression.getExpression());
                    if (type != null) {
                        evaluatedType = type.getTypeText();
                    }
                } else {
                    evaluatedType = "number";
                }
            } else if (JSTokenTypes.TYPEOF_KEYWORD == sign) {
                evaluatedType = "string";
            } else if (JSTokenTypes.AWAIT_KEYWORD == sign && (type = JSResolveUtil.getExpressionJSType(prefixExpression.getExpression())) != null && (promiseComponentType = JSTypeUtils.getPromiseComponentTypeOrNull(type)) != null) {
                this.addType(promiseComponentType, (PsiElement)rawqualifier);
                return;
            }
            if (evaluatedType != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                JSType type2 = JSNamedType.createType(evaluatedType, source, JSContext.INSTANCE);
                this.addType(type2, (PsiElement)rawqualifier);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
            }
        } else if (rawqualifier instanceof JSPostfixExpression) {
            prefixExpression = (JSPostfixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            if (JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.MINUSMINUS == sign) {
                if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    this.simpleEvalType(rawqualifier, prefixExpression.getExpression());
                } else {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false);
                    this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
                }
            }
        } else if (rawqualifier instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)rawqualifier;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression rOperand = binaryExpression.getROperand();
            JSExpression lOperand = binaryExpression.getLOperand();
            if (lOperand != null && rOperand != null) {
                if (sign == JSTokenTypes.AS_KEYWORD) {
                    this.resolveAsBinaryOperationExpression(rawqualifier, rOperand);
                } else if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(sign) || JSTokenTypes.EQUALITY_OPERATIONS.contains(sign) || sign == JSTokenTypes.IS_KEYWORD) {
                    this.addType(new JSBooleanType(true, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false), JSTypeContext.INSTANCE), null);
                } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(sign) || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.OROR) {
                    if (sign == JSTokenTypes.DIV || (sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.MINUS || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign)) && !DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false);
                        this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
                    } else {
                        JSType lProcType = JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(lOperand));
                        JSType rProcType = JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(rOperand));
                        if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND) {
                            if (lProcType != null) {
                                this.addType(lProcType, (PsiElement)rawqualifier);
                            }
                            if (rProcType != null) {
                                this.addType(rProcType, (PsiElement)rawqualifier);
                            }
                            if (lProcType == null && rProcType == null) {
                                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                            }
                        } else {
                            JSPrimitiveType evaluatedType = null;
                            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)binaryExpression);
                            if (lProcType instanceof JSStringType || rProcType instanceof JSStringType) {
                                evaluatedType = new JSStringType(true, typeSource, JSTypeContext.INSTANCE);
                            } else if ((lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
                                evaluatedType = new JSIntType(true, typeSource, JSTypeContext.INSTANCE);
                            } else if ((lProcType instanceof JSNumberType || lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSNumberType || rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
                                evaluatedType = new JSNumberType(true, typeSource, JSTypeContext.INSTANCE);
                            }
                            if (evaluatedType != null) {
                                this.addType(evaluatedType, (PsiElement)rawqualifier);
                            } else {
                                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                            }
                        }
                    }
                } else if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(sign)) {
                    JSTypeEvaluationResult result = null;
                    if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                        result = JSTypeEvaluator.getExpressionType(lOperand);
                    }
                    if (result == null) {
                        result = JSTypeEvaluator.getExpressionType(rOperand);
                    }
                    if (result != null) {
                        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : result.getResults()) {
                            this.addTypeEvaluationResultElement(element);
                        }
                    } else {
                        this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                    }
                } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(sign)) {
                    this.simpleEvalType(rawqualifier, lOperand);
                }
            }
        } else if (rawqualifier instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression(rawqualifier);
        } else if (rawqualifier instanceof JSArrayLiteralExpression) {
            JSExpression[] expressions = ((JSArrayLiteralExpression)rawqualifier).getExpressions();
            JSType type = expressions.length > 0 ? this.getArrayTypeFromExpressions(rawqualifier, expressions) : JSNamedType.createType("Array", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
            this.addType(type, (PsiElement)rawqualifier);
            if (this.myTypeProcessor instanceof ResolveProcessor) {
                ((ResolveProcessor)((Object)this.myTypeProcessor)).execute((PsiElement)rawqualifier, ResolveState.initial());
            }
        } else if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            this.evalComponentTypeFromArrayExpression(rawqualifier, ((JSIndexedPropertyAccessExpression)rawqualifier).getQualifier());
        } else if (rawqualifier instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)rawqualifier, this.isFromCurrentFile((PsiElement)rawqualifier));
        } else if (rawqualifier instanceof JSParenthesizedExpression) {
            this.evaluateTypes(((JSParenthesizedExpression)rawqualifier).getInnerExpression(), place);
        } else if (rawqualifier instanceof JSThisExpression) {
            this.processThisQualifierExpression((JSThisExpression)rawqualifier);
        } else if (rawqualifier instanceof JSSuperExpression) {
            JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier);
            this.processSuperQualifierExpression((JSSuperExpression)rawqualifier, jsClass);
        } else if (rawqualifier instanceof JSFunctionExpression) {
            this.processFunction((JSFunction)((JSFunctionExpression)rawqualifier));
        } else if (rawqualifier instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)rawqualifier;
            JSExpression thenPart = conditionalExpression.getThen();
            JSExpression elsePart = conditionalExpression.getElse();
            JSType thenType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, thenPart);
            JSType elseType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, elsePart);
            if (thenType != null || elseType != null) {
                JSType common = null;
                if (elseType == null) {
                    common = thenType;
                }
                if (thenType == null) {
                    common = elseType;
                }
                if (common == null) {
                    common = thenType instanceof JSAnyType ? JSTypeEvaluator.replaceTypeSourceByNotExplicitly((JSExpression)conditionalExpression, elseType) : (elseType instanceof JSAnyType ? JSTypeEvaluator.replaceTypeSourceByNotExplicitly((JSExpression)conditionalExpression, thenType) : JSTypeUtils.getCommonType(thenType, elseType, DialectDetector.dialectOfElement((PsiElement)conditionalExpression), true));
                }
                this.addType(common, (PsiElement)conditionalExpression);
            }
        } else if (!this.evaluateDialectSpecificTypes(rawqualifier) && rawqualifier != null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    private void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier) {
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processThisQualifierExpression"));
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier, true);
        if (jsClass != null) {
            String name = jsClass.getQualifiedName();
            if (name != null) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                JSContext staticOrInstance = JSResolveUtil.calculateStaticFromContext((PsiElement)rawqualifier) ? JSContext.STATIC : JSContext.INSTANCE;
                this.addType(JSNamedType.createType(name, typeSource, staticOrInstance), (PsiElement)jsClass);
            }
        } else {
            PsiElement thisScope = JSPsiImplUtils.getExecutionScope((PsiElement)rawqualifier);
            this.processThisQualifierInExecutionScope(rawqualifier, thisScope);
        }
    }

    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        if (thisQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisQualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processThisQualifierInExecutionScope"));
        }
        JSType type = JSDocumentationUtils.findContextType(thisScope);
        if (type != null) {
            this.addType(type, null);
        } else {
            JSType thisType;
            JSNamespaceEvaluationResult thisNs = JSContextResolver.resolveContext((PsiElement)thisQualifier);
            JSType jSType = thisType = thisNs != null ? thisNs.toType((PsiElement)thisQualifier) : null;
            if (thisType != null) {
                this.addType(thisType, (PsiElement)thisQualifier);
            } else if (thisScope instanceof JSFunctionExpression && thisScope.getParent() instanceof JSArgumentList) {
                JSType funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)thisScope));
                if ((funcType = JSTypeUtils.getValuableType(funcType)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)funcType).getThisType()) != null) {
                    this.addType(thisType, (PsiElement)thisQualifier);
                }
            }
            if (thisType == null) {
                this.myTypeProcessor.setUnknownElement((PsiElement)thisQualifier);
            }
        }
    }

    private void resolveAsBinaryOperationExpression(JSExpression rawqualifier, JSExpression rOperand) {
        PsiElement resolve;
        boolean isClassCast = false;
        if (rOperand instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSVariable && "Class".equals(((JSVariable)resolve).getTypeString())) {
            isClassCast = true;
        }
        if (isClassCast) {
            this.addType("*", (PsiElement)rawqualifier);
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rOperand);
            this.addType(JSTypeUtils.createType(JSImportHandlingUtil.resolveTypeName(rOperand.getText(), (PsiElement)rOperand), source), null);
        }
    }

    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, JSClass jsClass) {
        JSClass[] classes;
        if (jsClass != null && (classes = jsClass.getSuperClasses()).length > 0) {
            JSClass aClass = classes[0];
            this.addType(aClass.getQualifiedName(), (PsiElement)aClass);
        }
    }

    @NotNull
    private static JSType replaceTypeSourceByNotExplicitly(JSExpression conditionalExpression, JSType partType) {
        JSType jSType = JSTypeUtils.copyWithExplicitlyDeclaredRecursive(partType, false);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "replaceTypeSourceByNotExplicitly"));
        }
        return jSType;
    }

    @Nullable
    private JSType getConditionalPartTypeOrAny(JSExpression conditionalExpression, JSExpression part) {
        JSType partType = null;
        if (part != null && (partType = JSResolveUtil.getExpressionJSType(part)) == null) {
            partType = JSAnyType.get((PsiElement)conditionalExpression, false);
        }
        return partType;
    }

    @NotNull
    protected JSType getArrayTypeFromExpressions(JSExpression rawQualifier, JSExpression[] expressions) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)rawQualifier);
        List<JSTypeUtils.TypeProvider> providers = Arrays.stream(expressions).map(el -> () -> this.getExpressionTypeForArrayLiteral(rawQualifier, (JSExpression)el, holder)).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)rawQualifier, true);
        JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true));
        if (jSArrayTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getArrayTypeFromExpressions"));
        }
        return jSArrayTypeImpl;
    }

    @Nullable
    protected JSType getExpressionTypeForArrayLiteral(JSExpression rawqualifier, JSExpression expression, DialectOptionHolder holder) {
        JSType exprType;
        boolean isTypeScript = holder != null && holder.isTypeScript;
        JSType jSType = exprType = expression != null ? JSTypeEvaluator.getTypeFromConstant(expression) : this.createNullType(rawqualifier);
        if (exprType != null && !isTypeScript) {
            exprType = JSTypeUtils.getNonValueType(exprType);
        }
        if (exprType == null && isTypeScript) {
            if (expression instanceof JSObjectLiteralExpression) {
                exprType = JSTypeEvaluator.getObjectLiteralType((JSObjectLiteralExpression)expression, true);
            }
            if (exprType == null) {
                exprType = new JSTypeofTypeImpl(expression, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true));
            }
        }
        return exprType;
    }

    @NotNull
    protected JSType createNullType(JSExpression rawqualifier) {
        JSType jSType = JSNamedType.createType("null", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "createNullType"));
        }
        return jSType;
    }

    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        return false;
    }

    protected void evaluateNewExpressionTypes(JSNewExpression newExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateNewExpressionTypes"));
        }
        JSExpression methodExpr = newExpression.getMethodExpression();
        this.myContext.processWithJSElementToApply(new JSApplyInstanceContextElement(newExpression), () -> {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$evaluateNewExpressionTypes$6"));
            }
            this.evaluateTypes(methodExpr, place);
        });
    }

    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateCallExpressionTypes"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateCallExpressionTypes"));
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            boolean isTypeScript;
            JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
            String referencedName = invoked.getReferenceName();
            DialectOptionHolder dialect = DialectDetector.dialectOfFile(callExpression.getContainingFile());
            boolean bl = isTypeScript = dialect != null && dialect.isTypeScript;
            if ("create".equals(referencedName) && dialect != null && dialect.isJavaScript()) {
                boolean processed = this.processCreateMethodCall(callExpression, invoked);
                if (processed) {
                    return;
                }
            } else if (!isTypeScript && ("apply".equals(referencedName) || "call".equals(referencedName))) {
                methodExpression = this.processApplyOrCallMethodCall(methodExpression, invoked);
            } else if (!isTypeScript && ("reduce".equals(referencedName) || "reduceRight".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processReduceMethodCall(methodExpression, invoked);
            } else if (this.processRequireMethodCall(callExpression, invoked, isTypeScript)) {
                return;
            }
        }
        JSApplyContextElement elementToApply = callExpression instanceof JSNewExpression ? new JSApplyInstanceContextElement((JSNewExpression)callExpression) : new JSApplyCallElement(callExpression);
        JSExpression finalMethodExpression = methodExpression;
        this.myContext.processWithJSElementToApply(elementToApply, () -> {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$evaluateCallExpressionTypes$7"));
            }
            this.evaluateTypes(finalMethodExpression, place);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequireMethodCall(@NotNull JSCallExpression callExpression, @Nullable JSReferenceExpression invoked, boolean isTypeScript) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processRequireMethodCall"));
        }
        Collection<PsiElement> modules = CommonJSUtil.findReferencedModulesIfRequireCall(callExpression);
        if (!modules.isEmpty()) {
            JSReferenceExpression previousProcessedExpression = this.myContext.getProcessedExpression();
            try {
                boolean oldIsTypeGuessed = this.myContext.isTypeGuessed();
                if (isTypeScript) {
                    this.myContext.setTypeIsGuessed(true);
                }
                this.myContext.setProcessedExpression(invoked);
                for (PsiElement module : modules) {
                    this.addModuleFromRequire(module, callExpression);
                }
                if (isTypeScript) {
                    this.myContext.setTypeIsGuessed(oldIsTypeGuessed);
                }
            }
            finally {
                this.myContext.setProcessedExpression(previousProcessedExpression);
            }
            return true;
        }
        return false;
    }

    private static JSExpression processReduceMethodCall(JSExpression methodExpression, JSReferenceExpression invoked) {
        JSExpression[] expressions;
        JSExpression qualifier = invoked.getQualifier();
        if (qualifier instanceof JSArrayLiteralExpression && (expressions = ((JSArrayLiteralExpression)qualifier).getExpressions()).length > 0 && expressions[0] != null) {
            return expressions[0];
        }
        return methodExpression;
    }

    private JSExpression processApplyOrCallMethodCall(@NotNull JSExpression methodExpression, @NotNull JSReferenceExpression invoked) {
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processApplyOrCallMethodCall"));
        }
        if (invoked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invoked", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processApplyOrCallMethodCall"));
        }
        JSExpression qualifier = invoked.getQualifier();
        if (qualifier != null) {
            Ref referencesLib = Ref.create((Object)false);
            this.processItem(qualifier, JSEvaluateContext.JSEvaluationPlace.REFERENCE_EXPRESSION, ref -> {
                ResolveResult[] results;
                if (invoked == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invoked", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$processApplyOrCallMethodCall$8"));
                }
                for (ResolveResult result : results = invoked.multiResolve(false)) {
                    String fileName;
                    PsiElement element = result.getElement();
                    if (element == null || !"ECMAScript.js2".equals(fileName = element.getContainingFile().getName()) && !"EcmaScript.js".equals(fileName) && !TypeScriptLibraryProvider.LIBS_D_TS.contains(fileName)) continue;
                    referencesLib.set((Object)true);
                    return;
                }
            });
            if (((Boolean)referencesLib.get()).booleanValue()) {
                return qualifier;
            }
        }
        return methodExpression;
    }

    private boolean processCreateMethodCall(@NotNull JSCallExpression callExpression, @NotNull JSReferenceExpression invoked) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processCreateMethodCall"));
        }
        if (invoked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invoked", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processCreateMethodCall"));
        }
        Ref processed = Ref.create((Object)false);
        this.processItem(invoked, JSEvaluateContext.JSEvaluationPlace.REFERENCE_EXPRESSION, ref -> {
            JSExpression[] arguments;
            JSExpression firstArgument;
            JSType type;
            JSFunctionItem functionItem;
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$processCreateMethodCall$9"));
            }
            boolean hasExplicitReturnType = false;
            PsiElement resolve = ref.resolve();
            if (resolve != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)ref)) != null && JSTypeUtils.isStrictType(type = functionItem.getReturnType())) {
                hasExplicitReturnType = true;
            }
            JSExpression jSExpression = firstArgument = (arguments = callExpression.getArguments()).length > 0 ? arguments[0] : null;
            if (!hasExplicitReturnType && (firstArgument instanceof JSLiteralExpression && ((JSLiteralExpression)firstArgument).isQuotedLiteral() || firstArgument instanceof JSReferenceExpression)) {
                String typeString;
                String string = typeString = firstArgument instanceof JSReferenceExpression ? JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)firstArgument))) : (String)((JSLiteralExpression)firstArgument).getValue();
                if (typeString != null) {
                    JSType type2 = JSNamedType.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)firstArgument), JSTypeContext.UNKNOWN);
                    this.addType(type2, (PsiElement)firstArgument);
                }
                processed.set((Object)true);
            }
        });
        return Boolean.TRUE.equals(processed.get());
    }

    protected void addModuleFromRequire(PsiElement element, JSCallExpression callExpression) {
        JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.EXTERNAL_MODULE, module -> this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)module));
    }

    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return;
        }
        if (resolve instanceof JSFile) {
            this.addTypeFromModuleFile((JSFile)resolve);
        } else if (resolve instanceof JsonFile) {
            this.applyContextAndProcessResolvedElement(resolve);
        } else {
            this.addTypeFromResolveResult(resolve, false);
        }
    }

    private void addTypeFromModuleFile(@NotNull JSFile jsFile) {
        JSType innerAlias;
        PsiFile placeFile;
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromModuleFile"));
        }
        this.applyContextAndProcessResolvedElement((PsiElement)jsFile);
        JSPsiElementBase exportedElement = JSResolveUtil.getExportedElement(jsFile);
        JSReferenceExpression place = this.myContext.getProcessedExpression();
        PsiFile psiFile = placeFile = place != null ? place.getContainingFile() : null;
        if (exportedElement == null && jsFile.hasES6Syntax() && placeFile instanceof JSFile && DialectDetector.isJavaScript((PsiElement)placeFile) && !((JSFile)placeFile).hasES6Syntax()) {
            JSElement defaultExport = ES6PsiUtil.findDefaultExport((PsiElement)jsFile);
            if (defaultExport instanceof ES6ExportDefaultAssignment) {
                String reference = ((ES6ExportDefaultAssignment)defaultExport).getInitializerReference();
                if (reference != null) {
                    PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(reference, (PsiElement)defaultExport);
                    if (localResolve != null) {
                        exportedElement = localResolve;
                    }
                } else {
                    JSExpression expression = ((ES6ExportDefaultAssignment)defaultExport).getStubSafeExpression();
                    if (expression != null) {
                        exportedElement = expression;
                    }
                }
            } else if (defaultExport != null) {
                exportedElement = defaultExport;
            }
        }
        if (exportedElement != null) {
            JSTypeEvaluator.processWithEvaluationGuard(exportedElement, JSEvaluateContext.JSEvaluationPlace.EXPORTED_ELEMENT, element -> {
                if (jsFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$addTypeFromModuleFile$12"));
                }
                this.myContext.withJSModule((PsiFile)jsFile, () -> this.addTypeFromResolveResult((PsiElement)element, false));
            });
        }
        if ((innerAlias = jsFile.getExportsInnerAlias()) != null) {
            JSPsiElementBase finalExportedElement = exportedElement;
            JSApplyContextUtil.applyTypeToContext(innerAlias, this.myContext, (arg_0, arg_1) -> this.lambda$addTypeFromModuleFile$15((PsiElement)finalExportedElement, jsFile, arg_0, arg_1));
        }
    }

    public static void addDefaultExportNamespaces(@NotNull PsiElement source, @NotNull JSContext jsContext, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addDefaultExportNamespaces"));
        }
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addDefaultExportNamespaces"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addDefaultExportNamespaces"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addDefaultExportNamespaces"));
        }
        JSNamespaceImpl moduleExports = new JSNamespaceImpl(JSQualifiedNameImpl.fromComponents("module", "exports"), jsContext, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(moduleExports, context, source, processor);
        JSNamespaceImpl exports = new JSNamespaceImpl(JSQualifiedNameImpl.create("exports", null), jsContext, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(exports, context, source, processor);
    }

    protected boolean processFunction(@NotNull JSFunction function) {
        boolean hasSomeType;
        boolean inCall;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processFunction"));
        }
        JSApplyContextElement elementToApply = this.myContext.peekJSElementToApply();
        boolean bl = inCall = elementToApply instanceof JSApplyCallElement || elementToApply instanceof JSApplyInstanceContextElement && ((JSApplyInstanceContextElement)elementToApply).getNewExpression() != null;
        if (function.isGetProperty()) {
            JSType returnType = JSFunctionImpl.getReturnTypeInContext(function, (PsiElement)this.myContext.getProcessedExpression());
            if (returnType != null) {
                this.addType(returnType, null);
            }
            hasSomeType = returnType != null;
        } else if (function.isSetProperty()) {
            JSType parameterType = JSResolveUtil.getTypeFromSetAccessor((JSFunctionItem)function);
            if (parameterType != null) {
                this.addType(parameterType, null);
            }
            hasSomeType = parameterType != null;
        } else if (!inCall) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)function);
            if (source.getLanguage() == JSTypeSource.SourceLanguage.TS) {
                this.addType(TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl(function), (PsiElement)function);
            } else if (this.isFromCurrentFile((PsiElement)function) && JSPsiImplUtils.isArrowFunction(function)) {
                JSExpression returned = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function);
                SmartList parameterTypes = new SmartList();
                for (JSParameterListElement parameter : function.getParameters()) {
                    parameterTypes.add(parameter.getTypeDecorator());
                }
                JSTypeSource explicitlyDeclaredSource = JSTypeSourceFactory.createTypeSource((PsiElement)function, true);
                JSFunctionTypeImpl type = new JSFunctionTypeImpl(explicitlyDeclaredSource, (List<JSParameterTypeDecorator>)parameterTypes, JSResolveUtil.getExpressionJSType(returned));
                this.addType(type, (PsiElement)function);
            } else {
                String name;
                JSType functionType = source.getLanguage() == JSTypeSource.SourceLanguage.JS ? ((name = function.getQualifiedName()) != null ? JSNamedType.createType(name, source, JSContext.STATIC) : JSNamedType.createType("Function", source, JSContext.INSTANCE)) : JSNamedType.createType("Function", source, JSContext.INSTANCE);
                this.addType(functionType, (PsiElement)function);
                if (this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
                    this.addType(JSNamedType.createType("Object", source, JSContext.STATIC), (PsiElement)function);
                }
            }
            hasSomeType = true;
        } else {
            hasSomeType = this.myContext.processWithoutTopJSElementToApply((Processor<JSApplyContextElement>)((Processor)pop -> {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$processFunction$16"));
                }
                boolean hasSomeTypeInner = false;
                JSType s = null;
                Object callExpression = pop instanceof JSApplyCallElement ? ((JSApplyCallElement)pop).getCallExpression() : ((JSApplyInstanceContextElement)pop).getNewExpression();
                boolean isNewCall = callExpression instanceof JSNewExpression;
                if (isNewCall) {
                    JSClass parentClass;
                    if (function.isConstructor() && (parentClass = JSUtils.getMemberContainingClass((PsiElement)function)) != null) {
                        String qName = parentClass.getQualifiedName();
                        if (qName != null) {
                            JSType type = JSNamedType.createType(qName, JSTypeSourceFactory.createTypeSource((PsiElement)parentClass, false), JSContext.INSTANCE);
                            this.addType(type, (PsiElement)parentClass);
                            hasSomeTypeInner = true;
                        }
                    } else if (function instanceof JSFunctionExpression && function.getName() == null && function.getParent() instanceof ES6ExportDefaultAssignment) {
                        s = JSNamedType.createExplicitlyDeclaredType("\"default\"", (PsiElement)function);
                    } else {
                        String name = JSTypeEvaluator.getElementQName((JSNamedElement)function);
                        if (name != null) {
                            s = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)function), JSTypeContext.INSTANCE);
                        }
                    }
                } else {
                    s = JSFunctionImpl.getReturnTypeInContext(function, (PsiElement)this.myContext.getProcessedExpression());
                    if (!JSTypeUtils.isRestrictiveType(s) && !DialectDetector.isTypeScript((PsiElement)function)) {
                        Collection<JSObjectLiteralExpression> objectLiterals = JSStubBasedPsiTreeUtil.findReturnedExpressions(function, JSObjectLiteralExpression.class);
                        for (JSObjectLiteralExpression objectLiteral : objectLiterals) {
                            this.addTypeFromObjectLiteralExpression(objectLiteral, false);
                        }
                        if (!objectLiterals.isEmpty()) {
                            s = null;
                        }
                    }
                }
                if (s != null) {
                    JSExpression methodExpression = callExpression != null ? callExpression.getMethodExpression() : null;
                    s = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(s, methodExpression, (PsiElement)function);
                    this.addType(s, null);
                    hasSomeTypeInner = true;
                }
                return hasSomeTypeInner;
            }));
        }
        return hasSomeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefExpr(@NotNull JSReferenceExpression expression) {
        JSNamespaceEvaluationResult ns;
        JSExpression qualifier;
        JSExpression exprQualifier;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processRefExpr"));
        }
        String referenceName = expression.getReferenceName();
        if ("prototype".equals(referenceName) && !DialectDetector.isTypeScript((PsiElement)expression) && (exprQualifier = expression.getQualifier()) instanceof JSReferenceExpression) {
            this.myContext.processWithJSElementToApply(JSApplyInstanceContextElement.INSTANCE, () -> this.processRefExpr((JSReferenceExpression)exprQualifier));
            return;
        }
        if ("constructor".equals(referenceName) && DialectDetector.isJavaScript((PsiElement)expression) && (qualifier = expression.getQualifier()) != null) {
            this.myContext.processWithJSElementToApply(JSApplyStaticContextElement.INSTANCE, () -> this.evaluateTypes(qualifier));
            return;
        }
        if (JSSymbolUtil.isExplicitExportReference(expression) && DialectDetector.isJavaScript((PsiElement)expression)) {
            JSTypeEvaluator.addDefaultExportNamespaces((PsiElement)expression, JSContext.STATIC, this.myContext, this.myTypeProcessor);
            return;
        }
        boolean unqualified = expression.getQualifier() == null;
        ResolveResult[] resolveResults = this.getResolveResultsFromQualifier(expression);
        boolean hasSomeType = false;
        if (unqualified && (ns = this.evaluateNamespaceLocally(expression)) != null) {
            ns = ns.withExplicitlyDeclared(false);
            this.addNamespace(ns, (PsiElement)expression);
            JSElement exprForClassExtending = ns.getSource();
            if (exprForClassExtending instanceof JSReferenceExpression) {
                this.addAdditionalTypes((JSReferenceExpression)exprForClassExtending, (JSReferenceExpression)exprForClassExtending);
            }
            hasSomeType = true;
        }
        if (resolveResults.length > 0 && !JSTypeEvaluator.shouldSkipProcessing(resolveResults)) {
            boolean wasGuessed = this.myContext.isTypeGuessed();
            JSReferenceExpression previousProcessedExpression = this.myContext.getProcessedExpression();
            try {
                this.myContext.setTypeIsGuessed(wasGuessed || !this.qualifierTypeIsExplicitlyDeclared(expression.getQualifier()));
                this.myContext.setProcessedExpression(expression);
                for (ResolveResult r : resolveResults) {
                    PsiElement element = r.getElement();
                    if (element == null) continue;
                    hasSomeType &= this.addTypeFromResolveResult(element, hasSomeType);
                }
            }
            finally {
                this.myContext.setTypeIsGuessed(wasGuessed);
                this.myContext.setProcessedExpression(previousProcessedExpression);
            }
        }
        if (!DialectDetector.isActionScript((PsiElement)expression)) {
            JSReferenceExpression localQualifier = JSUtils.findRefExprThatStartCallChaining(expression);
            JSNamespaceEvaluationResult ns2 = JSSymbolUtil.evaluateNamespaceLocally(localQualifier);
            if (ns2 != null && ns2.getSource() instanceof JSReferenceExpression) {
                localQualifier = (JSReferenceExpression)ns2.getSource();
            }
            hasSomeType |= this.addAdditionalTypes(localQualifier, expression);
        }
        if (resolveResults.length == 0 && !hasSomeType) {
            JSType typeFromReferenceExpression = JSSymbolUtil.createTypeFromReferenceExpression(expression, JSTypeContext.STATIC);
            if (typeFromReferenceExpression != null && this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
                this.addType(typeFromReferenceExpression, (PsiElement)expression);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)expression);
            }
        }
    }

    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        ResolveResult[] resolveResultArray = qualifier.multiResolve(false);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        return resolveResultArray;
    }

    @Nullable
    protected JSNamespaceEvaluationResult evaluateNamespaceLocally(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateNamespaceLocally"));
        }
        return DialectDetector.isTypeScript((PsiElement)expression) ? null : JSSymbolUtil.evaluateNamespaceLocally(expression);
    }

    private static boolean shouldSkipProcessing(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "shouldSkipProcessing"));
        }
        if (resolveResults.length < 20) {
            return false;
        }
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (element instanceof TypeScriptModule || element instanceof TypeScriptInterface || element instanceof TypeScriptClass) continue;
            return true;
        }
        return false;
    }

    protected boolean addTypeFromResolveResult(@NotNull PsiElement resolveResult, boolean hasSomeType) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromResolveResult"));
        }
        this.myContext.setSource(resolveResult);
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            if (!handler.addTypeFromResolveResult(this, resolveResult, hasSomeType)) continue;
            return true;
        }
        if (resolveResult instanceof JSVariable) {
            this.addTypeFromVariableResolveResult((JSVariable)resolveResult);
        } else {
            hasSomeType = this.addTypeFromElementResolveResult(resolveResult, hasSomeType);
        }
        return hasSomeType;
    }

    protected boolean qualifierTypeIsExplicitlyDeclared(@Nullable JSExpression qualifier) {
        return true;
    }

    protected void addTypeFromVariableResolveResult(@NotNull JSVariable jsVariable) {
        boolean haveExplicitType;
        String name;
        if (jsVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsVariable", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromVariableResolveResult"));
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        boolean wasGuessed = this.myContext.isTypeGuessed();
        int jsElementsToApplySize = this.myContext.getJSElementsToApply().size();
        JSType variableType = jsVariable.getType();
        boolean isDestructuringType = variableType instanceof JSDestructuringTypeImpl;
        if (isDestructuringType) {
            variableType = null;
        }
        if (variableType == null && jsVariable instanceof JSParameter && this.isFromCurrentFile((PsiElement)jsVariable)) {
            if (this.addTypeFromAmdModuleReference((JSParameter)jsVariable)) {
                return;
            }
            variableType = JSContextTypeEvaluator.getParameterType((JSParameter)jsVariable, this.myContext);
        }
        if (jsVariable instanceof JSParameter && ((JSParameter)jsVariable).isRest()) {
            JSTypeSource typeSource = variableType != null ? variableType.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)jsVariable, ((JSParameter)jsVariable).getTypeDecorator().isExplicitlyDeclared());
            variableType = new JSArrayTypeImpl(variableType, typeSource);
        }
        variableType = this.substituteThisType(variableType, jsVariable);
        if (expression != null && JSTypeGuardChecker.isAvailable((PsiElement)expression, variableType) && (name = jsVariable.getName()) != null) {
            variableType = new JSTypeGuardChecker((PsiElement)expression, variableType, name).getNarrowedType();
        }
        if (haveExplicitType = this.useVariableType(variableType)) {
            this.addType(variableType, EXPLICIT_TYPE_MARKER_ELEMENT);
        }
        if (!haveExplicitType) {
            JSFunctionExpression functionExpression = jsVariable.tryGetFunctionExpressionInitializer();
            if (functionExpression != null) {
                this.processFunction((JSFunction)functionExpression);
            } else if (this.isFromCurrentFile((PsiElement)jsVariable)) {
                JSExpression initializer;
                boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)jsVariable);
                int sizeBefore = this.myContext.getJSElementsToApply().size();
                Condition condition = owner -> {
                    if (isTypeScript) {
                        if (JSDestructuringUtil.isDestructuring(owner.getParent())) {
                            return false;
                        }
                        if (owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getTypeElement() != null) {
                            return true;
                        }
                    }
                    return owner.getInitializer() != null;
                };
                JSInitializerOwner initializerOwner = JSDestructuringUtil.findDestructuringParent((JSElement)jsVariable, this.myContext, (Condition<JSInitializerOwner>)condition);
                JSExpression jSExpression = initializer = initializerOwner != null ? initializerOwner.getInitializer() : null;
                if (initializer != null) {
                    this.addTypeFromInitializer(initializer, isDestructuringType);
                } else if (isTypeScript && initializerOwner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)initializerOwner).getTypeElement() != null) {
                    this.myContext.setTypeIsGuessed(!isDestructuringType);
                    this.addType(((JSTypeDeclarationOwner)initializerOwner).getType(), (PsiElement)initializerOwner);
                } else if (expression != null) {
                    PsiElement grandParent;
                    boolean hasSomeInfoAboutVar = false;
                    if (expression.getQualifier() == null && !DialectDetector.isTypeScript((PsiElement)expression)) {
                        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(expression.getText(), true, new ResolveResultSink(null, expression.getText()));
                        hasSomeInfoAboutVar = this.findDef(expression, processor);
                    }
                    if (!hasSomeInfoAboutVar && variableType == null && (grandParent = jsVariable.getParent().getParent()) instanceof JSForInStatement && jsVariable.getParent() == ((JSForInStatement)grandParent).getDeclarationStatement()) {
                        variableType = this.getLoopVarType(expression, (PsiElement)jsVariable, (JSForInStatement)grandParent);
                    }
                    if (!hasSomeInfoAboutVar && variableType == null) {
                        this.myTypeProcessor.setUnknownElement((PsiElement)jsVariable);
                    }
                }
                while (this.myContext.getJSElementsToApply().size() > sizeBefore) {
                    this.myContext.popJSElementToApply();
                }
            }
        }
        if (!(isDestructuringType || haveExplicitType && JSTypeUtils.isStrictType(variableType))) {
            this.addNamespaceFromQualifiedNamedElement((JSQualifiedNamedElement)jsVariable);
        }
        this.myContext.setTypeIsGuessed(wasGuessed);
        while (this.myContext.getJSElementsToApply().size() > jsElementsToApplySize) {
            this.myContext.popJSElementToApply();
        }
    }

    public void addTypeFromInitializer(JSExpression initializer, boolean isDestructuringType) {
        boolean inCall;
        boolean bl = inCall = !this.myContext.isJSElementsToApplyEmpty();
        if (!inCall && this.isNullLiteral(initializer)) {
            this.addType(JSAnyType.get((PsiElement)initializer, false), (PsiElement)initializer);
        } else {
            this.myContext.setTypeIsGuessed(!isDestructuringType);
            this.evaluateCachedTypes(initializer);
        }
    }

    public void evaluateDestructuringContainer(@NotNull JSDestructuringContainer destructuringContainer) {
        JSExpression initializer;
        if (destructuringContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringContainer", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateDestructuringContainer"));
        }
        JSInitializerOwner initializerOwner = JSDestructuringUtil.findDestructuringParent((JSElement)destructuringContainer, this.myContext, (Condition<JSInitializerOwner>)((Condition)e -> e.getInitializer() != null));
        JSExpression jSExpression = initializer = initializerOwner != null ? initializerOwner.getInitializer() : null;
        if (initializer != null) {
            this.addTypeFromInitializer(initializer, true);
        }
    }

    private boolean isNullLiteral(JSExpression initializer) {
        return initializer instanceof JSLiteralExpression && initializer.getNode().findChildByType(JSTokenTypes.NULL_KEYWORD) != null;
    }

    protected JSType substituteThisType(JSType type, JSVariable jsVariable) {
        return type;
    }

    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromAmdModuleReference"));
        }
        boolean result = false;
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(parameter);
        if (amdModuleReference != null) {
            PsiReference[] references = amdModuleReference.getReferences();
            Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)parameter, references);
            for (PsiElement resolve : modules) {
                if (resolve instanceof JSFile) {
                    this.addTypeFromModuleFile((JSFile)resolve);
                    result = true;
                    continue;
                }
                if (!(resolve instanceof JSImplicitElement) || !JSAmdPsiUtil.isAmdModuleName((JSImplicitElement)resolve)) continue;
                PsiElement parent = resolve.getParent();
                assert (parent instanceof JSLiteralExpression);
                String moduleName = ((JSImplicitElement)resolve).getName();
                JSType type = JSNamedType.createType(moduleName, JSTypeSourceFactory.createTypeSource(resolve, true), JSContext.STATIC);
                this.addType(type, EXPLICIT_TYPE_MARKER_ELEMENT);
                result = true;
            }
        }
        return result;
    }

    protected boolean useVariableType(JSType type) {
        return type != null;
    }

    public boolean isFromCurrentFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "isFromCurrentFile"));
        }
        JSReferenceExpression context = this.myContext.getProcessedExpression();
        if (context == null) {
            context = this.myContext.targetFile;
        }
        return context != null && context.getContainingFile().isEquivalentTo((PsiElement)element.getContainingFile());
    }

    private void evaluateCachedTypes(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateCachedTypes"));
        }
        if (!this.myContext.isJSElementsToApplyEmpty()) {
            this.doEvaluateTypes(expression, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
            return;
        }
        JSTypeEvaluationResult result = JSTypeEvaluator.getExpressionType(expression);
        if (result != null) {
            List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                this.addTypeEvaluationResultElement(element);
            }
        }
    }

    protected boolean processInstanceContextForClass(@NotNull JSClass jsClass, boolean hasSomeType) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processInstanceContextForClass"));
        }
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        assert (peek instanceof JSApplyInstanceContextElement);
        JSFunction function = this.getClassConstructor(jsClass);
        this.addTypeFromClass((PsiElement)jsClass, (PsiElement)function);
        return true;
    }

    protected boolean addTypeFromElementResolveResult(PsiElement resolveResult, boolean hasSomeType) {
        if (resolveResult instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolveResult;
            boolean typeAdded = false;
            String typeString = implicitElement.getTypeString();
            if (typeString != null) {
                JSType type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource(resolveResult, true));
                this.addType(type, resolveResult);
                typeAdded = true;
            }
            if (!typeAdded && implicitElement.getType().providesNamespace()) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(resolveResult, implicitElement.isNamespaceExplicitlyDeclared());
                JSType jsType = JSNamedType.createType(implicitElement.getQualifiedName(), typeSource, JSContext.STATIC);
                this.addType(jsType, resolveResult);
            } else {
                JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)implicitElement), JSContext.STATIC, implicitElement.isNamespaceExplicitlyDeclared());
                this.addNamespace(namespace, resolveResult);
            }
            return true;
        }
        if (resolveResult instanceof JSProperty) {
            hasSomeType |= this.addTypeFromProperty((JSProperty)resolveResult);
        } else if (resolveResult instanceof JSClass && this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
            hasSomeType = this.processInstanceContextForClass((JSClass)resolveResult, hasSomeType);
        } else if (resolveResult instanceof JSClass || resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor() && resolveResult.getParent() instanceof JSClass) {
            this.addTypeFromClass(resolveResult, null);
            hasSomeType = true;
        } else if (resolveResult instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)resolveResult, false);
        } else if (resolveResult instanceof JSDefinitionExpression) {
            JSType parameterType = null;
            PsiElement resolveResultParent = resolveResult.getParent();
            if (resolveResultParent instanceof JSForInStatement && resolveResult == ((JSForInStatement)resolveResultParent).getVariableExpression()) {
                parameterType = this.getLoopVarType(this.myContext.getProcessedExpression(), resolveResult, (JSForInStatement)resolveResultParent);
            }
            if (parameterType == null) {
                this.addTypeFromDefExpr((JSDefinitionExpression)resolveResult);
            }
            hasSomeType = true;
        } else if (this.addTypeFromDialectSpecificElements(resolveResult)) {
            hasSomeType = true;
        } else if (resolveResult instanceof JSFunction) {
            if (this.processFunction((JSFunction)resolveResult)) {
                hasSomeType = true;
            }
        } else if (resolveResult instanceof JSNamedElement) {
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)resolveResult);
            if (name != null) {
                JSType jsType = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(resolveResult), JSContext.STATIC);
                this.addType(jsType, resolveResult);
            }
        } else if (resolveResult instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression((JSExpression)resolveResult);
            hasSomeType = true;
        } else if (resolveResult instanceof JSExpressionStatement) {
            String type;
            String s = JSDocumentationUtils.findType(resolveResult);
            if (BaseJSSymbolProcessor.isValidType(s) && (type = JSImportHandlingUtil.resolveTypeName(s, resolveResult)) != null) {
                this.addType(type, null);
                hasSomeType = true;
            }
        } else if (resolveResult instanceof JsonElement) {
            this.applyContextAndProcessResolvedElement(resolveResult);
            hasSomeType = true;
        }
        if (!hasSomeType && resolveResult != null) {
            this.myTypeProcessor.setUnknownElement(resolveResult);
        }
        return hasSomeType;
    }

    private boolean addTypeFromProperty(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromProperty"));
        }
        boolean typeAdded = false;
        JSType jsType = property.getType();
        if (jsType != null) {
            this.addType(jsType, (PsiElement)property);
            typeAdded = true;
        } else if (this.tryAddTypeFromInitializerReference((PsiElement)property)) {
            typeAdded = true;
        } else {
            JSExpression value;
            String qualifiedName;
            JSFunction functionInitializer = property.tryGetFunctionInitializer();
            JSObjectLiteralExpression objectLiteralExpression = property.getObjectLiteralExpressionInitializer();
            boolean providesNamespace = functionInitializer != null && !functionInitializer.isGetProperty() && !functionInitializer.isSetProperty() || objectLiteralExpression != null;
            boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)property);
            if (!isTypeScript && providesNamespace && (qualifiedName = property.getQualifiedName()) != null) {
                JSType type = JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)property, false), JSContext.STATIC);
                this.addType(type, (PsiElement)property);
                typeAdded = true;
            }
            if (functionInitializer != null || objectLiteralExpression != null) {
                boolean wasGuessed = this.myContext.isTypeGuessed();
                this.myContext.setTypeIsGuessed(!isTypeScript);
                if (functionInitializer != null) {
                    typeAdded |= this.processFunction(functionInitializer);
                } else {
                    this.addTypeFromObjectLiteralExpression(objectLiteralExpression, false);
                }
                this.myContext.setTypeIsGuessed(wasGuessed);
            } else if (this.isFromCurrentFile((PsiElement)property) && (value = property.getValue()) != null) {
                this.evaluateCachedTypes(value);
            }
        }
        return typeAdded;
    }

    protected void addNamespaceFromQualifiedNamedElement(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addNamespaceFromQualifiedNamedElement"));
        }
        JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)element), JSContext.STATIC, false);
        this.addNamespace(namespace, (PsiElement)element);
    }

    protected void addTypeFromClass(@NotNull PsiElement resolveResult, @Nullable PsiElement constructor) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromClass"));
        }
    }

    @Nullable
    protected JSFunction getClassConstructor(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getClassConstructor"));
        }
        return resolveResult.getConstructor();
    }

    private JSType getLoopVarType(@Nullable JSReferenceExpression expression, PsiElement element, JSForInStatement forInStatement) {
        JSType parameterType;
        if (forInStatement.isForEach()) {
            parameterType = this.evalComponentTypeFromArrayExpression((JSExpression)expression, forInStatement.getCollectionExpression());
        } else {
            parameterType = JSNamedType.createType("string", JSTypeSourceFactory.createTypeSource(element, DialectDetector.isTypeScript(element)), JSContext.INSTANCE);
            this.addType(parameterType, element);
        }
        return parameterType;
    }

    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        return false;
    }

    @Nullable
    public JSType evalComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        if (collectionExpression == null) {
            return null;
        }
        JSTypeEvaluationResult result = JSTypeEvaluator.getExpressionType(collectionExpression);
        if (result == null) {
            return null;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
        JSType type = JSTypeUtils.getValuableType(result.getType());
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            JSExpression indexExpression;
            int index = -1;
            if (rawqualifier instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral()) {
                Object value = ((JSLiteralExpression)indexExpression).getValue();
                assert (value instanceof Double || value instanceof Long) : indexExpression.getText();
                if (value instanceof Long && (Long)value >= 0L && (Long)value <= Integer.MAX_VALUE) {
                    index = Math.toIntExact((Long)value);
                }
            }
            boolean processed = false;
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                PsiElement source = element.getSource();
                if (source instanceof JsonFile) {
                    source = ((JsonFile)source).getTopLevelValue();
                }
                if (source instanceof JSArrayLiteralExpression) {
                    JSExpression[] expressions = ((JSArrayLiteralExpression)source).getExpressions();
                    if (index >= 0 && index < expressions.length) {
                        this.addTypeFromElementResolveResult((PsiElement)expressions[index], false);
                        processed = true;
                        continue;
                    }
                    for (JSExpression expr : expressions) {
                        if (!(expr instanceof JSObjectLiteralExpression)) continue;
                        this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expr, false);
                        processed = true;
                    }
                    continue;
                }
                if (!(source instanceof JsonArray)) continue;
                List values = ((JsonArray)source).getValueList();
                if (index < 0 || index >= values.size()) continue;
                this.applyContextAndProcessResolvedElement((PsiElement)values.get(index));
                processed = true;
            }
            if (!processed && type instanceof JSTupleTypeImpl) {
                List<JSType> types = ((JSTupleTypeImpl)type).getTypes();
                if (index >= 0 && index < types.size()) {
                    JSType jsType = types.get(index);
                    this.addType(jsType, (PsiElement)rawqualifier);
                    return jsType;
                }
            }
        }
        return this.addComponentTypeFromProcessor(rawqualifier, type);
    }

    @Nullable
    public JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) != null) {
            if (type instanceof JSCompositeTypeImpl) {
                for (JSType typeOption : ((JSCompositeTypeImpl)type).getTypes()) {
                    this.addComponentTypeFromProcessor(rawqualifier, typeOption);
                }
                return null;
            }
            JSTypeSource source = type.getSource();
            if ((type = JSTypeUtils.getIndexableComponentType(type)) == null) {
                type = JSAnyType.get((PsiElement)rawqualifier, false);
            }
            type = JSTypeUtils.copyWithExplicitlyDeclared(type, source.isExplicitlyDeclared() && type.getSource().isExplicitlyDeclared());
            this.addType(type, (PsiElement)rawqualifier);
            return type;
        }
        return null;
    }

    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromLiteralExpression"));
        }
        JSType type = JSTypeEvaluator.getTypeFromConstant(rawqualifier);
        if (type != null) {
            this.addType(type, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    public static JSType getTypeFromConstant(@NotNull JSExpression rawqualifier) {
        String literalText;
        String text;
        String type;
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getTypeFromConstant"));
        }
        ASTNode childNode = rawqualifier.getNode().getFirstChildNode();
        IElementType constantType = childNode.getElementType();
        String string = constantType == JSTokenTypes.STRING_LITERAL || constantType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL || constantType == JSTokenTypes.BACKQUOTE ? "string" : (constantType == JSTokenTypes.NUMERIC_LITERAL ? "number" : (constantType == JSTokenTypes.REGEXP_LITERAL ? "RegExp" : (constantType == JSTokenTypes.XML_START_TAG_START ? "XML" : (constantType == JSTokenTypes.XML_START_TAG_LIST ? "XMLList" : (constantType == JSTokenTypes.TRUE_KEYWORD || constantType == JSTokenTypes.FALSE_KEYWORD ? "boolean" : (constantType == JSTokenTypes.NULL_KEYWORD && !DialectDetector.isActionScript((PsiElement)rawqualifier) ? "null" : (type = constantType == JSTokenTypes.UNDEFINED_KEYWORD && !DialectDetector.isActionScript((PsiElement)rawqualifier) ? "undefined" : null)))))));
        if (type == "number" && DialectDetector.isActionScript((PsiElement)rawqualifier) && (text = childNode.getText()).indexOf(46) == -1) {
            type = "int";
        }
        if ((type == "XMLList" || type == "XML") && DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            type = null;
        }
        if (type == "string" && (literalText = childNode.getText()).length() >= 2) {
            return new JSStringLiteralTypeImpl(literalText.substring(1, literalText.length() - 1), JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true));
        }
        if (type != null) {
            return JSNamedType.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        }
        return null;
    }

    private boolean addAdditionalTypes(@NotNull JSReferenceExpression localQualifier, @NotNull JSReferenceExpression qualifier) {
        JSTypeSource typeSource;
        JSApplyContextElement peek;
        if (localQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localQualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addAdditionalTypes"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addAdditionalTypes"));
        }
        if (DialectDetector.isTypeScript((PsiElement)localQualifier)) {
            return false;
        }
        boolean hasSomeType = false;
        String localQualifierText = localQualifier.getText();
        if ("$".equals(localQualifierText) || "jQuery.$".equals(localQualifierText)) {
            peek = this.myContext.peekJSElementToApply();
            if (peek instanceof JSApplyCallElement) {
                this.myContext.popJSElementToApply();
            }
            typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)localQualifier, false);
            this.addType(JSNamedType.createType("jQuery", typeSource, JSContext.UNKNOWN), (PsiElement)localQualifier);
            if (peek instanceof JSApplyCallElement) {
                this.myContext.pushJSElementToApply(peek);
            }
            hasSomeType = true;
        }
        if ("$".equals(qualifier.getText())) {
            peek = this.myContext.peekJSElementToApply();
            if (peek instanceof JSApplyCallElement) {
                this.myContext.popJSElementToApply();
            }
            typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)localQualifier, false);
            this.addType(JSNamedType.createType("HTMLElement", typeSource, JSContext.UNKNOWN), (PsiElement)localQualifier);
            if (peek instanceof JSApplyCallElement) {
                this.myContext.pushJSElementToApply(peek);
            }
            hasSomeType = true;
        } else if ("getComponentById".equals(qualifier.getReferencedName())) {
            hasSomeType |= this.tryAddBindowsType(qualifier);
        }
        return hasSomeType;
    }

    private boolean tryAddBindowsType(JSReferenceExpression qualifier) {
        JSIndexContent content;
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies;
        PsiFile containingFile;
        PsiElement element = qualifier.getParent();
        if (!(element instanceof JSCallExpression)) {
            return false;
        }
        JSArgumentList argumentList = ((JSCallExpression)element).getArgumentList();
        if (argumentList == null) {
            return false;
        }
        JSExpression[] expressions = argumentList.getArguments();
        if (expressions.length == 0 || !(expressions[0] instanceof JSLiteralExpression)) {
            return false;
        }
        String val = StringUtil.unquoteString((String)expressions[0].getText());
        PsiElement contextElement = qualifier.getContainingFile().getContext();
        if (contextElement != null && JSTagContextBuilder.isBindowsXml(containingFile = contextElement.getContainingFile()) && (proxies = (content = JSIndexContent.get(containingFile)).getImplicitElements().get(val)) != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                XmlTag tag;
                PsiElement elementAtOffset = proxy.toOffsetBasedImplicitElement(containingFile).getElementAtOffset();
                if (elementAtOffset == null || (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, XmlTag.class)) == null) continue;
                JSType type = JSNamedType.createType(JSTagContextBuilder.getTypeName(tag), JSTypeSourceFactory.createTypeSource(elementAtOffset), JSContext.UNKNOWN);
                this.myTypeProcessor.process(type, this.myContext, elementAtOffset);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String getElementQName(JSNamedElement psiElement) {
        String name = null;
        if (psiElement instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        if (name == null) {
            name = psiElement.getName();
        }
        return name;
    }

    private void addTypeFromObjectLiteralExpression(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        if (peek instanceof JSApplyPropertyElement) {
            this.myContext.processWithoutTopJSElementToApply(() -> {
                String name = ((JSApplyPropertyElement)peek).getName();
                JSProperty property = expression.findProperty(name);
                if (property != null) {
                    this.addTypeFromProperty(property);
                }
            });
            return;
        }
        JSType recordType = JSTypeEvaluator.getObjectLiteralType(expression, evaluatePropertyTypes);
        this.myTypeProcessor.process(recordType, this.myContext, (PsiElement)expression);
        for (String extendedType : expression.getExtendedTypes()) {
            JSNamespace namespace = JSNamespaceImpl.fromNamepath(extendedType, true);
            this.addNamespace(namespace, (PsiElement)expression);
        }
    }

    @NotNull
    protected static JSType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            JSObjectType jSObjectType = new JSObjectType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, false), JSTypeContext.UNKNOWN);
            if (jSObjectType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getObjectLiteralType"));
            }
            return jSObjectType;
        }
        JSProperty[] properties = expression.getProperties();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, DialectDetector.isTypeScript((PsiElement)expression));
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        for (JSProperty property : properties) {
            String name = property.getName();
            if (name == null && property instanceof JSComputedPropertyNameOwner) {
                name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)property);
            }
            if (name == null) continue;
            TypeScriptJSFunctionTypeImpl type = null;
            if (evaluatePropertyTypes) {
                type = property instanceof ES6FunctionProperty ? TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl((JSFunction)((ES6FunctionProperty)property)) : JSResolveUtil.getExpressionJSType(property.getValue());
            }
            typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, (PsiElement)property));
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(typeSource, typeMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getObjectLiteralType"));
        }
        return jSRecordTypeImpl;
    }

    private boolean findDef(@NotNull JSReferenceExpression qualifier, @NotNull SinkResolveProcessor processor) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "findDef"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "findDef"));
        }
        PsiElement parent = qualifier.getParent();
        JSResolveUtil.treeWalkUp(processor, (PsiElement)qualifier, parent, (PsiElement)qualifier);
        PsiElement jsElement = processor.getResult();
        if (jsElement instanceof JSDefinitionExpression) {
            this.addTypeFromDefExpr((JSDefinitionExpression)jsElement);
            return true;
        }
        return false;
    }

    private void addTypeFromDefExpr(@NotNull JSDefinitionExpression psiElement) {
        JSFunctionExpression initializer;
        boolean canHaveType;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromDefExpr"));
        }
        JSType jsType = psiElement.getType();
        if (jsType != null) {
            this.addType(jsType, (PsiElement)psiElement);
            if (jsType.getSource().isExplicitlyDeclared()) {
                return;
            }
        }
        boolean bl = canHaveType = (initializer = psiElement.tryGetFunctionExpressionInitializer()) != null && !this.myContext.isJSElementsToApplyEmpty();
        if (canHaveType && this.processFunction((JSFunction)initializer)) {
            return;
        }
        String type = psiElement.getQualifiedName();
        boolean initializerProcessed = false;
        if (this.isFromCurrentFile((PsiElement)psiElement)) {
            JSExpression expr = JSPsiImplUtils.getRightmostOperand(psiElement);
            boolean bl2 = initializerProcessed = expr != null && this.processItem(psiElement, JSEvaluateContext.JSEvaluationPlace.DEFAULT, expression -> this.evaluateCachedTypes(expr));
        }
        if (!canHaveType && jsType == null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)psiElement);
        }
        if (!initializerProcessed) {
            this.tryAddTypeFromInitializerReference((PsiElement)psiElement);
        }
        if (psiElement.isNamespaceExplicitlyDeclared() && type != null) {
            JSContext jsContext = this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement ? JSContext.INSTANCE : JSContext.STATIC;
            JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)psiElement);
            boolean explicitType = comment != null && comment.hasNamespaceTag();
            JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(type), jsContext, explicitType);
            this.addNamespace(namespace, (PsiElement)(explicitType ? EXPLICIT_TYPE_MARKER_ELEMENT : psiElement));
        }
    }

    private boolean tryAddTypeFromInitializerReference(@NotNull PsiElement resolveResult) {
        String initializerReference;
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "tryAddTypeFromInitializerReference"));
        }
        String string = resolveResult instanceof JSDefinitionExpression ? ((JSDefinitionExpression)resolveResult).getInitializerReference() : (resolveResult instanceof JSProperty ? ((JSProperty)resolveResult).getInitializerReference() : (initializerReference = resolveResult instanceof JSVariable ? ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText() : null));
        if (initializerReference == null || StringUtil.isQuotedString((String)initializerReference)) {
            return false;
        }
        PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult.getContext());
        if (localResolve instanceof JSQualifiedNamedElement) {
            this.processItem(localResolve, JSEvaluateContext.JSEvaluationPlace.DEFAULT, e -> this.addTypeFromResolveResult((PsiElement)e, false));
            return true;
        }
        return false;
    }

    private void simpleEvalType(JSExpression rawqualifier, JSExpression lOperand) {
        JSType evaluatedType = JSResolveUtil.getExpressionJSType(lOperand);
        if (evaluatedType != null) {
            this.addType(evaluatedType, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    protected <T extends PsiElement> boolean processItem(@NotNull T element, @NotNull JSEvaluateContext.JSEvaluationPlace place, @NotNull Consumer<T> runnable) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processItem"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processItem"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processItem"));
        }
        if (!JSTypeEvaluator.processWithEvaluationGuard(element, place, runnable)) {
            if (this.myTypeProcessor instanceof QualifiedItemProcessor) {
                ((QualifiedItemProcessor)this.myTypeProcessor).resolved = QualifiedItemProcessor.TypeResolveState.Undefined;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PsiElement> boolean processWithEvaluationGuard(@NotNull T element, @NotNull JSEvaluateContext.JSEvaluationPlace place, @NotNull Consumer<T> runnable) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processWithEvaluationGuard"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processWithEvaluationGuard"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processWithEvaluationGuard"));
        }
        JSRecursionGuard context = recursionGuardHolder.get();
        boolean created = false;
        if (context == null) {
            context = new JSRecursionGuard();
            recursionGuardHolder.set(context);
            created = true;
        }
        if (!created && context.isAlreadyProcessingItem(element, place)) {
            return false;
        }
        try {
            context.addProcessingItem(element, place);
            runnable.accept(element);
            boolean bl = true;
            return bl;
        }
        finally {
            context.removeProcessingItem(element, place);
            if (created) {
                recursionGuardHolder.set(null);
            }
        }
    }

    private void applyContextAndProcessResolvedElement(@NotNull PsiElement resolve) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessResolvedElement"));
        }
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        if (peek instanceof JSApplyPropertyElement) {
            Ref result = Ref.create((Object)true);
            this.myContext.processWithoutTopJSElementToApply(() -> {
                if (resolve == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$applyContextAndProcessResolvedElement$24"));
                }
                result.set((Object)this.applyDestructuringPropertyAndProcessResolvedElement(resolve, (JSApplyPropertyElement)peek));
            });
            if (!((Boolean)result.get()).booleanValue()) {
                return;
            }
        }
        this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
    }

    private boolean applyDestructuringPropertyAndProcessResolvedElement(@NotNull PsiElement resolve, @NotNull JSApplyPropertyElement property) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyDestructuringPropertyAndProcessResolvedElement"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyDestructuringPropertyAndProcessResolvedElement"));
        }
        final String name = property.getName();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$2", "execute"));
                }
                if (!(element instanceof JSPsiNamedElementBase) || name.equals(((JSPsiNamedElementBase)element).getName())) {
                    JSTypeEvaluator.this.myTypeProcessor.processResolvedElement(element, JSTypeEvaluator.this.myContext);
                }
                return true;
            }
        };
        JSReferenceExpression place = this.myContext.getProcessedExpression();
        if (place == null) {
            place = resolve;
        }
        return QualifiedItemProcessor.processResolvedElement(resolve, this.myContext, processor, (PsiElement)place);
    }

    private /* synthetic */ void lambda$addTypeFromModuleFile$15(PsiElement finalExportedElement, @NotNull JSFile jsFile, JSType newType, JSEvaluationResultContext newContext) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$addTypeFromModuleFile$15"));
        }
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)typeComponent -> {
            if (jsFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "lambda$null$14"));
            }
            if (!(typeComponent instanceof JSNamedType && finalExportedElement instanceof JSElementBase && typeComponent.getTypeText().equals(((JSElementBase)finalExportedElement).getQualifiedName()))) {
                this.myContext.withJSModule((PsiFile)jsFile, () -> this.addType((JSType)typeComponent, null));
            }
            return true;
        }), newType);
    }
}

