/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.ES6SpreadPropertyImpl;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringUtil {
    @Nullable
    public static PsiElement getParentSkippingDestructuring(@NotNull JSVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getParentSkippingDestructuring"));
        }
        PsiElement parent = var.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static boolean isDestructuring(@Nullable PsiElement parent) {
        return parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement;
    }

    @Nullable
    public static ASTNode getParentSkippingDestructuring(@NotNull ASTNode varNode) {
        if (varNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varNode", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getParentSkippingDestructuring"));
        }
        ASTNode parent = varNode.getTreeParent();
        while (JSElementTypes.DESTRUCTURING_CONTAINERS.contains(parent.getElementType()) || JSElementTypes.DESTRUCTURING_ELEMENTS.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_PROPERTIES.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_ARRAY_REST == parent.getElementType()) {
            if ((parent = parent.getTreeParent()) != null) continue;
            return null;
        }
        return parent;
    }

    @Nullable
    public static JSExpression getNearestDestructuringInitializer(@NotNull JSVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getNearestDestructuringInitializer"));
        }
        PsiElement parent = var.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            JSExpression initializer;
            if (parent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parent).getInitializer()) != null) {
                return initializer;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static JSExpression getNearestDestructuringInitializer(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getNearestDestructuringInitializer"));
        }
        PsiElement parent = referenceExpression.getParent();
        while (parent instanceof JSProperty || parent instanceof JSObjectLiteralExpression || parent instanceof JSArrayLiteralExpression || parent instanceof JSSpreadExpression || parent instanceof ES6SpreadPropertyImpl) {
            parent = parent.getParent();
        }
        return parent instanceof JSDefinitionExpression ? ((JSDefinitionExpression)parent).getInitializer() : null;
    }

    @Nullable
    public static JSInitializerOwner findDestructuringParent(@NotNull JSElement destructuringElement, @NotNull JSEvaluateContext context, @NotNull Condition<JSInitializerOwner> parentCondition) {
        if (destructuringElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringElement", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "findDestructuringParent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "findDestructuringParent"));
        }
        if (parentCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCondition", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "findDestructuringParent"));
        }
        JSElement element = destructuringElement;
        while (element instanceof JSDestructuringContainer || element instanceof JSDestructuringElement || element instanceof JSDestructuringProperty || element instanceof JSDestructuringArrayRestElement || element instanceof JSInitializerOwner) {
            if (element instanceof JSInitializerOwner && parentCondition.value((Object)((JSInitializerOwner)element))) {
                return (JSInitializerOwner)element;
            }
            if (element instanceof JSDestructuringArray) {
                context.pushJSElementToApply(new JSApplyIndexedAccessElement((JSDestructuringArray)element, destructuringElement));
            } else if (element instanceof JSDestructuringProperty) {
                context.pushJSElementToApply(new JSApplyPropertyElement((JSDestructuringProperty)element));
            }
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    public static List<JSReferenceExpression> collectAssignmentTargets(@NotNull JSExpression pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "collectAssignmentTargets"));
        }
        assert (pattern instanceof JSObjectLiteralExpression || pattern instanceof JSArrayLiteralExpression);
        final ArrayList result = ContainerUtil.newArrayList();
        pattern.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                JSDefinitionExpression definition = node.getDefinitionExpression();
                if (definition != null) {
                    definition.accept((PsiElementVisitor)this);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                super.visitJSReferenceExpression(node);
                result.add(node);
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "collectAssignmentTargets"));
        }
        return arrayList;
    }
}

