/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierAliasBase;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportedExportedDefaultBindingImpl;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImportStatementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTreeUtil {
    @NotNull
    private static Map<String, JSScopeNameUsages> calcScopeNameUsage(final CompositeElement scope) {
        THashMap result = new THashMap();
        scope.acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor((Map)result){
            final /* synthetic */ Map val$result;
            {
                this.val$result = map;
            }

            protected void visitNode(TreeElement element) {
                IElementType type;
                String initializerReferenceName;
                String declaredName = JSTreeUtil.getDeclaredOrAssignedName(element);
                if (declaredName != null) {
                    JSScopeNameUsages declaredNameUsage = this.getOrCreateScopeNameUsage(declaredName);
                    declaredNameUsage.getDeclarationsAndAssignments().add((CompositeElement)element);
                }
                if ((initializerReferenceName = JSTreeUtil.getInitializerReferenceName(element)) != null) {
                    JSScopeNameUsages declaredNameUsage = this.getOrCreateScopeNameUsage(initializerReferenceName);
                    declaredNameUsage.getReferenceAssignments().add((CompositeElement)element);
                }
                if (ScopeTypesHolder.SCOPE_TYPES.contains(type = element.getElementType()) && element != scope) {
                    return;
                }
                super.visitNode(element);
            }

            @NotNull
            private JSScopeNameUsages getOrCreateScopeNameUsage(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSTreeUtil$1", "getOrCreateScopeNameUsage"));
                }
                JSScopeNameUsages scopeNameUsage = (JSScopeNameUsages)this.val$result.get(name);
                if (scopeNameUsage == null) {
                    scopeNameUsage = new JSScopeNameUsages();
                    this.val$result.put(name, scopeNameUsage);
                }
                JSScopeNameUsages jSScopeNameUsages = scopeNameUsage;
                if (jSScopeNameUsages == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSTreeUtil$1", "getOrCreateScopeNameUsage"));
                }
                return jSScopeNameUsages;
            }
        });
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "calcScopeNameUsage"));
        }
        return tHashMap;
    }

    public static boolean definedInScopeAndUp(@NotNull String name, @NotNull ASTNode scopeElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "definedInScopeAndUp"));
        }
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "definedInScopeAndUp"));
        }
        for (ASTNode parent = scopeElement; parent != null; parent = parent.getTreeParent()) {
            JSScopeDeclarationsAndAssignments declarationsAndAssignments;
            IElementType parentType = parent.getElementType();
            if (!ScopeTypesHolder.SCOPE_TYPES.contains(parentType) || (declarationsAndAssignments = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)parent)) == null || !declarationsAndAssignments.hasDeclarationOrAssignment(false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInScopeAndUp(@Nullable String name, @NotNull ASTNode scopeElement) {
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getDeclarationsAndAssignmentsInScopeAndUp"));
        }
        for (ASTNode parent = scopeElement; parent != null; parent = parent.getTreeParent()) {
            JSScopeDeclarationsAndAssignments declarationsAndAssignments;
            IElementType parentType = parent.getElementType();
            if (!ScopeTypesHolder.SCOPE_TYPES.contains(parentType) || (declarationsAndAssignments = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)parent)) == null) continue;
            return declarationsAndAssignments;
        }
        return null;
    }

    @Nullable
    public static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInScope(@Nullable String name, @NotNull CompositeElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getDeclarationsAndAssignmentsInScope"));
        }
        assert (ScopeTypesHolder.SCOPE_TYPES.contains(scope.getElementType())) : scope.getElementType() + " doesn't provide scope";
        return JSTreeUtil.getDeclarationsAndAssignmentsInCodeBlockInner(scope, name);
    }

    public static boolean definedOrAssignedInCodeBlock(@NotNull String name, boolean includeAssignments, @NotNull CompositeElement scope) {
        JSScopeDeclarationsAndAssignments declarationsAndAssignments;
        ASTNode parent;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "definedOrAssignedInCodeBlock"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "definedOrAssignedInCodeBlock"));
        }
        if (!(ScopeTypesHolder.SCOPE_TYPES.contains(scope.getElementType()) || !((parent = TreeUtil.findParent((ASTNode)scope, (TokenSet)ScopeTypesHolder.SCOPE_TYPES)) instanceof CompositeElement) || (declarationsAndAssignments = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)parent)) != null && declarationsAndAssignments.hasDeclarationOrAssignment(includeAssignments))) {
            return false;
        }
        JSScopeNameUsages nameUsages = JSTreeUtil.getNameUsagesInCodeBlockInner(scope, name);
        return nameUsages != null && nameUsages.getDeclarationsAndAssignments().hasDeclarationOrAssignment(includeAssignments);
    }

    @Nullable
    private static JSScopeDeclarationsAndAssignments getDeclarationsAndAssignmentsInCodeBlockInner(@NotNull CompositeElement scope, @Nullable String name) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getDeclarationsAndAssignmentsInCodeBlockInner"));
        }
        Map<String, JSScopeNameUsages> scopeNameUsage = JSTreeUtil.getScopeNameUsage(scope);
        if (name != null) {
            JSScopeNameUsages nameUsages = scopeNameUsage.get(name);
            return nameUsages != null ? nameUsages.getDeclarationsAndAssignments() : null;
        }
        JSScopeDeclarationsAndAssignments result = new JSScopeDeclarationsAndAssignments();
        for (JSScopeNameUsages nameUsages : scopeNameUsage.values()) {
            result.myElements.addAll(nameUsages.getDeclarationsAndAssignments().myElements);
        }
        return result;
    }

    private static Map<String, JSScopeNameUsages> getScopeNameUsage(@NotNull CompositeElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getScopeNameUsage"));
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)scope.getPsi(), () -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "lambda$getScopeNameUsage$0"));
            }
            return new CachedValueProvider.Result(JSTreeUtil.calcScopeNameUsage(scope), new Object[]{scope.getPsi()});
        });
    }

    @Nullable
    private static JSScopeNameUsages getNameUsagesInCodeBlockInner(@NotNull CompositeElement scope, @NotNull String name) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getNameUsagesInCodeBlockInner"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getNameUsagesInCodeBlockInner"));
        }
        return JSTreeUtil.getScopeNameUsage(scope).get(name);
    }

    @Nullable
    public static String getDeclaredOrAssignedName(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getDeclaredOrAssignedName"));
        }
        IElementType type = element.getElementType();
        ASTNode identifier = null;
        if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type)) {
            identifier = JSVariableBaseImpl.findVariableNameIdentifier((ASTNode)element);
        } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(type)) {
            identifier = JSPsiImplUtils.findNameIdentifierOfFunction((ASTNode)element);
        } else if (type == JSStubElementTypes.DEFINITION_EXPRESSION) {
            ASTNode expressionNode = JSDefinitionExpressionImpl.getExpressionNode((ASTNode)element);
            if (expressionNode != null && expressionNode.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(expressionNode) == null) {
                identifier = JSReferenceExpressionImpl.getNameElement(expressionNode);
            }
        } else if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(type) || type == JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS) {
            identifier = JSClassBase.findNameIdentifier((ASTNode)element);
        } else if (type == ES6ElementTypes.IMPORT_SPECIFIER || type == ES6ElementTypes.EXPORT_SPECIFIER) {
            if (element.findChildByType((IElementType)ES6ElementTypes.IMPORT_SPECIFIER_ALIAS) == null && element.findChildByType((IElementType)ES6ElementTypes.EXPORT_SPECIFIER_ALIAS) == null) {
                identifier = ES6ImportExportSpecifierBase.getDeclarationNameElement((ASTNode)element);
            }
        } else if (type == JSStubElementTypes.TYPESCRIPT_MODULE) {
            ASTNode moduleIdentifier = TypeScriptModuleImpl.findNameIdentifier((ASTNode)element);
            if (moduleIdentifier != null && !StringUtil.isQuotedString((String)moduleIdentifier.getText())) {
                identifier = moduleIdentifier;
            }
        } else {
            if (type == TypeScriptElementTypes.IMPLICIT_MODULE) {
                return ((TypeScriptImplicitModule)element.getPsi()).getName();
            }
            if (type == TypeScriptElementTypes.IMPORT_STATEMENT) {
                identifier = TypeScriptImportStatementImpl.findNameIdentifier((ASTNode)element);
            } else if (type == ES6ElementTypes.IMPORT_SPECIFIER_ALIAS || type == ES6ElementTypes.EXPORT_SPECIFIER_ALIAS) {
                identifier = ES6ImportExportSpecifierAliasBase.findNameIdentifier((ASTNode)element);
            } else if (type == ES6ElementTypes.IMPORTED_BINDING || type == ES6ElementTypes.EXPORTED_DEFAULT_BINDING) {
                identifier = ES6ImportedExportedDefaultBindingImpl.findNameIdentifier((ASTNode)element);
            } else assert (!JSStubBasedPsiTreeUtil.DECLARATIONS_TOKEN_SET.contains(type)) : type + " is not handled";
        }
        return identifier != null ? identifier.getText() : null;
    }

    @Nullable
    public static String getInitializerReferenceName(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getInitializerReferenceName"));
        }
        ASTNode initializer = JSTreeUtil.getInitializerNode((ASTNode)element);
        if (initializer != null && initializer.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode(initializer) == null) {
            return JSReferenceExpressionImpl.getReferenceName(initializer);
        }
        return null;
    }

    public static Language getLanguage(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getLanguage"));
        }
        FileElement fileElement = element instanceof TreeElement ? TreeUtil.getFileElement((TreeElement)((TreeElement)element)) : null;
        return fileElement != null ? fileElement.getElementType().getLanguage() : null;
    }

    @NotNull
    public static Set<String> findReturnedReferences(@NotNull CompositeElement function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "findReturnedReferences"));
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)function.getPsi(), () -> {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "lambda$findReturnedReferences$1"));
            }
            return new CachedValueProvider.Result(JSTreeUtil.calculateReturnedReferences((TreeElement)function), new Object[]{function.getPsi()});
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "findReturnedReferences"));
        }
        return set;
    }

    private static Set<String> calculateReturnedReferences(final @NotNull TreeElement function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "calculateReturnedReferences"));
        }
        THashSet referencedNames = new THashSet();
        new RecursiveTreeElementWalkingVisitor((Set)referencedNames){
            int inReturnStatement;
            final /* synthetic */ Set val$referencedNames;
            {
                this.val$referencedNames = set;
            }

            protected void visitNode(TreeElement element) {
                if (element == function) {
                    super.visitNode(element);
                    return;
                }
                IElementType type = element.getElementType();
                if (type == JSStubElementTypes.RETURN_STATEMENT) {
                    ++this.inReturnStatement;
                } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(type) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(type)) {
                    if (this.inReturnStatement == 0) {
                        return;
                    }
                } else if (JSElementTypes.EXPRESSIONS.contains(type)) {
                    if (this.inReturnStatement > 0) {
                        if (type == JSElementTypes.REFERENCE_EXPRESSION && JSReferenceExpressionImpl.getQualifierNode((ASTNode)element) == null && element.getTreeParent().getElementType() != JSStubElementTypes.CALL_EXPRESSION) {
                            this.val$referencedNames.add(element.getLastChildNode().getText());
                        }
                    } else {
                        return;
                    }
                }
                super.visitNode(element);
            }

            protected void elementFinished(@NotNull ASTNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil$2", "elementFinished"));
                }
                if (element.getElementType() == JSStubElementTypes.RETURN_STATEMENT) {
                    --this.inReturnStatement;
                }
            }
        }.visitNode(function);
        return referencedNames;
    }

    @Nullable
    public static String getName(@NotNull ASTNode namedElement) {
        ASTNode identifier;
        if (namedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedElement", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getName"));
        }
        IElementType type = namedElement.getElementType();
        if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type)) {
            ASTNode identifier2 = JSVariableBaseImpl.findVariableNameIdentifier(namedElement);
            if (identifier2 != null) {
                return identifier2.getText();
            }
        } else if (JSExtendedLanguagesTokenSetProvider.PROPERTIES.contains(type) && (identifier = JSPropertyImpl.findNameIdentifier(namedElement)) != null) {
            return identifier.getText();
        }
        return null;
    }

    public static boolean withinWithStatement(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "withinWithStatement"));
        }
        return TreeUtil.findParent((ASTNode)element, (IElementType)JSElementTypes.WITH_STATEMENT) != null;
    }

    public static Project getProject(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/util/JSTreeUtil", "getProject"));
        }
        ASTNode parent = node;
        do {
            node = parent;
        } while ((parent = parent.getTreeParent()) != null);
        return node.getPsi().getProject();
    }

    public static ASTNode getInitializerNode(ASTNode ownerNode) {
        ASTNode eqNode;
        IElementType elementType = ownerNode.getElementType();
        ASTNode initializer = null;
        if (JSExtendedLanguagesTokenSetProvider.PROPERTIES.contains(elementType)) {
            initializer = ownerNode.findChildByType(JSElementTypes.EXPRESSIONS);
        } else if (elementType == JSStubElementTypes.DEFINITION_EXPRESSION) {
            ASTNode parent = ownerNode.getTreeParent();
            if (parent != null && parent.getElementType() == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
                initializer = JSBinaryExpressionImpl.getROperandNode(parent);
            }
        } else if (elementType != JSStubElementTypes.ASSIGNMENT_EXPRESSION && (eqNode = ownerNode.findChildByType(JSTokenTypes.EQ)) != null) {
            initializer = ownerNode.findChildByType(JSElementTypes.EXPRESSIONS, eqNode);
        }
        return initializer;
    }

    public static class JSScopeNameUsages {
        private final JSScopeDeclarationsAndAssignments myDeclarationsAndAssignments = new JSScopeDeclarationsAndAssignments();
        private final JSScopeReferenceAssignments myReferenceAssignments = new JSScopeReferenceAssignments();

        public JSScopeDeclarationsAndAssignments getDeclarationsAndAssignments() {
            return this.myDeclarationsAndAssignments;
        }

        public JSScopeReferenceAssignments getReferenceAssignments() {
            return this.myReferenceAssignments;
        }
    }

    public static class JSScopeReferenceAssignments
    extends SmartList<CompositeElement> {
    }

    public static class JSScopeDeclarationsAndAssignments {
        @NotNull
        private final List<CompositeElement> myElements = new SmartList();

        public boolean hasDeclarationOrAssignment(boolean includeAssignments) {
            if (includeAssignments) {
                return !this.myElements.isEmpty();
            }
            int size = this.myElements.size();
            for (int i = 0; i < size; ++i) {
                CompositeElement element = this.myElements.get(i);
                if (element.getElementType() == JSStubElementTypes.DEFINITION_EXPRESSION) continue;
                return true;
            }
            return false;
        }

        public void add(@NotNull CompositeElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments", "add"));
            }
            this.myElements.add(element);
        }

        private int findNearestDefinitionIndex(@NotNull ASTNode context) {
            CompositeElement element;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments", "findNearestDefinitionIndex"));
            }
            if (this.myElements.isEmpty()) {
                return -1;
            }
            if (this.myElements.size() == 1) {
                return 0;
            }
            int i = Collections.binarySearch(this.myElements, context, (o1, o2) -> {
                int o2Length;
                int o2Start;
                int o1Start = o1.getStartOffset();
                if (o1Start < (o2Start = o2.getStartOffset())) {
                    return -1;
                }
                if (o2Start < o1Start) {
                    return 1;
                }
                int o1Length = o1.getTextLength();
                if (o1Length < (o2Length = o2.getTextLength())) {
                    return -1;
                }
                if (o2Length < o1Length) {
                    return 1;
                }
                return 0;
            });
            if (i < 0) {
                i = -i - 2;
            }
            if ((element = this.myElements.get(i = Math.max(i, 0))).getElementType() == JSStubElementTypes.DEFINITION_EXPRESSION) {
                element = element.getTreeParent();
            }
            return element.getTextRange().contains(context.getTextRange()) && i > 0 ? i - 1 : i;
        }

        @Nullable
        public CompositeElement findNearestDefinition(@NotNull ASTNode context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments", "findNearestDefinition"));
            }
            int i = this.findNearestDefinitionIndex(context);
            return i >= 0 ? this.myElements.get(i) : null;
        }

        public boolean processFromNearest(@NotNull ASTNode context, @NotNull PsiScopeProcessor processor) {
            int i;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments", "processFromNearest"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/util/JSTreeUtil$JSScopeDeclarationsAndAssignments", "processFromNearest"));
            }
            int start = this.findNearestDefinitionIndex(context);
            if (start == -1) {
                return true;
            }
            for (i = start; i < this.myElements.size(); ++i) {
                if (processor.execute(this.myElements.get(i).getPsi(), ResolveState.initial())) continue;
                return false;
            }
            for (i = 0; i < start; ++i) {
                if (processor.execute(this.myElements.get(i).getPsi(), ResolveState.initial())) continue;
                return false;
            }
            return true;
        }
    }

    static class ScopeTypesHolder {
        static final TokenSet SCOPE_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, TokenSet.create((IElementType[])JSFileElementType.getAll().values().toArray(IElementType.EMPTY_ARRAY)), JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS});

        ScopeTypesHolder() {
        }
    }
}

