/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefaultRenameProcessor
extends RenamePsiElementProcessor {
    public static final String SEARCH_IN_COMMENTS = "js.rename.search.in.comments";
    public static final String SEARCH_FOR_TEXT_OCCURRENCES = "js.rename.search.for.text.occurrences";
    public static final String SEARCH_FOR_JAVASCRIPT_OCCURRENCES = "ts.rename.search.for.js.occurrences";

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "canProcessElement"));
        }
        return element instanceof JSNamedElement;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        super.prepareRenaming(element, newName, allRenames, scope);
        if (element instanceof TypeScriptFunction) {
            Collection<TypeScriptFunction> overloads = TypeScriptPsiUtil.getAllOverloads((TypeScriptFunction)element);
            overloads.forEach(el -> allRenames.put((PsiElement)el, newName));
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element, boolean searchInCommentsAndStrings) {
        boolean isTypeScript = DialectDetector.isTypeScript(element);
        ReferencesType refType = isTypeScript && !JSDefaultRenameProcessor.getSearchJavaScriptReferences(element) ? ReferencesType.TS : ReferencesType.ALL;
        Collection<PsiReference> collection = JSDefaultRenameProcessor.getReferences(element, searchInCommentsAndStrings, refType);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "findReferences"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiReference> getReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings, ReferencesType type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "getReferences"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        SearchScope defaultScope = JSDefaultRenameProcessor.getScope(element, type);
        Collection<PsiReference> collection = JSDefaultRenameProcessor.findReferencesForScope(element, searchInCommentsAndStrings, defaultScope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "getReferences"));
        }
        return collection;
    }

    @NotNull
    public static SearchScope getScope(@NotNull PsiElement element, ReferencesType type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "getScope"));
        }
        Object defaultScope = element.getUseScope();
        if (defaultScope instanceof GlobalSearchScope) {
            boolean useJS = true;
            switch (type) {
                case TS: {
                    useJS = false;
                }
                case JS: {
                    final boolean finalUseJS = useJS;
                    defaultScope = new DelegatingGlobalSearchScope((GlobalSearchScope)defaultScope){

                        public boolean contains(@NotNull VirtualFile file) {
                            if (file == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$1", "contains"));
                            }
                            if (!super.contains(file)) {
                                return false;
                            }
                            return finalUseJS == DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
                        }
                    };
                    break;
                }
            }
        }
        SearchScope searchScope = defaultScope;
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "getScope"));
        }
        return searchScope;
    }

    public static Collection<PsiReference> findReferencesForScope(PsiElement element, boolean searchInCommentsAndStrings, SearchScope useScope) {
        return JSDefaultRenameProcessor.findReferencesForScope(element, searchInCommentsAndStrings, useScope, -1L);
    }

    public static Collection<PsiReference> findReferencesForScope(final PsiElement element, final boolean searchInCommentsAndStrings, SearchScope useScope, final long timeoutMs) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        final boolean hasES6Imports = holder != null && (holder.isTypeScript || holder.isECMA6);
        List<PsiReference> result = Collections.synchronizedList(new ArrayList());
        final long start = timeoutMs <= 0L ? 0L : System.currentTimeMillis();
        try {
            ReferencesSearch.search((PsiElement)element, (SearchScope)useScope).forEach((Processor)new CommonProcessors.CollectProcessor<PsiReference>(result){

                protected boolean accept(PsiReference psiReference) {
                    if (timeoutMs > 0L && System.currentTimeMillis() - start > timeoutMs) {
                        throw new ProcessCanceledException();
                    }
                    return JSDefaultRenameProcessor.acceptReference(psiReference, searchInCommentsAndStrings, hasES6Imports, element);
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return result;
    }

    public static boolean acceptReference(PsiReference psiReference, boolean searchInCommentsAndStrings, boolean hasES6Imports, PsiElement element) {
        Object[] results;
        boolean accept;
        boolean bl = accept = searchInCommentsAndStrings || JSDefaultRenameProcessor.isStrictlyRenameableReference(psiReference);
        if (!accept) {
            return false;
        }
        if (!hasES6Imports) {
            return true;
        }
        PsiElement elementToRename = psiReference.getElement();
        if (elementToRename instanceof JSReferenceExpression && ((JSReferenceExpression)elementToRename).getQualifier() == null && (results = ((JSReferenceExpression)elementToRename).multiResolve(false)).length == 1) {
            PsiElement item = ((ResolveResult)ArrayUtil.getFirstElement((Object[])results)).getElement();
            if (element.isEquivalentTo(item)) {
                return true;
            }
            if (ES6PsiUtil.isImportElement(item)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isStrictlyRenameableReference(PsiReference psiReference) {
        PsiElement element = psiReference.getElement();
        boolean reallyWeak = psiReference.isSoft() && element instanceof JSLiteralExpression && !(element.getParent() instanceof JSIndexedPropertyAccessExpression);
        return !reallyWeak;
    }

    public boolean isToSearchInComments(PsiElement element) {
        return PropertiesComponent.getInstance().getBoolean(SEARCH_IN_COMMENTS, true);
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        PropertiesComponent.getInstance().setValue(SEARCH_IN_COMMENTS, String.valueOf(enabled));
        super.setToSearchInComments(element, enabled);
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return PropertiesComponent.getInstance().getBoolean(SEARCH_FOR_TEXT_OCCURRENCES);
    }

    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        element = JSDefaultRenameProcessor.substituteOverload(element);
        if ((element = this.substituteDestructuringShorthanding(element, editor, null)) == null) {
            return null;
        }
        return this.substituteShorthandedProperty(element, editor, null);
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteElementToRename"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteElementToRename"));
        }
        if (renameCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renameCallback", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteElementToRename"));
        }
        element = JSDefaultRenameProcessor.substituteOverload(element);
        if ((element = this.substituteDestructuringShorthanding(element, editor, renameCallback)) == null) {
            return;
        }
        if ((element = this.substituteShorthandedProperty(element, editor, renameCallback)) == null) {
            return;
        }
        renameCallback.pass((Object)element);
    }

    @Nullable
    private PsiElement substituteShorthandedProperty(@NotNull PsiElement element, @Nullable Editor editor, @Nullable Pass<PsiElement> callback) {
        PsiElement valueResolveResult;
        JSReferenceExpression referenceExpression;
        ES6Property property;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteShorthandedProperty"));
        }
        ES6Property eS6Property = property = element instanceof ES6Property ? (ES6Property)element : null;
        if (property == null || !property.isShorthanded() || property.getValue() == null) {
            return element;
        }
        PsiReference reference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        ES6Property atCaret = reference != null ? (ES6Property)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), ES6Property.class, (boolean)false) : null;
        JSReferenceExpression jSReferenceExpression = referenceExpression = property.getValue() instanceof JSReferenceExpression ? (JSReferenceExpression)property.getValue() : null;
        if (atCaret == property && referenceExpression != null && (valueResolveResult = referenceExpression.resolve()) != null) {
            String valueDescription = ElementDescriptionUtil.getElementDescription((PsiElement)valueResolveResult, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
            String title = JSBundle.message((String)"javascript.rename.shorthand.target.dialog.title", (Object[])new Object[]{valueDescription});
            String message = JSBundle.message((String)"javascript.rename.choose.target.message", (Object[])new Object[0]);
            String propertyDescription = JSBundle.message((String)"javascript.rename.shorthand.property.description", (Object[])new Object[0]);
            return this.substituteWithPopup(editor, callback, title, message, valueResolveResult, StringUtil.capitalize((String)valueDescription), (PsiElement)property, propertyDescription);
        }
        return element;
    }

    @NotNull
    private static PsiElement substituteOverload(PsiElement element) {
        TypeScriptFunction impl;
        TypeScriptFunction func;
        if (element instanceof TypeScriptFunction && (func = (TypeScriptFunction)element).isOverloadDeclaration() && (impl = TypeScriptPsiUtil.getOverloadImplementation(func)) != null) {
            TypeScriptFunction typeScriptFunction = impl;
            if (typeScriptFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteOverload"));
            }
            return typeScriptFunction;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteOverload"));
        }
        return psiElement;
    }

    @Nullable
    private PsiElement substituteDestructuringShorthanding(@NotNull PsiElement element, @Nullable Editor editor, @Nullable Pass<PsiElement> renameCallback) {
        PsiElement shorthandedPropertyResolve;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteDestructuringShorthanding"));
        }
        if (!(element instanceof JSVariable)) {
            return element;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSDestructuringShorthandedProperty)) {
            return element;
        }
        PsiReference propertyRef = parent.getReference();
        PsiElement psiElement = shorthandedPropertyResolve = propertyRef instanceof JSDestructuringPropertyReference ? propertyRef.resolve() : null;
        if (shorthandedPropertyResolve != null) {
            String description = ElementDescriptionUtil.getElementDescription((PsiElement)shorthandedPropertyResolve, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
            String title = JSBundle.message((String)"javascript.rename.destructuring.target.dialog.title", (Object[])new Object[]{description});
            String message = JSBundle.message((String)"javascript.rename.choose.target.message", (Object[])new Object[0]);
            String initializer = JSBundle.message((String)"javascript.destructuring.initializer", (Object[])new Object[]{description});
            String variable = JSBundle.message((String)"javascript.destructuring.variable.only", (Object[])new Object[0]);
            return this.substituteWithPopup(editor, renameCallback, title, message, shorthandedPropertyResolve, initializer, element, variable);
        }
        return element;
    }

    @Nullable
    @Contract(value="null,null,_,_,_,_,_,_ -> fail")
    protected PsiElement substituteWithPopup(@Nullable Editor editor, @Nullable Pass<PsiElement> renameCallback, @NotNull String title, @Nullable String message, @NotNull PsiElement defaultElement, @NotNull String defaultElementLabel, @NotNull PsiElement otherElement, @NotNull String otherElementLabel) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteWithPopup"));
        }
        if (defaultElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultElement", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteWithPopup"));
        }
        if (defaultElementLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultElementLabel", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteWithPopup"));
        }
        if (otherElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherElement", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteWithPopup"));
        }
        if (otherElementLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherElementLabel", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "substituteWithPopup"));
        }
        if (defaultElement == otherElement) {
            return this.processSubstituted(defaultElement, editor, renameCallback);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.processSubstituted(defaultElement, editor, renameCallback);
        }
        if (renameCallback == null) {
            int exitCode = Messages.showOkCancelDialog((Project)defaultElement.getProject(), (String)message, (String)title, (String)defaultElementLabel, (String)otherElementLabel, (Icon)Messages.getQuestionIcon());
            return this.processSubstituted(exitCode == 0 ? defaultElement : otherElement, editor, null);
        }
        assert (editor != null) : "editor must be provided for inplace rename";
        JBList list = new JBList(new Object[]{defaultElementLabel, otherElementLabel});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
            if (defaultElementLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultElementLabel", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "lambda$substituteWithPopup$1"));
            }
            if (defaultElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultElement", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "lambda$substituteWithPopup$1"));
            }
            if (otherElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherElement", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "lambda$substituteWithPopup$1"));
            }
            Object value = list.getSelectedValue();
            if (value instanceof String) {
                PsiElement method = value.equals(defaultElementLabel) ? defaultElement : otherElement;
                this.processSubstituted(method, editor, renameCallback);
            }
        }).createPopup().showInBestPositionFor(editor);
        return null;
    }

    public RenameDialog createRenameDialog(Project project, final PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        boolean isContextTypeScript = nameSuggestionContext != null && DialectDetector.isTypeScript(nameSuggestionContext);
        boolean isElementToRenameTypeScript = DialectDetector.isTypeScript(element);
        if (!isContextTypeScript) {
            if (isElementToRenameTypeScript) {
                this.setSearchJavaScriptReferences(element, true);
            }
            return super.createRenameDialog(project, element, nameSuggestionContext, editor);
        }
        return new RenameDialog(project, element, nameSuggestionContext, editor){
            private JCheckBox myCbSearchForReferences;

            protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
                gbConstraints.insets = JBUI.insetsBottom((int)4);
                gbConstraints.gridwidth = 1;
                gbConstraints.gridx = 0;
                gbConstraints.weighty = 0.0;
                gbConstraints.weightx = 1.0;
                gbConstraints.fill = 1;
                this.myCbSearchForReferences = new NonFocusableCheckBox(JSBundle.message((String)"typescript.rename.javascript.references", (Object[])new Object[0]));
                this.myCbSearchForReferences.setSelected(JSDefaultRenameProcessor.getSearchJavaScriptReferences(element));
                panel.add((Component)this.myCbSearchForReferences, gbConstraints);
                super.createCheckboxes(panel, gbConstraints);
            }

            protected void doAction() {
                JSDefaultRenameProcessor.this.setSearchJavaScriptReferences(element, this.myCbSearchForReferences.isSelected());
                super.doAction();
            }
        };
    }

    @Nullable
    protected PsiElement processSubstituted(@NotNull PsiElement psiElement, Editor editor, @Nullable Pass<PsiElement> renameCallback) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "processSubstituted"));
        }
        if (!PsiElementRenameHandler.canRename((Project)psiElement.getProject(), (Editor)editor, (PsiElement)psiElement)) {
            return null;
        }
        if (renameCallback != null) {
            renameCallback.pass((Object)super.substituteElementToRename(psiElement, editor));
            return null;
        }
        return psiElement;
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        JSDestructuringProperty destructuringProperty;
        PsiElement parent = element.getParent();
        JSDestructuringProperty jSDestructuringProperty = destructuringProperty = parent instanceof JSDestructuringProperty ? (JSDestructuringProperty)parent : null;
        if (destructuringProperty != null) {
            destructuringProperty = destructuringProperty.setDestructuringElementName(newName);
            super.renameElement((PsiElement)destructuringProperty.getDestructuringElement(), newName, usages, listener);
            return;
        }
        if (element instanceof ES6Property && ((ES6Property)element).isShorthanded()) {
            ES6ChangeUtil.expandShorthandPropertyWithName((ES6Property)element, newName);
        }
        for (PsiElement usageElement : JSDefaultRenameProcessor.collectShorthandPropertyUsages(ContainerUtil.mapNotNull((Object[])usages, UsageInfo::getReference))) {
            ES6Property property = (ES6Property)PsiTreeUtil.getNonStrictParentOfType((PsiElement)usageElement, (Class[])new Class[]{ES6Property.class});
            if (property == usageElement) {
                ES6ChangeUtil.expandShorthandPropertyWithName(property, newName);
                continue;
            }
            ES6ChangeUtil.expandShorthandPropertyWithValue(property, newName);
        }
        super.renameElement(element, newName, usages, listener);
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        PropertiesComponent.getInstance().setValue(SEARCH_FOR_TEXT_OCCURRENCES, String.valueOf(enabled));
        super.setToSearchForTextOccurrences(element, enabled);
    }

    public static boolean getSearchJavaScriptReferences(PsiElement element) {
        return PropertiesComponent.getInstance((Project)element.getProject()).getBoolean(SEARCH_FOR_JAVASCRIPT_OCCURRENCES, true);
    }

    public void setSearchJavaScriptReferences(PsiElement element, boolean enabled) {
        PropertiesComponent.getInstance((Project)element.getProject()).setValue(SEARCH_FOR_JAVASCRIPT_OCCURRENCES, enabled, true);
    }

    @NotNull
    public static List<PsiElement> collectShorthandPropertyUsages(@NotNull Collection<PsiReference> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "collectShorthandPropertyUsages"));
        }
        ArrayList results = ContainerUtil.newArrayList();
        for (PsiReference ref : refs) {
            PsiElement element = ref instanceof JSPropertyNameReference ? ref.getElement() : ref.getElement().getParent();
            ES6Property property = element instanceof ES6Property ? (ES6Property)element : null;
            if (property == null || !property.isShorthanded()) continue;
            results.add(ref.getElement());
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "collectShorthandPropertyUsages"));
        }
        return arrayList;
    }

    public static enum ReferencesType {
        ALL,
        TS,
        JS;

    }
}

