/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeFromUsageDetector {
    @Nullable
    public static JSType detectTypeFromUsage(@NotNull PsiElement parent, @NotNull PsiFile containingFile) {
        JSExpression expression;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/types/TypeFromUsageDetector", "detectTypeFromUsage"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/lang/javascript/types/TypeFromUsageDetector", "detectTypeFromUsage"));
        }
        if (parent instanceof JSVariable && (expression = ((JSVariable)parent).getInitializer()) != null) {
            return JSResolveUtil.getExpressionJSType(expression);
        }
        if (!(parent instanceof JSFunction)) {
            return null;
        }
        JSFunction function = (JSFunction)parent;
        JSType functionType = TypeFromUsageDetector.getFunctionType(function, containingFile);
        if (functionType != null && ES6PsiUtil.isAsyncContext(function) && !"Promise".equals(JSTypeUtils.getQualifiedNameMatchingType(functionType, false))) {
            JSTypeSource source = functionType.getSource();
            functionType = new JSGenericTypeImpl(source, JSNamedType.createType("Promise", source, JSTypeContext.INSTANCE), functionType);
        }
        return functionType;
    }

    @Nullable
    protected static JSType getFunctionType(final @NotNull JSFunction parent, final @NotNull PsiFile containingFile) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/types/TypeFromUsageDetector", "getFunctionType"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/lang/javascript/types/TypeFromUsageDetector", "getFunctionType"));
        }
        JSSourceElement[] body = parent.getBody();
        if (body.length == 0) {
            return null;
        }
        THashSet usedTypes = new THashSet(4, (TObjectHashingStrategy)new TObjectHashingStrategy<JSType>(){

            public int computeHashCode(JSType object) {
                return object.getTypeText(JSType.TypeTextFormat.SIMPLE).hashCode();
            }

            public boolean equals(JSType o1, JSType o2) {
                return o1.getTypeText(JSType.TypeTextFormat.SIMPLE).equals(o2.getTypeText(JSType.TypeTextFormat.SIMPLE));
            }
        });
        ArrayList<JSClass> classesList = new ArrayList<JSClass>();
        Ref hasUnresolvedTypes = new Ref();
        Ref hasValuelessReturns = new Ref();
        body[0].acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor((Set)usedTypes, classesList, hasUnresolvedTypes, hasValuelessReturns){
            final /* synthetic */ Set val$usedTypes;
            final /* synthetic */ List val$classesList;
            final /* synthetic */ Ref val$hasUnresolvedTypes;
            final /* synthetic */ Ref val$hasValuelessReturns;
            {
                this.val$usedTypes = set;
                this.val$classesList = list;
                this.val$hasUnresolvedTypes = ref;
                this.val$hasValuelessReturns = ref2;
            }

            public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/types/TypeFromUsageDetector$2", "visitJSReturnStatement"));
                }
                super.visitJSReturnStatement(node);
                JSExpression expression = node.getExpression();
                if (expression != null) {
                    JSType jsType = JSTypeEvaluator.forceEvaluateType((PsiElement)parent, expression, containingFile);
                    if (jsType == null || !this.val$usedTypes.add(jsType)) {
                        return;
                    }
                    PsiElement psiElement = JSResolveUtil.findType(jsType.getTypeText(), (PsiElement)parent, true);
                    if (psiElement instanceof JSClass) {
                        this.val$classesList.add((JSClass)psiElement);
                    } else {
                        this.val$hasUnresolvedTypes.set((Object)true);
                    }
                } else {
                    this.val$hasValuelessReturns.set((Object)true);
                }
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/types/TypeFromUsageDetector$2", "visitJSFunctionExpression"));
                }
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/types/TypeFromUsageDetector$2", "visitJSFunctionDeclaration"));
                }
            }
        });
        if (classesList.isEmpty() && hasUnresolvedTypes.get() == null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)parent);
            return JSNamedType.createType("void", source, JSTypeContext.INSTANCE);
        }
        if (!classesList.isEmpty() && hasUnresolvedTypes.get() == null && hasValuelessReturns.get() == null) {
            return TypeFromUsageDetector.calcCommonType(classesList);
        }
        if (hasUnresolvedTypes.get() != null && usedTypes.size() == 1) {
            return (JSType)usedTypes.iterator().next();
        }
        return JSAnyType.get((PsiElement)parent, false);
    }

    @NotNull
    public static JSType calcCommonType(List<JSClass> aClasses) {
        JSClass aClass;
        if (aClasses.size() == 0) {
            JSAnyType jSAnyType = JSAnyType.get(null, false);
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/TypeFromUsageDetector", "calcCommonType"));
            }
            return jSAnyType;
        }
        Ref classRef = new Ref((Object)aClasses.get(0));
        THashSet descendantClasses = new THashSet();
        TypeFromUsageDetector.processNontrivialAncestors(aClasses.get(0), (Processor<JSClass>)((Processor)arg_0 -> TypeFromUsageDetector.lambda$calcCommonType$0((Set)descendantClasses, arg_0)), (Set<JSClass>)new THashSet());
        for (JSClass clazz : aClasses.subList(1, aClasses.size())) {
            THashSet visitedClasses;
            boolean res;
            if (((JSClass)classRef.get()).equals(clazz) || !(res = TypeFromUsageDetector.processNontrivialAncestors(clazz, (Processor<JSClass>)((Processor)arg_0 -> TypeFromUsageDetector.lambda$calcCommonType$1((Set)descendantClasses, classRef, arg_0)), (Set<JSClass>)(visitedClasses = new THashSet())))) continue;
            classRef.set(null);
            break;
        }
        String qualifiedName = (aClass = (JSClass)classRef.get()) != null ? aClass.getQualifiedName() : null;
        JSAnyType jSAnyType = qualifiedName == null ? JSAnyType.get((PsiElement)aClasses.get(0), false) : JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)aClasses.get(0), true), JSTypeContext.INSTANCE);
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/TypeFromUsageDetector", "calcCommonType"));
        }
        return jSAnyType;
    }

    private static boolean processNontrivialAncestors(JSClass aClass, Processor<JSClass> processor, Set<JSClass> visited) {
        if (!visited.add(aClass)) {
            return false;
        }
        if (!processor.process((Object)aClass)) {
            return false;
        }
        for (JSClass superClazz : aClass.getSupers()) {
            if ("Object".equals(superClazz.getQualifiedName())) break;
            if (!processor.process((Object)superClazz)) {
                return false;
            }
            if (TypeFromUsageDetector.processNontrivialAncestors(superClazz, processor, visited)) continue;
            return false;
        }
        for (JSClass superClazz : aClass.getImplementedInterfaces()) {
            if ("Object".equals(superClazz.getQualifiedName())) break;
            visited.add(superClazz);
            if (!processor.process((Object)superClazz)) {
                return false;
            }
            if (TypeFromUsageDetector.processNontrivialAncestors(superClazz, processor, visited)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$calcCommonType$1(Set descendantClasses, Ref classRef, JSClass jsClass) {
        String qName = jsClass.getQualifiedName();
        if (descendantClasses.contains(qName)) {
            classRef.set((Object)jsClass);
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$calcCommonType$0(Set descendantClasses, JSClass jsClass) {
        descendantClasses.add(jsClass.getQualifiedName());
        return true;
    }
}

