/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptorFactory;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptorWrapper;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)ChangeSignatureFix.class.getName());
    protected final SmartPsiElementPointer<JSFunction> myFunction;
    private final List<JSParameterInfo> myParamInfos;
    @Nullable
    private final SmartPsiElementPointer<JSArgumentList> myExpectedArguments;
    @Nullable
    private final Computable<JSParameterList> myExpectedParameterListComputable;
    private boolean myShowDialogOnIncompatibleOverride;
    private String overriddenReturnType;

    public ChangeSignatureFix(JSFunction function, JSParameterList expectedParameterList, boolean showDialogOnIncompatibleOverride) {
        this(function, (Computable<JSParameterList>)new Computable.PredefinedValueComputable((Object)expectedParameterList), null, null);
        this.myShowDialogOnIncompatibleOverride = showDialogOnIncompatibleOverride;
    }

    public ChangeSignatureFix(JSFunction function, Computable.NotNullCachedComputable<JSParameterList> expectedParameterListComputable) {
        this(function, (Computable<JSParameterList>)expectedParameterListComputable, null, null);
    }

    public ChangeSignatureFix(JSFunction function, JSArgumentList expectedArguments) {
        this(function, null, expectedArguments, null);
    }

    public ChangeSignatureFix(JSFunction function, List<JSParameterInfo> parameterInfos) {
        this(function, null, null, parameterInfos);
    }

    private ChangeSignatureFix(@NotNull JSFunction function, @Nullable Computable<JSParameterList> expectedParametersComputable, @Nullable JSArgumentList expectedArgumentList, @Nullable List<JSParameterInfo> paramInfos) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "<init>"));
        }
        this.myShowDialogOnIncompatibleOverride = true;
        this.myFunction = SmartPointerManager.getInstance((Project)function.getProject()).createSmartPsiElementPointer((PsiElement)function);
        this.myExpectedParameterListComputable = expectedParametersComputable;
        this.myExpectedArguments = expectedArgumentList == null ? null : SmartPointerManager.getInstance((Project)function.getProject()).createSmartPsiElementPointer((PsiElement)expectedArgumentList);
        this.myParamInfos = paramInfos;
    }

    @NotNull
    public String getText() {
        JSFunction function = (JSFunction)this.myFunction.getElement();
        if (function == null) {
            String string = JSBundle.message((String)"change.method.signature.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "getText"));
            }
            return string;
        }
        String string = JSBundle.message((String)"change.method.signature.fix.text", (Object[])new Object[]{JSFormatUtil.formatMethod(function, 4353, 0, 0, null)});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"change.method.signature.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "isAvailable"));
        }
        JSFunction function = (JSFunction)this.myFunction.getElement();
        if (function == null || !function.isValid() || ModuleUtilCore.findModuleForPsiElement((PsiElement)function) == null) {
            return false;
        }
        if (this.myExpectedParameterListComputable != null) {
            return ((JSParameterList)this.myExpectedParameterListComputable.compute()).isValid();
        }
        if (this.myExpectedArguments != null) {
            JSExpression[] arguments;
            JSArgumentList argumentList = (JSArgumentList)this.myExpectedArguments.getElement();
            for (JSExpression argument : arguments = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY) {
                if (argument.isValid()) continue;
                return false;
            }
            return this.handleCall(function, arguments, true) != null;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "invoke"));
        }
        PsiFile context = editor != null ? file.findElementAt(editor.getCaretModel().getOffset()) : file;
        this.invoke((PsiElement)context);
    }

    public void invoke(PsiElement context) throws IncorrectOperationException {
        List paramInfos;
        boolean mustShowDialog;
        JSArgumentList argumentList;
        JSFunction function = (JSFunction)this.myFunction.getElement();
        if (function == null) {
            return;
        }
        JSArgumentList jSArgumentList = argumentList = this.myExpectedArguments != null ? (JSArgumentList)this.myExpectedArguments.getElement() : null;
        if (argumentList != null) {
            Pair<Boolean, List<JSParameterInfo>> result = this.handleCall(function, argumentList.getArguments(), false);
            LOG.assertTrue(result != null);
            mustShowDialog = (Boolean)result.first;
            paramInfos = (List)result.second;
        } else if (this.myExpectedParameterListComputable != null) {
            mustShowDialog = false;
            paramInfos = this.handleDeclaration(function);
        } else {
            mustShowDialog = false;
            paramInfos = this.myParamInfos;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.runSilently(paramInfos, function);
        } else if (!mustShowDialog && !this.needToShowDialog(function)) {
            this.runSilently(paramInfos, function);
        } else {
            JSChangeSignatureDialog d = this.createDialog(context, paramInfos);
            d.show();
        }
    }

    protected JSChangeSignatureDialog createDialog(PsiElement context, final List<JSParameterInfo> paramInfos) {
        JSFunction function = (JSFunction)this.myFunction.getElement();
        JSMethodDescriptor parent = JSMethodDescriptorFactory.create(function, false);
        JSMethodDescriptorWrapper descriptor = new JSMethodDescriptorWrapper(parent){

            @Override
            public List<JSParameterInfo> getParameters() {
                return paramInfos;
            }

            @Override
            public String getReturnType() {
                String returnType = ChangeSignatureFix.this.getOverriddenReturnType();
                if (returnType == null) {
                    returnType = super.getReturnType();
                }
                return returnType;
            }
        };
        return new JSChangeSignatureDialog(descriptor, context){

            @Override
            protected JSChangeSignatureProcessor createRefactoringProcessor() {
                JSChangeSignatureProcessor p = super.createRefactoringProcessor();
                ChangeSignatureFix.this.setFilter(p);
                return p;
            }

            public JComponent getPreferredFocusedComponent() {
                if (this.myReturnTypeField != null) {
                    return this.myReturnTypeField.getComponent();
                }
                return super.getPreferredFocusedComponent();
            }
        };
    }

    private boolean needToShowDialog(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "needToShowDialog"));
        }
        if (this.myParamInfos == null && this.myExpectedArguments == null) {
            return this.myShowDialogOnIncompatibleOverride;
        }
        if (JSInheritanceUtil.participatesInHierarchy(function)) {
            return true;
        }
        PsiReference[] references = (PsiReference[])ReferencesSearch.search((PsiElement)function).toArray((Object[])PsiReference.EMPTY_ARRAY);
        boolean usageFound = this.myParamInfos != null;
        for (PsiReference reference : references) {
            JSReferenceExpression refExpr;
            if (!(reference.getElement() instanceof JSReferenceExpression) || !((refExpr = (JSReferenceExpression)reference.getElement()).getParent() instanceof JSCallExpression)) continue;
            if (usageFound) {
                return true;
            }
            usageFound = true;
        }
        return false;
    }

    protected void runSilently(List<JSParameterInfo> paramInfos, @NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "runSilently"));
        }
        JSAttributeList attributeList = function instanceof JSFunctionExpression && function.getParent() instanceof JSVariable ? ((JSVariable)function.getParent()).getAttributeList() : function.getAttributeList();
        this.createProcessor(paramInfos, attributeList, function).run();
    }

    protected JSChangeSignatureProcessor createProcessor(List<JSParameterInfo> paramInfos, JSAttributeList attributeList, @NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "createProcessor"));
        }
        String returnType = this.getOverriddenReturnType();
        if (returnType == null) {
            returnType = JSMethodDescriptorFactory.create(function, false).getReturnType();
        }
        JSChangeSignatureProcessor p = new JSChangeSignatureProcessor(function, attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL, function.getName(), returnType, paramInfos.toArray(new JSParameterInfo[paramInfos.size()]), Collections.emptySet());
        this.setFilter(p);
        return p;
    }

    @Nullable
    protected String getOverriddenReturnType() {
        return this.overriddenReturnType;
    }

    public void setOverriddenReturnType(String overriddenReturnType) {
        this.overriddenReturnType = overriddenReturnType;
    }

    private void setFilter(JSChangeSignatureProcessor processor) {
        if (this.myExpectedParameterListComputable != null) {
            JSFunction subjectFunction = (JSFunction)((JSParameterList)this.myExpectedParameterListComputable.compute()).getParent();
            processor.setDeclarationsFilter((Condition<JSFunction>)((Condition)jsFunction -> subjectFunction != jsFunction));
        }
    }

    @Nullable
    protected Pair<Boolean, List<JSParameterInfo>> handleCall(final @NotNull JSFunction function, @NotNull JSExpression[] arguments, boolean dummy) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "handleCall"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "handleCall"));
        }
        JSParameter[] parameters = function.getParameterVariables();
        ArrayList<JSParameterInfo> result = new ArrayList<JSParameterInfo>(arguments.length);
        boolean showDialog = false;
        Computable.NotNullCachedComputable<JSFunction> fakeFunction = new Computable.NotNullCachedComputable<JSFunction>(){

            @NotNull
            protected JSFunction internalCompute() {
                StringBuilder functionText = new StringBuilder("function ");
                functionText.append(function.getName()).append("()");
                JSType returnType = function.getReturnType();
                if (returnType != null && !(returnType instanceof JSTypeofTypeImpl)) {
                    functionText.append(":").append(returnType.getTypeText(JSType.TypeTextFormat.CODE));
                }
                for (JSSourceElement element : function.getBody()) {
                    functionText.append(element.getText());
                }
                JSFunction jSFunction = (JSFunction)PsiTreeUtil.findChildOfType((PsiElement)JSElementFactory.createExpressionCodeFragment(function.getProject(), functionText, function.getParent(), JavaScriptSupportLoader.ECMA_SCRIPT_L4, null, JSElementFactory.TopLevelCompletion.NO, null), JSFunction.class);
                if (jSFunction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix$3", "internalCompute"));
                }
                return jSFunction;
            }
        };
        boolean hasTypesLang = DialectDetector.isActionScript((PsiElement)function) || DialectDetector.isTypeScript((PsiElement)function);
        Trinity<Integer, Integer, Boolean> minMaxParameters = ValidateTypesUtil.getMinMaxParameters((JSParameterItem[])parameters);
        if (arguments.length < (Integer)minMaxParameters.first) {
            int ai = 0;
            int pi = 0;
            while (ai < arguments.length && pi < (Integer)minMaxParameters.first) {
                String argumentType;
                JSExpression argument = arguments[ai];
                JSParameter parameter = parameters[pi];
                JSType jsType = parameter.getType();
                String parameterType = jsType != null ? jsType.getResolvedTypeText() : null;
                String string = argumentType = hasTypesLang ? JSResolveUtil.getQualifiedExpressionType(argument, argument.getContainingFile()) : null;
                if (ChangeSignatureFix.isAssignableType(parameterType, argumentType, argument)) {
                    JSExpression initializer = parameter.getInitializer();
                    result.add(new JSParameterInfo(parameter.getName(), StringUtil.isEmpty((String)parameterType) ? argumentType : parameterType, initializer != null ? initializer.getText() : null, "", pi));
                    ++pi;
                    ++ai;
                    continue;
                }
                ++pi;
            }
            if (result.size() != arguments.length) {
                return null;
            }
            while (pi < parameters.length) {
                if (parameters[pi].isOptional()) {
                    showDialog = true;
                    JSType type = parameters[pi].getType();
                    JSExpression initializer = parameters[pi].getInitializer();
                    result.add(new JSParameterInfo(parameters[pi].getName(), type != null ? type.getResolvedTypeText() : null, initializer != null ? initializer.getText() : null, "", pi));
                }
                ++pi;
            }
        } else if (arguments.length > (Integer)minMaxParameters.second) {
            ArrayList<String> paramsNames = new ArrayList<String>();
            for (JSParameter parameter : parameters) {
                paramsNames.add(parameter.getName());
            }
            int ai = 0;
            int pi = 0;
            int lastRequiredParamIndex = -1;
            while (ai < arguments.length) {
                boolean parameterAssignable;
                JSExpression argument = arguments[ai];
                JSParameter parameter = pi < parameters.length ? parameters[pi] : null;
                JSType parameterJSType = parameter != null ? parameter.getType() : null;
                String parameterType = parameterJSType != null ? parameterJSType.getTypeText(JSType.TypeTextFormat.CODE) : null;
                JSType argumentJSType = hasTypesLang ? JSResolveUtil.getExpressionJSType(argument) : null;
                String argumentType = argumentJSType != null ? argumentJSType.getTypeText(JSType.TypeTextFormat.CODE) : null;
                boolean bl = parameterAssignable = parameter != null && ChangeSignatureFix.isAssignableType(parameterType, argumentType, argument);
                if (parameterAssignable) {
                    JSExpression initializer = parameter.getInitializer();
                    result.add(new JSParameterInfo(parameter.getName(), parameterType, initializer != null ? initializer.getText() : null, "", pi));
                    ++pi;
                    ++ai;
                    continue;
                }
                String name = null;
                if (argument instanceof JSReferenceExpression) {
                    name = ((JSReferenceExpression)argument).getReferencedName();
                    if (!dummy) {
                        name = ChangeSignatureFix.trimPrefix(argument, name);
                    }
                } else if (argument instanceof JSFunctionExpression) {
                    name = argument.getName();
                }
                if (!dummy) {
                    name = ChangeSignatureFix.adjustParameterName(argument, paramsNames, (Computable<JSFunction>)fakeFunction, name);
                }
                String defaultValue = argument.getText();
                if (!dummy && StringUtil.isNotEmpty((String)defaultValue)) {
                    PsiElement psiElement = JSChangeUtil.createJSTreeFromText(argument.getProject(), defaultValue, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
                    psiElement.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)argument);
                    PsiElement fixed = JSRefactoringUtil.fixOutgoingReferences(psiElement, new ArrayList<String>(), new ArrayList<String>(), Collections.emptyList(), null, false, false);
                    defaultValue = fixed.getText();
                }
                result.add(new JSParameterInfo(name, argumentType != null ? argumentType : "", "", defaultValue, -1));
                lastRequiredParamIndex = result.size() - 1;
                ++ai;
            }
            if (result.size() != arguments.length) {
                return null;
            }
            for (int i = 0; i < lastRequiredParamIndex; ++i) {
                ((JSParameterInfo)result.get(i)).setInitializer("");
            }
        } else {
            int pi = 0;
            for (int ai = 0; pi < parameters.length || ai < arguments.length; ++pi, ++ai) {
                JSParameter parameter;
                if (pi < parameters.length && ai < arguments.length) {
                    parameter = parameters[pi];
                    JSExpression argument = arguments[ai];
                    JSType type = parameter.getType();
                    String parameterType = type != null ? type.getTypeText(JSType.TypeTextFormat.CODE) : null;
                    String argumentType = JSResolveUtil.getQualifiedExpressionType(argument, argument.getContainingFile());
                    if (parameter.isRest()) {
                        result.add(new JSParameterInfo(parameter.getName(), "...", "", "", pi));
                        break;
                    }
                    if (ChangeSignatureFix.isAssignableType(parameterType, argumentType, argument)) {
                        JSExpression initializer = parameter.getInitializer();
                        result.add(new JSParameterInfo(parameter.getName(), parameterType, initializer != null ? initializer.getText() : null, "", pi));
                        continue;
                    }
                    result.add(new JSParameterInfo(parameter.getName(), argumentType, "", "", pi));
                    continue;
                }
                if (pi >= parameters.length) {
                    LOG.assertTrue(((Boolean)minMaxParameters.third).booleanValue());
                    break;
                }
                LOG.assertTrue(ai >= arguments.length);
                parameter = parameters[pi];
                JSType type = parameter.getType();
                String parameterType = parameter.isRest() ? "..." : (type != null ? type.getResolvedTypeText() : null);
                JSExpression initializer = parameter.getInitializer();
                result.add(new JSParameterInfo(parameter.getName(), parameterType, initializer != null ? initializer.getText() : null, "", pi));
            }
        }
        return Pair.create((Object)showDialog, result);
    }

    private static String trimPrefix(JSExpression argument, String name) {
        PsiElement resolved = ((JSReferenceExpression)argument).resolve();
        if (resolved instanceof JSVariable && JSUtils.getMemberContainingClass(resolved) != null) {
            JSCodeStyleSettings jsCodeStyleSettings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)argument.getProject()).getCustomSettings(JSCodeStyleSettings.class);
            return ChangeSignatureFix.trim(name, jsCodeStyleSettings.FIELD_PREFIX);
        }
        if (resolved instanceof JSFunction && JSPsiImplUtils.isGetterOrSetter((JSFunction)resolved)) {
            JSCodeStyleSettings jsCodeStyleSettings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)argument.getProject()).getCustomSettings(JSCodeStyleSettings.class);
            return ChangeSignatureFix.trim(name, jsCodeStyleSettings.PROPERTY_PREFIX);
        }
        return name;
    }

    private static String trim(String name, String prefix) {
        return StringUtil.isNotEmpty((String)prefix) && !name.equals(prefix) && name.startsWith(prefix) ? name.substring(prefix.length()) : name;
    }

    private static boolean isAssignableType(String parameterType, String argumentType, JSExpression argument) {
        if (argumentType == null) {
            return true;
        }
        if ("Boolean".equals(parameterType)) {
            return "Boolean".equals(argumentType);
        }
        return JSResolveUtil.isAssignableType(parameterType, argumentType, (PsiElement)argument) && !ValidateTypesUtil.checkIfNullIsAssignedToNumeric(argument, parameterType, argumentType);
    }

    private static String adjustParameterName(JSExpression argument, Collection<String> paramsNames, Computable<JSFunction> fakeFunction, String name) {
        if (paramsNames.contains(name) || name != null && JSChangeSignatureProcessor.getCollidingElement((JSFunction)fakeFunction.compute(), name, (Condition<PsiElement>)Conditions.alwaysTrue()) != null) {
            name = null;
        }
        if (name == null) {
            Set<String> names = BasicIntroducedEntityInfoProvider.getNameCandidates(argument, (PsiElement)fakeFunction.compute(), "", paramsNames, EnumSet.of(BasicIntroducedEntityInfoProvider.NameSuggestOption.IgnoreParamName, BasicIntroducedEntityInfoProvider.NameSuggestOption.TypeHasHigherPriorityThanName));
            if (names.isEmpty()) {
                int postfix = 1;
                name = "p";
                while (paramsNames.contains(name)) {
                    name = "p" + postfix++;
                }
            } else {
                name = names.iterator().next();
            }
        }
        paramsNames.add(name);
        return name;
    }

    private List<JSParameterInfo> handleDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "handleDeclaration"));
        }
        JSParameterListElement[] expectedParams = ((JSParameterList)this.myExpectedParameterListComputable.compute()).getParameters();
        JSParameterListElement[] actualParams = function.getParameters();
        ArrayList<JSParameterInfo> result = new ArrayList<JSParameterInfo>(expectedParams.length);
        HashMap<String, Integer> actualName2Index = new HashMap<String, Integer>(actualParams.length);
        for (int i = 0; i < actualParams.length; ++i) {
            actualName2Index.put(actualParams[i].getName(), i);
        }
        for (JSParameterListElement expectedParam : expectedParams) {
            Integer prevIndex = (Integer)actualName2Index.get(expectedParam.getName());
            JSType type = expectedParam.getType();
            String typeText = type != null ? type.getResolvedTypeText() : null;
            JSExpression initializer = expectedParam.getInitializer();
            result.add(new JSParameterInfo(expectedParam.getName(), typeText, initializer != null ? initializer.getText() : null, JSTypeUtils.defaultValueOfType(typeText), prevIndex != null ? prevIndex : -1));
        }
        return result;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/validation/fixes/ChangeSignatureFix", "applyFix"));
        }
        this.invoke(descriptor.getPsiElement());
    }
}

