/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action.before;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.action.before.TypeScriptCompileBeforeRunTask;
import com.intellij.lang.typescript.compiler.action.before.TypeScriptCompileBeforeTaskDialog;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileBeforeRunTaskProvider
extends BeforeRunTaskProvider<TypeScriptCompileBeforeRunTask> {
    public static final Key<TypeScriptCompileBeforeRunTask> ID = Key.create((String)"TypeScript.Before.Run");

    public Key<TypeScriptCompileBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Typescript.CompileCurrentFile2;
    }

    public String getName() {
        return JSBundle.message((String)"typescript.compiler.before.run", (Object[])new Object[0]);
    }

    public String getDescription(TypeScriptCompileBeforeRunTask task) {
        return this.getName();
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public TypeScriptCompileBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider", "createTask"));
        }
        Project project = runConfiguration.getProject();
        if (project == null || project.isDefault()) {
            return null;
        }
        if (!TypeScriptCompileBeforeRunTaskProvider.isServiceOrCompilerEnabled(project)) {
            return null;
        }
        return new TypeScriptCompileBeforeRunTask();
    }

    private static boolean isServiceOrCompilerEnabled(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return settings.isCompilerEnabled() || settings.isUseService();
    }

    public boolean configureTask(RunConfiguration runConfiguration, TypeScriptCompileBeforeRunTask task) {
        Project project = runConfiguration.getProject();
        TypeScriptCompileBeforeTaskDialog dialog = new TypeScriptCompileBeforeTaskDialog(project, task.isFailOnError(), task.getConfigPath());
        if (dialog.showAndGet()) {
            task.setFailOnError(dialog.isFailOnError());
            task.setConfigPath(dialog.getConfigPath());
            return true;
        }
        return false;
    }

    public boolean canExecuteTask(RunConfiguration configuration, TypeScriptCompileBeforeRunTask task) {
        return true;
    }

    public boolean executeTask(final DataContext context, RunConfiguration configuration, ExecutionEnvironment env, TypeScriptCompileBeforeRunTask task) {
        VirtualFile configFile;
        final Project project = configuration.getProject();
        if (project == null) {
            return true;
        }
        if (!TypeScriptCompileBeforeRunTaskProvider.isServiceOrCompilerEnabled(project)) {
            return true;
        }
        String path = task.getConfigPath();
        boolean isEmptyPath = StringUtil.isEmptyOrSpaces((String)path);
        VirtualFile virtualFile = configFile = isEmptyPath ? null : LocalFileSystem.getInstance().findFileByPath(path);
        if (!(isEmptyPath || configFile != null && "tsconfig.json".equals(configFile.getName()))) {
            ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)ToolWindowId.RUN, (String)"Compile TypeScript", (Throwable)new ExecutionException("Cannot compile TypeScript. Config file is incorrect"));
            return false;
        }
        final Ref hasErrors = Ref.create((Object)false);
        final Semaphore targetDone = new Semaphore();
        targetDone.down();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                new TypeScriptCompileAllAction(){

                    @Override
                    @NotNull
                    protected Collection<TypeScriptConfig> getConfigsForProcessing(Project project) {
                        ApplicationManager.getApplication().assertReadAccessAllowed();
                        if (configFile != null) {
                            TypeScriptConfig config = TypeScriptConfigService.Provider.getConfig(project, configFile);
                            if (config != null) {
                                List list = ContainerUtil.createMaybeSingletonList((Object)config);
                                if (list == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1", "getConfigsForProcessing"));
                                }
                                return list;
                            }
                            JSLanguageServiceQueue.LOGGER.warn("Cannot file config file, will process all config files");
                        }
                        Collection<TypeScriptConfig> collection = super.getConfigsForProcessing(project);
                        if (collection == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1", "getConfigsForProcessing"));
                        }
                        return collection;
                    }

                    @Override
                    protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1", "canUseOnlyConfigs"));
                        }
                        return configFile != null || super.canUseOnlyConfigs(project, settings);
                    }

                    @Override
                    protected void release() {
                        targetDone.up();
                    }

                    @Override
                    protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager, @NotNull Collection<JSAnnotationError> infos) {
                        if (manager == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1", "logErrors"));
                        }
                        if (infos == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1", "logErrors"));
                        }
                        manager.logProjectErrors((ImmutableList<JSAnnotationError>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), (Boolean)hasErrors.get());
                    }

                    @Override
                    protected void logErrors(Project project, Collection<JSAnnotationError> infos) {
                        if (!infos.isEmpty()) {
                            for (JSAnnotationError info : infos) {
                                if (!"error".equalsIgnoreCase(info.getCategory())) continue;
                                hasErrors.set((Object)true);
                                break;
                            }
                        }
                        super.logErrors(project, infos);
                    }
                }.runCompile(project, context);
            }
        }, ModalityState.NON_MODAL);
        targetDone.waitFor(TimeUnit.SECONDS.toMillis(40L));
        return !task.isFailOnError() || (Boolean)hasErrors.get() == false;
    }
}

