/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.JSExportedMembersIndex;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ES6ImportCompletionUtil {
    @NotNull
    public static final JSInsertHandler<LookupElement> IMPORT_INSERT_HANDLER = new JSInsertHandler<LookupElement>(){

        @Override
        public void handleInsert(InsertionContext context, LookupElement item) {
            super.handleInsert(context, item);
            context.commitDocument();
            CaretModel model = context.getEditor().getCaretModel();
            if (model.getCaretCount() > 1 && model.getPrimaryCaret() != model.getCurrentCaret()) {
                return;
            }
            PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
            if (originalElement == null || !ES6ImportCompletionUtil.shouldAddImport(originalElement)) {
                return;
            }
            String name = item.getLookupString();
            PsiElement psiElement = item.getPsiElement();
            ES6ImportAction action = ES6CreateImportUtil.createImportAction(context.getEditor(), originalElement, name, null, ES6ImportAction.DEFAULT_FILTER);
            Object importedElement = psiElement instanceof JSElement ? action.executeFor((JSElement)psiElement) : action.executeForAllVariants();
            if (importedElement != null) {
                PsiElement toProcessPlace;
                PsiElement psiElement2 = toProcessPlace = originalElement.getNode().getElementType() == JSTokenTypes.IDENTIFIER ? originalElement.getParent() : originalElement;
                if (toProcessPlace.isValid()) {
                    context.commitDocument();
                    PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting();
                    JSInsertHandler.insertBracesIfNeed(context, importedElement, toProcessPlace);
                }
            }
        }
    };

    public static void addExportedVariants(@NotNull JSReferenceExpression expression, @NotNull Iterable sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        if (sinkResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sinkResults", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        if (completionResultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        assert (expression.getQualifier() == null);
        ES6ImportCompletionUtil.addExportedVariants((PsiElement)expression, sinkResults, completionResultSet);
    }

    public static void addExportedVariants(@NotNull ES6ImportExportSpecifier specifier, @NotNull Iterable sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        if (sinkResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sinkResults", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        if (completionResultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        ES6ImportCompletionUtil.addExportedVariants((PsiElement)specifier, sinkResults, completionResultSet);
    }

    private static void addExportedVariants(@NotNull PsiElement place, @NotNull Iterable sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        if (sinkResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sinkResults", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        if (completionResultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "addExportedVariants"));
        }
        PsiFile containingFile = place.getContainingFile();
        THashSet<PsiElement> addedElements = ES6ImportCompletionUtil.getProcessedElements(sinkResults);
        Project project = containingFile.getProject();
        JSInsertHandler<LookupElement> handler = IMPORT_INSERT_HANDLER;
        JSImportPlaceInfo info = new JSImportPlaceInfo(place);
        MultiMap symbolsToImport = MultiMap.createSet();
        ArrayList needToCheckConfigAccess = ContainerUtil.newArrayList();
        GlobalSearchScope scope = ES6CreateImportUtil.createSymbolToImportSearchScope(project, (PsiElement)containingFile);
        PrefixMatcher prefixMatcher = completionResultSet.getPrefixMatcher();
        boolean isTypeScript = DialectDetector.isTypeScript(place);
        boolean isImportSpecifier = place instanceof ES6ImportSpecifier;
        Processor processor = element -> {
            if (completionResultSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "lambda$addExportedVariants$0"));
            }
            if (!addedElements.contains(element)) {
                boolean canBeImported;
                String name = ES6ImportPsiUtil.getExportedElementName(element);
                if (name == null || !prefixMatcher.prefixMatches(name)) {
                    return true;
                }
                boolean bl = element instanceof JSExportAssignment || (isImportSpecifier ? ES6ImportHandler.isExternalModuleExport(element) : ES6CreateImportUtil.isAvailableForImport((PsiElement)element, info)) ? true : (canBeImported = false);
                if (!canBeImported) {
                    return true;
                }
                Collection classes = symbolsToImport.get((Object)name);
                if (classes.contains(element.getClass())) {
                    return true;
                }
                Class<?> elementClass = element.getClass();
                symbolsToImport.putValue((Object)name, elementClass);
                PsiFile file = element.getContainingFile();
                if (!isTypeScript || file instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                    LookupElement item = ES6ImportCompletionUtil.createLookupElement(name, (PsiElement)element, handler);
                    completionResultSet.addElement(item);
                } else {
                    needToCheckConfigAccess.add(element);
                }
            }
            return true;
        };
        ES6ImportCompletionUtil.processExportedElementsForKey(project, "exp", scope, (Processor<JSElement>)processor);
        if (!isImportSpecifier) {
            ES6ImportCompletionUtil.processExportedElementsForKey(project, "def", scope, (Processor<JSElement>)processor);
        }
        needToCheckConfigAccess.forEach(element -> {
            if (completionResultSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "lambda$addExportedVariants$1"));
            }
            if (TypeScriptConfigService.Provider.isAccessible(project, info.getFile(), element.getContainingFile().getVirtualFile())) {
                String name = ES6ImportPsiUtil.getExportedElementName(element);
                assert (name != null);
                LookupElement item = ES6ImportCompletionUtil.createLookupElement(name, (PsiElement)element, handler);
                completionResultSet.addElement(item);
            }
        });
    }

    @NotNull
    public static THashSet<PsiElement> getProcessedElements(@NotNull Iterable sinkResults) {
        if (sinkResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sinkResults", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "getProcessedElements"));
        }
        THashSet addedElements = new THashSet();
        for (Object object : sinkResults) {
            PsiElement sinkResult;
            if (object instanceof LookupElement) {
                sinkResult = ((LookupElement)object).getPsiElement();
            } else {
                if (!(object instanceof PsiElement)) continue;
                sinkResult = (PsiElement)object;
            }
            if (sinkResult instanceof ES6ImportExportSpecifier) {
                ResolveResult[] results;
                for (ResolveResult result : results = ((ES6ImportExportSpecifier)sinkResult).multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (element == null) continue;
                    addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)element));
                }
                continue;
            }
            if (sinkResult == null) continue;
            addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)sinkResult));
        }
        THashSet tHashSet = addedElements;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "getProcessedElements"));
        }
        return tHashSet;
    }

    private static void processExportedElementsForKey(Project project, String key, GlobalSearchScope scope, Processor<JSElement> processor) {
        StubIndex.getInstance().processElements(JSExportedMembersIndex.KEY, (Object)key, project, scope, JSElement.class, processor);
    }

    private static LookupElement createLookupElement(@NotNull String name, @NotNull PsiElement element, @NotNull InsertHandler<LookupElement> handler) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "createLookupElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "createLookupElement"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "createLookupElement"));
        }
        return JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)name).withInsertHandler(handler).withIcon(JSLookupUtilImpl.getIcon(element, false)), JSLookupPriority.NO_RELEVANT_NO_SMARTNESS_PRIORITY);
    }

    private static boolean shouldAddImport(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil", "shouldAddImport"));
        }
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return DialectDetector.isTypeScript(element) ? settings.isShowTypeScriptAutoImport() : settings.isShowJavaScriptAutoImport();
    }
}

