/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptDocumentationProvider
extends JSDocumentationProvider {
    @Override
    protected void appendVariableInitializer(@NotNull JSVariable variable, StringBuilder result) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendVariableInitializer"));
        }
        String text = variable.getLiteralOrReferenceInitializerText();
        if (text != null) {
            super.appendVariableInitializer(variable, result);
        }
    }

    @Override
    @Nullable
    protected String createQuickNavigateForJSClass(JSClass jsClass) {
        if (jsClass instanceof TypeScriptTypeAlias) {
            StringBuilder result = new StringBuilder();
            this.appendAttrList((JSAttributeListOwner)jsClass, result);
            result.append("type ");
            result.append(jsClass.getName());
            return result.toString();
        }
        return super.createQuickNavigateForJSClass(jsClass);
    }

    @Override
    @NotNull
    protected String getFunctionPrefix(@NotNull JSFunction function, boolean get, boolean set) {
        JSClass jsClass;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getFunctionPrefix"));
        }
        if (!get && !set && (jsClass = JSUtils.getMemberContainingClass((PsiElement)function)) != null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getFunctionPrefix"));
            }
            return "";
        }
        String string = super.getFunctionPrefix(function, get, set);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getFunctionPrefix"));
        }
        return string;
    }

    @Override
    protected void appendAttrList(JSAttributeListOwner owner, StringBuilder result) {
        JSAttributeList attributeList = owner.getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            String ns = JSResolveUtil.getNamespaceValue(attributeList);
            if (ns == null) {
                JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)owner);
                if (jsClass != null) {
                    ns = JSFormatUtil.formatVisibility(type, (PsiElement)owner);
                } else if (owner instanceof JSQualifiedNamedElement) {
                    if (((JSQualifiedNamedElement)owner).isExported()) {
                        ns = "export";
                    } else if (((JSQualifiedNamedElement)owner).isExportedWithDefault()) {
                        ns = "export default";
                    }
                }
            }
            if (ns != null) {
                result.append(ns);
                result.append(" ");
            }
            TypeScriptDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.STATIC);
            TypeScriptDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.READONLY);
        }
    }
}

