/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.formatter.TypedJSSpacingProcessor;
import com.intellij.lang.typescript.formatter.blocks.TypedJSSubBlockVisitor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedJSBlock
extends JSBlock
implements BlockEx {
    public TypedJSBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/formatter/blocks/TypedJSBlock", "<init>"));
        }
        if (jsBlockContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsBlockContext", "com/intellij/lang/typescript/formatter/blocks/TypedJSBlock", "<init>"));
        }
        super(node, alignment, indent, wrap, sharedAlignmentFactory, jsBlockContext);
    }

    @Override
    protected SubBlockVisitor createSubBlockVisitor() {
        return new TypedJSSubBlockVisitor(this, this.mySharedAlignmentFactory, this.myBlockContext);
    }

    @Override
    protected Spacing calculateSpacing(ASTNode child1, ASTNode child2) {
        return new TypedJSSpacingProcessor(this.myNode, child1, child2, this.myBlockContext.getTopSettings(), this.myBlockContext.getDialect(), this.myDialectSettings).calcSpacing();
    }

    @Override
    protected boolean checkShouldWrapEveryItem(IElementType nodeType) {
        CommonCodeStyleSettings commonSettings = this.myBlockContext.getCommonSettings();
        return super.checkShouldWrapEveryItem(nodeType) || TypedJSBlock.shouldWrapEveryItem(nodeType, TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE, this.myDialectSettings.UNION_TYPES_WRAP) || TypedJSBlock.shouldWrapEveryItem(nodeType, TypeScriptElementTypes.TYPE_PARAMETER_LIST, commonSettings.METHOD_PARAMETERS_WRAP);
    }

    @Override
    protected boolean isChainedCallsFormattingSupported() {
        return true;
    }

    @Nullable
    public Language getLanguage() {
        return this.myBlockContext.getDialect();
    }
}

